/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.testFramework.fixtures.impl;

import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.WriteAction;
import com.intellij.openapi.util.Computable;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileFilter;
import com.intellij.testFramework.fixtures.TempDirTestFixture;
import com.intellij.testFramework.fixtures.impl.BaseFixture;
import java.io.File;
import java.io.IOException;
import org.jetbrains.annotations.NotNull;
import org.junit.Assert;

public class TempDirTestFixtureImpl
extends BaseFixture
implements TempDirTestFixture {
    private File myTempDir;

    @Override
    @NotNull
    public VirtualFile copyAll(@NotNull String dataDir, @NotNull String targetDir) {
        if (dataDir == null) {
            TempDirTestFixtureImpl.$$$reportNull$$$0(0);
        }
        if (targetDir == null) {
            TempDirTestFixtureImpl.$$$reportNull$$$0(1);
        }
        VirtualFile virtualFile = this.copyAll(dataDir, targetDir, VirtualFileFilter.ALL);
        if (virtualFile == null) {
            TempDirTestFixtureImpl.$$$reportNull$$$0(2);
        }
        return virtualFile;
    }

    @Override
    @NotNull
    public VirtualFile copyAll(final @NotNull String dataDir, final @NotNull String targetDir, final @NotNull VirtualFileFilter filter) {
        if (dataDir == null) {
            TempDirTestFixtureImpl.$$$reportNull$$$0(3);
        }
        if (targetDir == null) {
            TempDirTestFixtureImpl.$$$reportNull$$$0(4);
        }
        if (filter == null) {
            TempDirTestFixtureImpl.$$$reportNull$$$0(5);
        }
        this.createTempDirectory();
        VirtualFile virtualFile = (VirtualFile)ApplicationManager.getApplication().runWriteAction((Computable)new Computable<VirtualFile>(){

            public VirtualFile compute() {
                try {
                    VirtualFile tempDir = LocalFileSystem.getInstance().refreshAndFindFileByPath(TempDirTestFixtureImpl.this.myTempDir.getCanonicalPath().replace(File.separatorChar, '/'));
                    Assert.assertNotNull((Object)tempDir);
                    if (targetDir.length() > 0) {
                        Assert.assertFalse((String)"nested directories not implemented", (boolean)targetDir.contains("/"));
                        VirtualFile child = tempDir.findChild(targetDir);
                        if (child == null) {
                            child = tempDir.createChildDirectory((Object)this, targetDir);
                        }
                        tempDir = child;
                    }
                    VirtualFile from = LocalFileSystem.getInstance().refreshAndFindFileByPath(dataDir);
                    Assert.assertNotNull((String)(dataDir + " not found"), (Object)from);
                    VfsUtil.copyDirectory(null, (VirtualFile)from, (VirtualFile)tempDir, (VirtualFileFilter)filter);
                    return tempDir;
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
            }
        });
        if (virtualFile == null) {
            TempDirTestFixtureImpl.$$$reportNull$$$0(6);
        }
        return virtualFile;
    }

    @Override
    @NotNull
    public String getTempDirPath() {
        String string = this.createTempDirectory().getAbsolutePath();
        if (string == null) {
            TempDirTestFixtureImpl.$$$reportNull$$$0(7);
        }
        return string;
    }

    public File createTempFile(String fileName) throws IOException {
        String prefix = StringUtil.getPackageName((String)fileName);
        if (prefix.length() < 3) {
            prefix = prefix + "___";
        }
        String suffix = "." + StringUtil.getShortName((String)fileName);
        return FileUtil.createTempFile((File)new File(this.getTempDirPath()), (String)prefix, (String)suffix, (boolean)true);
    }

    @Override
    public VirtualFile getFile(@NotNull String path) {
        if (path == null) {
            TempDirTestFixtureImpl.$$$reportNull$$$0(8);
        }
        try {
            return (VirtualFile)WriteAction.computeAndWait(() -> {
                if (path == null) {
                    TempDirTestFixtureImpl.$$$reportNull$$$0(18);
                }
                String fullPath = this.myTempDir.getCanonicalPath() + '/' + path;
                VirtualFile file = LocalFileSystem.getInstance().refreshAndFindFileByPath(fullPath);
                return file;
            });
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    @NotNull
    public VirtualFile createFile(@NotNull String name2) {
        if (name2 == null) {
            TempDirTestFixtureImpl.$$$reportNull$$$0(9);
        }
        File file = new File(this.createTempDirectory(), name2);
        VirtualFile virtualFile = (VirtualFile)WriteAction.computeAndWait(() -> {
            FileUtil.createIfDoesntExist((File)file);
            return LocalFileSystem.getInstance().refreshAndFindFileByIoFile(file);
        });
        if (virtualFile == null) {
            TempDirTestFixtureImpl.$$$reportNull$$$0(10);
        }
        return virtualFile;
    }

    @Override
    @NotNull
    public VirtualFile findOrCreateDir(@NotNull String name2) throws IOException {
        if (name2 == null) {
            TempDirTestFixtureImpl.$$$reportNull$$$0(11);
        }
        VirtualFile virtualFile = VfsUtil.createDirectories((String)new File(this.createTempDirectory(), name2).getPath());
        if (virtualFile == null) {
            TempDirTestFixtureImpl.$$$reportNull$$$0(12);
        }
        return virtualFile;
    }

    @Override
    @NotNull
    public VirtualFile createFile(@NotNull String name2, @NotNull String text) throws IOException {
        if (name2 == null) {
            TempDirTestFixtureImpl.$$$reportNull$$$0(13);
        }
        if (text == null) {
            TempDirTestFixtureImpl.$$$reportNull$$$0(14);
        }
        VirtualFile file = this.createFile(name2);
        WriteAction.runAndWait(() -> {
            if (text == null) {
                TempDirTestFixtureImpl.$$$reportNull$$$0(17);
            }
            VfsUtil.saveText((VirtualFile)file, (String)text);
        });
        VirtualFile virtualFile = file;
        if (virtualFile == null) {
            TempDirTestFixtureImpl.$$$reportNull$$$0(15);
        }
        return virtualFile;
    }

    @Override
    public void setUp() throws Exception {
        super.setUp();
        this.createTempDirectory();
    }

    @Override
    public void tearDown() throws Exception {
        try {
            if (this.myTempDir != null) {
                WriteAction.runAndWait(() -> this.findOrCreateDir("").delete((Object)this));
            }
        }
        finally {
            super.tearDown();
        }
    }

    protected File getTempHome() {
        return null;
    }

    @NotNull
    protected File createTempDirectory() {
        File file;
        try {
            if (this.myTempDir == null) {
                File tempHome = this.getTempHome();
                this.myTempDir = tempHome == null ? FileUtil.createTempDirectory((String)"unitTest", null, (boolean)false) : FileUtil.createTempDirectory((File)tempHome, (String)"unitTest", null, (boolean)false);
            }
            file = this.myTempDir;
        }
        catch (IOException e) {
            throw new RuntimeException("Cannot create temp dir", e);
        }
        if (file == null) {
            TempDirTestFixtureImpl.$$$reportNull$$$0(16);
        }
        return file;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 6: 
            case 7: 
            case 10: 
            case 12: 
            case 15: 
            case 16: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 6: 
            case 7: 
            case 10: 
            case 12: 
            case 15: 
            case 16: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dataDir";
                break;
            }
            case 1: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "targetDir";
                break;
            }
            case 2: 
            case 6: 
            case 7: 
            case 10: 
            case 12: 
            case 15: 
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/testFramework/fixtures/impl/TempDirTestFixtureImpl";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "filter";
                break;
            }
            case 8: 
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "path";
                break;
            }
            case 9: 
            case 11: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 14: 
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "text";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/testFramework/fixtures/impl/TempDirTestFixtureImpl";
                break;
            }
            case 2: 
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "copyAll";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getTempDirPath";
                break;
            }
            case 10: 
            case 15: {
                objectArray = objectArray2;
                objectArray2[1] = "createFile";
                break;
            }
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "findOrCreateDir";
                break;
            }
            case 16: {
                objectArray = objectArray2;
                objectArray2[1] = "createTempDirectory";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "copyAll";
                break;
            }
            case 2: 
            case 6: 
            case 7: 
            case 10: 
            case 12: 
            case 15: 
            case 16: {
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "getFile";
                break;
            }
            case 9: 
            case 13: 
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "createFile";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "findOrCreateDir";
                break;
            }
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "lambda$createFile$2";
                break;
            }
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "lambda$getFile$0";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 6: 
            case 7: 
            case 10: 
            case 12: 
            case 15: 
            case 16: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

