/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.testFramework.fixtures;

import com.intellij.codeInsight.hint.EditorHintListener;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.project.Project;
import com.intellij.ui.LightweightHint;
import org.jetbrains.annotations.Nullable;

public class EditorHintFixture
implements EditorHintListener {
    private LightweightHint myCurrentHint;

    public EditorHintFixture(Disposable parentDisposable) {
        ApplicationManager.getApplication().getMessageBus().connect(parentDisposable).subscribe(EditorHintListener.TOPIC, (Object)this);
    }

    public void hintShown(Project project2, LightweightHint hint, int flags) {
        hint.putUserData(LightweightHint.SHOWN_AT_DEBUG, (Object)Boolean.TRUE);
        this.myCurrentHint = hint;
        hint.addHintListener(event -> {
            LightweightHint source = (LightweightHint)event.getSource();
            source.putUserData(LightweightHint.SHOWN_AT_DEBUG, null);
            if (source == this.myCurrentHint) {
                this.myCurrentHint = null;
            }
        });
    }

    @Nullable
    public String getCurrentHintText() {
        return this.myCurrentHint == null ? null : this.myCurrentHint.getComponent().toString();
    }
}

