/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.testFramework;

import com.intellij.openapi.editor.EditorFactory;
import com.intellij.openapi.editor.impl.event.EditorEventMulticasterImpl;
import com.intellij.openapi.project.ProjectManager;
import com.intellij.openapi.project.impl.ProjectManagerImpl;
import com.intellij.openapi.vfs.encoding.EncodingManager;
import com.intellij.util.containers.hash.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.junit.Assert;

public class EditorListenerTracker {
    private final Map<Class, List> before;
    private final boolean myDefaultProjectInitialized;

    public EditorListenerTracker() {
        EncodingManager.getInstance();
        EditorEventMulticasterImpl multicaster = (EditorEventMulticasterImpl)EditorFactory.getInstance().getEventMulticaster();
        this.before = multicaster.getListeners();
        this.myDefaultProjectInitialized = ((ProjectManagerImpl)ProjectManager.getInstance()).isDefaultProjectInitialized();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void checkListenersLeak() throws AssertionError {
        try {
            Class aClass;
            if (this.myDefaultProjectInitialized != ((ProjectManagerImpl)ProjectManager.getInstance()).isDefaultProjectInitialized()) {
                return;
            }
            EditorEventMulticasterImpl multicaster = (EditorEventMulticasterImpl)EditorFactory.getInstance().getEventMulticaster();
            Map after2 = multicaster.getListeners();
            LinkedHashMap leaked = new LinkedHashMap();
            for (Map.Entry entry : after2.entrySet()) {
                aClass = (Class)entry.getKey();
                List beforeList = this.before.get(aClass);
                List afterList = (List)entry.getValue();
                if (beforeList != null) {
                    afterList.removeAll(beforeList);
                }
                if (afterList.isEmpty()) continue;
                leaked.put(aClass, afterList);
            }
            for (Map.Entry entry : leaked.entrySet()) {
                aClass = (Class)entry.getKey();
                List list = (List)entry.getValue();
                Assert.fail((String)("Listeners leaked for " + aClass + ":\n" + list));
            }
        }
        finally {
            this.before.clear();
        }
    }
}

