/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.structuralsearch.plugin.ui;

import com.intellij.codeInsight.daemon.DaemonCodeAnalyzer;
import com.intellij.codeInsight.template.TemplateContextType;
import com.intellij.codeInsight.template.impl.TemplateEditorUtil;
import com.intellij.find.FindBundle;
import com.intellij.find.FindSettings;
import com.intellij.icons.AllIcons;
import com.intellij.ide.IdeBundle;
import com.intellij.ide.util.scopeChooser.ScopeChooserCombo;
import com.intellij.lang.Language;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.actionSystem.impl.ActionToolbarImpl;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.command.CommandProcessor;
import com.intellij.openapi.command.WriteCommandAction;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.SelectionModel;
import com.intellij.openapi.editor.event.DocumentEvent;
import com.intellij.openapi.editor.event.DocumentListener;
import com.intellij.openapi.editor.ex.EditorEx;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.fileTypes.LanguageFileType;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectManager;
import com.intellij.openapi.project.ProjectManagerListener;
import com.intellij.openapi.ui.DialogWrapper;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.codeStyle.CodeStyleManager;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.search.SearchScope;
import com.intellij.structuralsearch.MalformedPatternException;
import com.intellij.structuralsearch.MatchOptions;
import com.intellij.structuralsearch.Matcher;
import com.intellij.structuralsearch.NoMatchFoundException;
import com.intellij.structuralsearch.SSRBundle;
import com.intellij.structuralsearch.StructuralSearchProfile;
import com.intellij.structuralsearch.StructuralSearchUtil;
import com.intellij.structuralsearch.UnsupportedPatternException;
import com.intellij.structuralsearch.impl.matcher.compiler.PatternCompiler;
import com.intellij.structuralsearch.plugin.StructuralSearchPlugin;
import com.intellij.structuralsearch.plugin.ui.Configuration;
import com.intellij.structuralsearch.plugin.ui.ConfigurationManager;
import com.intellij.structuralsearch.plugin.ui.EditVarConstraintsDialog;
import com.intellij.structuralsearch.plugin.ui.FileTypeInfo;
import com.intellij.structuralsearch.plugin.ui.FileTypeSelector;
import com.intellij.structuralsearch.plugin.ui.ScopePanel;
import com.intellij.structuralsearch.plugin.ui.SearchCommand;
import com.intellij.structuralsearch.plugin.ui.SearchConfiguration;
import com.intellij.structuralsearch.plugin.ui.SearchContext;
import com.intellij.structuralsearch.plugin.ui.SelectTemplateDialog;
import com.intellij.structuralsearch.plugin.ui.SubstitutionShortInfoHandler;
import com.intellij.structuralsearch.plugin.ui.UIUtil;
import com.intellij.ui.EditorTextField;
import com.intellij.util.Alarm;
import com.intellij.util.ObjectUtils;
import com.intellij.util.Producer;
import com.intellij.util.SmartList;
import com.intellij.util.textCompletion.TextCompletionUtil;
import com.intellij.util.ui.LafIconLookup;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.GroupLayout;
import javax.swing.Icon;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.LayoutStyle;
import javax.swing.UIManager;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.Nullable;

public class StructuralSearchDialog
extends DialogWrapper {
    static final Key<Boolean> STRUCTURAL_SEARCH = Key.create((String)"STRUCTURAL_SEARCH_AREA");
    protected SearchContext searchContext;
    protected EditorTextField searchCriteriaEdit;
    private ScopeChooserCombo myScopeChooserCombo;
    private JCheckBox recursiveMatching;
    private JCheckBox caseSensitiveMatch;
    private FileTypeSelector fileTypes;
    protected Configuration myConfiguration;
    private JCheckBox openInNewTab;
    private final Alarm myAlarm;
    public static final String USER_DEFINED = SSRBundle.message("new.template.defaultname", new Object[0]);
    private boolean useLastConfiguration;
    @NonNls
    private FileType ourFtSearchVariant = StructuralSearchUtil.getDefaultFileType();
    private static Language ourDialect = null;
    private static String ourContext = null;
    private final boolean myShowScopePanel;
    private final boolean myRunFindActionOnClose;
    private boolean myDoingOkAction;
    private String mySavedEditorText;
    private JPanel myContentPanel;
    private boolean myFilterEnabled = false;

    public StructuralSearchDialog(SearchContext searchContext) {
        this(searchContext, true, true);
    }

    public StructuralSearchDialog(SearchContext searchContext, boolean showScope, boolean runFindActionOnClose) {
        super(searchContext.getProject(), true);
        if (showScope) {
            this.setModal(false);
        }
        this.myShowScopePanel = showScope;
        this.myRunFindActionOnClose = runFindActionOnClose;
        this.searchContext = searchContext;
        this.setTitle(this.getDefaultTitle());
        if (runFindActionOnClose) {
            this.setOKButtonText(FindBundle.message((String)"find.dialog.find.button", (Object[])new Object[0]));
        }
        this.myConfiguration = this.createConfiguration(null);
        this.init();
        this.myAlarm = new Alarm(Alarm.ThreadToUse.POOLED_THREAD, this.myDisposable);
        ProjectManager.getInstance().addProjectManagerListener(searchContext.getProject(), new ProjectManagerListener(){

            public void projectClosing(Project project2) {
                StructuralSearchDialog.this.close(1);
            }
        });
    }

    public void setUseLastConfiguration(boolean useLastConfiguration) {
        this.useLastConfiguration = useLastConfiguration;
    }

    void setSearchPattern(Configuration config) {
        this.setValuesFromConfig(config);
        this.initiateValidation();
    }

    protected EditorTextField createEditor(SearchContext searchContext, String text) {
        FileTypeInfo info = this.fileTypes.getSelectedItem();
        assert (info != null);
        FileType fileType = info.getFileType();
        Language dialect = info.getDialect();
        StructuralSearchProfile profile2 = StructuralSearchUtil.getProfileByFileType(fileType);
        assert (profile2 != null);
        Document document = profile2.createDocument(searchContext.getProject(), fileType, dialect, text);
        document.addDocumentListener(new DocumentListener(){

            public void documentChanged(DocumentEvent event) {
                StructuralSearchDialog.this.initiateValidation();
            }
        });
        return new EditorTextField(document, searchContext.getProject(), fileType){

            protected EditorEx createEditor() {
                EditorEx editorEx = super.createEditor();
                TextCompletionUtil.installCompletionHint((EditorEx)editorEx);
                editorEx.putUserData(STRUCTURAL_SEARCH, (Object)true);
                return editorEx;
            }
        };
    }

    void initiateValidation() {
        this.myAlarm.cancelAllRequests();
        this.myAlarm.addRequest(() -> {
            try {
                boolean valid = this.isValid();
                boolean compiled = this.isCompiled();
                ApplicationManager.getApplication().invokeLater(() -> {
                    this.myFilterEnabled = compiled;
                    this.getOKAction().setEnabled(valid);
                });
            }
            catch (ProcessCanceledException e) {
                throw e;
            }
            catch (RuntimeException e) {
                Logger.getInstance(StructuralSearchDialog.class).error((Throwable)e);
            }
        }, 250);
    }

    private boolean isCompiled() {
        try {
            return PatternCompiler.compilePattern(this.getProject(), this.myConfiguration.getMatchOptions(), false) != null;
        }
        catch (MalformedPatternException e) {
            return false;
        }
    }

    void updateEditor() {
        if (this.myContentPanel != null) {
            if (this.searchCriteriaEdit != null) {
                this.mySavedEditorText = this.searchCriteriaEdit.getText();
                this.myContentPanel.remove((Component)this.searchCriteriaEdit);
            }
            this.searchCriteriaEdit = this.createEditor(this.searchContext, this.mySavedEditorText != null ? this.mySavedEditorText : "");
            this.myContentPanel.add((Component)this.searchCriteriaEdit, "Center");
            this.myContentPanel.revalidate();
            final StructuralSearchProfile profile2 = StructuralSearchUtil.getProfileByFileType(this.ourFtSearchVariant);
            assert (profile2 != null);
            this.searchCriteriaEdit.addPropertyChangeListener(new PropertyChangeListener(){

                @Override
                public void propertyChange(PropertyChangeEvent evt) {
                    Editor editor = StructuralSearchDialog.this.searchCriteriaEdit.getEditor();
                    if (editor == null) {
                        return;
                    }
                    TemplateEditorUtil.setHighlighter((Editor)editor, (TemplateContextType)profile2.getTemplateContextType());
                    SubstitutionShortInfoHandler.install(editor);
                    editor.putUserData(SubstitutionShortInfoHandler.CURRENT_CONFIGURATION_KEY, (Object)StructuralSearchDialog.this.myConfiguration);
                    Project project2 = StructuralSearchDialog.this.searchContext.getProject();
                    PsiFile psiFile = PsiDocumentManager.getInstance((Project)project2).getPsiFile(StructuralSearchDialog.this.searchCriteriaEdit.getDocument());
                    if (psiFile != null) {
                        DaemonCodeAnalyzer.getInstance((Project)project2).setHighlightingEnabled(psiFile, false);
                    }
                    StructuralSearchDialog.this.searchCriteriaEdit.removePropertyChangeListener((PropertyChangeListener)this);
                }
            });
        }
    }

    private void detectFileTypeAndDialect() {
        PsiFile file = this.searchContext.getFile();
        if (file != null) {
            FileType fileType;
            PsiFile context = null;
            if (this.searchContext.getEditor() != null && (context = file.findElementAt(this.searchContext.getEditor().getCaretModel().getOffset())) != null) {
                context = context.getParent();
            }
            if (context == null) {
                context = file;
            }
            FileType detectedFileType = null;
            StructuralSearchProfile profile2 = StructuralSearchUtil.getProfileByPsiElement((PsiElement)context);
            if (profile2 != null && (fileType = profile2.detectFileType((PsiElement)context)) != null) {
                detectedFileType = fileType;
            }
            if (detectedFileType == null) {
                for (FileType fileType2 : StructuralSearchUtil.getSuitableFileTypes()) {
                    if (!(fileType2 instanceof LanguageFileType) || !((LanguageFileType)fileType2).getLanguage().equals(context.getLanguage())) continue;
                    detectedFileType = fileType2;
                    break;
                }
            }
            this.ourFtSearchVariant = detectedFileType != null ? detectedFileType : StructuralSearchUtil.getDefaultFileType();
        }
    }

    protected boolean isRecursiveSearchEnabled() {
        return this.myShowScopePanel;
    }

    public void setValuesFromConfig(Configuration configuration) {
        this.myConfiguration = this.createConfiguration(configuration);
        MatchOptions matchOptions = this.myConfiguration.getMatchOptions();
        Document document = this.searchCriteriaEdit.getDocument();
        CommandProcessor.getInstance().executeCommand(this.searchContext.getProject(), () -> ApplicationManager.getApplication().runWriteAction(() -> document.replaceString(0, document.getTextLength(), (CharSequence)matchOptions.getSearchPattern())), null, null);
        this.recursiveMatching.setSelected(this.isRecursiveSearchEnabled() && matchOptions.isRecursiveSearch());
        this.caseSensitiveMatch.setSelected(matchOptions.isCaseSensitiveMatch());
        this.fileTypes.setSelectedItem(matchOptions.getFileType(), matchOptions.getDialect(), matchOptions.getPatternContext());
        Editor editor = this.searchCriteriaEdit.getEditor();
        if (editor != null) {
            editor.putUserData(SubstitutionShortInfoHandler.CURRENT_CONFIGURATION_KEY, (Object)this.myConfiguration);
        }
    }

    public Configuration createConfiguration(Configuration template) {
        return template == null ? new SearchConfiguration(USER_DEFINED, USER_DEFINED) : new SearchConfiguration(template);
    }

    protected void setText(String text) {
        this.setTextForEditor(text, this.searchCriteriaEdit);
    }

    protected final void setTextForEditor(String selection, EditorTextField editor) {
        editor.setText(selection);
        editor.selectAll();
        Project project2 = this.searchContext.getProject();
        Document document = editor.getDocument();
        PsiDocumentManager documentManager = PsiDocumentManager.getInstance((Project)project2);
        documentManager.commitDocument(document);
        PsiFile file = documentManager.getPsiFile(document);
        if (file == null) {
            return;
        }
        WriteCommandAction.writeCommandAction((Project)project2, (PsiFile[])new PsiFile[]{file}).run(() -> CodeStyleManager.getInstance((Project)project2).adjustLineIndent(file, new TextRange(0, document.getTextLength())));
    }

    protected void startSearching() {
        new SearchCommand(this.myConfiguration, this.searchContext).startSearching();
    }

    protected String getDefaultTitle() {
        return SSRBundle.message("structural.search.title", new Object[0]);
    }

    protected JComponent createCenterPanel() {
        this.myContentPanel = new JPanel(new BorderLayout());
        this.searchCriteriaEdit = this.createEditor(this.searchContext, this.mySavedEditorText != null ? this.mySavedEditorText : "");
        this.myContentPanel.add("Center", (Component)this.searchCriteriaEdit);
        if (this.myShowScopePanel) {
            this.myScopeChooserCombo = new ScopeChooserCombo(this.searchContext.getProject(), true, false, FindSettings.getInstance().getDefaultScopeName());
            Disposer.register((Disposable)this.myDisposable, (Disposable)this.myScopeChooserCombo);
            this.myScopeChooserCombo.getComboBox().addItemListener(e -> this.initiateValidation());
        } else {
            this.myScopeChooserCombo = null;
        }
        ScopePanel scopePanel = new ScopePanel();
        this.myContentPanel.add("South", scopePanel);
        this.updateEditor();
        return this.myContentPanel;
    }

    @Nullable
    protected JComponent createNorthPanel() {
        DefaultActionGroup historyActionGroup = new DefaultActionGroup(new AnAction[]{new AnAction(StructuralSearchDialog.getShowHistoryIcon()){

            public void actionPerformed(AnActionEvent e) {
                SelectTemplateDialog dialog = new SelectTemplateDialog(StructuralSearchDialog.this.searchContext.getProject(), true, StructuralSearchDialog.this.isReplaceDialog());
                if (!dialog.showAndGet()) {
                    return;
                }
                Configuration[] configurations = dialog.getSelectedConfigurations();
                if (configurations.length == 1) {
                    StructuralSearchDialog.this.setSearchPattern(configurations[0]);
                    StructuralSearchDialog.this.initiateValidation();
                }
            }
        }});
        ActionToolbarImpl historyToolbar = (ActionToolbarImpl)ActionManager.getInstance().createActionToolbar("EditorToolbar", (ActionGroup)historyActionGroup, true);
        historyToolbar.setLayoutPolicy(0);
        JLabel label = new JLabel(SSRBundle.message("search.template", new Object[0]));
        UIUtil.installCompleteMatchInfo(label, (Producer<? extends Configuration>)((Producer)() -> this.myConfiguration));
        this.recursiveMatching = new JCheckBox(SSRBundle.message("recursive.matching.checkbox", new Object[0]), true);
        this.recursiveMatching.setVisible(this.isRecursiveSearchEnabled());
        this.caseSensitiveMatch = new JCheckBox(FindBundle.message((String)"find.popup.case.sensitive", (Object[])new Object[0]), true);
        ArrayList<FileType> types = new ArrayList<FileType>();
        for (FileType fileType : StructuralSearchUtil.getSuitableFileTypes()) {
            if (StructuralSearchUtil.getProfileByFileType(fileType) == null) continue;
            types.add(fileType);
        }
        Collections.sort(types, (o1, o2) -> o1.getName().compareToIgnoreCase(o2.getName()));
        this.fileTypes = new FileTypeSelector(types);
        this.fileTypes.setMinimumAndPreferredWidth(200);
        this.fileTypes.setSelectedItem(this.ourFtSearchVariant, ourDialect, ourContext);
        this.fileTypes.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                if (e.getStateChange() == 1) {
                    StructuralSearchDialog.this.updateEditor();
                    StructuralSearchDialog.this.initiateValidation();
                }
            }
        });
        JLabel fileTypeLabel = new JLabel(SSRBundle.message("search.dialog.file.type.label", new Object[0]));
        fileTypeLabel.setLabelFor((Component)((Object)this.fileTypes));
        DefaultActionGroup templateActionGroup = new DefaultActionGroup(new AnAction[]{new AnAction(SSRBundle.message("save.template.text.button", new Object[0])){

            public void actionPerformed(AnActionEvent e) {
                ConfigurationManager.getInstance(StructuralSearchDialog.this.getProject()).showSaveTemplateAsDialog(StructuralSearchDialog.this.getConfiguration());
            }
        }, new AnAction(SSRBundle.message("copy.existing.template.button", new Object[0])){

            public void actionPerformed(AnActionEvent e) {
                SelectTemplateDialog dialog = new SelectTemplateDialog(StructuralSearchDialog.this.searchContext.getProject(), false, StructuralSearchDialog.this.isReplaceDialog());
                if (!dialog.showAndGet()) {
                    return;
                }
                Configuration[] configurations = dialog.getSelectedConfigurations();
                if (configurations.length == 1) {
                    StructuralSearchDialog.this.setSearchPattern(configurations[0]);
                }
            }
        }});
        templateActionGroup.setPopup(true);
        templateActionGroup.getTemplatePresentation().setIcon(AllIcons.General.GearPlain);
        AnAction filterAction = new AnAction(AllIcons.General.Filter){

            public void actionPerformed(AnActionEvent e) {
                new EditVarConstraintsDialog(StructuralSearchDialog.this.searchContext.getProject(), StructuralSearchDialog.this.myConfiguration, StructuralSearchDialog.this.getVariablesFromListeners(), StructuralSearchDialog.this.fileTypes.getSelectedFileType()).show();
                StructuralSearchDialog.this.initiateValidation();
            }

            public void update(AnActionEvent e) {
                e.getPresentation().setEnabled(StructuralSearchDialog.this.myFilterEnabled);
            }
        };
        DefaultActionGroup optionsActionGroup = new DefaultActionGroup(new AnAction[]{filterAction, templateActionGroup});
        ActionToolbarImpl optionsToolbar = (ActionToolbarImpl)ActionManager.getInstance().createActionToolbar("EditorToolbar", (ActionGroup)optionsActionGroup, true);
        optionsToolbar.setLayoutPolicy(0);
        optionsToolbar.setForceMinimumSize(true);
        JPanel northPanel = new JPanel(null);
        GroupLayout layout = new GroupLayout(northPanel);
        northPanel.setLayout(layout);
        layout.setHonorsVisibility(true);
        layout.setHorizontalGroup(layout.createSequentialGroup().addComponent((Component)historyToolbar, -2, -1, -2).addComponent(label).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED, 20, Integer.MAX_VALUE).addComponent(this.recursiveMatching).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED, 15, 15).addComponent(this.caseSensitiveMatch).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED, 15, 15).addComponent(fileTypeLabel).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, 5, 5).addComponent((Component)((Object)this.fileTypes)).addComponent((Component)optionsToolbar, -2, -1, -2));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent((Component)historyToolbar).addComponent(label).addComponent(this.recursiveMatching).addComponent(this.caseSensitiveMatch).addComponent(fileTypeLabel).addComponent((Component)((Object)this.fileTypes)).addComponent((Component)optionsToolbar));
        this.detectFileTypeAndDialect();
        return northPanel;
    }

    @Nullable
    protected JPanel createSouthAdditionalPanel() {
        if (!this.myRunFindActionOnClose) {
            return null;
        }
        JPanel panel = new JPanel(new BorderLayout());
        panel.setBorder(BorderFactory.createEmptyBorder(0, 6, 0, 0));
        this.openInNewTab = new JCheckBox(SSRBundle.message("open.in.new.tab.checkbox", new Object[0]));
        this.openInNewTab.setSelected(FindSettings.getInstance().isShowResultsInSeparateView());
        panel.add((Component)this.openInNewTab, "East");
        return panel;
    }

    protected List<String> getVariablesFromListeners() {
        Editor editor = this.searchCriteriaEdit.getEditor();
        if (editor == null) {
            return new SmartList();
        }
        return StructuralSearchDialog.getVarsFrom(editor);
    }

    protected static List<String> getVarsFrom(Editor searchCriteriaEdit) {
        SubstitutionShortInfoHandler handler = SubstitutionShortInfoHandler.retrieve(searchCriteriaEdit);
        return handler == null ? new SmartList() : new ArrayList<String>(handler.getVariables());
    }

    public final Project getProject() {
        return this.searchContext.getProject();
    }

    protected boolean isReplaceDialog() {
        return false;
    }

    public void show() {
        StructuralSearchPlugin.getInstance(this.getProject()).setDialogVisible(true);
        if (!this.useLastConfiguration) {
            Configuration configuration;
            SelectionModel selectionModel;
            Editor editor = this.searchContext.getEditor();
            boolean setSomeText = false;
            if (editor != null && (selectionModel = editor.getSelectionModel()).hasSelection()) {
                this.setText(selectionModel.getSelectedText());
                setSomeText = true;
            }
            if (!setSomeText && (configuration = ConfigurationManager.getInstance(this.getProject()).getMostRecentConfiguration()) != null) {
                this.setValuesFromConfig(configuration);
            }
        }
        this.initiateValidation();
        super.show();
    }

    public JComponent getPreferredFocusedComponent() {
        return this.searchCriteriaEdit;
    }

    protected void doOKAction() {
        this.myDoingOkAction = true;
        boolean result = this.isValid();
        this.myDoingOkAction = false;
        if (!result) {
            return;
        }
        this.myAlarm.cancelAllRequests();
        super.doOKAction();
        if (!this.myRunFindActionOnClose) {
            return;
        }
        SearchScope selectedScope = this.myScopeChooserCombo.getSelectedScope();
        if (selectedScope == null) {
            return;
        }
        FindSettings findSettings = FindSettings.getInstance();
        findSettings.setDefaultScopeName(selectedScope.getDisplayName());
        findSettings.setShowResultsInSeparateView(this.openInNewTab.isSelected());
        try {
            this.removeUnusedVariableConstraints(this.myConfiguration);
            ConfigurationManager.getInstance(this.getProject()).addHistoryConfiguration(this.myConfiguration);
            this.startSearching();
        }
        catch (MalformedPatternException ex) {
            this.reportMessage(SSRBundle.message("this.pattern.is.malformed.message", ex.getMessage()), this.searchCriteriaEdit);
        }
    }

    private void removeUnusedVariableConstraints(Configuration configuration) {
        List<String> variableNames = this.getVariablesFromListeners();
        variableNames.add("__context__");
        configuration.getMatchOptions().retainVariableConstraints(variableNames);
    }

    public Configuration getConfiguration() {
        this.removeUnusedVariableConstraints(this.myConfiguration);
        this.setValuesToConfig(this.myConfiguration);
        return this.myConfiguration;
    }

    protected boolean isValid() {
        try {
            Matcher.validate(this.searchContext.getProject(), this.getConfiguration().getMatchOptions());
        }
        catch (MalformedPatternException ex) {
            this.reportMessage(SSRBundle.message("this.pattern.is.malformed.message", ex.getMessage() != null ? ex.getMessage() : ""), this.searchCriteriaEdit);
            return false;
        }
        catch (UnsupportedPatternException ex) {
            this.reportMessage(SSRBundle.message("this.pattern.is.unsupported.message", ex.getMessage()), this.searchCriteriaEdit);
            return false;
        }
        catch (NoMatchFoundException e) {
            this.reportMessage(e.getMessage(), this.searchCriteriaEdit);
            return false;
        }
        this.reportMessage(null, this.searchCriteriaEdit);
        return true;
    }

    protected void reportMessage(String message, EditorTextField editor) {
        com.intellij.util.ui.UIUtil.invokeLaterIfNeeded(() -> {
            editor.putClientProperty((Object)"JComponent.outline", (Object)(message == null ? null : "error"));
            editor.setToolTipText(message);
            editor.repaint();
        });
    }

    protected void setValuesToConfig(Configuration config) {
        MatchOptions options = config.getMatchOptions();
        if (this.myShowScopePanel) {
            boolean searchWithinHierarchy = IdeBundle.message((String)"scope.class.hierarchy", (Object[])new Object[0]).equals(this.myScopeChooserCombo.getSelectedScopeName());
            options.setScope((SearchScope)(searchWithinHierarchy && !this.myDoingOkAction ? GlobalSearchScope.projectScope((Project)this.getProject()) : this.myScopeChooserCombo.getSelectedScope()));
        }
        options.setRecursiveSearch(this.isRecursiveSearchEnabled() && this.recursiveMatching.isSelected());
        FileTypeInfo info = this.fileTypes.getSelectedItem();
        this.ourFtSearchVariant = info != null ? info.getFileType() : null;
        ourDialect = info != null ? info.getDialect() : null;
        ourContext = info != null ? info.getContext() : null;
        FileType fileType = this.ourFtSearchVariant;
        options.setFileType(fileType);
        options.setDialect(ourDialect);
        options.setPatternContext(ourContext);
        options.setSearchPattern(this.searchCriteriaEdit.getDocument().getText());
        options.setCaseSensitiveMatch(this.caseSensitiveMatch.isSelected());
    }

    protected String getDimensionServiceKey() {
        return "#com.intellij.structuralsearch.plugin.ui.SearchDialog";
    }

    public void dispose() {
        StructuralSearchPlugin.getInstance(this.getProject()).setDialogVisible(false);
        this.myAlarm.cancelAllRequests();
        this.searchCriteriaEdit.removeNotify();
        super.dispose();
    }

    protected String getHelpId() {
        return "find.structuredSearch";
    }

    private static Icon getShowHistoryIcon() {
        return (Icon)ObjectUtils.coalesce((Object)UIManager.getIcon("TextField.darcula.searchWithHistory.icon"), (Object)LafIconLookup.getIcon((String)"searchWithHistory"));
    }
}

