/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.structuralsearch.inspection.highlightTemplate;

import com.intellij.codeInsight.daemon.DaemonCodeAnalyzer;
import com.intellij.ide.DataManager;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.popup.JBPopupFactory;
import com.intellij.structuralsearch.SSRBundle;
import com.intellij.structuralsearch.inspection.highlightTemplate.SSBasedInspectionCompiledPatternsCache;
import com.intellij.structuralsearch.plugin.replace.ui.ReplaceDialog;
import com.intellij.structuralsearch.plugin.ui.Configuration;
import com.intellij.structuralsearch.plugin.ui.ConfigurationManager;
import com.intellij.structuralsearch.plugin.ui.SearchConfiguration;
import com.intellij.structuralsearch.plugin.ui.SearchContext;
import com.intellij.structuralsearch.plugin.ui.SearchDialog;
import com.intellij.ui.AnActionButton;
import com.intellij.ui.AnActionButtonRunnable;
import com.intellij.ui.AnActionButtonUpdater;
import com.intellij.ui.DoubleClickListener;
import com.intellij.ui.ToolbarDecorator;
import com.intellij.ui.components.JBList;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Rectangle;
import java.awt.event.MouseEvent;
import java.util.List;
import javax.swing.AbstractListModel;
import javax.swing.DefaultListCellRenderer;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.ListCellRenderer;
import javax.swing.ListModel;

public class SSBasedInspectionOptions {
    final JBList<Configuration> myTemplatesList;
    final List<Configuration> myConfigurations;

    public SSBasedInspectionOptions(List<Configuration> configurations) {
        this.myConfigurations = configurations;
        this.myTemplatesList = new JBList((ListModel)new MyListModel());
        this.myTemplatesList.setCellRenderer((ListCellRenderer)new DefaultListCellRenderer(){

            @Override
            public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
                JLabel component = (JLabel)super.getListCellRendererComponent((JList<?>)list, value, index, isSelected, cellHasFocus);
                Configuration configuration = SSBasedInspectionOptions.this.myConfigurations.get(index);
                component.setText(configuration.getName());
                return component;
            }
        });
    }

    void addTemplate(SearchDialogFactory searchDialogFactory) {
        SearchDialog dialog = SSBasedInspectionOptions.createDialog(searchDialogFactory);
        if (!dialog.showAndGet()) {
            return;
        }
        if (!ConfigurationManager.showSaveTemplateAsDialog(this.myConfigurations, dialog.getConfiguration(), dialog.getProject())) {
            return;
        }
        this.configurationsChanged(dialog.getProject());
    }

    private static SearchDialog createDialog(SearchDialogFactory searchDialogFactory) {
        SearchContext searchContext = SSBasedInspectionOptions.createSearchContext();
        return searchDialogFactory.createDialog(searchContext);
    }

    static SearchContext createSearchContext() {
        AnActionEvent event = new AnActionEvent(null, DataManager.getInstance().getDataContext(), "", new DefaultActionGroup().getTemplatePresentation(), ActionManager.getInstance(), 0);
        return SearchContext.buildFromDataContext(event.getDataContext());
    }

    public void configurationsChanged(Project project2) {
        ((MyListModel)this.myTemplatesList.getModel()).fireContentsChanged();
        DaemonCodeAnalyzer.getInstance((Project)project2).restart();
    }

    public JPanel getComponent() {
        final JPanel panel = new JPanel(new BorderLayout());
        panel.add(new JLabel(SSRBundle.message("SSRInspection.selected.templates", new Object[0])));
        panel.add(ToolbarDecorator.createDecorator(this.myTemplatesList).setAddAction(new AnActionButtonRunnable(){

            public void run(AnActionButton button) {
                AnAction[] children = new AnAction[]{new AnAction(SSRBundle.message("SSRInspection.add.search.template.button", new Object[0])){

                    public void actionPerformed(AnActionEvent e) {
                        SSBasedInspectionOptions.this.addTemplate(new SearchDialogFactory(){

                            @Override
                            public SearchDialog createDialog(SearchContext searchContext) {
                                return new SearchDialog(searchContext, false, false);
                            }
                        });
                    }
                }, new AnAction(SSRBundle.message("SSRInspection.add.replace.template.button", new Object[0])){

                    public void actionPerformed(AnActionEvent e) {
                        SSBasedInspectionOptions.this.addTemplate(new SearchDialogFactory(){

                            @Override
                            public SearchDialog createDialog(SearchContext searchContext) {
                                return new ReplaceDialog(searchContext, false, false);
                            }
                        });
                    }
                }};
                JBPopupFactory.getInstance().createActionGroupPopup(null, (ActionGroup)new DefaultActionGroup(children), DataManager.getInstance().getDataContext((Component)button.getContextComponent()), JBPopupFactory.ActionSelectionAid.SPEEDSEARCH, true).show(button.getPreferredPopupPoint());
            }
        }).setEditAction(new AnActionButtonRunnable(){

            public void run(AnActionButton button) {
                Project project2 = (Project)CommonDataKeys.PROJECT.getData(DataManager.getInstance().getDataContext((Component)panel));
                if (project2 != null && !DumbService.isDumb((Project)project2)) {
                    SSBasedInspectionOptions.this.performEditAction(project2);
                }
            }
        }).setEditActionUpdater(new AnActionButtonUpdater(){

            public boolean isEnabled(AnActionEvent e) {
                Project project2 = e.getProject();
                return project2 != null && !DumbService.isDumb((Project)project2);
            }
        }).setRemoveAction(new AnActionButtonRunnable(){

            public void run(AnActionButton button) {
                Project project2 = (Project)CommonDataKeys.PROJECT.getData(DataManager.getInstance().getDataContext((Component)panel));
                if (project2 == null) {
                    return;
                }
                for (Configuration configuration : SSBasedInspectionOptions.this.myTemplatesList.getSelectedValuesList()) {
                    SSBasedInspectionOptions.this.myConfigurations.remove(configuration);
                    SSBasedInspectionCompiledPatternsCache.removeFromCache(configuration, project2);
                }
                SSBasedInspectionOptions.this.configurationsChanged(project2);
            }
        }).setRemoveActionUpdater(new AnActionButtonUpdater(){

            public boolean isEnabled(AnActionEvent e) {
                Project project2 = e.getProject();
                return project2 != null && !DumbService.isDumb((Project)project2);
            }
        }).setMoveUpAction(new AnActionButtonRunnable(){

            public void run(AnActionButton button) {
                SSBasedInspectionOptions.this.performMoveUpDown(false);
            }
        }).setMoveDownAction(new AnActionButtonRunnable(){

            public void run(AnActionButton button) {
                SSBasedInspectionOptions.this.performMoveUpDown(true);
            }
        }).setPreferredSize(new Dimension(-1, 100)).createPanel());
        new DoubleClickListener(){

            protected boolean onDoubleClick(MouseEvent e) {
                Project project2 = (Project)CommonDataKeys.PROJECT.getData(DataManager.getInstance().getDataContext((Component)panel));
                if (project2 != null && !DumbService.isDumb((Project)project2)) {
                    SSBasedInspectionOptions.this.performEditAction(project2);
                }
                return true;
            }
        }.installOn(this.myTemplatesList);
        return panel;
    }

    void performMoveUpDown(boolean down) {
        int i;
        int[] indices = this.myTemplatesList.getSelectedIndices();
        if (indices.length == 0) {
            return;
        }
        int delta = down ? 1 : -1;
        this.myTemplatesList.removeSelectionInterval(0, this.myConfigurations.size() - 1);
        int n = i = down ? indices.length - 1 : 0;
        while (down ? i >= 0 : i < indices.length) {
            int index = indices[i];
            Configuration temp = this.myConfigurations.get(index);
            this.myConfigurations.set(index, this.myConfigurations.get(index + delta));
            this.myConfigurations.set(index + delta, temp);
            this.myTemplatesList.addSelectionInterval(index + delta, index + delta);
            i -= delta;
        }
        int index = down ? this.myTemplatesList.getMaxSelectionIndex() : this.myTemplatesList.getMinSelectionIndex();
        Rectangle cellBounds = this.myTemplatesList.getCellBounds(index, index);
        if (cellBounds != null) {
            this.myTemplatesList.scrollRectToVisible(cellBounds);
        }
    }

    void performEditAction(Project project2) {
        final Configuration configuration = (Configuration)this.myTemplatesList.getSelectedValue();
        if (configuration == null) {
            return;
        }
        SearchDialog dialog = SSBasedInspectionOptions.createDialog(new SearchDialogFactory(){

            @Override
            public SearchDialog createDialog(SearchContext searchContext) {
                if (configuration instanceof SearchConfiguration) {
                    return new SearchDialog(searchContext, false, false){

                        @Override
                        public Configuration createConfiguration(Configuration c) {
                            return configuration.copy();
                        }
                    };
                }
                return new ReplaceDialog(searchContext, false, false){

                    @Override
                    public Configuration createConfiguration(Configuration c) {
                        return configuration.copy();
                    }
                };
            }
        });
        dialog.setValuesFromConfig(configuration);
        dialog.setUseLastConfiguration(true);
        if (!dialog.showAndGet()) {
            return;
        }
        Configuration newConfiguration = dialog.getConfiguration();
        int index = this.myConfigurations.indexOf(configuration);
        this.myConfigurations.set(index, newConfiguration);
        SSBasedInspectionCompiledPatternsCache.removeFromCache(configuration, project2);
        this.configurationsChanged(project2);
    }

    private class MyListModel
    extends AbstractListModel<Configuration> {
        private MyListModel() {
        }

        @Override
        public int getSize() {
            return SSBasedInspectionOptions.this.myConfigurations.size();
        }

        @Override
        public Configuration getElementAt(int index) {
            return index < SSBasedInspectionOptions.this.myConfigurations.size() ? SSBasedInspectionOptions.this.myConfigurations.get(index) : null;
        }

        public void fireContentsChanged() {
            this.fireContentsChanged(SSBasedInspectionOptions.this.myTemplatesList, -1, -1);
        }
    }

    static interface SearchDialogFactory {
        public SearchDialog createDialog(SearchContext var1);
    }
}

