/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.structuralsearch.impl.matcher.predicates;

import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiAnonymousClass;
import com.intellij.psi.PsiArrayType;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiExpressionStatement;
import com.intellij.psi.PsiIdentifier;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiSubstitutor;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiTypeParameter;
import com.intellij.structuralsearch.impl.matcher.MatchContext;
import com.intellij.structuralsearch.impl.matcher.predicates.MatchPredicate;
import com.intellij.structuralsearch.impl.matcher.predicates.RegExpPredicate;
import com.intellij.util.SmartList;
import gnu.trove.THashSet;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class ExprTypePredicate
extends MatchPredicate {
    private final RegExpPredicate delegate;
    private final boolean withinHierarchy;
    private final boolean needsTypeParameters;
    private final boolean needsFullyQualified;
    private final boolean needsArrayType;
    private final boolean myCaseSensitive;
    private final List<String> myTypes;

    public ExprTypePredicate(String type, String baseName, boolean _withinHierarchy, boolean caseSensitiveMatch, boolean target) {
        this.delegate = Registry.is((String)"ssr.use.regexp.to.specify.type") ? new RegExpPredicate(type, caseSensitiveMatch, baseName, false, target) : null;
        this.withinHierarchy = _withinHierarchy;
        this.needsTypeParameters = type.indexOf(60) >= 0;
        this.needsFullyQualified = type.indexOf(46) >= 0;
        this.needsArrayType = type.indexOf(91) >= 0;
        this.myCaseSensitive = caseSensitiveMatch;
        this.myTypes = StringUtil.split((String)type, (String)"|");
    }

    @Override
    public boolean match(PsiElement match, int start, int end, MatchContext context) {
        if (match instanceof PsiIdentifier) {
            match = match.getParent();
        } else if (match instanceof PsiExpressionStatement) {
            match = ((PsiExpressionStatement)match).getExpression();
        }
        if (!(match instanceof PsiExpression)) {
            return false;
        }
        PsiType type = this.evalType((PsiExpression)match, context);
        return type != null && this.doMatchWithTheType(type, context, match, null);
    }

    protected PsiType evalType(PsiExpression match, MatchContext context) {
        PsiElement parent;
        if (match instanceof PsiReferenceExpression && (parent = match.getParent()) instanceof PsiMethodCallExpression) {
            return ((PsiMethodCallExpression)parent).getType();
        }
        return match.getType();
    }

    private boolean doMatchWithTheType(PsiType type, MatchContext context, PsiElement matchedNode, Set<PsiType> visited) {
        List<String> permutations = this.getTextPermutations(type);
        for (String permutation : permutations) {
            if (!(this.delegate == null ? this.doMatch(permutation) : this.delegate.doMatch(permutation, context, matchedNode))) continue;
            return true;
        }
        if (this.withinHierarchy) {
            if (visited == null) {
                visited = new THashSet();
                visited.add(type);
            }
            for (PsiType superType : type.getSuperTypes()) {
                if (!visited.add(superType) || !this.doMatchWithTheType(superType, context, matchedNode, (Set<PsiType>)visited)) continue;
                return true;
            }
        }
        return false;
    }

    private boolean doMatch(String text) {
        return this.myTypes.stream().anyMatch(type -> this.myCaseSensitive ? type.equals(text) : type.equalsIgnoreCase(text));
    }

    private List<String> getTextPermutations(PsiType type) {
        String dimensions;
        if (type instanceof PsiArrayType) {
            if (!this.needsArrayType) {
                return Collections.emptyList();
            }
            dimensions = StringUtil.repeat((String)"[]", (int)type.getArrayDimensions());
            type = type.getDeepComponentType();
        } else {
            dimensions = "";
        }
        SmartList result = new SmartList();
        if (type instanceof PsiClassType) {
            PsiClassType classType = (PsiClassType)type;
            PsiClassType.ClassResolveResult resolveResult = classType.resolveGenerics();
            PsiClass aClass = resolveResult.getElement();
            StringBuilder typeText = new StringBuilder();
            if (aClass != null) {
                PsiSubstitutor substitutor = resolveResult.getSubstitutor();
                ExprTypePredicate.buildText(aClass, substitutor, true, typeText);
                typeText.append(dimensions);
                String unqualified = typeText.toString();
                if (this.needsTypeParameters) {
                    result.add(unqualified);
                }
                ExprTypePredicate.addWithoutTypeParameters(unqualified, dimensions, (List<String>)result);
                if (typeText.indexOf(".") >= 0) {
                    typeText.setLength(0);
                    ExprTypePredicate.buildText(aClass, substitutor, false, typeText);
                    typeText.append(dimensions);
                    String outerClassQualified = typeText.toString();
                    if (this.needsTypeParameters) {
                        result.add(outerClassQualified);
                    }
                    ExprTypePredicate.addWithoutTypeParameters(outerClassQualified, dimensions, (List<String>)result);
                }
                if (!this.needsFullyQualified) {
                    return result;
                }
            }
        }
        String fullyQualified = type.getCanonicalText() + dimensions;
        if (this.needsTypeParameters) {
            result.add(fullyQualified);
        }
        ExprTypePredicate.addWithoutTypeParameters(fullyQualified, dimensions, (List<String>)result);
        return result;
    }

    private static void addWithoutTypeParameters(String typeText, String suffix, List<String> result) {
        int lt = typeText.indexOf("<");
        if (lt >= 0) {
            result.add(typeText.substring(0, lt) + suffix);
        } else if (result.isEmpty() || !result.get(result.size() - 1).equals(typeText)) {
            result.add(typeText);
        }
    }

    private static void buildText(PsiClass aClass, PsiSubstitutor substitutor, boolean qualifyInnerClasses, StringBuilder text) {
        PsiTypeParameter[] parameters;
        PsiElement parent;
        if (aClass instanceof PsiAnonymousClass) {
            PsiClassType baseClassType = ((PsiAnonymousClass)aClass).getBaseClassType();
            PsiClassType.ClassResolveResult baseResolveResult = baseClassType.resolveGenerics();
            PsiClass baseClass = baseResolveResult.getElement();
            if (baseClass != null) {
                ExprTypePredicate.buildText(baseClass, substitutor == null ? null : baseResolveResult.getSubstitutor(), qualifyInnerClasses, text);
            } else {
                text.append(baseClassType.getCanonicalText());
            }
            return;
        }
        if (qualifyInnerClasses && (parent = aClass.getParent()) instanceof PsiClass && !(parent instanceof PsiAnonymousClass)) {
            ExprTypePredicate.buildText((PsiClass)parent, substitutor, true, text);
            text.append('.');
        }
        text.append(aClass.getName());
        if (substitutor != null && (parameters = aClass.getTypeParameters()).length > 0) {
            int pos = text.length();
            text.append('<');
            Map substitutionMap = substitutor.getSubstitutionMap();
            int length = parameters.length;
            for (int i = 0; i < length; ++i) {
                PsiClassType classType;
                PsiClassType.ClassResolveResult result;
                PsiClass aClass1;
                PsiTypeParameter parameter = parameters[i];
                PsiType parameterType = (PsiType)substitutionMap.get(parameter);
                if (parameterType == null) {
                    text.setLength(pos);
                    return;
                }
                if (i > 0) {
                    text.append(',');
                }
                if (parameterType instanceof PsiClassType && (aClass1 = (result = (classType = (PsiClassType)parameterType).resolveGenerics()).getElement()) != null) {
                    ExprTypePredicate.buildText(aClass1, result.getSubstitutor(), qualifyInnerClasses, text);
                    continue;
                }
                text.append(parameterType.getPresentableText());
            }
            text.append('>');
        }
    }
}

