/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.packaging.impl.artifacts;

import com.intellij.openapi.roots.ProjectModelExternalSource;
import com.intellij.openapi.util.UserDataHolderBase;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.packaging.artifacts.Artifact;
import com.intellij.packaging.artifacts.ArtifactListener;
import com.intellij.packaging.artifacts.ArtifactProperties;
import com.intellij.packaging.artifacts.ArtifactPropertiesProvider;
import com.intellij.packaging.artifacts.ArtifactType;
import com.intellij.packaging.artifacts.ModifiableArtifact;
import com.intellij.packaging.elements.CompositePackagingElement;
import com.intellij.packaging.impl.elements.ArchivePackagingElement;
import com.intellij.util.EventDispatcher;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ArtifactImpl
extends UserDataHolderBase
implements ModifiableArtifact {
    private CompositePackagingElement<?> myRootElement;
    private String myName;
    private boolean myBuildOnMake;
    private String myOutputPath;
    private final EventDispatcher<ArtifactListener> myDispatcher;
    private ArtifactType myArtifactType;
    private Map<ArtifactPropertiesProvider, ArtifactProperties<?>> myProperties;
    private final ProjectModelExternalSource myExternalSource;

    public ArtifactImpl(@NotNull String name2, @NotNull ArtifactType artifactType, boolean buildOnMake, @NotNull CompositePackagingElement<?> rootElement, String outputPath, @Nullable ProjectModelExternalSource externalSource) {
        if (name2 == null) {
            ArtifactImpl.$$$reportNull$$$0(0);
        }
        if (artifactType == null) {
            ArtifactImpl.$$$reportNull$$$0(1);
        }
        if (rootElement == null) {
            ArtifactImpl.$$$reportNull$$$0(2);
        }
        this(name2, artifactType, buildOnMake, rootElement, outputPath, externalSource, null);
    }

    public ArtifactImpl(@NotNull String name2, @NotNull ArtifactType artifactType, boolean buildOnMake, @NotNull CompositePackagingElement<?> rootElement, String outputPath, @Nullable ProjectModelExternalSource externalSource, EventDispatcher<ArtifactListener> dispatcher) {
        if (name2 == null) {
            ArtifactImpl.$$$reportNull$$$0(3);
        }
        if (artifactType == null) {
            ArtifactImpl.$$$reportNull$$$0(4);
        }
        if (rootElement == null) {
            ArtifactImpl.$$$reportNull$$$0(5);
        }
        this.myName = name2;
        this.myArtifactType = artifactType;
        this.myBuildOnMake = buildOnMake;
        this.myRootElement = rootElement;
        this.myOutputPath = outputPath;
        this.myDispatcher = dispatcher;
        this.myExternalSource = externalSource;
        this.myProperties = new HashMap();
        this.resetProperties();
    }

    private void resetProperties() {
        this.myProperties.clear();
        for (ArtifactPropertiesProvider provider : ArtifactPropertiesProvider.getProviders()) {
            if (!provider.isAvailableFor(this.myArtifactType)) continue;
            this.myProperties.put(provider, provider.createProperties(this.myArtifactType));
        }
    }

    @NotNull
    public ArtifactType getArtifactType() {
        ArtifactType artifactType = this.myArtifactType;
        if (artifactType == null) {
            ArtifactImpl.$$$reportNull$$$0(6);
        }
        return artifactType;
    }

    public String getName() {
        return this.myName;
    }

    public boolean isBuildOnMake() {
        return this.myBuildOnMake;
    }

    @NotNull
    public CompositePackagingElement<?> getRootElement() {
        CompositePackagingElement<?> compositePackagingElement = this.myRootElement;
        if (compositePackagingElement == null) {
            ArtifactImpl.$$$reportNull$$$0(7);
        }
        return compositePackagingElement;
    }

    public String getOutputPath() {
        return this.myOutputPath;
    }

    public Collection<? extends ArtifactPropertiesProvider> getPropertiesProviders() {
        return Collections.unmodifiableCollection(this.myProperties.keySet());
    }

    @Nullable
    public ProjectModelExternalSource getExternalSource() {
        return this.myExternalSource;
    }

    public ArtifactImpl createCopy(EventDispatcher<ArtifactListener> dispatcher) {
        ArtifactImpl artifact = new ArtifactImpl(this.myName, this.myArtifactType, this.myBuildOnMake, this.myRootElement, this.myOutputPath, this.myExternalSource, dispatcher);
        for (Map.Entry<ArtifactPropertiesProvider, ArtifactProperties<?>> entry : this.myProperties.entrySet()) {
            ArtifactProperties<?> newProperties = artifact.myProperties.get(entry.getKey());
            newProperties.loadState(entry.getValue().getState());
        }
        return artifact;
    }

    public void setName(@NotNull String name2) {
        if (name2 == null) {
            ArtifactImpl.$$$reportNull$$$0(8);
        }
        String oldName = this.myName;
        this.myName = name2;
        if (this.myDispatcher != null) {
            ((ArtifactListener)this.myDispatcher.getMulticaster()).artifactChanged((Artifact)this, oldName);
        }
    }

    @NonNls
    public String toString() {
        return "artifact:" + this.myName;
    }

    public void setRootElement(CompositePackagingElement<?> root) {
        this.myRootElement = root;
    }

    public void setProperties(ArtifactPropertiesProvider provider, ArtifactProperties<?> properties) {
        if (properties != null) {
            this.myProperties.put(provider, properties);
        } else {
            this.myProperties.remove(provider);
        }
    }

    public void setArtifactType(@NotNull ArtifactType selected) {
        if (selected == null) {
            ArtifactImpl.$$$reportNull$$$0(9);
        }
        this.myArtifactType = selected;
        this.resetProperties();
    }

    public void setBuildOnMake(boolean buildOnMake) {
        this.myBuildOnMake = buildOnMake;
    }

    public void setOutputPath(String outputPath) {
        this.myOutputPath = outputPath;
    }

    public ArtifactProperties<?> getProperties(@NotNull ArtifactPropertiesProvider provider) {
        if (provider == null) {
            ArtifactImpl.$$$reportNull$$$0(10);
        }
        return this.myProperties.get(provider);
    }

    public VirtualFile getOutputFile() {
        String filePath = this.getOutputFilePath();
        return !StringUtil.isEmpty((String)filePath) ? LocalFileSystem.getInstance().findFileByPath(filePath) : null;
    }

    public String getOutputFilePath() {
        if (StringUtil.isEmpty((String)this.myOutputPath)) {
            return null;
        }
        String filePath = this.myRootElement instanceof ArchivePackagingElement ? this.myOutputPath + "/" + ((ArchivePackagingElement)this.myRootElement).getArchiveFileName() : this.myOutputPath;
        return filePath;
    }

    public void copyFrom(ArtifactImpl modified) {
        this.myName = modified.getName();
        this.myOutputPath = modified.getOutputPath();
        this.myBuildOnMake = modified.isBuildOnMake();
        this.myRootElement = modified.getRootElement();
        this.myProperties = modified.myProperties;
        this.myArtifactType = modified.getArtifactType();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 6: 
            case 7: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 6: 
            case 7: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 1: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "artifactType";
                break;
            }
            case 2: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "rootElement";
                break;
            }
            case 6: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/packaging/impl/artifacts/ArtifactImpl";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "selected";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "provider";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/packaging/impl/artifacts/ArtifactImpl";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getArtifactType";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getRootElement";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 6: 
            case 7: {
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "setName";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "setArtifactType";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "getProperties";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 6: 
            case 7: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

