/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.roots.ui.configuration.projectRoot.daemon;

import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleType;
import com.intellij.openapi.roots.DependencyScope;
import com.intellij.openapi.roots.ModifiableRootModel;
import com.intellij.openapi.roots.impl.OrderEntryUtil;
import com.intellij.openapi.roots.libraries.Library;
import com.intellij.openapi.roots.ui.configuration.ModuleEditor;
import com.intellij.openapi.roots.ui.configuration.projectRoot.ModuleStructureConfigurable;
import com.intellij.openapi.roots.ui.configuration.projectRoot.StructureConfigurableContext;
import com.intellij.openapi.roots.ui.configuration.projectRoot.daemon.LibraryProjectStructureElement;
import com.intellij.openapi.roots.ui.configuration.projectRoot.daemon.ModuleProjectStructureElement;
import com.intellij.openapi.roots.ui.configuration.projectRoot.daemon.PlaceInModuleClasspath;
import com.intellij.openapi.roots.ui.configuration.projectRoot.daemon.PlaceInProjectStructure;
import com.intellij.openapi.roots.ui.configuration.projectRoot.daemon.ProjectStructureElement;
import com.intellij.openapi.roots.ui.configuration.projectRoot.daemon.ProjectStructureElementUsage;
import com.intellij.openapi.util.text.StringUtil;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class UsageInModuleClasspath
extends ProjectStructureElementUsage {
    private final StructureConfigurableContext myContext;
    private final ModuleProjectStructureElement myContainingElement;
    @Nullable
    private final DependencyScope myScope;
    private final ProjectStructureElement mySourceElement;
    private final Module myModule;

    public UsageInModuleClasspath(@NotNull StructureConfigurableContext context, @NotNull ModuleProjectStructureElement containingElement, ProjectStructureElement sourceElement, @Nullable DependencyScope scope) {
        if (context == null) {
            UsageInModuleClasspath.$$$reportNull$$$0(0);
        }
        if (containingElement == null) {
            UsageInModuleClasspath.$$$reportNull$$$0(1);
        }
        this.myContext = context;
        this.myContainingElement = containingElement;
        this.myScope = scope;
        this.myModule = containingElement.getModule();
        this.mySourceElement = sourceElement;
    }

    @Override
    public ProjectStructureElement getSourceElement() {
        return this.mySourceElement;
    }

    @Override
    public ModuleProjectStructureElement getContainingElement() {
        return this.myContainingElement;
    }

    public Module getModule() {
        return this.myModule;
    }

    @Override
    public String getPresentableName() {
        return this.myModule.getName();
    }

    @Override
    public PlaceInProjectStructure getPlace() {
        return new PlaceInModuleClasspath(this.myContext, this.myModule, (ProjectStructureElement)this.myContainingElement, this.mySourceElement);
    }

    @Override
    public int hashCode() {
        return this.myModule.hashCode() * 31 + this.mySourceElement.hashCode();
    }

    @Override
    public boolean equals(Object obj) {
        return obj instanceof UsageInModuleClasspath && this.myModule.equals(((UsageInModuleClasspath)obj).myModule) && this.mySourceElement.equals(((UsageInModuleClasspath)obj).mySourceElement);
    }

    @Override
    public Icon getIcon() {
        return ModuleType.get((Module)this.myModule).getIcon();
    }

    @Override
    public void removeSourceElement() {
        if (this.mySourceElement instanceof LibraryProjectStructureElement) {
            ModuleStructureConfigurable.getInstance(this.myModule.getProject()).removeLibraryOrderEntry(this.myModule, ((LibraryProjectStructureElement)this.mySourceElement).getLibrary());
        }
    }

    @Override
    @Nullable
    public String getPresentableLocationInElement() {
        return this.myScope != null && this.myScope != DependencyScope.COMPILE ? "[" + StringUtil.decapitalize((String)this.myScope.getDisplayName()) + "]" : null;
    }

    @Override
    public void replaceElement(ProjectStructureElement newElement) {
        ModuleEditor editor = this.myContext.getModulesConfigurator().getModuleEditor(this.myModule);
        if (editor != null) {
            ModifiableRootModel rootModel = editor.getModifiableRootModelProxy();
            OrderEntryUtil.replaceLibrary((ModifiableRootModel)rootModel, (Library)((LibraryProjectStructureElement)this.mySourceElement).getLibrary(), (Library)((LibraryProjectStructureElement)newElement).getLibrary());
            this.myContext.getDaemonAnalyzer().queueUpdate(new ModuleProjectStructureElement(this.myContext, this.myModule));
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[0] = "context";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[0] = "containingElement";
                break;
            }
        }
        objectArray[1] = "com/intellij/openapi/roots/ui/configuration/projectRoot/daemon/UsageInModuleClasspath";
        objectArray[2] = "<init>";
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

