/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.roots.ui.configuration.projectRoot;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectBundle;
import com.intellij.openapi.roots.libraries.Library;
import com.intellij.openapi.roots.libraries.LibraryTable;
import com.intellij.openapi.roots.ui.configuration.libraries.LibraryPresentationManager;
import com.intellij.openapi.roots.ui.configuration.libraryEditor.LibraryEditor;
import com.intellij.openapi.roots.ui.configuration.libraryEditor.LibraryRootsComponent;
import com.intellij.openapi.roots.ui.configuration.projectRoot.ProjectStructureElementConfigurable;
import com.intellij.openapi.roots.ui.configuration.projectRoot.StructureConfigurableContext;
import com.intellij.openapi.roots.ui.configuration.projectRoot.StructureLibraryTableModifiableModelProvider;
import com.intellij.openapi.roots.ui.configuration.projectRoot.daemon.LibraryProjectStructureElement;
import com.intellij.openapi.roots.ui.configuration.projectRoot.daemon.ProjectStructureElement;
import com.intellij.openapi.util.Computable;
import com.intellij.openapi.util.Disposer;
import javax.swing.Icon;
import javax.swing.JComponent;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class LibraryConfigurable
extends ProjectStructureElementConfigurable<Library> {
    private LibraryRootsComponent myLibraryEditorComponent;
    private final Library myLibrary;
    private final StructureLibraryTableModifiableModelProvider myModel;
    private final StructureConfigurableContext myContext;
    private final Project myProject;
    private final LibraryProjectStructureElement myProjectStructureElement;
    private boolean myUpdatingName;
    private boolean myPropertiesLoaded;

    protected LibraryConfigurable(StructureLibraryTableModifiableModelProvider modelProvider, Library library, StructureConfigurableContext context, Runnable updateTree) {
        super(true, updateTree);
        this.myModel = modelProvider;
        this.myContext = context;
        this.myProject = context.getProject();
        this.myLibrary = library;
        this.myProjectStructureElement = new LibraryProjectStructureElement(context, this.myLibrary);
    }

    public JComponent createOptionsPanel() {
        this.myLibraryEditorComponent = new LibraryRootsComponent(this.myProject, (Computable<LibraryEditor>)((Computable)() -> this.getLibraryEditor()));
        this.myLibraryEditorComponent.addListener(() -> {
            this.myContext.getDaemonAnalyzer().queueUpdate(this.myProjectStructureElement);
            this.updateName();
        });
        return this.myLibraryEditorComponent.getComponent();
    }

    public boolean isModified() {
        return this.myLibraryEditorComponent != null && this.myLibraryEditorComponent.hasChanges();
    }

    @Override
    @NotNull
    public ProjectStructureElement getProjectStructureElement() {
        LibraryProjectStructureElement libraryProjectStructureElement = this.myProjectStructureElement;
        if (libraryProjectStructureElement == null) {
            LibraryConfigurable.$$$reportNull$$$0(0);
        }
        return libraryProjectStructureElement;
    }

    public void apply() {
        this.applyProperties();
    }

    public void reset() {
        this.resetProperties();
    }

    public void disposeUIResources() {
        if (this.myLibraryEditorComponent != null) {
            Disposer.dispose((Disposable)this.myLibraryEditorComponent);
            this.myLibraryEditorComponent = null;
        }
    }

    public void setDisplayName(String name2) {
        if (!this.myUpdatingName) {
            this.getLibraryEditor().setName(name2);
            if (this.myLibraryEditorComponent != null) {
                this.myLibraryEditorComponent.onLibraryRenamed();
            }
            this.myContext.getDaemonAnalyzer().queueUpdateForAllElementsWithErrors();
        }
    }

    protected LibraryEditor getLibraryEditor() {
        return this.myModel.getModifiableModel().getLibraryEditor(this.myLibrary);
    }

    public void updateName() {
        this.myUpdatingName = true;
        try {
            super.updateName();
        }
        finally {
            this.myUpdatingName = false;
        }
    }

    public Library getEditableObject() {
        return this.myLibrary;
    }

    public String getBannerSlogan() {
        LibraryTable libraryTable = this.myLibrary.getTable();
        String libraryType = libraryTable == null ? ProjectBundle.message((String)"module.library.display.name", (Object[])new Object[]{1}) : libraryTable.getPresentation().getDisplayName(false);
        return ProjectBundle.message((String)"project.roots.library.banner.text", (Object[])new Object[]{this.getDisplayName(), libraryType});
    }

    public String getDisplayName() {
        if (this.myModel.getModifiableModel().hasLibraryEditor(this.myLibrary)) {
            return this.getLibraryEditor().getName();
        }
        return this.myLibrary.getName();
    }

    public void onSelected() {
        this.resetProperties();
    }

    public void onUnselected() {
        this.applyProperties();
    }

    private void resetProperties() {
        if (this.myLibraryEditorComponent != null) {
            this.myLibraryEditorComponent.updatePropertiesLabel();
            this.myLibraryEditorComponent.resetProperties();
            this.myPropertiesLoaded = true;
        }
    }

    private void applyProperties() {
        if (this.myLibraryEditorComponent != null && this.myPropertiesLoaded) {
            this.myLibraryEditorComponent.applyProperties();
            this.myPropertiesLoaded = false;
        }
    }

    public Icon getIcon(boolean open) {
        return LibraryPresentationManager.getInstance().getNamedLibraryIcon(this.myLibrary, this.myContext);
    }

    @Nullable
    @NonNls
    public String getHelpTopic() {
        return "preferences.jdkGlobalLibs";
    }

    public void updateComponent() {
        if (this.myLibraryEditorComponent != null) {
            this.myLibraryEditorComponent.updateRootsTree();
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/roots/ui/configuration/projectRoot/LibraryConfigurable", "getProjectStructureElement"));
    }
}

