/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.roots.ui.configuration.libraryEditor;

import com.intellij.notification.Notification;
import com.intellij.notification.NotificationType;
import com.intellij.openapi.application.ApplicationBundle;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.Task;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.sun.jna.platform.mac.XAttrUtil;
import java.io.IOException;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.jetbrains.annotations.NotNull;

public class JavadocQuarantineStatusCleaner {
    private static final Logger LOG = Logger.getInstance(JavadocQuarantineStatusCleaner.class);
    private static final String QUARANTINE_ATTRIBUTE = "com.apple.quarantine";

    public static void cleanIfNeeded(VirtualFile ... docFolders) {
        if (docFolders == null) {
            JavadocQuarantineStatusCleaner.$$$reportNull$$$0(0);
        }
        if (docFolders.length > 0 && SystemInfo.isMac) {
            ApplicationManager.getApplication().executeOnPooledThread(() -> {
                List quarantined;
                if (docFolders == null) {
                    JavadocQuarantineStatusCleaner.$$$reportNull$$$0(1);
                }
                if (!(quarantined = Stream.of(docFolders).filter(f -> f.isInLocalFileSystem() && f.isDirectory() && XAttrUtil.getXAttr((String)f.getPath(), (String)QUARANTINE_ATTRIBUTE) != null).map(VirtualFile::getPath).collect(Collectors.toList())).isEmpty()) {
                    ApplicationManager.getApplication().invokeLater(() -> {
                        String title = ApplicationBundle.message((String)"quarantine.cleaner", (Object[])new Object[0]);
                        String message = ApplicationBundle.message((String)"quarantine.dialog.message", (Object[])new Object[]{StringUtil.join((Collection)quarantined, (String)"\n")});
                        if (Messages.showYesNoDialog((String)message, (String)title, null) == 0) {
                            JavadocQuarantineStatusCleaner.cleanQuarantineStatusInBackground(quarantined);
                        }
                    }, ModalityState.any());
                }
            });
        }
    }

    private static void cleanQuarantineStatusInBackground(final List<String> paths) {
        new Task.Backgroundable(null, ApplicationBundle.message((String)"quarantine.clean.progress", (Object[])new Object[0]), true){

            public void run(@NotNull ProgressIndicator indicator) {
                if (indicator == null) {
                    1.$$$reportNull$$$0(0);
                }
                for (String path : paths) {
                    indicator.checkCanceled();
                    indicator.setText2(path);
                    try {
                        Stream<Path> s = Files.walk(Paths.get(path, new String[0]), new FileVisitOption[0]);
                        Throwable throwable = null;
                        try {
                            s.forEach(p -> {
                                if (indicator == null) {
                                    1.$$$reportNull$$$0(2);
                                }
                                indicator.checkCanceled();
                                XAttrUtil.removeXAttr((String)p.toFile().getAbsolutePath(), (String)JavadocQuarantineStatusCleaner.QUARANTINE_ATTRIBUTE);
                            });
                        }
                        catch (Throwable throwable2) {
                            throwable = throwable2;
                            throw throwable2;
                        }
                        finally {
                            if (s == null) continue;
                            if (throwable != null) {
                                try {
                                    s.close();
                                }
                                catch (Throwable throwable3) {
                                    throwable.addSuppressed(throwable3);
                                }
                                continue;
                            }
                            s.close();
                        }
                    }
                    catch (IOException e) {
                        throw new RuntimeException(e);
                    }
                }
            }

            public void onThrowable(@NotNull Throwable error) {
                if (error == null) {
                    1.$$$reportNull$$$0(1);
                }
                LOG.warn(error);
                String title = ApplicationBundle.message((String)"quarantine.cleaner", (Object[])new Object[0]);
                String message = ApplicationBundle.message((String)"quarantine.error.message", (Object[])new Object[]{error.getMessage()});
                new Notification(title, title, message, NotificationType.WARNING).notify(null);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2;
                Object[] objectArray3 = new Object[3];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "indicator";
                        break;
                    }
                    case 1: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "error";
                        break;
                    }
                }
                objectArray2[1] = "com/intellij/openapi/roots/ui/configuration/libraryEditor/JavadocQuarantineStatusCleaner$1";
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[2] = "run";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[2] = "onThrowable";
                        break;
                    }
                    case 2: {
                        objectArray = objectArray2;
                        objectArray2[2] = "lambda$run$0";
                        break;
                    }
                }
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        }.queue();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        objectArray2[0] = "docFolders";
        objectArray2[1] = "com/intellij/openapi/roots/ui/configuration/libraryEditor/JavadocQuarantineStatusCleaner";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "cleanIfNeeded";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "lambda$cleanIfNeeded$2";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

