/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.roots.ui.configuration.classpath;

import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.StdModuleTypes;
import com.intellij.openapi.project.ProjectBundle;
import com.intellij.openapi.roots.ModifiableRootModel;
import com.intellij.openapi.roots.OrderEntry;
import com.intellij.openapi.roots.ui.configuration.ChooseModulesDialog;
import com.intellij.openapi.roots.ui.configuration.classpath.AddItemPopupAction;
import com.intellij.openapi.roots.ui.configuration.classpath.ClasspathElementChooser;
import com.intellij.openapi.roots.ui.configuration.classpath.ClasspathPanel;
import com.intellij.openapi.roots.ui.configuration.classpath.ClasspathTableItem;
import com.intellij.openapi.roots.ui.configuration.projectRoot.StructureConfigurableContext;
import com.intellij.openapi.ui.Messages;
import java.awt.Component;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;

class AddModuleDependencyAction
extends AddItemPopupAction<Module> {
    private final StructureConfigurableContext myContext;
    private final ClasspathPanel myClasspathPanel;

    public AddModuleDependencyAction(ClasspathPanel classpathPanel, int actionIndex, StructureConfigurableContext context) {
        super(classpathPanel, actionIndex, ProjectBundle.message((String)"classpath.add.module.dependency.action", (Object[])new Object[0]), StdModuleTypes.JAVA.getIcon());
        this.myContext = context;
        this.myClasspathPanel = classpathPanel;
    }

    @Override
    protected ClasspathTableItem<?> createTableItem(Module item) {
        return ClasspathTableItem.createItem((OrderEntry)this.myClasspathPanel.getRootModel().addModuleOrderEntry(item), this.myContext);
    }

    private List<Module> getNotAddedModules() {
        ModifiableRootModel rootModel = this.myClasspathPanel.getRootModel();
        HashSet<Module> addedModules = new HashSet<Module>(Arrays.asList(rootModel.getModuleDependencies(true)));
        addedModules.add(rootModel.getModule());
        Module[] modules = this.myClasspathPanel.getModuleConfigurationState().getModulesProvider().getModules();
        ArrayList<Module> elements = new ArrayList<Module>();
        for (Module module2 : modules) {
            if (addedModules.contains(module2)) continue;
            elements.add(module2);
        }
        return elements;
    }

    @Override
    protected ClasspathElementChooser<Module> createChooser() {
        List<Module> chooseItems = this.getNotAddedModules();
        if (chooseItems.isEmpty()) {
            Messages.showMessageDialog((Component)this.myClasspathPanel.getComponent(), (String)ProjectBundle.message((String)"message.no.module.dependency.candidates", (Object[])new Object[0]), (String)this.getTitle(), (Icon)Messages.getInformationIcon());
            return null;
        }
        return new ModuleChooser(this.myClasspathPanel, chooseItems, ProjectBundle.message((String)"classpath.chooser.title.add.module.dependency", (Object[])new Object[0]), ProjectBundle.message((String)"classpath.chooser.description.add.module.dependency", (Object[])new Object[0]));
    }

    private static class ModuleChooser
    implements ClasspathElementChooser<Module> {
        private final List<Module> myItems;
        private final String myTitle;
        private final String myDescription;
        private final ClasspathPanel myClasspathPanel;

        public ModuleChooser(ClasspathPanel classpathPanel, List<Module> items, String title, String description) {
            this.myItems = items;
            this.myTitle = title;
            this.myDescription = description;
            this.myClasspathPanel = classpathPanel;
        }

        @Override
        @NotNull
        public List<Module> chooseElements() {
            ChooseModulesDialog dialog = new ChooseModulesDialog((Component)this.myClasspathPanel.getComponent(), this.myItems, this.myTitle, this.myDescription);
            dialog.show();
            List list = dialog.getChosenElements();
            if (list == null) {
                ModuleChooser.$$$reportNull$$$0(0);
            }
            return list;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/roots/ui/configuration/classpath/AddModuleDependencyAction$ModuleChooser", "chooseElements"));
        }
    }
}

