/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.roots.ui.configuration.artifacts.actions;

import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.project.DumbAwareAction;
import com.intellij.openapi.roots.ui.configuration.artifacts.LayoutTreeComponent;
import com.intellij.openapi.roots.ui.configuration.artifacts.nodes.CompositePackagingElementNode;
import com.intellij.openapi.roots.ui.configuration.artifacts.nodes.PackagingElementNode;
import com.intellij.packaging.elements.CompositePackagingElement;
import com.intellij.packaging.elements.PackagingElement;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import javax.swing.Icon;

public class MovePackagingElementAction
extends DumbAwareAction {
    private final LayoutTreeComponent myLayoutTreeComponent;
    private final int myDirection;

    public MovePackagingElementAction(LayoutTreeComponent layoutTreeComponent, String text, String description, Icon icon, int direction) {
        super(text, description, icon);
        this.myLayoutTreeComponent = layoutTreeComponent;
        this.myDirection = direction;
    }

    public void update(AnActionEvent e) {
        boolean b = this.isEnabled();
        e.getPresentation().setEnabled(b);
        e.getPresentation().setText(this.getTemplatePresentation().getText() + " (disabled if elements are sorted)");
    }

    private boolean isEnabled() {
        if (this.myLayoutTreeComponent.isSortElements()) {
            return false;
        }
        PackagingElementNode<?> node = this.myLayoutTreeComponent.getSelection().getNodeIfSingle();
        if (node == null) {
            return false;
        }
        CompositePackagingElementNode parent = node.getParentNode();
        if (parent == null) {
            return false;
        }
        Object element = node.getElementIfSingle();
        CompositePackagingElement parentElement = (CompositePackagingElement)parent.getElementIfSingle();
        if (parentElement == null || element == null) {
            return false;
        }
        List children = parentElement.getChildren();
        int index = children.indexOf(element);
        return index != -1 && 0 <= index + this.myDirection && index + this.myDirection < children.size();
    }

    public void actionPerformed(AnActionEvent e) {
        PackagingElementNode<?> node = this.myLayoutTreeComponent.getSelection().getNodeIfSingle();
        if (node == null) {
            return;
        }
        CompositePackagingElementNode parent = node.getParentNode();
        if (parent == null) {
            return;
        }
        Object element = node.getElementIfSingle();
        CompositePackagingElement parentElement = (CompositePackagingElement)parent.getElementIfSingle();
        if (parentElement == null || element == null) {
            return;
        }
        if (!this.myLayoutTreeComponent.checkCanModifyChildren((PackagingElement<?>)parentElement, parent, (Collection<? extends PackagingElementNode<?>>)Arrays.asList(node))) {
            return;
        }
        ArrayList toSelect = new ArrayList();
        this.myLayoutTreeComponent.editLayout(() -> {
            int index = parentElement.getChildren().indexOf(element);
            PackagingElement moved = parentElement.moveChild(index, this.myDirection);
            if (moved != null) {
                toSelect.add(moved);
            }
        });
        if (!toSelect.isEmpty()) {
            this.myLayoutTreeComponent.updateAndSelect(parent, toSelect);
        }
    }
}

