/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.roots.ui.configuration.actions;

import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.LangDataKeys;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.module.ModifiableModuleModel;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleGrouperKt;
import com.intellij.openapi.project.DumbAwareAction;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectBundle;
import com.intellij.openapi.roots.ui.configuration.ProjectSettingsService;
import com.intellij.openapi.ui.InputValidator;
import com.intellij.openapi.ui.InputValidatorEx;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.TextRange;
import com.intellij.util.PathUtilRt;
import java.util.Collection;
import kotlin.Metadata;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 10}, bv={1, 0, 2}, k=1, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0016J\u0010\u0010\u0007\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0016\u00a8\u0006\b"}, d2={"Lcom/intellij/openapi/roots/ui/configuration/actions/ChangeModuleNamesAction;", "Lcom/intellij/openapi/project/DumbAwareAction;", "()V", "actionPerformed", "", "e", "Lcom/intellij/openapi/actionSystem/AnActionEvent;", "update", "intellij.java.ui"})
public final class ChangeModuleNamesAction
extends DumbAwareAction {
    public void update(@NotNull AnActionEvent e) {
        Intrinsics.checkParameterIsNotNull((Object)e, (String)"e");
        Project project2 = e.getProject();
        Presentation presentation = e.getPresentation();
        Intrinsics.checkExpressionValueIsNotNull((Object)presentation, (String)"e.presentation");
        presentation.setVisible(project2 != null && ModuleGrouperKt.isQualifiedModuleNamesEnabled((Project)project2) && e.getData(LangDataKeys.MODIFIABLE_MODULE_MODEL) != null);
        Module[] modules = (Module[])e.getData(LangDataKeys.MODULE_CONTEXT_ARRAY);
        Presentation presentation2 = e.getPresentation();
        Intrinsics.checkExpressionValueIsNotNull((Object)presentation2, (String)"e.presentation");
        presentation2.setEnabled(modules != null && modules.length > 1);
    }

    /*
     * WARNING - void declaration
     */
    public void actionPerformed(@NotNull AnActionEvent e) {
        boolean bl;
        Object it;
        String commonPrefix;
        ModifiableModuleModel model;
        Module[] modules;
        block6: {
            void $receiver$iv;
            String initial$iv;
            Intrinsics.checkParameterIsNotNull((Object)e, (String)"e");
            Module[] moduleArray = (Module[])e.getData(LangDataKeys.MODULE_CONTEXT_ARRAY);
            if (moduleArray == null) {
                return;
            }
            Intrinsics.checkExpressionValueIsNotNull((Object)moduleArray, (String)"e.getData(LangDataKeys.M\u2026_CONTEXT_ARRAY) ?: return");
            modules = moduleArray;
            ModifiableModuleModel modifiableModuleModel = (ModifiableModuleModel)e.getData(LangDataKeys.MODIFIABLE_MODULE_MODEL);
            if (modifiableModuleModel == null) {
                return;
            }
            Intrinsics.checkExpressionValueIsNotNull((Object)modifiableModuleModel, (String)"e.getData(LangDataKeys.M\u2026E_MODULE_MODEL) ?: return");
            model = modifiableModuleModel;
            Function1<Module, String> getGroupName$ = new Function1<Module, String>(model){
                final /* synthetic */ ModifiableModuleModel $model;

                @NotNull
                public final String invoke(@NotNull Module module2) {
                    Intrinsics.checkParameterIsNotNull((Object)module2, (String)"module");
                    StringBuilder stringBuilder = new StringBuilder();
                    String string = this.$model.getActualName(module2);
                    Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"model.getActualName(module)");
                    return stringBuilder.append(StringsKt.substringBeforeLast$default((String)string, (char)'.', null, (int)2, null)).append(".").toString();
                }
                {
                    this.$model = modifiableModuleModel;
                    super(1);
                }
            };
            Module[] moduleArray2 = modules;
            Module module2 = modules[0];
            Intrinsics.checkExpressionValueIsNotNull((Object)module2, (String)"modules[0]");
            String accumulator$iv = initial$iv = getGroupName$.invoke(module2);
            int n = ((void)$receiver$iv).length;
            for (int i = 0; i < n; ++i) {
                void m;
                void element$iv;
                void var12_17 = element$iv = $receiver$iv[i];
                String prefix = accumulator$iv;
                CharSequence charSequence = prefix;
                void v4 = m;
                Intrinsics.checkExpressionValueIsNotNull((Object)v4, (String)"m");
                accumulator$iv = StringsKt.commonPrefixWith$default((CharSequence)charSequence, (CharSequence)getGroupName$.invoke((Module)v4), (boolean)false, (int)2, null);
            }
            commonPrefix = StringsKt.substringBeforeLast((String)accumulator$iv, (char)'.', (String)"");
            for (Module element$iv : modules) {
                it = element$iv;
                if (!Intrinsics.areEqual((Object)model.getActualName((Module)it), (Object)commonPrefix)) continue;
                bl = true;
                break block6;
            }
            bl = false;
        }
        boolean isPrefixEqualToModuleName = bl;
        InputValidatorEx validator2 = new InputValidatorEx(isPrefixEqualToModuleName){
            final /* synthetic */ boolean $isPrefixEqualToModuleName;

            @Nullable
            public String getErrorText(@NotNull String inputString) {
                Intrinsics.checkParameterIsNotNull((Object)inputString, (String)"inputString");
                CharSequence charSequence = inputString;
                if (charSequence.length() > 0) {
                    boolean bl;
                    block7: {
                        Iterable $receiver$iv = StringsKt.split$default((CharSequence)inputString, (char[])new char[]{'.'}, (boolean)false, (int)0, (int)6, null);
                        if ($receiver$iv instanceof Collection && ((Collection)$receiver$iv).isEmpty()) {
                            bl = false;
                        } else {
                            for (T element$iv : $receiver$iv) {
                                String it = (String)element$iv;
                                CharSequence charSequence2 = it;
                                if (!(charSequence2.length() == 0)) continue;
                                bl = true;
                                break block7;
                            }
                            bl = false;
                        }
                    }
                    if (bl) {
                        return ProjectBundle.message((String)"error.message.module.name.prefix.contains.empty.string", (Object[])new Object[0]);
                    }
                }
                if (this.$isPrefixEqualToModuleName && (charSequence = (CharSequence)inputString).length() == 0) {
                    return ProjectBundle.message((String)"error.message.module.name.cannot.be.empty", (Object[])new Object[0]);
                }
                if (!PathUtilRt.isValidFileName((String)(inputString + ".iml"), (boolean)true)) {
                    return ProjectBundle.message((String)"error.message.module.name.prefix.contains.invalid.chars", (Object[])new Object[0]);
                }
                return null;
            }

            public boolean checkInput(@NotNull String inputString) {
                Intrinsics.checkParameterIsNotNull((Object)inputString, (String)"inputString");
                return this.getErrorText(inputString) == null;
            }

            public boolean canClose(@NotNull String inputString) {
                Intrinsics.checkParameterIsNotNull((Object)inputString, (String)"inputString");
                return this.getErrorText(inputString) == null;
            }
            {
                this.$isPrefixEqualToModuleName = $captured_local_variable$0;
            }
        };
        String newPrefix = Messages.showInputDialog((Project)e.getProject(), (String)ProjectBundle.message((String)"dialog.text.enter.common.prefix", (Object[])new Object[]{modules.length}), (String)ProjectBundle.message((String)"dialog.title.change.module.names", (Object[])new Object[0]), null, (String)commonPrefix, (InputValidator)((InputValidator)validator2), (TextRange)TextRange.allOf((String)commonPrefix), (String)ProjectBundle.message((String)"dialog.text.enter.common.prefix.comment", (Object[])new Object[0]));
        if (newPrefix == null) {
            return;
        }
        CharSequence element$iv = commonPrefix;
        String prefixToRemove = element$iv.length() == 0 ? "" : commonPrefix + '.';
        it = newPrefix;
        String prefixToPrepend = it.length() == 0 || StringsKt.endsWith$default((CharSequence)newPrefix, (char)'.', (boolean)false, (int)2, null) ? newPrefix : newPrefix + '.';
        Module[] $receiver$iv = modules;
        int n = $receiver$iv.length;
        for (int i = 0; i < n; ++i) {
            String oldName;
            Module element$iv2;
            Module it2 = element$iv2 = $receiver$iv[i];
            Intrinsics.checkExpressionValueIsNotNull((Object)model.getActualName(it2), (String)"model.getActualName(it)");
            String newName = Intrinsics.areEqual((Object)oldName, (Object)commonPrefix) ? newPrefix : prefixToPrepend + StringsKt.removePrefix((String)oldName, (CharSequence)prefixToRemove);
            model.renameModule(it2, newName);
        }
        ProjectSettingsService.getInstance((Project)e.getProject()).processModulesMoved(modules, null);
    }

    public ChangeModuleNamesAction() {
        super(ProjectBundle.message((String)"action.text.change.module.names", (Object[])new Object[0]), ProjectBundle.message((String)"action.description.change.module.names", (Object[])new Object[0]), null);
    }
}

