/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.roots.ui.configuration;

import com.intellij.openapi.extensions.ExtensionPointName;
import com.intellij.openapi.extensions.Extensions;
import com.intellij.openapi.roots.OrderRootType;
import com.intellij.openapi.roots.libraries.ui.LibraryRootsDetector;
import com.intellij.openapi.roots.libraries.ui.OrderRoot;
import com.intellij.openapi.roots.libraries.ui.RootDetector;
import com.intellij.openapi.roots.libraries.ui.impl.LibraryRootsDetectorImpl;
import com.intellij.openapi.roots.libraries.ui.impl.RootDetectionUtil;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VirtualFile;
import java.awt.Component;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

public class LibrarySourceRootDetectorUtil {
    public static ExtensionPointName<RootDetector> JAVA_SOURCE_ROOT_DETECTOR = ExtensionPointName.create((String)"com.intellij.library.javaSourceRootDetector");

    protected LibrarySourceRootDetectorUtil() {
    }

    public static VirtualFile[] scanAndSelectDetectedJavaSourceRoots(Component parentComponent, VirtualFile[] rootCandidates) {
        List orderRoots = RootDetectionUtil.detectRoots(Arrays.asList(rootCandidates), (Component)parentComponent, null, (LibraryRootsDetector)new LibraryRootsDetectorImpl(Arrays.asList(Extensions.getExtensions(JAVA_SOURCE_ROOT_DETECTOR))), (OrderRootType[])new OrderRootType[]{OrderRootType.SOURCES});
        ArrayList<VirtualFile> result = new ArrayList<VirtualFile>();
        for (OrderRoot root : orderRoots) {
            result.add(root.getFile());
        }
        return VfsUtil.toVirtualFileArray(result);
    }
}

