/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.roots.ui.configuration;

import com.intellij.ProjectTopics;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.options.ConfigurationException;
import com.intellij.openapi.project.ProjectBundle;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.roots.ModifiableRootModel;
import com.intellij.openapi.roots.ModuleRootEvent;
import com.intellij.openapi.roots.ModuleRootListener;
import com.intellij.openapi.roots.ModuleRootModel;
import com.intellij.openapi.roots.OrderEntry;
import com.intellij.openapi.roots.impl.storage.ClassPathStorageUtil;
import com.intellij.openapi.roots.impl.storage.ClasspathStorage;
import com.intellij.openapi.roots.impl.storage.ClasspathStorageProvider;
import com.intellij.openapi.roots.ui.configuration.ModuleConfigurationState;
import com.intellij.openapi.roots.ui.configuration.ModuleElementsEditor;
import com.intellij.openapi.roots.ui.configuration.ModuleJdkConfigurable;
import com.intellij.openapi.roots.ui.configuration.ProjectStructureConfigurable;
import com.intellij.openapi.roots.ui.configuration.classpath.ClasspathPanelImpl;
import com.intellij.openapi.ui.ComboBox;
import com.intellij.openapi.util.Disposer;
import com.intellij.ui.ListCellRendererWrapper;
import com.intellij.util.ArrayUtil;
import com.intellij.util.ui.JBUI;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.util.LinkedHashMap;
import javax.swing.BorderFactory;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.ListCellRenderer;
import org.jetbrains.annotations.NotNull;

public class ClasspathEditor
extends ModuleElementsEditor
implements ModuleRootListener {
    public static final String NAME = ProjectBundle.message((String)"modules.classpath.title", (Object[])new Object[0]);
    private ClasspathPanelImpl myPanel;
    private ClasspathFormatPanel myClasspathFormatPanel;

    public ClasspathEditor(ModuleConfigurationState state) {
        super(state);
        Disposable disposable = Disposer.newDisposable();
        state.getProject().getMessageBus().connect(disposable).subscribe(ProjectTopics.PROJECT_ROOTS, (Object)this);
        this.registerDisposable(disposable);
    }

    public boolean isModified() {
        return super.isModified() || this.myClasspathFormatPanel != null && this.myClasspathFormatPanel.isModified();
    }

    public String getHelpTopic() {
        return "projectStructure.modules.dependencies";
    }

    public String getDisplayName() {
        return NAME;
    }

    public void saveData() {
        this.myPanel.stopEditing();
    }

    public void apply() throws ConfigurationException {
        if (this.myClasspathFormatPanel != null) {
            this.myClasspathFormatPanel.apply();
        }
    }

    public void canApply() throws ConfigurationException {
        super.canApply();
        if (this.myClasspathFormatPanel != null) {
            this.myClasspathFormatPanel.canApply();
        }
    }

    public JComponent createComponentImpl() {
        this.myPanel = new ClasspathPanelImpl(this.getState());
        JPanel panel = new JPanel(new BorderLayout());
        panel.setBorder(BorderFactory.createEmptyBorder(6, 6, 6, 6));
        panel.add((Component)this.myPanel, "Center");
        ModuleJdkConfigurable jdkConfigurable = new ModuleJdkConfigurable(this, ProjectStructureConfigurable.getInstance(this.myProject).getProjectJdksModel()){

            @Override
            protected ModifiableRootModel getRootModel() {
                return ClasspathEditor.this.getState().getRootModel();
            }
        };
        panel.add((Component)jdkConfigurable.createComponent(), "North");
        jdkConfigurable.reset();
        this.registerDisposable(jdkConfigurable);
        ClasspathStorageProvider[] providers = (ClasspathStorageProvider[])ClasspathStorageProvider.EXTENSION_POINT_NAME.getExtensions();
        if (providers.length > 0) {
            this.myClasspathFormatPanel = new ClasspathFormatPanel(providers, this.getModel());
            panel.add((Component)this.myClasspathFormatPanel, "South");
        }
        return panel;
    }

    public void selectOrderEntry(@NotNull OrderEntry entry) {
        if (entry == null) {
            ClasspathEditor.$$$reportNull$$$0(0);
        }
        this.myPanel.selectOrderEntry(entry);
    }

    public void moduleStateChanged() {
        if (this.myPanel != null) {
            this.myPanel.initFromModel();
        }
    }

    public void rootsChanged(ModuleRootEvent event) {
        if (this.myPanel != null) {
            this.myPanel.rootsChanged();
        }
    }

    public void setSdk(Sdk newJDK) {
        ModifiableRootModel model = this.getModel();
        if (newJDK != null) {
            model.setSdk(newJDK);
        } else {
            model.inheritSdk();
        }
        if (this.myPanel != null) {
            this.myPanel.forceInitFromModel();
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "entry", "com/intellij/openapi/roots/ui/configuration/ClasspathEditor", "selectOrderEntry"));
    }

    private static class ClasspathFormatPanel
    extends JPanel {
        private final ModifiableRootModel rootModel;
        private final JComboBox<String> comboBoxClasspathFormat;

        private ClasspathFormatPanel(ClasspathStorageProvider[] providers, ModifiableRootModel model) {
            super(new GridBagLayout());
            this.rootModel = model;
            this.add((Component)new JLabel(ProjectBundle.message((String)"project.roots.classpath.format.label", (Object[])new Object[0])), new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 18, 0, (Insets)JBUI.insets((int)10, (int)6, (int)6, (int)0), 0, 0));
            final LinkedHashMap<String, String> formatIdToDescription = new LinkedHashMap<String, String>();
            formatIdToDescription.put("default", ProjectBundle.message((String)"project.roots.classpath.format.default.descr", (Object[])new Object[0]));
            for (ClasspathStorageProvider provider : providers) {
                formatIdToDescription.put(provider.getID(), provider.getDescription());
            }
            this.comboBoxClasspathFormat = new ComboBox((Object[])ArrayUtil.toStringArray(formatIdToDescription.keySet()));
            this.comboBoxClasspathFormat.setRenderer((ListCellRenderer<String>)new ListCellRendererWrapper<String>(){

                public void customize(JList list, String value, int index, boolean selected, boolean hasFocus) {
                    this.setText((String)formatIdToDescription.get(value));
                }
            });
            this.comboBoxClasspathFormat.setSelectedItem(this.getModuleClasspathFormat());
            this.add(this.comboBoxClasspathFormat, new GridBagConstraints(1, 0, 1, 1, 1.0, 0.0, 18, 0, (Insets)JBUI.insets((int)6, (int)6, (int)6, (int)0), 0, 0));
        }

        private String getSelectedClasspathFormat() {
            return (String)this.comboBoxClasspathFormat.getSelectedItem();
        }

        private String getModuleClasspathFormat() {
            return ClassPathStorageUtil.getStorageType((Module)this.rootModel.getModule());
        }

        private boolean isModified() {
            return !this.getSelectedClasspathFormat().equals(this.getModuleClasspathFormat());
        }

        public void canApply() throws ConfigurationException {
            ClasspathStorageProvider provider = ClasspathStorage.getProvider((String)this.getSelectedClasspathFormat());
            if (provider != null) {
                provider.assertCompatible((ModuleRootModel)this.rootModel);
            }
        }

        private void apply() throws ConfigurationException {
            this.canApply();
            ClasspathStorage.setStorageType((ModuleRootModel)this.rootModel, (String)this.getSelectedClasspathFormat());
        }
    }
}

