/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.externalSystem.view;

import com.intellij.execution.Executor;
import com.intellij.execution.ProgramRunnerUtil;
import com.intellij.execution.RunManager;
import com.intellij.execution.RunnerAndConfigurationSettings;
import com.intellij.execution.executors.DefaultRunExecutor;
import com.intellij.execution.impl.EditConfigurationsDialog;
import com.intellij.ide.projectView.PresentationData;
import com.intellij.openapi.externalSystem.model.execution.ExternalSystemTaskExecutionSettings;
import com.intellij.openapi.externalSystem.service.execution.ExternalSystemRunConfiguration;
import com.intellij.openapi.externalSystem.service.project.manage.ExternalSystemTaskActivator;
import com.intellij.openapi.externalSystem.view.ExternalProjectsView;
import com.intellij.openapi.externalSystem.view.ExternalSystemNode;
import com.intellij.openapi.externalSystem.view.RunConfigurationsNode;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.pom.Navigatable;
import com.intellij.ui.treeStructure.SimpleTree;
import java.awt.event.InputEvent;
import java.util.Collection;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class RunConfigurationNode
extends ExternalSystemNode {
    private final RunnerAndConfigurationSettings mySettings;

    public RunConfigurationNode(@NotNull ExternalProjectsView externalProjectsView, RunConfigurationsNode parent, @NotNull RunnerAndConfigurationSettings settings) {
        if (externalProjectsView == null) {
            RunConfigurationNode.$$$reportNull$$$0(0);
        }
        if (settings == null) {
            RunConfigurationNode.$$$reportNull$$$0(1);
        }
        super(externalProjectsView, parent);
        this.mySettings = settings;
    }

    protected void update(PresentationData presentation) {
        super.update(presentation);
        presentation.setIcon(ProgramRunnerUtil.getConfigurationIcon((RunnerAndConfigurationSettings)this.mySettings, (boolean)false));
        ExternalSystemRunConfiguration runConfiguration = (ExternalSystemRunConfiguration)this.mySettings.getConfiguration();
        ExternalSystemTaskExecutionSettings taskExecutionSettings = runConfiguration.getSettings();
        String shortcutHint = StringUtil.nullize((String)this.getShortcutsManager().getDescription(taskExecutionSettings.getExternalProjectPath(), this.mySettings.getName()));
        String activatorHint = StringUtil.nullize((String)this.getTaskActivator().getDescription(taskExecutionSettings.getExternalSystemId(), taskExecutionSettings.getExternalProjectPath(), ExternalSystemTaskActivator.getRunConfigurationActivationTaskName(this.mySettings)));
        String hint = shortcutHint == null ? activatorHint : (activatorHint == null ? shortcutHint : shortcutHint + ", " + activatorHint);
        this.setNameAndTooltip(this.getName(), StringUtil.join((Collection)taskExecutionSettings.getTaskNames(), (String)" "), hint);
    }

    public RunnerAndConfigurationSettings getSettings() {
        return this.mySettings;
    }

    @Override
    public String getName() {
        return this.mySettings.getName();
    }

    public boolean isAlwaysLeaf() {
        return true;
    }

    @Override
    @Nullable
    protected String getMenuId() {
        return "ExternalSystemView.RunConfigurationMenu";
    }

    public void updateRunConfiguration() {
    }

    @Override
    public void handleDoubleClickOrEnter(SimpleTree tree, InputEvent inputEvent) {
        ProgramRunnerUtil.executeConfiguration((RunnerAndConfigurationSettings)this.mySettings, (Executor)DefaultRunExecutor.getRunExecutorInstance());
        RunManager.getInstance((Project)this.mySettings.getConfiguration().getProject()).setSelectedConfiguration(this.mySettings);
    }

    @Override
    @Nullable
    public Navigatable getNavigatable() {
        return new Navigatable(){

            public void navigate(boolean requestFocus) {
                RunManager.getInstance((Project)RunConfigurationNode.this.myProject).setSelectedConfiguration(RunConfigurationNode.this.mySettings);
                EditConfigurationsDialog dialog = new EditConfigurationsDialog(RunConfigurationNode.this.myProject);
                dialog.show();
            }

            public boolean canNavigate() {
                return true;
            }

            public boolean canNavigateToSource() {
                return false;
            }
        };
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[0] = "externalProjectsView";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[0] = "settings";
                break;
            }
        }
        objectArray[1] = "com/intellij/openapi/externalSystem/view/RunConfigurationNode";
        objectArray[2] = "<init>";
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

