/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.externalSystem.service.project.settings;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.externalSystem.model.ConfigurationDataImpl;
import com.intellij.openapi.externalSystem.model.DataNode;
import com.intellij.openapi.externalSystem.model.Key;
import com.intellij.openapi.externalSystem.model.ProjectKeys;
import com.intellij.openapi.externalSystem.model.project.ModuleData;
import com.intellij.openapi.externalSystem.model.project.ProjectData;
import com.intellij.openapi.externalSystem.model.project.settings.ConfigurationData;
import com.intellij.openapi.externalSystem.service.project.IdeModifiableModelsProvider;
import com.intellij.openapi.externalSystem.service.project.manage.AbstractModuleDataService;
import com.intellij.openapi.externalSystem.service.project.manage.AbstractProjectDataService;
import com.intellij.openapi.externalSystem.service.project.settings.ConfigurationHandler;
import com.intellij.openapi.externalSystem.util.ExternalSystemApiUtil;
import com.intellij.openapi.externalSystem.util.Order;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.registry.Registry;
import java.util.Collection;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Order(value=-2147483645)
@ApiStatus.Experimental
public class ConfigurationDataService
extends AbstractProjectDataService<ConfigurationData, Void> {
    private static final Logger LOG = Logger.getInstance(ConfigurationDataService.class);
    public static final String EXTERNAL_SYSTEM_CONFIGURATION_IMPORT_ENABLED = "external.system.configuration.import.enabled";

    @NotNull
    public Key<ConfigurationData> getTargetDataKey() {
        Key key = ProjectKeys.CONFIGURATION;
        if (key == null) {
            ConfigurationDataService.$$$reportNull$$$0(0);
        }
        return key;
    }

    public void importData(@NotNull Collection<DataNode<ConfigurationData>> toImport, @Nullable ProjectData projectData, @NotNull Project project2, @NotNull IdeModifiableModelsProvider modelsProvider) {
        if (toImport == null) {
            ConfigurationDataService.$$$reportNull$$$0(1);
        }
        if (project2 == null) {
            ConfigurationDataService.$$$reportNull$$$0(2);
        }
        if (modelsProvider == null) {
            ConfigurationDataService.$$$reportNull$$$0(3);
        }
        if (toImport.isEmpty() || !Registry.is((String)EXTERNAL_SYSTEM_CONFIGURATION_IMPORT_ENABLED)) {
            LOG.debug("Configuration data is" + (!toImport.isEmpty() ? " not " : " ") + "empty, Registry flag is " + Registry.is((String)EXTERNAL_SYSTEM_CONFIGURATION_IMPORT_ENABLED));
            return;
        }
        DataNode<ConfigurationData> javaProjectDataNode = toImport.iterator().next();
        DataNode projectDataNode = ExternalSystemApiUtil.findParent(javaProjectDataNode, (Key)ProjectKeys.PROJECT);
        assert (projectDataNode != null);
        DataNode projectConfigurationNode = ExternalSystemApiUtil.find((DataNode)projectDataNode, (Key)ProjectKeys.CONFIGURATION);
        if (projectConfigurationNode != null) {
            ConfigurationData data = (ConfigurationData)projectConfigurationNode.getData();
            if (LOG.isDebugEnabled() && data instanceof ConfigurationDataImpl) {
                LOG.debug("Importing project configuration: " + ((ConfigurationDataImpl)data).getJsonString());
            }
            if (!ExternalSystemApiUtil.isOneToOneMapping((Project)project2, (ProjectData)((ProjectData)projectDataNode.getData()))) {
                LOG.warn("This external project are not the only project in the current IDE workspace, found project level configuration can override the configuration came from other external projects.");
            }
            for (ConfigurationHandler handler : (ConfigurationHandler[])ConfigurationHandler.EP_NAME.getExtensions()) {
                handler.apply(project2, modelsProvider, data);
            }
        }
        for (DataNode<ConfigurationData> node : toImport) {
            DataNode moduleDataNode;
            if (node == projectConfigurationNode || (moduleDataNode = ExternalSystemApiUtil.findParent(node, (Key)ProjectKeys.MODULE)) == null) continue;
            Module module2 = (Module)moduleDataNode.getUserData(AbstractModuleDataService.MODULE_KEY);
            Module module3 = module2 = module2 != null ? module2 : modelsProvider.findIdeModule((ModuleData)moduleDataNode.getData());
            if (module2 == null) {
                LOG.warn(String.format("Can't import module level configuration. Reason: target module (%s) is not found at the ide", moduleDataNode));
                continue;
            }
            ConfigurationData data = (ConfigurationData)node.getData();
            if (LOG.isDebugEnabled() && data instanceof ConfigurationDataImpl) {
                LOG.debug("Importing module configuration: " + ((ConfigurationDataImpl)data).getJsonString());
            }
            for (ConfigurationHandler handler : (ConfigurationHandler[])ConfigurationHandler.EP_NAME.getExtensions()) {
                handler.apply(module2, modelsProvider, data);
            }
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/externalSystem/service/project/settings/ConfigurationDataService";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "toImport";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "modelsProvider";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getTargetDataKey";
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/externalSystem/service/project/settings/ConfigurationDataService";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "importData";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

