/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.externalSystem.service.project.manage;

import com.intellij.ide.projectView.actions.MarkRootActionBase;
import com.intellij.openapi.components.ComponentManager;
import com.intellij.openapi.externalSystem.model.project.ContentRootData;
import com.intellij.openapi.externalSystem.util.DisposeAwareProjectChange;
import com.intellij.openapi.externalSystem.util.ExternalSystemApiUtil;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ContentEntry;
import com.intellij.openapi.roots.ModifiableRootModel;
import com.intellij.openapi.roots.ModuleRootManager;
import com.intellij.openapi.roots.ModuleRootModel;
import com.intellij.openapi.roots.SourceFolder;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileEvent;
import com.intellij.openapi.vfs.VirtualFileListener;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.jps.model.module.JpsModuleSourceRootType;

public class AddSourceFolderListener
implements VirtualFileListener {
    private final ContentRootData.SourceRoot myRoot;
    private final Project myProject;
    private final Module myModule;
    private final JpsModuleSourceRootType<?> mySourceRootType;

    public AddSourceFolderListener(ContentRootData.SourceRoot root, Module module2, JpsModuleSourceRootType<?> sourceRootType) {
        this.myRoot = root;
        this.myProject = module2.getProject();
        this.myModule = module2;
        this.mySourceRootType = sourceRootType;
    }

    public void fileCreated(final @NotNull VirtualFileEvent event) {
        if (event == null) {
            AddSourceFolderListener.$$$reportNull$$$0(0);
        }
        if (VfsUtilCore.isEqualOrAncestor((String)event.getFile().getUrl(), (String)VfsUtilCore.pathToUrl((String)this.myRoot.getPath()))) {
            Ref ref = Ref.create();
            ExternalSystemApiUtil.doWriteAction(() -> ref.set((Object)LocalFileSystem.getInstance().refreshAndFindFileByPath(this.myRoot.getPath())));
            VirtualFile sourceFolderFile = (VirtualFile)ref.get();
            if (sourceFolderFile != null && sourceFolderFile.isValid()) {
                ExternalSystemApiUtil.executeProjectChangeAction((boolean)false, (DisposeAwareProjectChange)new DisposeAwareProjectChange((ComponentManager)this.myProject){

                    public void execute() {
                        ModifiableRootModel rootModel = ModuleRootManager.getInstance((Module)AddSourceFolderListener.this.myModule).getModifiableModel();
                        ContentEntry entry = MarkRootActionBase.findContentEntry((ModuleRootModel)rootModel, (VirtualFile)event.getFile());
                        if (entry != null) {
                            SourceFolder sourceFolder = entry.addSourceFolder(VfsUtilCore.pathToUrl((String)AddSourceFolderListener.this.myRoot.getPath()), AddSourceFolderListener.this.mySourceRootType);
                            if (!StringUtil.isEmpty((String)AddSourceFolderListener.this.myRoot.getPackagePrefix())) {
                                sourceFolder.setPackagePrefix(AddSourceFolderListener.this.myRoot.getPackagePrefix());
                            }
                        }
                        rootModel.commit();
                    }
                });
            }
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "event", "com/intellij/openapi/externalSystem/service/project/manage/AddSourceFolderListener", "fileCreated"));
    }
}

