/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.externalSystem.service.project;

import com.intellij.openapi.externalSystem.model.ProjectSystemId;
import com.intellij.openapi.externalSystem.model.project.DependencyData;
import com.intellij.openapi.externalSystem.model.project.LibraryData;
import com.intellij.openapi.externalSystem.model.project.LibraryDependencyData;
import com.intellij.openapi.externalSystem.model.project.LibraryLevel;
import com.intellij.openapi.externalSystem.model.project.LibraryPathType;
import com.intellij.openapi.externalSystem.model.project.ModuleData;
import com.intellij.openapi.externalSystem.model.project.ModuleDependencyData;
import com.intellij.openapi.externalSystem.model.project.ProjectData;
import com.intellij.openapi.externalSystem.service.project.IdeModelsProvider;
import com.intellij.openapi.externalSystem.settings.ExternalProjectSettings;
import com.intellij.openapi.externalSystem.util.ExternalSystemApiUtil;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleManager;
import com.intellij.openapi.module.ModuleUtilCore;
import com.intellij.openapi.module.UnloadedModuleDescription;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ExportableOrderEntry;
import com.intellij.openapi.roots.LibraryOrderEntry;
import com.intellij.openapi.roots.ModuleOrderEntry;
import com.intellij.openapi.roots.ModuleRootManager;
import com.intellij.openapi.roots.OrderEntry;
import com.intellij.openapi.roots.OrderRootType;
import com.intellij.openapi.roots.libraries.Library;
import com.intellij.openapi.roots.libraries.LibraryTable;
import com.intellij.openapi.roots.libraries.LibraryTablesRegistrar;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.PathUtil;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.SequenceIterator;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class IdeModelsProviderImpl
implements IdeModelsProvider {
    @NotNull
    protected final Project myProject;
    @NotNull
    private final Map<ModuleData, Module> myIdeModulesCache;
    private final Map<Module, Map<String, List<ModuleOrderEntry>>> myIdeModuleToModuleDepsCache;

    public IdeModelsProviderImpl(@NotNull Project project2) {
        if (project2 == null) {
            IdeModelsProviderImpl.$$$reportNull$$$0(0);
        }
        this.myIdeModulesCache = ContainerUtil.createWeakMap();
        this.myIdeModuleToModuleDepsCache = ContainerUtil.createWeakMap();
        this.myProject = project2;
    }

    @NotNull
    public Module[] getModules() {
        Module[] moduleArray = ModuleManager.getInstance((Project)this.myProject).getModules();
        if (moduleArray == null) {
            IdeModelsProviderImpl.$$$reportNull$$$0(1);
        }
        return moduleArray;
    }

    @NotNull
    public Module[] getModules(@NotNull ProjectData projectData) {
        if (projectData == null) {
            IdeModelsProviderImpl.$$$reportNull$$$0(2);
        }
        List modules = ContainerUtil.filter((Object[])this.getModules(), module2 -> {
            if (projectData == null) {
                IdeModelsProviderImpl.$$$reportNull$$$0(25);
            }
            return ExternalSystemApiUtil.isExternalSystemAwareModule((ProjectSystemId)projectData.getOwner(), (Module)module2) && StringUtil.equals((CharSequence)projectData.getLinkedExternalProjectPath(), (CharSequence)ExternalSystemApiUtil.getExternalRootProjectPath((Module)module2));
        });
        Module[] moduleArray = (Module[])ContainerUtil.toArray((List)modules, (Object[])new Module[modules.size()]);
        if (moduleArray == null) {
            IdeModelsProviderImpl.$$$reportNull$$$0(3);
        }
        return moduleArray;
    }

    @NotNull
    public OrderEntry[] getOrderEntries(@NotNull Module module2) {
        if (module2 == null) {
            IdeModelsProviderImpl.$$$reportNull$$$0(4);
        }
        OrderEntry[] orderEntryArray = ModuleRootManager.getInstance((Module)module2).getOrderEntries();
        if (orderEntryArray == null) {
            IdeModelsProviderImpl.$$$reportNull$$$0(5);
        }
        return orderEntryArray;
    }

    @Nullable
    public Module findIdeModule(@NotNull ModuleData module2) {
        Module cachedIdeModule;
        if (module2 == null) {
            IdeModelsProviderImpl.$$$reportNull$$$0(6);
        }
        if ((cachedIdeModule = this.myIdeModulesCache.get(module2)) == null) {
            for (String candidate : this.suggestModuleNameCandidates(module2)) {
                Module ideModule = this.findIdeModule(candidate);
                if (ideModule == null || !IdeModelsProviderImpl.isApplicableIdeModule(module2, ideModule)) continue;
                this.myIdeModulesCache.put(module2, ideModule);
                return ideModule;
            }
        } else {
            return cachedIdeModule;
        }
        return null;
    }

    protected Iterable<String> suggestModuleNameCandidates(@NotNull ModuleData module2) {
        ExternalProjectSettings settings;
        if (module2 == null) {
            IdeModelsProviderImpl.$$$reportNull$$$0(7);
        }
        char delimiter = (settings = ExternalSystemApiUtil.getSettings((Project)this.myProject, (ProjectSystemId)module2.getOwner()).getLinkedProjectSettings(module2.getLinkedExternalProjectPath())) != null && settings.isUseQualifiedModuleNames() ? (char)'.' : '-';
        return new ModuleNameGenerator(module2, delimiter).generate();
    }

    private static boolean isApplicableIdeModule(@NotNull ModuleData moduleData, @NotNull Module ideModule) {
        if (moduleData == null) {
            IdeModelsProviderImpl.$$$reportNull$$$0(8);
        }
        if (ideModule == null) {
            IdeModelsProviderImpl.$$$reportNull$$$0(9);
        }
        for (VirtualFile root : ModuleRootManager.getInstance((Module)ideModule).getContentRoots()) {
            if (!FileUtil.pathsEqual((String)root.getPath(), (String)moduleData.getLinkedExternalProjectPath())) continue;
            return true;
        }
        return ExternalSystemApiUtil.isExternalSystemAwareModule((ProjectSystemId)moduleData.getOwner(), (Module)ideModule) && FileUtil.pathsEqual((String)ExternalSystemApiUtil.getExternalProjectPath((Module)ideModule), (String)moduleData.getLinkedExternalProjectPath());
    }

    @Nullable
    public Module findIdeModule(@NotNull String ideModuleName) {
        if (ideModuleName == null) {
            IdeModelsProviderImpl.$$$reportNull$$$0(10);
        }
        return ModuleManager.getInstance((Project)this.myProject).findModuleByName(ideModuleName);
    }

    @Nullable
    public UnloadedModuleDescription getUnloadedModuleDescription(@NotNull ModuleData moduleData) {
        if (moduleData == null) {
            IdeModelsProviderImpl.$$$reportNull$$$0(11);
        }
        for (String moduleName : this.suggestModuleNameCandidates(moduleData)) {
            UnloadedModuleDescription unloadedModuleDescription = ModuleManager.getInstance((Project)this.myProject).getUnloadedModuleDescription(moduleName);
            if (unloadedModuleDescription == null) continue;
            return unloadedModuleDescription;
        }
        return null;
    }

    @Nullable
    public Library findIdeLibrary(@NotNull LibraryData libraryData) {
        if (libraryData == null) {
            IdeModelsProviderImpl.$$$reportNull$$$0(12);
        }
        LibraryTable libraryTable = LibraryTablesRegistrar.getInstance().getLibraryTable(this.myProject);
        for (Library ideLibrary : libraryTable.getLibraries()) {
            if (!ExternalSystemApiUtil.isRelated((Library)ideLibrary, (LibraryData)libraryData)) continue;
            return ideLibrary;
        }
        return null;
    }

    @Nullable
    public ModuleOrderEntry findIdeModuleDependency(@NotNull ModuleDependencyData dependency, @NotNull Module module2) {
        Map namesToEntries;
        List candidates;
        if (dependency == null) {
            IdeModelsProviderImpl.$$$reportNull$$$0(13);
        }
        if (module2 == null) {
            IdeModelsProviderImpl.$$$reportNull$$$0(14);
        }
        if ((candidates = (List)(namesToEntries = this.myIdeModuleToModuleDepsCache.computeIfAbsent(module2, m -> Arrays.stream(this.getOrderEntries((Module)m)).filter(ModuleOrderEntry.class::isInstance).map(ModuleOrderEntry.class::cast).collect(Collectors.groupingBy(ModuleOrderEntry::getModuleName)))).get(dependency.getInternalName())) == null) {
            return null;
        }
        for (ModuleOrderEntry candidate : candidates) {
            if (!candidate.getScope().equals((Object)dependency.getScope())) continue;
            return candidate;
        }
        return null;
    }

    @Nullable
    public OrderEntry findIdeModuleOrderEntry(@NotNull DependencyData data) {
        Module ownerIdeModule;
        if (data == null) {
            IdeModelsProviderImpl.$$$reportNull$$$0(15);
        }
        if ((ownerIdeModule = this.findIdeModule(data.getOwnerModule())) == null) {
            return null;
        }
        LibraryDependencyData libraryDependencyData = null;
        ModuleDependencyData moduleDependencyData = null;
        if (data instanceof LibraryDependencyData) {
            libraryDependencyData = (LibraryDependencyData)data;
        } else if (data instanceof ModuleDependencyData) {
            moduleDependencyData = (ModuleDependencyData)data;
        } else {
            return null;
        }
        for (OrderEntry entry : this.getOrderEntries(ownerIdeModule)) {
            String entryName;
            if (entry instanceof LibraryOrderEntry && libraryDependencyData != null) {
                if (((LibraryOrderEntry)entry).isModuleLevel() && libraryDependencyData.getLevel() != LibraryLevel.MODULE) continue;
                if (StringUtil.isEmpty((String)((LibraryOrderEntry)entry).getLibraryName())) {
                    Set paths = ContainerUtil.map2Set((Collection)((LibraryData)libraryDependencyData.getTarget()).getPaths(LibraryPathType.BINARY), path -> PathUtil.getLocalPath((String)path));
                    Set entryPaths = ContainerUtil.map2Set((Object[])entry.getUrls(OrderRootType.CLASSES), s -> PathUtil.getLocalPath((String)VfsUtilCore.urlToPath((String)s)));
                    if (!entryPaths.equals(paths) || ((LibraryOrderEntry)entry).getScope() != data.getScope()) continue;
                    return entry;
                }
            }
            String string = entryName = libraryDependencyData != null ? libraryDependencyData.getInternalName() : moduleDependencyData.getInternalName();
            if (!entryName.equals(entry.getPresentableName()) || entry instanceof ExportableOrderEntry && ((ExportableOrderEntry)entry).getScope() != data.getScope()) continue;
            return entry;
        }
        return null;
    }

    @NotNull
    public VirtualFile[] getContentRoots(Module module2) {
        VirtualFile[] virtualFileArray = ModuleRootManager.getInstance((Module)module2).getContentRoots();
        if (virtualFileArray == null) {
            IdeModelsProviderImpl.$$$reportNull$$$0(16);
        }
        return virtualFileArray;
    }

    @NotNull
    public VirtualFile[] getSourceRoots(Module module2) {
        VirtualFile[] virtualFileArray = ModuleRootManager.getInstance((Module)module2).getSourceRoots();
        if (virtualFileArray == null) {
            IdeModelsProviderImpl.$$$reportNull$$$0(17);
        }
        return virtualFileArray;
    }

    @NotNull
    public VirtualFile[] getSourceRoots(Module module2, boolean includingTests) {
        VirtualFile[] virtualFileArray = ModuleRootManager.getInstance((Module)module2).getSourceRoots(includingTests);
        if (virtualFileArray == null) {
            IdeModelsProviderImpl.$$$reportNull$$$0(18);
        }
        return virtualFileArray;
    }

    @NotNull
    public Library[] getAllLibraries() {
        Library[] libraryArray = LibraryTablesRegistrar.getInstance().getLibraryTable(this.myProject).getLibraries();
        if (libraryArray == null) {
            IdeModelsProviderImpl.$$$reportNull$$$0(19);
        }
        return libraryArray;
    }

    @Nullable
    public Library getLibraryByName(String name2) {
        return LibraryTablesRegistrar.getInstance().getLibraryTable(this.myProject).getLibraryByName(name2);
    }

    @NotNull
    public String[] getLibraryUrls(@NotNull Library library, @NotNull OrderRootType type) {
        if (library == null) {
            IdeModelsProviderImpl.$$$reportNull$$$0(20);
        }
        if (type == null) {
            IdeModelsProviderImpl.$$$reportNull$$$0(21);
        }
        String[] stringArray = library.getUrls(type);
        if (stringArray == null) {
            IdeModelsProviderImpl.$$$reportNull$$$0(22);
        }
        return stringArray;
    }

    @NotNull
    public List<Module> getAllDependentModules(@NotNull Module module2) {
        if (module2 == null) {
            IdeModelsProviderImpl.$$$reportNull$$$0(23);
        }
        List list = ModuleUtilCore.getAllDependentModules((Module)module2);
        if (list == null) {
            IdeModelsProviderImpl.$$$reportNull$$$0(24);
        }
        return list;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 3: 
            case 5: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 22: 
            case 24: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 3: 
            case 5: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 22: 
            case 24: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: 
            case 3: 
            case 5: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 22: 
            case 24: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/externalSystem/service/project/IdeModelsProviderImpl";
                break;
            }
            case 2: 
            case 25: {
                objectArray2 = objectArray3;
                objectArray3[0] = "projectData";
                break;
            }
            case 4: 
            case 6: 
            case 7: 
            case 14: 
            case 23: {
                objectArray2 = objectArray3;
                objectArray3[0] = "module";
                break;
            }
            case 8: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "moduleData";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "ideModule";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "ideModuleName";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "libraryData";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dependency";
                break;
            }
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "data";
                break;
            }
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "library";
                break;
            }
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "type";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/externalSystem/service/project/IdeModelsProviderImpl";
                break;
            }
            case 1: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getModules";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getOrderEntries";
                break;
            }
            case 16: {
                objectArray = objectArray2;
                objectArray2[1] = "getContentRoots";
                break;
            }
            case 17: 
            case 18: {
                objectArray = objectArray2;
                objectArray2[1] = "getSourceRoots";
                break;
            }
            case 19: {
                objectArray = objectArray2;
                objectArray2[1] = "getAllLibraries";
                break;
            }
            case 22: {
                objectArray = objectArray2;
                objectArray2[1] = "getLibraryUrls";
                break;
            }
            case 24: {
                objectArray = objectArray2;
                objectArray2[1] = "getAllDependentModules";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 3: 
            case 5: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 22: 
            case 24: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "getModules";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "getOrderEntries";
                break;
            }
            case 6: 
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "findIdeModule";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "suggestModuleNameCandidates";
                break;
            }
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "isApplicableIdeModule";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "getUnloadedModuleDescription";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "findIdeLibrary";
                break;
            }
            case 13: 
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "findIdeModuleDependency";
                break;
            }
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "findIdeModuleOrderEntry";
                break;
            }
            case 20: 
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "getLibraryUrls";
                break;
            }
            case 23: {
                objectArray = objectArray;
                objectArray[2] = "getAllDependentModules";
                break;
            }
            case 25: {
                objectArray = objectArray;
                objectArray[2] = "lambda$getModules$0";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 3: 
            case 5: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 22: 
            case 24: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static class ModuleNameGenerator {
        private static final int MAX_FILE_DEPTH = 3;
        private static final int MAX_NUMBER_SEQ = 2;
        private final ModuleData myModule;
        private final char myDelimiter;

        public ModuleNameGenerator(@NotNull ModuleData module2, char delimiter) {
            if (module2 == null) {
                ModuleNameGenerator.$$$reportNull$$$0(0);
            }
            this.myModule = module2;
            this.myDelimiter = delimiter;
        }

        Iterable<String> generate() {
            String prefix = this.myModule.getGroup();
            File modulePath = new File(this.myModule.getLinkedExternalProjectPath());
            if (modulePath.isFile()) {
                modulePath = modulePath.getParentFile();
            }
            final ArrayList names = prefix == null || StringUtil.startsWith((CharSequence)this.myModule.getInternalName(), (CharSequence)prefix) ? ContainerUtil.newArrayList((Object[])new String[]{this.myModule.getInternalName()}) : ContainerUtil.newArrayList((Object[])new String[]{this.myModule.getInternalName(), prefix + this.myDelimiter + this.myModule.getInternalName()});
            String name2 = (String)names.get(0);
            List pathParts = FileUtil.splitPath((String)FileUtil.toSystemDependentName((String)modulePath.getPath()));
            StringBuilder nameBuilder = new StringBuilder();
            String duplicateCandidate = name2;
            int i = pathParts.size() - 1;
            for (int j = 0; i >= 0 && j < 3; --i, ++j) {
                String part = (String)pathParts.get(i);
                boolean isAlreadyIncluded = false;
                if (duplicateCandidate.length() > 0) {
                    if (duplicateCandidate.equals(part) || duplicateCandidate.endsWith(this.myDelimiter + part) || duplicateCandidate.endsWith('_' + part)) {
                        --j;
                        duplicateCandidate = StringUtil.trimEnd((String)StringUtil.trimEnd((String)StringUtil.trimEnd((String)duplicateCandidate, (String)part), (char)this.myDelimiter), (char)'_');
                        isAlreadyIncluded = true;
                    } else if (name2.startsWith(part) || i > 1 && name2.startsWith((String)pathParts.get(i - 1) + this.myDelimiter + part)) {
                        --j;
                        isAlreadyIncluded = true;
                    } else {
                        duplicateCandidate = "";
                    }
                }
                if (isAlreadyIncluded) continue;
                nameBuilder.insert(0, part + this.myDelimiter);
                names.add(nameBuilder.toString() + name2);
            }
            final String namePrefix = (String)ContainerUtil.getLastItem((List)names);
            return new Iterable<String>(){

                @Override
                @NotNull
                public Iterator<String> iterator() {
                    SequenceIterator sequenceIterator = new SequenceIterator(new Iterator[]{names.iterator(), new Iterator<String>(){
                        int current = 0;

                        @Override
                        public boolean hasNext() {
                            return this.current < 2;
                        }

                        @Override
                        public String next() {
                            ++this.current;
                            return namePrefix + '~' + this.current;
                        }
                    }});
                    if (sequenceIterator == null) {
                        1.$$$reportNull$$$0(0);
                    }
                    return sequenceIterator;
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/externalSystem/service/project/IdeModelsProviderImpl$ModuleNameGenerator$1", "iterator"));
                }
            };
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "module", "com/intellij/openapi/externalSystem/service/project/IdeModelsProviderImpl$ModuleNameGenerator", "<init>"));
        }
    }
}

