/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.externalSystem.service.execution;

import com.intellij.build.BuildDescriptor;
import com.intellij.build.BuildProgressListener;
import com.intellij.build.BuildView;
import com.intellij.build.BuildViewManager;
import com.intellij.build.DefaultBuildDescriptor;
import com.intellij.build.ViewManager;
import com.intellij.build.events.BuildEvent;
import com.intellij.build.events.EventResult;
import com.intellij.build.events.FailureResult;
import com.intellij.build.events.impl.FailureResultImpl;
import com.intellij.build.events.impl.FinishBuildEventImpl;
import com.intellij.build.events.impl.StartBuildEventImpl;
import com.intellij.build.events.impl.SuccessResultImpl;
import com.intellij.build.output.BuildOutputInstantReaderImpl;
import com.intellij.build.process.BuildProcessHandler;
import com.intellij.diagnostic.logging.LogConfigurationPanel;
import com.intellij.execution.DefaultExecutionResult;
import com.intellij.execution.ExecutionBundle;
import com.intellij.execution.ExecutionException;
import com.intellij.execution.ExecutionResult;
import com.intellij.execution.Executor;
import com.intellij.execution.JavaRunConfigurationExtensionManager;
import com.intellij.execution.RunConfigurationExtension;
import com.intellij.execution.RunnerAndConfigurationSettings;
import com.intellij.execution.configurations.ConfigurationFactory;
import com.intellij.execution.configurations.JavaParameters;
import com.intellij.execution.configurations.LocatableConfigurationBase;
import com.intellij.execution.configurations.ParametersList;
import com.intellij.execution.configurations.RunConfiguration;
import com.intellij.execution.configurations.RunConfigurationBase;
import com.intellij.execution.configurations.RunProfileState;
import com.intellij.execution.configurations.SearchScopeProvider;
import com.intellij.execution.configurations.SearchScopeProvidingRunProfile;
import com.intellij.execution.console.DuplexConsoleView;
import com.intellij.execution.executors.DefaultDebugExecutor;
import com.intellij.execution.impl.ConsoleViewImpl;
import com.intellij.execution.impl.ExecutionManagerImpl;
import com.intellij.execution.process.ProcessHandler;
import com.intellij.execution.process.ProcessOutputTypes;
import com.intellij.execution.runners.ExecutionEnvironment;
import com.intellij.execution.runners.FakeRerunAction;
import com.intellij.execution.runners.ProgramRunner;
import com.intellij.execution.testframework.sm.runner.SMRunnerConsolePropertiesProvider;
import com.intellij.execution.testframework.sm.runner.SMTRunnerConsoleProperties;
import com.intellij.execution.ui.ExecutionConsole;
import com.intellij.execution.ui.RunContentDescriptor;
import com.intellij.icons.AllIcons;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.FoldRegion;
import com.intellij.openapi.editor.FoldingModel;
import com.intellij.openapi.extensions.Extensions;
import com.intellij.openapi.externalSystem.ExternalSystemManager;
import com.intellij.openapi.externalSystem.execution.ExternalSystemExecutionConsoleManager;
import com.intellij.openapi.externalSystem.model.ProjectSystemId;
import com.intellij.openapi.externalSystem.model.execution.ExternalSystemTaskExecutionSettings;
import com.intellij.openapi.externalSystem.model.task.ExternalSystemTask;
import com.intellij.openapi.externalSystem.model.task.ExternalSystemTaskId;
import com.intellij.openapi.externalSystem.model.task.ExternalSystemTaskNotificationEvent;
import com.intellij.openapi.externalSystem.model.task.ExternalSystemTaskNotificationListener;
import com.intellij.openapi.externalSystem.model.task.ExternalSystemTaskNotificationListenerAdapter;
import com.intellij.openapi.externalSystem.model.task.event.ExternalSystemTaskExecutionEvent;
import com.intellij.openapi.externalSystem.service.execution.AbstractExternalSystemTaskConfigurationType;
import com.intellij.openapi.externalSystem.service.execution.ExternalSystemOutputParserProvider;
import com.intellij.openapi.externalSystem.service.execution.ExternalSystemProcessHandler;
import com.intellij.openapi.externalSystem.service.execution.ExternalSystemRunConfigurationEditor;
import com.intellij.openapi.externalSystem.service.internal.ExternalSystemExecuteTaskTask;
import com.intellij.openapi.externalSystem.util.ExternalSystemApiUtil;
import com.intellij.openapi.externalSystem.util.ExternalSystemBundle;
import com.intellij.openapi.externalSystem.util.ExternalSystemUtil;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.options.SettingsEditor;
import com.intellij.openapi.options.SettingsEditorGroup;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.impl.DirectoryIndex;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.InvalidDataException;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.UserDataHolderBase;
import com.intellij.openapi.util.WriteExternalException;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.util.ArrayUtil;
import com.intellij.util.SmartList;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.net.NetUtils;
import com.intellij.util.text.CharArrayUtil;
import com.intellij.util.text.DateFormatUtil;
import com.intellij.util.xmlb.Accessor;
import com.intellij.util.xmlb.SerializationFilter;
import com.intellij.util.xmlb.XmlSerializer;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.InetAddress;
import java.net.ServerSocket;
import java.util.List;
import javax.swing.Icon;
import org.jdom.Element;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ExternalSystemRunConfiguration
extends LocatableConfigurationBase
implements SearchScopeProvidingRunProfile,
SMRunnerConsolePropertiesProvider {
    public static final Key<InputStream> RUN_INPUT_KEY = Key.create((String)"RUN_INPUT_KEY");
    public static final Key<Class<? extends BuildProgressListener>> PROGRESS_LISTENER_KEY = Key.create((String)"PROGRESS_LISTENER_KEY");
    private static final Logger LOG = Logger.getInstance(ExternalSystemRunConfiguration.class);
    private ExternalSystemTaskExecutionSettings mySettings;
    private static final boolean DISABLE_FORK_DEBUGGER = Boolean.getBoolean("external.system.disable.fork.debugger");

    public ExternalSystemRunConfiguration(@NotNull ProjectSystemId externalSystemId, Project project2, ConfigurationFactory factory, String name2) {
        if (externalSystemId == null) {
            ExternalSystemRunConfiguration.$$$reportNull$$$0(0);
        }
        super(project2, factory, name2);
        this.mySettings = new ExternalSystemTaskExecutionSettings();
        this.mySettings.setExternalSystemIdString(externalSystemId.getId());
    }

    public String suggestedName() {
        return AbstractExternalSystemTaskConfigurationType.generateName(this.getProject(), this.mySettings);
    }

    public ExternalSystemRunConfiguration clone() {
        Element element = new Element("toClone");
        try {
            this.writeExternal(element);
            RunConfiguration configuration = this.getFactory().createTemplateConfiguration(this.getProject());
            configuration.setName(this.getName());
            configuration.readExternal(element);
            return (ExternalSystemRunConfiguration)configuration;
        }
        catch (InvalidDataException | WriteExternalException e) {
            LOG.error(e);
            return null;
        }
    }

    public void readExternal(@NotNull Element element) throws InvalidDataException {
        JavaRunConfigurationExtensionManager javaRunConfigurationExtensionManager;
        if (element == null) {
            ExternalSystemRunConfiguration.$$$reportNull$$$0(1);
        }
        super.readExternal(element);
        Element e = element.getChild("ExternalSystemSettings");
        if (e != null) {
            this.mySettings = (ExternalSystemTaskExecutionSettings)XmlSerializer.deserialize((Element)e, ExternalSystemTaskExecutionSettings.class);
        }
        if ((javaRunConfigurationExtensionManager = JavaRunConfigurationExtensionManager.getInstance()) != null) {
            javaRunConfigurationExtensionManager.readExternal((RunConfigurationBase)this, element);
        }
    }

    public void writeExternal(@NotNull Element element) throws WriteExternalException {
        if (element == null) {
            ExternalSystemRunConfiguration.$$$reportNull$$$0(2);
        }
        super.writeExternal(element);
        element.addContent(XmlSerializer.serialize((Object)this.mySettings, (SerializationFilter)new SerializationFilter(){

            public boolean accepts(@NotNull Accessor accessor, @NotNull Object bean) {
                if (accessor == null) {
                    1.$$$reportNull$$$0(0);
                }
                if (bean == null) {
                    1.$$$reportNull$$$0(1);
                }
                switch (accessor.getName()) {
                    case "passParentEnvs": {
                        return !ExternalSystemRunConfiguration.this.mySettings.isPassParentEnvs();
                    }
                    case "env": {
                        return !ExternalSystemRunConfiguration.this.mySettings.getEnv().isEmpty();
                    }
                }
                return true;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[3];
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[0] = "accessor";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[0] = "bean";
                        break;
                    }
                }
                objectArray[1] = "com/intellij/openapi/externalSystem/service/execution/ExternalSystemRunConfiguration$1";
                objectArray[2] = "accepts";
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        }));
        JavaRunConfigurationExtensionManager javaRunConfigurationExtensionManager = JavaRunConfigurationExtensionManager.getInstance();
        if (javaRunConfigurationExtensionManager != null) {
            javaRunConfigurationExtensionManager.writeExternal((RunConfigurationBase)this, element);
        }
    }

    @NotNull
    public ExternalSystemTaskExecutionSettings getSettings() {
        ExternalSystemTaskExecutionSettings externalSystemTaskExecutionSettings = this.mySettings;
        if (externalSystemTaskExecutionSettings == null) {
            ExternalSystemRunConfiguration.$$$reportNull$$$0(3);
        }
        return externalSystemTaskExecutionSettings;
    }

    @NotNull
    public SettingsEditor<ExternalSystemRunConfiguration> getConfigurationEditor() {
        SettingsEditorGroup group = new SettingsEditorGroup();
        group.addEditor(ExecutionBundle.message((String)"run.configuration.configuration.tab.title", (Object[])new Object[0]), (SettingsEditor)new ExternalSystemRunConfigurationEditor(this.getProject(), this.mySettings.getExternalSystemId()));
        JavaRunConfigurationExtensionManager javaRunConfigurationExtensionManager = JavaRunConfigurationExtensionManager.getInstance();
        if (javaRunConfigurationExtensionManager != null) {
            javaRunConfigurationExtensionManager.appendEditors((RunConfigurationBase)this, group);
        }
        group.addEditor(ExecutionBundle.message((String)"logs.tab.title", (Object[])new Object[0]), (SettingsEditor)new LogConfigurationPanel());
        SettingsEditorGroup settingsEditorGroup = group;
        if (settingsEditorGroup == null) {
            ExternalSystemRunConfiguration.$$$reportNull$$$0(4);
        }
        return settingsEditorGroup;
    }

    @Nullable
    public RunProfileState getState(@NotNull Executor executor, @NotNull ExecutionEnvironment env) {
        if (executor == null) {
            ExternalSystemRunConfiguration.$$$reportNull$$$0(5);
        }
        if (env == null) {
            ExternalSystemRunConfiguration.$$$reportNull$$$0(6);
        }
        MyRunnableState runnableState = new MyRunnableState(this.mySettings, this.getProject(), DefaultDebugExecutor.EXECUTOR_ID.equals(executor.getId()), this, env);
        this.copyUserDataTo(runnableState);
        return runnableState;
    }

    @Nullable
    public GlobalSearchScope getSearchScope() {
        Module module2;
        VirtualFile file;
        GlobalSearchScope scope = null;
        ExternalSystemManager manager = ExternalSystemApiUtil.getManager((ProjectSystemId)this.mySettings.getExternalSystemId());
        if (manager != null) {
            scope = manager.getSearchScope(this.getProject(), this.mySettings);
        }
        if (scope == null && (file = VfsUtil.findFileByIoFile((File)new File(this.mySettings.getExternalProjectPath()), (boolean)false)) != null && (module2 = DirectoryIndex.getInstance((Project)this.getProject()).getInfoForFile(file).getModule()) != null) {
            scope = SearchScopeProvider.createSearchScope((Module[])((Module[])ContainerUtil.ar((Object[])new Module[]{module2})));
        }
        return scope;
    }

    public SMTRunnerConsoleProperties createTestConsoleProperties(Executor executor) {
        ExternalSystemManager manager = ExternalSystemApiUtil.getManager((ProjectSystemId)this.mySettings.getExternalSystemId());
        if (manager != null) {
            Object testConsoleProperties = manager.createTestConsoleProperties(this.getProject(), executor, (RunConfiguration)this);
            return testConsoleProperties instanceof SMTRunnerConsoleProperties ? (SMTRunnerConsoleProperties)testConsoleProperties : null;
        }
        return null;
    }

    private static void foldGreetingOrFarewell(@Nullable ExecutionConsole consoleView, String text, boolean isGreeting) {
        DuplexConsoleView duplexConsoleView;
        int limit = 100;
        if (text.length() < limit) {
            return;
        }
        Object consoleViewImpl = consoleView instanceof ConsoleViewImpl ? (ConsoleViewImpl)consoleView : (consoleView instanceof DuplexConsoleView ? ((duplexConsoleView = (DuplexConsoleView)consoleView).getPrimaryConsoleView() instanceof ConsoleViewImpl ? (ConsoleViewImpl)duplexConsoleView.getPrimaryConsoleView() : (duplexConsoleView.getSecondaryConsoleView() instanceof ConsoleViewImpl ? (ConsoleViewImpl)duplexConsoleView.getSecondaryConsoleView() : null)) : null);
        if (consoleViewImpl != null) {
            consoleViewImpl.performWhenNoDeferredOutput(() -> ExternalSystemRunConfiguration.lambda$foldGreetingOrFarewell$1((ConsoleViewImpl)consoleViewImpl, isGreeting, text, limit));
        }
    }

    private static /* synthetic */ void lambda$foldGreetingOrFarewell$1(ConsoleViewImpl consoleViewImpl, boolean isGreeting, String text, int limit) {
        int line;
        if (!ApplicationManager.getApplication().isDispatchThread()) {
            return;
        }
        Document document = consoleViewImpl.getEditor().getDocument();
        int n = line = isGreeting ? 0 : document.getLineCount() - 2;
        if (CharArrayUtil.regionMatches((CharSequence)document.getCharsSequence(), (int)document.getLineStartOffset(line), (CharSequence)text)) {
            FoldingModel foldingModel = consoleViewImpl.getEditor().getFoldingModel();
            foldingModel.runBatchFoldingOperation(() -> {
                FoldRegion region = foldingModel.addFoldRegion(document.getLineStartOffset(line), document.getLineEndOffset(line) + 1, StringUtil.trimLog((String)text, (int)limit));
                if (region != null) {
                    region.setExpanded(false);
                }
            });
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 3: 
            case 4: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 3: 
            case 4: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "externalSystemId";
                break;
            }
            case 1: 
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 3: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/externalSystem/service/execution/ExternalSystemRunConfiguration";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "executor";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "env";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/externalSystem/service/execution/ExternalSystemRunConfiguration";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getSettings";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getConfigurationEditor";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "readExternal";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "writeExternal";
                break;
            }
            case 3: 
            case 4: {
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "getState";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 3: 
            case 4: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static class MyTaskRerunAction
    extends FakeRerunAction {
        private final BuildProgressListener myProgressListener;
        private final RunContentDescriptor myContentDescriptor;
        private final ExecutionEnvironment myEnvironment;

        public MyTaskRerunAction(BuildProgressListener progressListener, ExecutionEnvironment environment, RunContentDescriptor contentDescriptor) {
            this.myProgressListener = progressListener;
            this.myContentDescriptor = contentDescriptor;
            this.myEnvironment = environment;
        }

        public void update(@NotNull AnActionEvent event) {
            if (event == null) {
                MyTaskRerunAction.$$$reportNull$$$0(0);
            }
            Presentation presentation = event.getPresentation();
            ExecutionEnvironment environment = this.getEnvironment(event);
            if (environment != null) {
                presentation.setText(ExecutionBundle.message((String)"rerun.configuration.action.name", (Object[])new Object[]{StringUtil.escapeMnemonics((String)environment.getRunProfile().getName())}));
                Icon icon = ExecutionManagerImpl.isProcessRunning((RunContentDescriptor)this.getDescriptor(event)) ? AllIcons.Actions.Restart : (this.myProgressListener instanceof BuildViewManager ? AllIcons.Actions.Compile : environment.getExecutor().getIcon());
                presentation.setIcon(icon);
                presentation.setEnabled(this.isEnabled(event));
                return;
            }
            presentation.setEnabled(false);
        }

        @Nullable
        protected RunContentDescriptor getDescriptor(AnActionEvent event) {
            return this.myContentDescriptor != null ? this.myContentDescriptor : super.getDescriptor(event);
        }

        protected ExecutionEnvironment getEnvironment(@NotNull AnActionEvent event) {
            if (event == null) {
                MyTaskRerunAction.$$$reportNull$$$0(1);
            }
            return this.myEnvironment;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            objectArray2[0] = "event";
            objectArray2[1] = "com/intellij/openapi/externalSystem/service/execution/ExternalSystemRunConfiguration$MyTaskRerunAction";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "update";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "getEnvironment";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    public static class MyRunnableState
    extends UserDataHolderBase
    implements RunProfileState {
        @NotNull
        private final ExternalSystemTaskExecutionSettings mySettings;
        @NotNull
        private final Project myProject;
        @NotNull
        private final ExternalSystemRunConfiguration myConfiguration;
        @NotNull
        private final ExecutionEnvironment myEnv;
        @Nullable
        private RunContentDescriptor myContentDescriptor;
        private final int myDebugPort;
        private ServerSocket myForkSocket;

        public MyRunnableState(@NotNull ExternalSystemTaskExecutionSettings settings, @NotNull Project project2, boolean debug, @NotNull ExternalSystemRunConfiguration configuration, @NotNull ExecutionEnvironment env) {
            int port;
            if (settings == null) {
                MyRunnableState.$$$reportNull$$$0(0);
            }
            if (project2 == null) {
                MyRunnableState.$$$reportNull$$$0(1);
            }
            if (configuration == null) {
                MyRunnableState.$$$reportNull$$$0(2);
            }
            if (env == null) {
                MyRunnableState.$$$reportNull$$$0(3);
            }
            this.myForkSocket = null;
            this.mySettings = settings;
            this.myProject = project2;
            this.myConfiguration = configuration;
            this.myEnv = env;
            if (debug) {
                try {
                    port = NetUtils.findAvailableSocketPort();
                }
                catch (IOException e) {
                    LOG.warn("Unexpected I/O exception occurred on attempt to find a free port to use for external system task debugging", (Throwable)e);
                    port = 0;
                }
            } else {
                port = 0;
            }
            this.myDebugPort = port;
        }

        public int getDebugPort() {
            return this.myDebugPort;
        }

        @Nullable
        public ServerSocket getForkSocket() {
            if (this.myForkSocket == null && !DISABLE_FORK_DEBUGGER) {
                try {
                    this.myForkSocket = new ServerSocket(0, 0, InetAddress.getByName("127.0.0.1"));
                }
                catch (IOException e) {
                    LOG.error((Throwable)e);
                }
            }
            return this.myForkSocket;
        }

        @Nullable
        public ExecutionResult execute(Executor executor, @NotNull ProgramRunner runner) throws ExecutionException {
            AnAction[] restartActions;
            if (runner == null) {
                MyRunnableState.$$$reportNull$$$0(4);
            }
            if (this.myProject.isDisposed()) {
                return null;
            }
            String jvmAgentSetup = this.getJvmAgentSetup();
            ApplicationManager.getApplication().assertIsDispatchThread();
            FileDocumentManager.getInstance().saveAllDocuments();
            ExternalSystemExecuteTaskTask task = new ExternalSystemExecuteTaskTask(this.myProject, this.mySettings, jvmAgentSetup);
            this.copyUserDataTo(task);
            final String executionName = StringUtil.isNotEmpty((String)this.mySettings.getExecutionName()) ? this.mySettings.getExecutionName() : (StringUtil.isNotEmpty((String)this.myConfiguration.getName()) ? this.myConfiguration.getName() : AbstractExternalSystemTaskConfigurationType.generateName(this.myProject, this.mySettings.getExternalSystemId(), this.mySettings.getExternalProjectPath(), this.mySettings.getTaskNames(), this.mySettings.getExecutionName(), ": ", ""));
            final ExternalSystemProcessHandler processHandler = new ExternalSystemProcessHandler(task, executionName);
            final ExternalSystemExecutionConsoleManager<ExternalSystemRunConfiguration, ExecutionConsole, ProcessHandler> consoleManager = ExternalSystemUtil.getConsoleManagerFor(task);
            final ExecutionConsole consoleView = consoleManager.attachExecutionConsole(this.myProject, (ExternalSystemTask)task, this.myEnv, (ProcessHandler)processHandler);
            if (consoleView == null) {
                restartActions = AnAction.EMPTY_ARRAY;
                Disposer.register((Disposable)this.myProject, (Disposable)processHandler);
            } else {
                Disposer.register((Disposable)this.myProject, (Disposable)consoleView);
                Disposer.register((Disposable)consoleView, (Disposable)processHandler);
                restartActions = consoleManager.getRestartActions(consoleView);
            }
            Class progressListenerClazz = (Class)task.getUserData(PROGRESS_LISTENER_KEY);
            final BuildProgressListener progressListener = progressListenerClazz != null ? (BuildProgressListener)ServiceManager.getService((Project)this.myProject, (Class)progressListenerClazz) : this.createBuildView(task.getId(), executionName, task.getExternalProjectPath(), consoleView);
            SmartList buildOutputParsers = new SmartList();
            for (ExternalSystemOutputParserProvider outputParserProvider : (ExternalSystemOutputParserProvider[])ExternalSystemOutputParserProvider.EP_NAME.getExtensions()) {
                if (!task.getExternalSystemId().equals((Object)outputParserProvider.getExternalSystemId())) continue;
                buildOutputParsers.addAll(outputParserProvider.getBuildOutputParsers(task));
            }
            final BuildOutputInstantReaderImpl buildOutputInstantReader = progressListener == null || buildOutputParsers.isEmpty() ? null : new BuildOutputInstantReaderImpl((Object)task.getId(), progressListener, (List)buildOutputParsers);
            JavaRunConfigurationExtensionManager javaRunConfigurationExtensionManager = JavaRunConfigurationExtensionManager.getInstance();
            if (javaRunConfigurationExtensionManager != null) {
                javaRunConfigurationExtensionManager.attachExtensionsToProcess((RunConfigurationBase)this.myConfiguration, (ProcessHandler)processHandler, this.myEnv.getRunnerSettings());
            }
            ApplicationManager.getApplication().executeOnPooledThread(() -> {
                String startDateTime = DateFormatUtil.formatTimeWithSeconds((long)System.currentTimeMillis());
                final String settingsDescription = StringUtil.isEmpty((String)this.mySettings.toString()) ? "" : String.format(" '%s'", this.mySettings.toString());
                final String greeting = this.mySettings.getTaskNames().size() > 1 ? ExternalSystemBundle.message((String)"run.text.starting.multiple.task", (Object[])new Object[]{startDateTime, settingsDescription}) + "\n" : ExternalSystemBundle.message((String)"run.text.starting.single.task", (Object[])new Object[]{startDateTime, settingsDescription}) + "\n";
                ExternalSystemTaskNotificationListenerAdapter taskListener = new ExternalSystemTaskNotificationListenerAdapter(){
                    private boolean myResetGreeting = true;

                    public void onStart(@NotNull ExternalSystemTaskId id, String workingDir) {
                        if (id == null) {
                            1.$$$reportNull$$$0(0);
                        }
                        if (progressListener != null) {
                            long eventTime = System.currentTimeMillis();
                            MyTaskRerunAction rerunTaskAction = new MyTaskRerunAction(progressListener, myEnv, myContentDescriptor);
                            progressListener.onEvent((BuildEvent)new StartBuildEventImpl((BuildDescriptor)new DefaultBuildDescriptor((Object)id, executionName, workingDir, eventTime), "running...").withProcessHandler((BuildProcessHandler)processHandler, view -> {
                                processHandler.notifyTextAvailable(greeting + "\n", ProcessOutputTypes.SYSTEM);
                                ExternalSystemRunConfiguration.foldGreetingOrFarewell(consoleView, greeting, true);
                            }).withContentDescriptorSupplier(() -> myContentDescriptor).withRestartAction((AnAction)rerunTaskAction).withRestartActions(restartActions).withExecutionEnvironment(myEnv));
                        }
                    }

                    public void onTaskOutput(@NotNull ExternalSystemTaskId id, @NotNull String text, boolean stdOut) {
                        if (id == null) {
                            1.$$$reportNull$$$0(1);
                        }
                        if (text == null) {
                            1.$$$reportNull$$$0(2);
                        }
                        if (this.myResetGreeting) {
                            processHandler.notifyTextAvailable("\r", ProcessOutputTypes.SYSTEM);
                            this.myResetGreeting = false;
                        }
                        if (consoleView != null) {
                            consoleManager.onOutput(consoleView, (ProcessHandler)processHandler, text, stdOut ? ProcessOutputTypes.STDOUT : ProcessOutputTypes.STDERR);
                        } else {
                            processHandler.notifyTextAvailable(text, stdOut ? ProcessOutputTypes.STDOUT : ProcessOutputTypes.STDERR);
                        }
                        if (buildOutputInstantReader != null) {
                            buildOutputInstantReader.append((CharSequence)text);
                        }
                    }

                    public void onFailure(@NotNull ExternalSystemTaskId id, @NotNull Exception e) {
                        if (id == null) {
                            1.$$$reportNull$$$0(3);
                        }
                        if (e == null) {
                            1.$$$reportNull$$$0(4);
                        }
                        FailureResultImpl failureResult = ExternalSystemUtil.createFailureResult(executionName + " failed", e, id.getProjectSystemId(), myProject);
                        if (progressListener != null) {
                            progressListener.onEvent((BuildEvent)new FinishBuildEventImpl((Object)id, null, System.currentTimeMillis(), "failed", (EventResult)failureResult));
                        }
                        ExternalSystemUtil.printFailure(e, (FailureResult)failureResult, consoleView, processHandler);
                        processHandler.notifyProcessTerminated(1);
                    }

                    public void onSuccess(@NotNull ExternalSystemTaskId id) {
                        if (id == null) {
                            1.$$$reportNull$$$0(5);
                        }
                        if (progressListener != null) {
                            progressListener.onEvent((BuildEvent)new FinishBuildEventImpl((Object)id, null, System.currentTimeMillis(), "completed successfully", (EventResult)new SuccessResultImpl()));
                        }
                    }

                    public void onStatusChange(@NotNull ExternalSystemTaskNotificationEvent event) {
                        if (event == null) {
                            1.$$$reportNull$$$0(6);
                        }
                        if (progressListener != null && event instanceof ExternalSystemTaskExecutionEvent) {
                            BuildEvent buildEvent = ExternalSystemUtil.convert((ExternalSystemTaskExecutionEvent)event);
                            progressListener.onEvent(buildEvent);
                        }
                    }

                    public void onEnd(@NotNull ExternalSystemTaskId id) {
                        if (id == null) {
                            1.$$$reportNull$$$0(7);
                        }
                        String endDateTime = DateFormatUtil.formatTimeWithSeconds((long)System.currentTimeMillis());
                        String farewell = mySettings.getTaskNames().size() > 1 ? ExternalSystemBundle.message((String)"run.text.ended.multiple.task", (Object[])new Object[]{endDateTime, settingsDescription}) : ExternalSystemBundle.message((String)"run.text.ended.single.task", (Object[])new Object[]{endDateTime, settingsDescription});
                        processHandler.notifyTextAvailable(farewell + "\n", ProcessOutputTypes.SYSTEM);
                        ExternalSystemRunConfiguration.foldGreetingOrFarewell(consoleView, farewell, false);
                        processHandler.notifyProcessTerminated(0);
                        if (buildOutputInstantReader != null) {
                            buildOutputInstantReader.close();
                        }
                    }

                    private static /* synthetic */ void $$$reportNull$$$0(int n) {
                        Object[] objectArray;
                        Object[] objectArray2;
                        Object[] objectArray3 = new Object[3];
                        switch (n) {
                            default: {
                                objectArray2 = objectArray3;
                                objectArray3[0] = "id";
                                break;
                            }
                            case 2: {
                                objectArray2 = objectArray3;
                                objectArray3[0] = "text";
                                break;
                            }
                            case 4: {
                                objectArray2 = objectArray3;
                                objectArray3[0] = "e";
                                break;
                            }
                            case 6: {
                                objectArray2 = objectArray3;
                                objectArray3[0] = "event";
                                break;
                            }
                        }
                        objectArray2[1] = "com/intellij/openapi/externalSystem/service/execution/ExternalSystemRunConfiguration$MyRunnableState$1";
                        switch (n) {
                            default: {
                                objectArray = objectArray2;
                                objectArray2[2] = "onStart";
                                break;
                            }
                            case 1: 
                            case 2: {
                                objectArray = objectArray2;
                                objectArray2[2] = "onTaskOutput";
                                break;
                            }
                            case 3: 
                            case 4: {
                                objectArray = objectArray2;
                                objectArray2[2] = "onFailure";
                                break;
                            }
                            case 5: {
                                objectArray = objectArray2;
                                objectArray2[2] = "onSuccess";
                                break;
                            }
                            case 6: {
                                objectArray = objectArray2;
                                objectArray2[2] = "onStatusChange";
                                break;
                            }
                            case 7: {
                                objectArray = objectArray2;
                                objectArray2[2] = "onEnd";
                                break;
                            }
                        }
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
                    }
                };
                task.execute((ExternalSystemTaskNotificationListener[])ArrayUtil.prepend((Object)taskListener, (Object[])ExternalSystemTaskNotificationListener.EP_NAME.getExtensions()));
            });
            ExecutionConsole executionConsole = progressListener instanceof ExecutionConsole ? (ExecutionConsole)progressListener : consoleView;
            AnAction[] actions = AnAction.EMPTY_ARRAY;
            if (executionConsole instanceof BuildView) {
                actions = ((BuildView)executionConsole).getSwitchActions();
            }
            DefaultExecutionResult executionResult = new DefaultExecutionResult(executionConsole, (ProcessHandler)processHandler, actions);
            executionResult.setRestartActions(restartActions);
            return executionResult;
        }

        @Nullable
        private String getJvmAgentSetup() throws ExecutionException {
            String jvmAgentSetup;
            RunConfigurationExtension[] extensions;
            if (!ExternalSystemApiUtil.isJavaCompatibleIde()) {
                return null;
            }
            JavaParameters extensionsJP = new JavaParameters();
            for (RunConfigurationExtension ext : extensions = (RunConfigurationExtension[])Extensions.getExtensions(RunConfigurationExtension.EP_NAME)) {
                ext.updateJavaParameters(this.myConfiguration, extensionsJP, this.myEnv.getRunnerSettings());
            }
            if (this.myDebugPort > 0) {
                jvmAgentSetup = "-agentlib:jdwp=transport=dt_socket,server=n,suspend=y,address=" + this.myDebugPort;
                if (this.getForkSocket() != null) {
                    jvmAgentSetup = jvmAgentSetup + " -forkSocket" + this.getForkSocket().getLocalPort();
                }
            } else {
                ParametersList parametersList = extensionsJP.getVMParametersList();
                ParametersList data = (ParametersList)this.myEnv.getUserData(ExternalSystemTaskExecutionSettings.JVM_AGENT_SETUP_KEY);
                if (data != null) {
                    parametersList.addAll(data.getList());
                }
                for (String parameter : parametersList.getList()) {
                    if (parameter.startsWith("-agentlib:") || parameter.startsWith("-agentpath:") || parameter.startsWith("-javaagent:")) continue;
                    throw new ExecutionException(ExternalSystemBundle.message((String)"run.invalid.jvm.agent.configuration", (Object[])new Object[]{parameter}));
                }
                jvmAgentSetup = parametersList.getParametersString();
            }
            return jvmAgentSetup;
        }

        private BuildProgressListener createBuildView(ExternalSystemTaskId id, String executionName, String workingDir, ExecutionConsole executionConsole) {
            DefaultBuildDescriptor buildDescriptor = new DefaultBuildDescriptor((Object)id, executionName, workingDir, System.currentTimeMillis());
            return new BuildView(this.myProject, executionConsole, (BuildDescriptor)buildDescriptor, "build.toolwindow.run.selection.state", new ViewManager(){

                public boolean isConsoleEnabledByDefault() {
                    return true;
                }

                public boolean isBuildContentView() {
                    return false;
                }
            });
        }

        public void setContentDescriptor(@Nullable RunContentDescriptor contentDescriptor) {
            this.myContentDescriptor = contentDescriptor;
            if (contentDescriptor != null) {
                contentDescriptor.setExecutionId(this.myEnv.getExecutionId());
                contentDescriptor.setAutoFocusContent(true);
                RunnerAndConfigurationSettings settings = this.myEnv.getRunnerAndConfigurationSettings();
                if (settings != null) {
                    contentDescriptor.setActivateToolWindowWhenAdded(settings.isActivateToolWindowBeforeRun());
                }
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "settings";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "configuration";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "env";
                    break;
                }
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "runner";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/openapi/externalSystem/service/execution/ExternalSystemRunConfiguration$MyRunnableState";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[2] = "execute";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

