/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.externalSystem.service.execution;

import com.intellij.build.process.BuildProcessHandler;
import com.intellij.execution.process.AnsiEscapeDecoder;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.externalSystem.model.task.ExternalSystemTask;
import com.intellij.openapi.externalSystem.model.task.ExternalSystemTaskNotificationListener;
import com.intellij.openapi.externalSystem.service.execution.ExternalSystemRunConfiguration;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.openapi.util.io.StreamUtil;
import java.io.Closeable;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PipedInputStream;
import java.io.PipedOutputStream;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ExternalSystemProcessHandler
extends BuildProcessHandler
implements AnsiEscapeDecoder.ColoredTextAcceptor,
Disposable {
    private static final Logger LOG = Logger.getInstance(ExternalSystemProcessHandler.class);
    private final String myExecutionName;
    @Nullable
    private ExternalSystemTask myTask;
    private final AnsiEscapeDecoder myAnsiEscapeDecoder;
    @Nullable
    private OutputStream myProcessInput;

    public ExternalSystemProcessHandler(@NotNull ExternalSystemTask task, String executionName) {
        if (task == null) {
            ExternalSystemProcessHandler.$$$reportNull$$$0(0);
        }
        this.myAnsiEscapeDecoder = new AnsiEscapeDecoder();
        this.myTask = task;
        this.myExecutionName = executionName;
        if (task instanceof UserDataHolder) {
            try {
                PipedInputStream inputStream = new PipedInputStream();
                this.myProcessInput = new PipedOutputStream(inputStream);
                ((UserDataHolder)task).putUserData(ExternalSystemRunConfiguration.RUN_INPUT_KEY, (Object)inputStream);
            }
            catch (IOException e) {
                LOG.warn("Unable to setup process input", (Throwable)e);
            }
        }
    }

    public String getExecutionName() {
        return this.myExecutionName;
    }

    public void notifyTextAvailable(@NotNull String text, @NotNull Key outputType) {
        if (text == null) {
            ExternalSystemProcessHandler.$$$reportNull$$$0(1);
        }
        if (outputType == null) {
            ExternalSystemProcessHandler.$$$reportNull$$$0(2);
        }
        this.myAnsiEscapeDecoder.escapeText(text, outputType, (AnsiEscapeDecoder.ColoredTextAcceptor)this);
    }

    protected void destroyProcessImpl() {
        ExternalSystemTask task = this.myTask;
        if (task != null) {
            task.cancel(new ExternalSystemTaskNotificationListener[0]);
        }
        this.closeInput();
    }

    protected void detachProcessImpl() {
        this.notifyProcessDetached();
        this.closeInput();
    }

    public boolean detachIsDefault() {
        return false;
    }

    @Nullable
    public OutputStream getProcessInput() {
        return this.myProcessInput;
    }

    public void notifyProcessTerminated(int exitCode) {
        super.notifyProcessTerminated(exitCode);
        this.closeInput();
    }

    public void coloredTextAvailable(@NotNull String text, @NotNull Key attributes) {
        if (text == null) {
            ExternalSystemProcessHandler.$$$reportNull$$$0(3);
        }
        if (attributes == null) {
            ExternalSystemProcessHandler.$$$reportNull$$$0(4);
        }
        super.notifyTextAvailable(text, attributes);
    }

    protected void closeInput() {
        ExternalSystemTask task = this.myTask;
        if (task instanceof UserDataHolder) {
            ((UserDataHolder)task).putUserData(ExternalSystemRunConfiguration.RUN_INPUT_KEY, null);
        }
        StreamUtil.closeStream((Closeable)this.myProcessInput);
        this.myProcessInput = null;
    }

    public void dispose() {
        try {
            this.detachProcessImpl();
        }
        finally {
            this.myTask = null;
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "task";
                break;
            }
            case 1: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "text";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "outputType";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "attributes";
                break;
            }
        }
        objectArray2[1] = "com/intellij/openapi/externalSystem/service/execution/ExternalSystemProcessHandler";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "notifyTextAvailable";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "coloredTextAvailable";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

