/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.externalSystem.action;

import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.externalSystem.action.ExternalSystemNodeAction;
import com.intellij.openapi.externalSystem.model.ExternalSystemDataKeys;
import com.intellij.openapi.externalSystem.model.ProjectSystemId;
import com.intellij.openapi.externalSystem.model.project.AbstractExternalEntityData;
import com.intellij.openapi.externalSystem.model.project.ExternalConfigPathAware;
import com.intellij.openapi.externalSystem.model.project.ModuleData;
import com.intellij.openapi.externalSystem.model.project.ProjectData;
import com.intellij.openapi.externalSystem.service.execution.ProgressExecutionMode;
import com.intellij.openapi.externalSystem.settings.ExternalProjectSettings;
import com.intellij.openapi.externalSystem.util.ExternalSystemApiUtil;
import com.intellij.openapi.externalSystem.util.ExternalSystemBundle;
import com.intellij.openapi.externalSystem.util.ExternalSystemUtil;
import com.intellij.openapi.externalSystem.view.ExternalSystemNode;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.project.Project;
import com.intellij.util.containers.ContainerUtil;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class RefreshExternalProjectAction
extends ExternalSystemNodeAction<AbstractExternalEntityData> {
    public RefreshExternalProjectAction() {
        super(AbstractExternalEntityData.class);
        this.getTemplatePresentation().setText(ExternalSystemBundle.message((String)"action.refresh.project.text", (Object[])new Object[]{"external"}));
        this.getTemplatePresentation().setDescription(ExternalSystemBundle.message((String)"action.refresh.project.description", (Object[])new Object[]{"external"}));
    }

    @Override
    public void update(@NotNull AnActionEvent e) {
        if (e == null) {
            RefreshExternalProjectAction.$$$reportNull$$$0(0);
        }
        super.update(e);
        if (((Object)((Object)this)).getClass() != RefreshExternalProjectAction.class) {
            return;
        }
        ProjectSystemId systemId = this.getSystemId(e);
        String systemIdName = systemId != null ? systemId.getReadableName() : "external";
        Presentation presentation = e.getPresentation();
        presentation.setText(ExternalSystemBundle.message((String)"action.refresh.project.text", (Object[])new Object[]{systemIdName}));
        presentation.setDescription(ExternalSystemBundle.message((String)"action.refresh.project.description", (Object[])new Object[]{systemIdName}));
    }

    @Override
    protected boolean isEnabled(AnActionEvent e) {
        if (!super.isEnabled(e)) {
            return false;
        }
        List selectedNodes = (List)ExternalSystemDataKeys.SELECTED_NODES.getData(e.getDataContext());
        if (selectedNodes == null || selectedNodes.size() != 1) {
            return false;
        }
        Object externalData = ((ExternalSystemNode)selectedNodes.get(0)).getData();
        return externalData instanceof ProjectData || externalData instanceof ModuleData;
    }

    @Override
    public void perform(@NotNull Project project2, @NotNull ProjectSystemId projectSystemId, @NotNull AbstractExternalEntityData externalEntityData, @NotNull AnActionEvent e) {
        ExternalConfigPathAware externalConfigPathAware;
        if (project2 == null) {
            RefreshExternalProjectAction.$$$reportNull$$$0(1);
        }
        if (projectSystemId == null) {
            RefreshExternalProjectAction.$$$reportNull$$$0(2);
        }
        if (externalEntityData == null) {
            RefreshExternalProjectAction.$$$reportNull$$$0(3);
        }
        if (e == null) {
            RefreshExternalProjectAction.$$$reportNull$$$0(4);
        }
        List selectedNodes = (List)ExternalSystemDataKeys.SELECTED_NODES.getData(e.getDataContext());
        ExternalSystemNode externalSystemNode = (ExternalSystemNode)ContainerUtil.getFirstItem((List)selectedNodes);
        assert (externalSystemNode != null);
        ExternalConfigPathAware externalConfigPathAware2 = externalConfigPathAware = externalSystemNode.getData() instanceof ExternalConfigPathAware ? (ExternalConfigPathAware)externalSystemNode.getData() : null;
        assert (externalConfigPathAware != null);
        FileDocumentManager.getInstance().saveAllDocuments();
        ExternalProjectSettings linkedProjectSettings = ExternalSystemApiUtil.getSettings((Project)project2, (ProjectSystemId)projectSystemId).getLinkedProjectSettings(externalConfigPathAware.getLinkedExternalProjectPath());
        String externalProjectPath = linkedProjectSettings == null ? externalConfigPathAware.getLinkedExternalProjectPath() : linkedProjectSettings.getExternalProjectPath();
        ExternalSystemUtil.refreshProject(project2, projectSystemId, externalProjectPath, false, ProgressExecutionMode.IN_BACKGROUND_ASYNC);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "e";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "projectSystemId";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "externalEntityData";
                break;
            }
        }
        objectArray2[1] = "com/intellij/openapi/externalSystem/action/RefreshExternalProjectAction";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "update";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "perform";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

