/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.jarRepository;

import com.intellij.jarRepository.JarRepositoryManager;
import com.intellij.jarRepository.RepositoryLibraryType;
import com.intellij.jarRepository.settings.RepositoryLibraryPropertiesDialog;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.OrderRootType;
import com.intellij.openapi.roots.libraries.ui.LibraryEditorComponent;
import com.intellij.openapi.roots.libraries.ui.OrderRoot;
import com.intellij.openapi.roots.ui.configuration.libraryEditor.LibraryEditor;
import com.intellij.openapi.roots.ui.configuration.libraryEditor.LibraryPropertiesEditorBase;
import java.util.Collection;
import org.jetbrains.idea.maven.utils.library.RepositoryLibraryDescription;
import org.jetbrains.idea.maven.utils.library.RepositoryLibraryProperties;
import org.jetbrains.idea.maven.utils.library.RepositoryUtils;
import org.jetbrains.idea.maven.utils.library.propertiesEditor.RepositoryLibraryPropertiesModel;

public class RepositoryLibraryWithDescriptionEditor
extends LibraryPropertiesEditorBase<RepositoryLibraryProperties, RepositoryLibraryType> {
    public RepositoryLibraryWithDescriptionEditor(LibraryEditorComponent<RepositoryLibraryProperties> editorComponent) {
        super(editorComponent, RepositoryLibraryType.getInstance(), null);
    }

    public void apply() {
    }

    @Override
    protected void edit() {
        RepositoryLibraryProperties properties = (RepositoryLibraryProperties)this.myEditorComponent.getProperties();
        boolean wasGeneratedName = RepositoryLibraryType.getInstance().getDescription(properties).equals(this.myEditorComponent.getLibraryEditor().getName());
        RepositoryLibraryPropertiesModel model = new RepositoryLibraryPropertiesModel(properties.getVersion(), RepositoryUtils.libraryHasSources(this.myEditorComponent.getLibraryEditor()), RepositoryUtils.libraryHasJavaDocs(this.myEditorComponent.getLibraryEditor()), properties.isIncludeTransitiveDependencies(), properties.getExcludedDependencies());
        Project project2 = this.myEditorComponent.getProject();
        assert (project2 != null) : "EditorComponent's project must not be null in order to be used with RepositoryLibraryWithDescriptionEditor";
        RepositoryLibraryPropertiesDialog dialog = new RepositoryLibraryPropertiesDialog(project2, model, RepositoryLibraryDescription.findDescription((RepositoryLibraryProperties)properties), true, true);
        if (!dialog.showAndGet()) {
            return;
        }
        ((RepositoryLibraryProperties)this.myEditorComponent.getProperties()).changeVersion(model.getVersion());
        ((RepositoryLibraryProperties)this.myEditorComponent.getProperties()).setIncludeTransitiveDependencies(model.isIncludeTransitiveDependencies());
        ((RepositoryLibraryProperties)this.myEditorComponent.getProperties()).setExcludedDependencies(model.getExcludedDependencies());
        if (wasGeneratedName) {
            this.myEditorComponent.renameLibrary(RepositoryLibraryType.getInstance().getDescription(properties));
        }
        LibraryEditor libraryEditor = this.myEditorComponent.getLibraryEditor();
        String copyTo = RepositoryUtils.getStorageRoot(this.myEditorComponent.getLibraryEditor().getUrls(OrderRootType.CLASSES), project2);
        Collection<OrderRoot> roots = JarRepositoryManager.loadDependenciesModal(project2, properties, model.isDownloadSources(), model.isDownloadJavaDocs(), copyTo, null);
        libraryEditor.removeAllRoots();
        if (roots != null) {
            libraryEditor.addRoots(roots);
        }
        this.myEditorComponent.updateRootsTree();
        this.updateDescription();
    }
}

