/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.jarRepository;

import com.intellij.CommonBundle;
import com.intellij.jarRepository.RemoteRepositoriesConfiguration;
import com.intellij.jarRepository.RemoteRepositoryDescription;
import com.intellij.jarRepository.RepositoryArtifactDescription;
import com.intellij.jarRepository.RepositoryAttachDialog;
import com.intellij.jarRepository.RepositoryLibraryType;
import com.intellij.jarRepository.services.MavenRepositoryServicesManager;
import com.intellij.notification.Notification;
import com.intellij.notification.NotificationType;
import com.intellij.notification.Notifications;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.application.WriteAction;
import com.intellij.openapi.components.ComponentManager;
import com.intellij.openapi.components.PathMacroManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.EmptyProgressIndicator;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.progress.Task;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.JavadocOrderRootType;
import com.intellij.openapi.roots.OrderRootType;
import com.intellij.openapi.roots.libraries.LibraryProperties;
import com.intellij.openapi.roots.libraries.NewLibraryConfiguration;
import com.intellij.openapi.roots.libraries.ui.OrderRoot;
import com.intellij.openapi.roots.ui.configuration.libraryEditor.LibraryEditor;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileManager;
import com.intellij.util.Processor;
import com.intellij.util.concurrency.SequentialTaskExecutor;
import gnu.trove.THashMap;
import java.awt.Component;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.EnumSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.swing.JComponent;
import org.eclipse.aether.artifact.Artifact;
import org.eclipse.aether.repository.RemoteRepository;
import org.eclipse.aether.transfer.RepositoryOfflineException;
import org.eclipse.aether.transfer.TransferCancelledException;
import org.eclipse.aether.version.Version;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.concurrency.AsyncPromise;
import org.jetbrains.concurrency.Promise;
import org.jetbrains.idea.maven.aether.ArtifactDependencyNode;
import org.jetbrains.idea.maven.aether.ArtifactKind;
import org.jetbrains.idea.maven.aether.ArtifactRepositoryManager;
import org.jetbrains.idea.maven.aether.ProgressConsumer;
import org.jetbrains.idea.maven.utils.library.RepositoryLibraryDescription;
import org.jetbrains.idea.maven.utils.library.RepositoryLibraryProperties;
import org.jetbrains.jps.model.library.JpsMavenRepositoryLibraryDescriptor;

public class JarRepositoryManager {
    private static final Logger LOG = Logger.getInstance((String)"#org.jetbrains.idea.maven.utils.library.RepositoryAttachHandler");
    private static final String MAVEN_REPOSITORY_MACRO = "$MAVEN_REPOSITORY$";
    private static final String DEFAULT_REPOSITORY_PATH = ".m2/repository";
    private static final AtomicInteger ourTasksInProgress = new AtomicInteger();
    private static volatile File ourLocalRepositoryPath;

    public static boolean hasRunningTasks() {
        return ourTasksInProgress.get() > 0;
    }

    @Nullable
    public static NewLibraryConfiguration chooseLibraryAndDownload(@NotNull Project project2, @Nullable String initialFilter, JComponent parentComponent) {
        String copyTo;
        boolean includeTransitiveDependencies;
        boolean attachJavaDoc;
        boolean attachSources;
        RepositoryAttachDialog dialog;
        if (project2 == null) {
            JarRepositoryManager.$$$reportNull$$$0(0);
        }
        if (!(dialog = new RepositoryAttachDialog(project2, initialFilter, RepositoryAttachDialog.Mode.DOWNLOAD)).showAndGet()) {
            return null;
        }
        String coord = dialog.getCoordinateText();
        NewLibraryConfiguration config = JarRepositoryManager.resolveAndDownload(project2, coord, attachSources = dialog.getAttachSources(), attachJavaDoc = dialog.getAttachJavaDoc(), includeTransitiveDependencies = dialog.getIncludeTransitiveDependencies(), copyTo = dialog.getDirectoryPath(), RemoteRepositoriesConfiguration.getInstance((Project)project2).getRepositories());
        if (config == null) {
            Messages.showErrorDialog((Component)parentComponent, (String)("No files were downloaded for " + coord), (String)CommonBundle.getErrorTitle());
        }
        return config;
    }

    @Nullable
    public static NewLibraryConfiguration resolveAndDownload(@NotNull Project project2, String coord, boolean attachSources, boolean attachJavaDoc, boolean includeTransitiveDependencies, String copyTo, Collection<RemoteRepositoryDescription> repositories) {
        RepositoryLibraryProperties props;
        Collection<OrderRoot> roots;
        if (project2 == null) {
            JarRepositoryManager.$$$reportNull$$$0(1);
        }
        if ((roots = JarRepositoryManager.loadDependenciesModal(project2, props = new RepositoryLibraryProperties(coord, includeTransitiveDependencies), attachSources, attachJavaDoc, copyTo, repositories)) != null && !roots.isEmpty()) {
            JarRepositoryManager.notifyArtifactsDownloaded(project2, roots);
            return new NewLibraryConfiguration(RepositoryLibraryDescription.findDescription((RepositoryLibraryProperties)props).getDisplayName(props.getVersion()), RepositoryLibraryType.getInstance(), (LibraryProperties)props){

                public void addRoots(@NotNull LibraryEditor editor) {
                    if (editor == null) {
                        1.$$$reportNull$$$0(0);
                    }
                    editor.addRoots(roots);
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "editor", "com/intellij/jarRepository/JarRepositoryManager$1", "addRoots"));
                }
            };
        }
        return null;
    }

    @NotNull
    public static File getLocalRepositoryPath() {
        File repoPath = ourLocalRepositoryPath;
        if (repoPath != null) {
            File file = repoPath;
            if (file == null) {
                JarRepositoryManager.$$$reportNull$$$0(2);
            }
            return file;
        }
        String expanded = PathMacroManager.getInstance((ComponentManager)ApplicationManager.getApplication()).expandPath(MAVEN_REPOSITORY_MACRO);
        if (!MAVEN_REPOSITORY_MACRO.equals(expanded) && (repoPath = new File(expanded)).exists()) {
            try {
                repoPath = repoPath.getCanonicalFile();
            }
            catch (IOException iOException) {
                // empty catch block
            }
            ourLocalRepositoryPath = repoPath;
            File file = repoPath;
            if (file == null) {
                JarRepositoryManager.$$$reportNull$$$0(3);
            }
            return file;
        }
        String userHome = System.getProperty("user.home", null);
        ourLocalRepositoryPath = repoPath = userHome != null ? new File(userHome, DEFAULT_REPOSITORY_PATH) : new File(DEFAULT_REPOSITORY_PATH);
        File file = repoPath;
        if (file == null) {
            JarRepositoryManager.$$$reportNull$$$0(4);
        }
        return file;
    }

    public static Collection<OrderRoot> loadDependenciesModal(@NotNull Project project2, @NotNull RepositoryLibraryProperties libraryProps, boolean loadSources, boolean loadJavadoc, @Nullable String copyTo, @Nullable Collection<RemoteRepositoryDescription> repositories) {
        if (project2 == null) {
            JarRepositoryManager.$$$reportNull$$$0(5);
        }
        if (libraryProps == null) {
            JarRepositoryManager.$$$reportNull$$$0(6);
        }
        return JarRepositoryManager.loadDependenciesImpl(project2, libraryProps, loadSources, loadJavadoc, copyTo, repositories, true);
    }

    @Deprecated
    public static Collection<OrderRoot> loadDependencies(@NotNull Project project2, @NotNull RepositoryLibraryProperties libraryProps, boolean loadSources, boolean loadJavadoc, @Nullable String copyTo, @Nullable Collection<RemoteRepositoryDescription> repositories) {
        if (project2 == null) {
            JarRepositoryManager.$$$reportNull$$$0(7);
        }
        if (libraryProps == null) {
            JarRepositoryManager.$$$reportNull$$$0(8);
        }
        return JarRepositoryManager.loadDependenciesImpl(project2, libraryProps, loadSources, loadJavadoc, copyTo, repositories, false);
    }

    private static Collection<OrderRoot> loadDependenciesImpl(@NotNull Project project2, @NotNull RepositoryLibraryProperties libraryProps, boolean loadSources, boolean loadJavadoc, @Nullable String copyTo, @Nullable Collection<RemoteRepositoryDescription> repositories, boolean modal) {
        JpsMavenRepositoryLibraryDescriptor libDescriptor;
        if (project2 == null) {
            JarRepositoryManager.$$$reportNull$$$0(9);
        }
        if (libraryProps == null) {
            JarRepositoryManager.$$$reportNull$$$0(10);
        }
        if ((libDescriptor = libraryProps.getRepositoryLibraryDescriptor()).getMavenId() != null) {
            if (repositories == null || repositories.isEmpty()) {
                repositories = RemoteRepositoriesConfiguration.getInstance((Project)project2).getRepositories();
            }
            if (!repositories.isEmpty()) {
                EnumSet<ArtifactKind> kinds = EnumSet.of(ArtifactKind.ARTIFACT);
                if (loadSources) {
                    kinds.add(ArtifactKind.SOURCES);
                }
                if (loadJavadoc) {
                    kinds.add(ArtifactKind.JAVADOC);
                }
                try {
                    if (modal) {
                        return JarRepositoryManager.submitModalJob(project2, "Resolving Maven dependencies...", JarRepositoryManager.newOrderRootResolveJob(libDescriptor, kinds, repositories, copyTo));
                    }
                    return (Collection)JarRepositoryManager.submitBackgroundJob(project2, "Resolving Maven dependencies...", JarRepositoryManager.newOrderRootResolveJob(libDescriptor, kinds, repositories, copyTo)).blockingGet(10, TimeUnit.MINUTES);
                }
                catch (ExecutionException | TimeoutException e) {
                    LOG.info((Throwable)e);
                }
            }
        }
        return Collections.emptyList();
    }

    public static Promise<List<OrderRoot>> loadDependenciesAsync(@NotNull Project project2, RepositoryLibraryProperties libraryProps, boolean loadSources, boolean loadJavadoc, @Nullable List<RemoteRepositoryDescription> repos, @Nullable String copyTo) {
        if (project2 == null) {
            JarRepositoryManager.$$$reportNull$$$0(11);
        }
        EnumSet<ArtifactKind> kinds = EnumSet.of(ArtifactKind.ARTIFACT);
        if (loadSources) {
            kinds.add(ArtifactKind.SOURCES);
        }
        if (loadJavadoc) {
            kinds.add(ArtifactKind.JAVADOC);
        }
        return JarRepositoryManager.loadDependenciesAsync(project2, libraryProps.getRepositoryLibraryDescriptor(), kinds, repos, copyTo);
    }

    public static Promise<List<OrderRoot>> loadDependenciesAsync(@NotNull Project project2, JpsMavenRepositoryLibraryDescriptor desc, Set<ArtifactKind> artifactKinds, @Nullable List<RemoteRepositoryDescription> repos, @Nullable String copyTo) {
        if (project2 == null) {
            JarRepositoryManager.$$$reportNull$$$0(12);
        }
        if (repos == null || repos.isEmpty()) {
            repos = RemoteRepositoriesConfiguration.getInstance((Project)project2).getRepositories();
        }
        return JarRepositoryManager.submitBackgroundJob(project2, "Resolving Maven dependencies...", JarRepositoryManager.newOrderRootResolveJob(desc, artifactKinds, repos, copyTo));
    }

    @NotNull
    public static Promise<Collection<String>> getAvailableVersions(Project project2, RepositoryLibraryDescription libraryDescription) {
        List repos = RemoteRepositoriesConfiguration.getInstance((Project)project2).getRepositories();
        Promise<Collection<String>> promise = JarRepositoryManager.submitBackgroundJob(project2, "Looking up available versions for " + libraryDescription.getDisplayName(), new VersionResolveJob(libraryDescription, repos));
        if (promise == null) {
            JarRepositoryManager.$$$reportNull$$$0(13);
        }
        return promise;
    }

    @Nullable
    public static ArtifactDependencyNode loadDependenciesTree(final @NotNull RepositoryLibraryDescription description, final @NotNull String version, Project project2) {
        if (description == null) {
            JarRepositoryManager.$$$reportNull$$$0(14);
        }
        if (version == null) {
            JarRepositoryManager.$$$reportNull$$$0(15);
        }
        List repositories = RemoteRepositoriesConfiguration.getInstance((Project)project2).getRepositories();
        return JarRepositoryManager.submitModalJob(project2, "Resolving Maven Dependencies", new AetherJob<ArtifactDependencyNode>((Collection)repositories){

            @Override
            protected String getProgressText() {
                return "Loading dependencies of " + description.getMavenCoordinates(version);
            }

            @Override
            protected ArtifactDependencyNode perform(ProgressIndicator progress, ArtifactRepositoryManager manager) throws Exception {
                return manager.collectDependencies(description.getGroupId(), description.getArtifactId(), version);
            }

            @Override
            protected ArtifactDependencyNode getDefaultResult() {
                return null;
            }
        });
    }

    private static void notifyArtifactsDownloaded(Project project2, Collection<OrderRoot> roots) {
        StringBuilder sb = new StringBuilder();
        String title = "The following files were downloaded:";
        sb.append("<ol>");
        for (OrderRoot root : roots) {
            sb.append("<li>");
            sb.append(root.getFile().getName());
            sb.append("</li>");
        }
        sb.append("</ol>");
        Notifications.Bus.notify((Notification)new Notification("Repository", "The following files were downloaded:", sb.toString(), NotificationType.INFORMATION), (Project)project2);
    }

    public static void searchArtifacts(final Project project2, String coord, final Consumer<? super Collection<Pair<RepositoryArtifactDescription, RemoteRepositoryDescription>>> resultProcessor) {
        if (coord == null || coord.length() == 0) {
            return;
        }
        final RepositoryArtifactDescription template = coord.indexOf(58) == -1 && Character.isUpperCase(coord.charAt(0)) ? new RepositoryArtifactDescription(null, null, null, "jar", null, coord, null) : new RepositoryArtifactDescription(new RepositoryLibraryProperties(coord, true), "jar", null);
        ProgressManager.getInstance().run((Task)new Task.Backgroundable(project2, "Maven", false){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void run(@NotNull ProgressIndicator indicator) {
                if (indicator == null) {
                    3.$$$reportNull$$$0(0);
                }
                ArrayList<Pair> resultList = new ArrayList<Pair>();
                try {
                    for (String serviceUrl : MavenRepositoryServicesManager.getServiceUrls((Project)project2)) {
                        try {
                            List artifacts = MavenRepositoryServicesManager.findArtifacts((RepositoryArtifactDescription)template, (String)serviceUrl);
                            if (artifacts.isEmpty()) continue;
                            List repositories = MavenRepositoryServicesManager.getRepositories((String)serviceUrl);
                            THashMap map = new THashMap();
                            for (RemoteRepositoryDescription repository : repositories) {
                                map.put(repository.getId(), repository);
                            }
                            for (RepositoryArtifactDescription artifact : artifacts) {
                                RemoteRepositoryDescription repository = (RemoteRepositoryDescription)map.get(artifact.getRepositoryId());
                                if (repository == null) continue;
                                resultList.add(Pair.create((Object)artifact, (Object)repository));
                            }
                        }
                        catch (Exception e) {
                            LOG.error((Throwable)e);
                        }
                    }
                }
                finally {
                    ApplicationManager.getApplication().invokeLater(() -> resultProcessor.accept(resultList));
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "indicator", "com/intellij/jarRepository/JarRepositoryManager$3", "run"));
            }
        });
    }

    public static void searchRepositories(Project project2, final Collection<String> serviceUrls, final Processor<? super Collection<RemoteRepositoryDescription>> resultProcessor) {
        ProgressManager.getInstance().run((Task)new Task.Backgroundable(project2, "Maven", false){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void run(@NotNull ProgressIndicator indicator) {
                if (indicator == null) {
                    4.$$$reportNull$$$0(0);
                }
                Ref result = Ref.create(Collections.emptyList());
                try {
                    ArrayList repoList = new ArrayList();
                    for (String url : serviceUrls) {
                        List repositories;
                        try {
                            repositories = MavenRepositoryServicesManager.getRepositories((String)url);
                        }
                        catch (Exception ex) {
                            LOG.warn("Accessing Service at: " + url, (Throwable)ex);
                            continue;
                        }
                        repoList.addAll(repositories);
                    }
                    result.set(repoList);
                }
                catch (Exception e) {
                    LOG.error((Throwable)e);
                }
                finally {
                    ApplicationManager.getApplication().invokeLater(() -> resultProcessor.process(result.get()));
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "indicator", "com/intellij/jarRepository/JarRepositoryManager$4", "run"));
            }
        });
    }

    @Nullable
    private static <T> T submitModalJob(@Nullable Project project2, String title, final Function<ProgressIndicator, T> job) {
        final Ref result = Ref.create(null);
        new Task.Modal(project2, title, true){

            public void run(@NotNull ProgressIndicator indicator) {
                if (indicator == null) {
                    5.$$$reportNull$$$0(0);
                }
                try {
                    ourTasksInProgress.incrementAndGet();
                    result.set(job.apply(indicator));
                }
                finally {
                    ourTasksInProgress.decrementAndGet();
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "indicator", "com/intellij/jarRepository/JarRepositoryManager$5", "run"));
            }
        }.queue();
        return (T)result.get();
    }

    private static <T> Promise<T> submitBackgroundJob(@Nullable Project project2, String title, Function<ProgressIndicator, T> job) {
        ModalityState startModality = ModalityState.defaultModalityState();
        AsyncPromise promise = new AsyncPromise();
        JobExecutor.INSTANCE.submit(() -> {
            try {
                ourTasksInProgress.incrementAndGet();
                EmptyProgressIndicator indicator = new EmptyProgressIndicator(startModality);
                Object result = ProgressManager.getInstance().runProcess(() -> JarRepositoryManager.lambda$null$0(job, (ProgressIndicator)indicator), (ProgressIndicator)indicator);
                promise.setResult(result);
            }
            catch (ProcessCanceledException indicator) {
            }
            catch (Throwable e) {
                LOG.info(e);
                promise.setError(e);
            }
            finally {
                ourTasksInProgress.decrementAndGet();
            }
        });
        return promise;
    }

    private static Collection<String> lookupVersionsImpl(String groupId, String artifactId, ArtifactRepositoryManager manager) throws Exception {
        try {
            List result = manager.getAvailableVersions(groupId, artifactId, "[0,)", ArtifactKind.ARTIFACT);
            return result.stream().sorted(Comparator.reverseOrder()).map(Version::toString).collect(Collectors.toCollection(() -> new ArrayList(result.size())));
        }
        catch (TransferCancelledException e) {
            throw new ProcessCanceledException((Throwable)e);
        }
    }

    private static Function<ProgressIndicator, List<OrderRoot>> newOrderRootResolveJob(@NotNull JpsMavenRepositoryLibraryDescriptor desc, @NotNull Set<ArtifactKind> kinds, @NotNull Collection<RemoteRepositoryDescription> repositories, @Nullable String copyTo) {
        if (desc == null) {
            JarRepositoryManager.$$$reportNull$$$0(16);
        }
        if (kinds == null) {
            JarRepositoryManager.$$$reportNull$$$0(17);
        }
        if (repositories == null) {
            JarRepositoryManager.$$$reportNull$$$0(18);
        }
        return new LibraryResolveJob(desc, kinds, repositories).andThen(resolved -> resolved.isEmpty() ? Collections.emptyList() : (List)WriteAction.computeAndWait(() -> JarRepositoryManager.createRoots(resolved, copyTo)));
    }

    private static List<OrderRoot> createRoots(@NotNull Collection<Artifact> artifacts, @Nullable String copyTo) {
        if (artifacts == null) {
            JarRepositoryManager.$$$reportNull$$$0(19);
        }
        ArrayList<OrderRoot> result = new ArrayList<OrderRoot>();
        VirtualFileManager manager = VirtualFileManager.getInstance();
        for (Artifact each : artifacts) {
            try {
                File repoFile;
                File toFile = repoFile = each.getFile();
                if (copyTo != null) {
                    toFile = new File(copyTo, repoFile.getName());
                    if (repoFile.exists()) {
                        FileUtil.copy((File)repoFile, (File)toFile);
                    }
                }
                manager.refreshAndFindFileByUrl(VfsUtilCore.pathToUrl((String)FileUtil.toSystemIndependentName((String)toFile.getPath())));
                String url = VfsUtil.getUrlForLibraryRoot((File)toFile);
                VirtualFile file = manager.refreshAndFindFileByUrl(url);
                if (file == null) continue;
                OrderRootType rootType = ArtifactKind.JAVADOC.getClassifier().equals(each.getClassifier()) ? JavadocOrderRootType.getInstance() : (ArtifactKind.SOURCES.getClassifier().equals(each.getClassifier()) ? OrderRootType.SOURCES : OrderRootType.CLASSES);
                result.add(new OrderRoot(file, rootType));
            }
            catch (IOException e) {
                LOG.warn((Throwable)e);
            }
        }
        return result;
    }

    private static /* synthetic */ Object lambda$null$0(Function job, ProgressIndicator indicator) {
        return job.apply(indicator);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 13: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 13: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/jarRepository/JarRepositoryManager";
                break;
            }
            case 6: 
            case 8: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "libraryProps";
                break;
            }
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "description";
                break;
            }
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "version";
                break;
            }
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "desc";
                break;
            }
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "kinds";
                break;
            }
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "repositories";
                break;
            }
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "artifacts";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/jarRepository/JarRepositoryManager";
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getLocalRepositoryPath";
                break;
            }
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "getAvailableVersions";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "chooseLibraryAndDownload";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "resolveAndDownload";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 13: {
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "loadDependenciesModal";
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "loadDependencies";
                break;
            }
            case 9: 
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "loadDependenciesImpl";
                break;
            }
            case 11: 
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "loadDependenciesAsync";
                break;
            }
            case 14: 
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "loadDependenciesTree";
                break;
            }
            case 16: 
            case 17: 
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "newOrderRootResolveJob";
                break;
            }
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "createRoots";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 13: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static class VersionResolveJob
    extends AetherJob<Collection<String>> {
        @NotNull
        private final RepositoryLibraryDescription myDesc;

        public VersionResolveJob(@NotNull RepositoryLibraryDescription repositoryLibraryDescription, @NotNull List<RemoteRepositoryDescription> repositories) {
            if (repositoryLibraryDescription == null) {
                VersionResolveJob.$$$reportNull$$$0(0);
            }
            if (repositories == null) {
                VersionResolveJob.$$$reportNull$$$0(1);
            }
            super(repositories);
            this.myDesc = repositoryLibraryDescription;
        }

        @Override
        protected String getProgressText() {
            return "Loading " + this.myDesc.getDisplayName() + " versions";
        }

        @Override
        protected Collection<String> perform(ProgressIndicator progress, ArtifactRepositoryManager manager) throws Exception {
            return JarRepositoryManager.lookupVersionsImpl(this.myDesc.getGroupId(), this.myDesc.getArtifactId(), manager);
        }

        @Override
        protected Collection<String> getDefaultResult() {
            return Collections.emptyList();
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "repositoryLibraryDescription";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "repositories";
                    break;
                }
            }
            objectArray[1] = "com/intellij/jarRepository/JarRepositoryManager$VersionResolveJob";
            objectArray[2] = "<init>";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private static class LibraryResolveJob
    extends AetherJob<Collection<Artifact>> {
        @NotNull
        private final JpsMavenRepositoryLibraryDescriptor myDesc;
        @NotNull
        private final Set<ArtifactKind> myKinds;

        public LibraryResolveJob(@NotNull JpsMavenRepositoryLibraryDescriptor desc, @NotNull Set<ArtifactKind> kinds, @NotNull Collection<RemoteRepositoryDescription> repositories) {
            if (desc == null) {
                LibraryResolveJob.$$$reportNull$$$0(0);
            }
            if (kinds == null) {
                LibraryResolveJob.$$$reportNull$$$0(1);
            }
            if (repositories == null) {
                LibraryResolveJob.$$$reportNull$$$0(2);
            }
            super(repositories);
            this.myDesc = desc;
            this.myKinds = kinds;
        }

        @Override
        protected boolean canStart() {
            return super.canStart() && this.myDesc.getMavenId() != null;
        }

        @Override
        protected String getProgressText() {
            return "Loading " + RepositoryLibraryDescription.findDescription((JpsMavenRepositoryLibraryDescriptor)this.myDesc).getDisplayName();
        }

        @Override
        protected Collection<Artifact> getDefaultResult() {
            return Collections.emptyList();
        }

        @Override
        protected Collection<Artifact> perform(ProgressIndicator progress, ArtifactRepositoryManager manager) throws Exception {
            String version = this.myDesc.getVersion();
            try {
                return manager.resolveDependencyAsArtifact(this.myDesc.getGroupId(), this.myDesc.getArtifactId(), version, this.myKinds, this.myDesc.isIncludeTransitiveDependencies(), this.myDesc.getExcludedDependencies());
            }
            catch (TransferCancelledException e) {
                throw new ProcessCanceledException((Throwable)e);
            }
            catch (RepositoryOfflineException e) {
                throw e;
            }
            catch (Exception e) {
                String resolvedVersion = this.resolveVersion(manager, version);
                if (Comparing.equal((String)version, (String)resolvedVersion)) {
                    throw e;
                }
                try {
                    return manager.resolveDependencyAsArtifact(this.myDesc.getGroupId(), this.myDesc.getArtifactId(), resolvedVersion, this.myKinds, this.myDesc.isIncludeTransitiveDependencies(), this.myDesc.getExcludedDependencies());
                }
                catch (TransferCancelledException e1) {
                    throw new ProcessCanceledException((Throwable)e1);
                }
            }
        }

        @Nullable
        private String resolveVersion(ArtifactRepositoryManager manager, String version) throws Exception {
            boolean isLatest = "LATEST".equals(version);
            boolean isRelease = "RELEASE".equals(version);
            if (isLatest || isRelease) {
                try {
                    for (String ver : JarRepositoryManager.lookupVersionsImpl(this.myDesc.getGroupId(), this.myDesc.getArtifactId(), manager)) {
                        if (isRelease && ver.endsWith("-SNAPSHOT")) continue;
                        return ver;
                    }
                }
                catch (InterruptedException | ExecutionException e) {
                    LOG.error("Got unexpected exception while resolving artifact versions", (Throwable)e);
                }
            }
            return version;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "desc";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "kinds";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[0] = "repositories";
                    break;
                }
            }
            objectArray[1] = "com/intellij/jarRepository/JarRepositoryManager$LibraryResolveJob";
            objectArray[2] = "<init>";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private static abstract class AetherJob<T>
    implements Function<ProgressIndicator, T> {
        @NotNull
        private final Collection<RemoteRepositoryDescription> myRepositories;

        public AetherJob(@NotNull Collection<RemoteRepositoryDescription> repositories) {
            if (repositories == null) {
                AetherJob.$$$reportNull$$$0(0);
            }
            this.myRepositories = repositories;
        }

        protected boolean canStart() {
            return !this.myRepositories.isEmpty();
        }

        @Override
        public final T apply(final ProgressIndicator indicator) {
            if (this.canStart()) {
                indicator.setText(this.getProgressText());
                indicator.setIndeterminate(true);
                ArrayList<RemoteRepository> remotes = new ArrayList<RemoteRepository>();
                for (RemoteRepositoryDescription repository : this.myRepositories) {
                    remotes.add(ArtifactRepositoryManager.createRemoteRepository((String)repository.getId(), (String)repository.getUrl()));
                }
                try {
                    return this.perform(indicator, new ArtifactRepositoryManager(JarRepositoryManager.getLocalRepositoryPath(), remotes, new ProgressConsumer(){

                        public void consume(String message) {
                            indicator.setText(message);
                        }

                        public boolean isCanceled() {
                            return indicator.isCanceled();
                        }
                    }));
                }
                catch (ProcessCanceledException e) {
                    throw e;
                }
                catch (Exception e) {
                    LOG.info((Throwable)e);
                }
            }
            return this.getDefaultResult();
        }

        protected abstract String getProgressText();

        protected abstract T perform(ProgressIndicator var1, ArtifactRepositoryManager var2) throws Exception;

        protected abstract T getDefaultResult();

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "repositories", "com/intellij/jarRepository/JarRepositoryManager$AetherJob", "<init>"));
        }
    }

    private static class JobExecutor {
        static final ExecutorService INSTANCE = SequentialTaskExecutor.createSequentialApplicationPoolExecutor((String)"RemoteLibraryDownloader");

        private JobExecutor() {
        }
    }
}

