/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.util.newProjectWizard;

import com.intellij.openapi.ui.GraphicsConfig;
import com.intellij.ui.Gray;
import com.intellij.util.ui.GraphicsUtil;
import com.intellij.util.ui.JBInsets;
import com.intellij.util.ui.UIUtil;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.geom.Path2D;
import javax.swing.AbstractButton;
import javax.swing.JComponent;
import javax.swing.SwingUtilities;
import javax.swing.border.EmptyBorder;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.basic.BasicButtonUI;
import sun.swing.SwingUtilities2;

class WizardArrowUI
extends BasicButtonUI {
    private final AbstractButton myButton;
    private static final Rectangle viewRect = new Rectangle();
    private static final Rectangle textRect = new Rectangle();
    private static final Rectangle iconRect = new Rectangle();

    public WizardArrowUI(AbstractButton b, boolean valid) {
        this.myButton = b;
        b.setOpaque(false);
        b.setBorder(new EmptyBorder(8, 0, 8, 40));
    }

    public static ComponentUI createUI(JComponent c) {
        return new WizardArrowUI((AbstractButton)c, false);
    }

    @Override
    protected void paintIcon(Graphics g, JComponent c, Rectangle iconRect) {
    }

    @Override
    protected int getTextShiftOffset() {
        return 5;
    }

    private String layout(AbstractButton b, FontMetrics fm, int width, int height) {
        viewRect.setBounds(0, 0, width, height);
        JBInsets.removeFrom((Rectangle)viewRect, (Insets)b.getInsets());
        WizardArrowUI.textRect.height = 0;
        WizardArrowUI.textRect.width = 0;
        WizardArrowUI.textRect.y = 0;
        WizardArrowUI.textRect.x = 0;
        WizardArrowUI.iconRect.height = 0;
        WizardArrowUI.iconRect.width = 0;
        WizardArrowUI.iconRect.y = 0;
        WizardArrowUI.iconRect.x = 0;
        return SwingUtilities.layoutCompoundLabel(b, fm, b.getText(), b.getIcon(), b.getVerticalAlignment(), b.getHorizontalAlignment(), b.getVerticalTextPosition(), b.getHorizontalTextPosition(), viewRect, iconRect, textRect, b.getText() == null ? 0 : b.getIconTextGap());
    }

    @Override
    public void paint(Graphics g, JComponent c) {
        int w = c.getWidth();
        int h = c.getHeight();
        this.layout(this.myButton, SwingUtilities2.getFontMetrics(c, g), w, h);
        GraphicsConfig config = GraphicsUtil.setupAAPainting((Graphics)g);
        h -= 4;
        if (!this.myButton.isSelected()) {
            w -= 15;
        }
        Path2D.Double path = new Path2D.Double();
        path.moveTo(0.0, 0.0);
        path.lineTo(w - h / 2, 0.0);
        path.lineTo(w, h / 2);
        path.lineTo(w - h / 2, h);
        path.lineTo(0.0, h);
        path.lineTo(0.0, 0.0);
        g.setColor(this.myButton.isSelected() ? UIUtil.getListSelectionBackground() : Gray._255.withAlpha(200));
        ((Graphics2D)g).fill(path);
        g.setColor(Gray._0.withAlpha(50));
        ((Graphics2D)g).draw(path);
        config.restore();
        WizardArrowUI.textRect.x = 2;
        WizardArrowUI.textRect.y -= 7;
        c.setForeground(UIUtil.getListForeground((boolean)this.myButton.isSelected()));
        GraphicsUtil.setupAntialiasing((Graphics)g);
        this.paintText(g, c, textRect, this.myButton.getText());
    }
}

