/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.util.importProject;

import com.intellij.ide.util.importProject.DetectedRootData;
import com.intellij.ide.util.projectWizard.importSources.DetectedContentRoot;
import com.intellij.ide.util.projectWizard.importSources.DetectedProjectRoot;
import com.intellij.ide.util.projectWizard.importSources.DetectedSourceRoot;
import com.intellij.ide.util.projectWizard.importSources.ProjectStructureDetector;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.fileTypes.FileTypeManager;
import com.intellij.openapi.module.ModuleType;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.io.FileSystemUtil;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.util.ArrayUtil;
import com.intellij.util.SmartList;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.MultiMap;
import gnu.trove.THashSet;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.NotNull;

public class RootDetectionProcessor {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.ide.util.importProject.RootDetectionProcessor");
    private final File myBaseDir;
    private final ProjectStructureDetector[] myDetectors;
    private final List<DetectedProjectRoot>[] myDetectedRoots;
    private final FileTypeManager myTypeManager;
    private final ProgressIndicator myProgressIndicator;

    @NotNull
    public static List<DetectedRootData> detectRoots(@NotNull File baseProjectFile) {
        if (baseProjectFile == null) {
            RootDetectionProcessor.$$$reportNull$$$0(0);
        }
        List<DetectedRootData> list = new RootDetectionProcessor(baseProjectFile, (ProjectStructureDetector[])ProjectStructureDetector.EP_NAME.getExtensions()).detectRoots();
        if (list == null) {
            RootDetectionProcessor.$$$reportNull$$$0(1);
        }
        return list;
    }

    public RootDetectionProcessor(File baseDir, ProjectStructureDetector[] detectors) {
        this.myBaseDir = RootDetectionProcessor.getCanonicalDir(baseDir);
        this.myDetectors = detectors;
        this.myDetectedRoots = new List[this.myDetectors.length];
        this.myTypeManager = FileTypeManager.getInstance();
        this.myProgressIndicator = ProgressManager.getInstance().getProgressIndicator();
    }

    private static File getCanonicalDir(File baseDir) {
        try {
            return new File(FileUtil.resolveShortWindowsName((String)baseDir.getAbsolutePath()));
        }
        catch (IOException e) {
            LOG.info((Throwable)e);
            return baseDir;
        }
    }

    public static MultiMap<ProjectStructureDetector, DetectedProjectRoot> createRootsMap(List<DetectedRootData> list) {
        MultiMap roots = new MultiMap();
        for (DetectedRootData rootData : list) {
            for (ProjectStructureDetector detector : rootData.getSelectedDetectors()) {
                roots.putValue((Object)detector, (Object)rootData.getSelectedRoot());
            }
        }
        return roots;
    }

    public Map<ProjectStructureDetector, List<DetectedProjectRoot>> runDetectors() {
        if (!this.myBaseDir.isDirectory()) {
            return Collections.emptyMap();
        }
        BitSet enabledDetectors = new BitSet(this.myDetectors.length);
        enabledDetectors.set(0, this.myDetectors.length);
        for (int i = 0; i < this.myDetectors.length; ++i) {
            this.myDetectedRoots[i] = new ArrayList<DetectedProjectRoot>();
        }
        THashSet parentDirectories = new THashSet(FileUtil.FILE_HASHING_STRATEGY);
        for (File parent = this.myBaseDir.getParentFile(); parent != null; parent = parent.getParentFile()) {
            parentDirectories.add(parent);
        }
        this.processRecursively(this.myBaseDir, enabledDetectors, (Set<File>)parentDirectories);
        LinkedHashMap<ProjectStructureDetector, List<DetectedProjectRoot>> result = new LinkedHashMap<ProjectStructureDetector, List<DetectedProjectRoot>>();
        for (int i = 0; i < this.myDetectors.length; ++i) {
            if (this.myDetectedRoots[i].isEmpty()) continue;
            result.put(this.myDetectors[i], this.myDetectedRoots[i]);
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<Pair<File, Integer>> processRecursively(File dir, BitSet enabledDetectors, Set<File> parentDirectories) {
        SmartList parentsToSkip = new SmartList();
        if (this.myTypeManager.isFileIgnored(dir.getName())) {
            return parentsToSkip;
        }
        if (this.myProgressIndicator != null) {
            if (this.myProgressIndicator.isCanceled()) {
                return parentsToSkip;
            }
            this.myProgressIndicator.setText2(dir.getPath());
        }
        if (FileSystemUtil.isSymLink((File)dir)) {
            try {
                if (parentDirectories.contains(dir.getCanonicalFile())) {
                    return parentsToSkip;
                }
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        try {
            parentDirectories.add(dir);
            File[] children = dir.listFiles();
            if (children == null) {
                children = ArrayUtil.EMPTY_FILE_ARRAY;
            }
            BitSet enabledForChildren = enabledDetectors;
            int detectorsLength = this.myDetectors.length;
            for (int i = 0; i < detectorsLength; ++i) {
                File parentToSkip;
                if (!enabledDetectors.get(i)) continue;
                ProjectStructureDetector.DirectoryProcessingResult result = this.myDetectors[i].detectRoots(dir, children, this.myBaseDir, this.myDetectedRoots[i]);
                if (!result.isProcessChildren()) {
                    if (enabledForChildren == enabledDetectors) {
                        enabledForChildren = new BitSet();
                        enabledForChildren.or(enabledDetectors);
                    }
                    enabledForChildren.set(i, false);
                }
                if ((parentToSkip = result.getParentToSkip()) == null || FileUtil.filesEqual((File)parentToSkip, (File)dir)) continue;
                parentsToSkip.add(Pair.create((Object)parentToSkip, (Object)i));
            }
            if (!enabledForChildren.isEmpty()) {
                for (File child : children) {
                    List<Pair<File, Integer>> toSkip;
                    if (!child.isDirectory() || (toSkip = this.processRecursively(child, enabledForChildren, parentDirectories)).isEmpty()) continue;
                    if (enabledForChildren == enabledDetectors) {
                        enabledForChildren = new BitSet();
                        enabledForChildren.or(enabledDetectors);
                    }
                    for (Pair<File, Integer> pair2 : toSkip) {
                        enabledForChildren.set((int)((Integer)pair2.getSecond()), false);
                        if (FileUtil.filesEqual((File)((File)pair2.getFirst()), (File)dir)) continue;
                        parentsToSkip.add(pair2);
                    }
                    if (enabledForChildren.isEmpty()) break;
                }
            }
            SmartList smartList = parentsToSkip;
            return smartList;
        }
        finally {
            parentDirectories.remove(dir);
        }
    }

    private static void removeIncompatibleRoots(DetectedProjectRoot root, Map<File, DetectedRootData> rootData) {
        DetectedRootData[] allRoots;
        for (DetectedRootData child : allRoots = rootData.values().toArray(new DetectedRootData[0])) {
            File childDirectory = child.getDirectory();
            if (!FileUtil.isAncestor((File)root.getDirectory(), (File)childDirectory, (boolean)true)) continue;
            for (DetectedProjectRoot projectRoot : child.getAllRoots()) {
                if (root.canContainRoot(projectRoot)) continue;
                child.removeRoot(projectRoot);
            }
            if (!child.isEmpty()) continue;
            rootData.remove(childDirectory);
        }
    }

    private static boolean isUnderIncompatibleRoot(DetectedProjectRoot root, Map<File, DetectedRootData> rootData) {
        for (File directory = root.getDirectory().getParentFile(); directory != null; directory = directory.getParentFile()) {
            DetectedRootData data = rootData.get(directory);
            if (data == null) continue;
            for (DetectedProjectRoot parentRoot : data.getAllRoots()) {
                if (parentRoot.canContainRoot(root)) continue;
                return true;
            }
        }
        return false;
    }

    private List<DetectedRootData> detectRoots() {
        Map<ProjectStructureDetector, List<DetectedProjectRoot>> roots = this.runDetectors();
        if (this.myProgressIndicator != null) {
            this.myProgressIndicator.setText2("Processing " + roots.values().size() + " project roots...");
        }
        LinkedHashMap<File, DetectedRootData> rootData = new LinkedHashMap<File, DetectedRootData>();
        for (ProjectStructureDetector detector : roots.keySet()) {
            for (DetectedProjectRoot detectedRoot : roots.get(detector)) {
                if (RootDetectionProcessor.isUnderIncompatibleRoot(detectedRoot, rootData)) continue;
                DetectedRootData data = (DetectedRootData)rootData.get(detectedRoot.getDirectory());
                if (data == null) {
                    rootData.put(detectedRoot.getDirectory(), new DetectedRootData(detector, detectedRoot));
                } else {
                    detectedRoot = data.addRoot(detector, detectedRoot);
                }
                RootDetectionProcessor.removeIncompatibleRoots(detectedRoot, rootData);
            }
        }
        List<DetectedRootData> dataCollection = this.mergeContentRoots(rootData);
        if (this.myProgressIndicator != null) {
            this.myProgressIndicator.setText2("");
        }
        return dataCollection;
    }

    private List<DetectedRootData> mergeContentRoots(Map<File, DetectedRootData> rootData) {
        LOG.debug(rootData.size() + " roots found, merging content roots");
        boolean hasSourceRoots = false;
        HashSet typesToReplace = new HashSet();
        HashSet<ModuleType> moduleTypes = new HashSet<ModuleType>();
        block0: for (DetectedRootData data : rootData.values()) {
            for (DetectedProjectRoot root : data.getAllRoots()) {
                if (root instanceof DetectedContentRoot) {
                    Collections.addAll(typesToReplace, ((DetectedContentRoot)root).getTypesToReplace());
                    moduleTypes.add(((DetectedContentRoot)root).getModuleType());
                    continue;
                }
                if (!(root instanceof DetectedSourceRoot)) continue;
                LOG.debug("Source root found: " + root.getDirectory() + ", content roots will be ignored");
                hasSourceRoots = true;
                continue block0;
            }
        }
        moduleTypes.removeAll(typesToReplace);
        if (hasSourceRoots || moduleTypes.size() <= 1) {
            Iterator<DetectedRootData> iterator = rootData.values().iterator();
            DetectedContentRoot firstRoot = null;
            ProjectStructureDetector firstDetector = null;
            while (iterator.hasNext()) {
                DetectedRootData data = iterator.next();
                for (DetectedProjectRoot root : data.getAllRoots()) {
                    if (!(root instanceof DetectedContentRoot)) continue;
                    LOG.debug("Removed detected " + root.getRootTypeName() + " content root: " + root.getDirectory());
                    Collection<ProjectStructureDetector> detectors = data.removeRoot(root);
                    if (firstRoot != null && firstDetector != null || !moduleTypes.contains(((DetectedContentRoot)root).getModuleType())) continue;
                    firstRoot = (DetectedContentRoot)root;
                    firstDetector = (ProjectStructureDetector)ContainerUtil.getFirstItem(detectors);
                }
                if (!data.isEmpty()) continue;
                iterator.remove();
            }
            if (!hasSourceRoots && firstRoot != null && firstDetector != null) {
                DetectedContentRoot baseRoot = new DetectedContentRoot(this.myBaseDir, firstRoot.getRootTypeName(), firstRoot.getModuleType(), new ModuleType[0]);
                DetectedRootData data = rootData.get(this.myBaseDir);
                if (data == null) {
                    rootData.put(this.myBaseDir, new DetectedRootData(firstDetector, baseRoot));
                } else {
                    data.addRoot(firstDetector, baseRoot);
                }
                LOG.debug("Added " + firstRoot.getRootTypeName() + " content root for " + this.myBaseDir);
            }
        }
        return new ArrayList<DetectedRootData>(rootData.values());
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "baseProjectFile";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/ide/util/importProject/RootDetectionProcessor";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/ide/util/importProject/RootDetectionProcessor";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "detectRoots";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "detectRoots";
                break;
            }
            case 1: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

