/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.execution.testDiscovery.actions;

import com.intellij.codeInsight.actions.FormatChangedTextUtil;
import com.intellij.execution.ExecutionException;
import com.intellij.execution.Executor;
import com.intellij.execution.JavaTestConfigurationBase;
import com.intellij.execution.Location;
import com.intellij.execution.actions.ConfigurationContext;
import com.intellij.execution.actions.RunConfigurationProducer;
import com.intellij.execution.configurations.RunProfile;
import com.intellij.execution.executors.DefaultRunExecutor;
import com.intellij.execution.runners.ExecutionEnvironmentBuilder;
import com.intellij.execution.runners.ExecutionUtil;
import com.intellij.execution.testDiscovery.TestDiscoveryConfigurationProducer;
import com.intellij.execution.testDiscovery.TestDiscoveryProducer;
import com.intellij.execution.testDiscovery.actions.DiscoveredTestsTree;
import com.intellij.execution.testDiscovery.actions.TestMethodUsage;
import com.intellij.featureStatistics.FeatureUsageTracker;
import com.intellij.find.FindUtil;
import com.intellij.find.actions.CompositeActiveComponent;
import com.intellij.icons.AllIcons;
import com.intellij.ide.DataManager;
import com.intellij.ide.util.JavaAnonymousClassesHelper;
import com.intellij.lang.Language;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.ActionToolbar;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.actionSystem.ShortcutSet;
import com.intellij.openapi.actionSystem.impl.ActionButton;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.keymap.KeymapUtil;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.popup.JBPopup;
import com.intellij.openapi.ui.popup.PopupChooserBuilder;
import com.intellij.openapi.util.Couple;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vcs.VcsDataKeys;
import com.intellij.openapi.vcs.changes.Change;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiAnonymousClass;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiSubstitutor;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.util.ClassUtil;
import com.intellij.psi.util.PsiFormatUtil;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiUtilCore;
import com.intellij.uast.UastMetaLanguage;
import com.intellij.ui.ActiveComponent;
import com.intellij.usages.UsageView;
import com.intellij.util.ArrayFactory;
import com.intellij.util.ArrayUtil;
import com.intellij.util.ObjectUtils;
import com.intellij.util.PsiNavigateUtil;
import com.intellij.util.ui.EdtInvocationManager;
import com.intellij.util.ui.JBDimension;
import com.intellij.util.ui.tree.TreeModelAdapter;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JTree;
import javax.swing.KeyStroke;
import javax.swing.event.TreeModelEvent;
import javax.swing.event.TreeModelListener;
import javax.swing.tree.TreeModel;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.uast.UFile;
import org.jetbrains.uast.UMethod;
import org.jetbrains.uast.UastContextKt;
import org.jetbrains.uast.visitor.AbstractUastVisitor;
import org.jetbrains.uast.visitor.UastVisitor;

public class ShowDiscoveredTestsAction
extends AnAction {
    private static final String RUN_ALL_ACTION_TEXT = "Run All Affected Tests";

    public void update(AnActionEvent e) {
        e.getPresentation().setEnabledAndVisible(ShowDiscoveredTestsAction.isEnabled(e.getProject()) && (ShowDiscoveredTestsAction.findMethodAtCaret(e) != null || e.getData(VcsDataKeys.CHANGES) != null));
    }

    public void actionPerformed(AnActionEvent e) {
        Project project2 = e.getProject();
        assert (project2 != null);
        PsiMethod method = ShowDiscoveredTestsAction.findMethodAtCaret(e);
        if (method != null) {
            ShowDiscoveredTestsAction.showDiscoveredTestsByPsi(e, project2, method);
        } else {
            ShowDiscoveredTestsAction.showDiscoveredTestsByChanges(e);
        }
    }

    private static void showDiscoveredTestsByPsi(AnActionEvent e, Project project2, PsiMethod method) {
        Couple<String> key = ShowDiscoveredTestsAction.getMethodKey(method);
        if (key == null) {
            return;
        }
        DataContext dataContext = DataManager.getInstance().getDataContext((Component)((Editor)e.getRequiredData(CommonDataKeys.EDITOR)).getContentComponent());
        FeatureUsageTracker.getInstance().triggerFeatureUsed("test.discovery");
        String presentableName = PsiFormatUtil.formatMethod((PsiMethod)method, (PsiSubstitutor)PsiSubstitutor.EMPTY, (int)4097, (int)0);
        ShowDiscoveredTestsAction.showDiscoveredTests(project2, dataContext, presentableName, method);
    }

    private static void showDiscoveredTestsByChanges(AnActionEvent e) {
        Change[] changes = (Change[])e.getRequiredData(VcsDataKeys.CHANGES);
        Project project2 = e.getProject();
        assert (project2 != null);
        ShowDiscoveredTestsAction.showDiscoveredTestsByChanges(project2, changes, "Selected Changes", e.getDataContext());
    }

    public static void showDiscoveredTestsByChanges(@NotNull Project project2, @NotNull Change[] changes, @NotNull String title, @NotNull DataContext dataContext) {
        if (project2 == null) {
            ShowDiscoveredTestsAction.$$$reportNull$$$0(0);
        }
        if (changes == null) {
            ShowDiscoveredTestsAction.$$$reportNull$$$0(1);
        }
        if (title == null) {
            ShowDiscoveredTestsAction.$$$reportNull$$$0(2);
        }
        if (dataContext == null) {
            ShowDiscoveredTestsAction.$$$reportNull$$$0(3);
        }
        PsiMethod[] asJavaMethods = ShowDiscoveredTestsAction.findMethods(project2, changes);
        FeatureUsageTracker.getInstance().triggerFeatureUsed("test.discovery.selected.changes");
        ShowDiscoveredTestsAction.showDiscoveredTests(project2, dataContext, title, asJavaMethods);
    }

    @NotNull
    public static PsiMethod[] findMethods(@NotNull Project project2, Change ... changes) {
        if (project2 == null) {
            ShowDiscoveredTestsAction.$$$reportNull$$$0(4);
        }
        if (changes == null) {
            ShowDiscoveredTestsAction.$$$reportNull$$$0(5);
        }
        UastMetaLanguage jvmLanguage = (UastMetaLanguage)Language.findInstance(UastMetaLanguage.class);
        List methods = FormatChangedTextUtil.getInstance().getChangedElements(project2, changes, file -> {
            PsiFile psiFile;
            if (project2 == null) {
                ShowDiscoveredTestsAction.$$$reportNull$$$0(31);
            }
            if (!jvmLanguage.matchesLanguage((psiFile = PsiUtilCore.getPsiFile((Project)project2, (VirtualFile)file)).getLanguage())) {
                return null;
            }
            Document document = FileDocumentManager.getInstance().getDocument(file);
            if (document == null) {
                return null;
            }
            UFile uFile = (UFile)UastContextKt.toUElement((PsiElement)psiFile, UFile.class);
            if (uFile == null) {
                return null;
            }
            PsiDocumentManager.getInstance((Project)project2).commitDocument(document);
            final ArrayList physicalMethods = new ArrayList();
            uFile.accept((UastVisitor)new AbstractUastVisitor(){

                public boolean visitMethod(@NotNull UMethod node) {
                    if (node == null) {
                        1.$$$reportNull$$$0(0);
                    }
                    physicalMethods.add(node.getSourcePsi());
                    return true;
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "node", "com/intellij/execution/testDiscovery/actions/ShowDiscoveredTestsAction$1", "visitMethod"));
                }
            });
            return physicalMethods;
        });
        PsiMethod[] psiMethodArray = (PsiMethod[])methods.stream().map(m -> (PsiMethod)ObjectUtils.tryCast((Object)Objects.requireNonNull(UastContextKt.toUElement((PsiElement)m)).getJavaPsi(), PsiMethod.class)).filter(Objects::nonNull).toArray(arg_0 -> ((ArrayFactory)PsiMethod.ARRAY_FACTORY).create(arg_0));
        if (psiMethodArray == null) {
            ShowDiscoveredTestsAction.$$$reportNull$$$0(6);
        }
        return psiMethodArray;
    }

    public static boolean isEnabled(@Nullable Project project2) {
        if (project2 == null || DumbService.isDumb((Project)project2)) {
            return false;
        }
        return Registry.is((String)"testDiscovery.enabled") || ApplicationManager.getApplication().isInternal();
    }

    @Nullable
    private static PsiMethod findMethodAtCaret(@NotNull AnActionEvent e) {
        if (e == null) {
            ShowDiscoveredTestsAction.$$$reportNull$$$0(7);
        }
        Editor editor = (Editor)e.getData(CommonDataKeys.EDITOR);
        PsiFile file = (PsiFile)e.getData(CommonDataKeys.PSI_FILE);
        if (editor == null || file == null) {
            return null;
        }
        PsiElement at = file.findElementAt(editor.getCaretModel().getOffset());
        PsiElement prev = at == null ? null : PsiTreeUtil.prevVisibleLeaf((PsiElement)at);
        UMethod uMethod = (UMethod)UastContextKt.getUastParentOfType((PsiElement)prev, UMethod.class);
        return uMethod == null ? null : (PsiMethod)ObjectUtils.tryCast((Object)uMethod.getJavaPsi(), PsiMethod.class);
    }

    static void showDiscoveredTests(final @NotNull Project project2, @NotNull DataContext dataContext, final @NotNull String title, PsiMethod ... methods) {
        if (project2 == null) {
            ShowDiscoveredTestsAction.$$$reportNull$$$0(8);
        }
        if (dataContext == null) {
            ShowDiscoveredTestsAction.$$$reportNull$$$0(9);
        }
        if (title == null) {
            ShowDiscoveredTestsAction.$$$reportNull$$$0(10);
        }
        if (methods == null) {
            ShowDiscoveredTestsAction.$$$reportNull$$$0(11);
        }
        final DiscoveredTestsTree tree = new DiscoveredTestsTree(title);
        final String initTitle = "Tests for " + title;
        final Ref ref = new Ref();
        final ConfigurationContext context = ConfigurationContext.getFromContext((DataContext)dataContext);
        ActiveComponent runButton = ShowDiscoveredTestsAction.createButton(RUN_ALL_ACTION_TEXT, AllIcons.Actions.Execute, () -> {
            if (project2 == null) {
                ShowDiscoveredTestsAction.$$$reportNull$$$0(30);
            }
            ShowDiscoveredTestsAction.runAllDiscoveredTests(project2, tree, (Ref<JBPopup>)ref, context, initTitle);
        });
        Runnable pinActionListener = () -> {
            JBPopup popup;
            UsageView view;
            if (project2 == null) {
                ShowDiscoveredTestsAction.$$$reportNull$$$0(29);
            }
            if ((view = FindUtil.showInUsageView(null, (Object[])tree.getTestMethods(), param -> param, (String)initTitle, p -> {
                p.setCodeUsages(false);
                p.setUsagesWord("test");
                p.setMergeDupLinesAvailable(false);
                p.setUsageTypeFilteringAvailable(false);
                p.setExcludeAvailable(false);
            }, (Project)project2)) != null) {
                view.addButtonToLowerPane((Action)new AbstractAction(RUN_ALL_ACTION_TEXT, AllIcons.Actions.Execute){

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        ShowDiscoveredTestsAction.runAllDiscoveredTests(project2, tree, (Ref<JBPopup>)ref, context, initTitle);
                    }
                });
            }
            if ((popup = (JBPopup)ref.get()) != null) {
                popup.cancel();
            }
        };
        KeyStroke findUsageKeyStroke = ShowDiscoveredTestsAction.findUsagesKeyStroke();
        String pinTooltip = "Open Find Usages Toolwindow" + (findUsageKeyStroke == null ? "" : " " + KeymapUtil.getKeystrokeText((KeyStroke)findUsageKeyStroke));
        ActiveComponent pinButton = ShowDiscoveredTestsAction.createButton(pinTooltip, AllIcons.General.Pin_tab, pinActionListener);
        PopupChooserBuilder builder = new PopupChooserBuilder((JTree)((Object)tree)).setTitle(initTitle).setMovable(true).setResizable(true).setCommandButton((ActiveComponent)new CompositeActiveComponent(new ActiveComponent[]{pinButton})).setSettingButton((Component)new CompositeActiveComponent(new ActiveComponent[]{runButton}).getComponent()).setItemChoosenCallback(() -> PsiNavigateUtil.navigate((PsiElement)tree.getSelectedElement())).registerKeyboardAction(findUsageKeyStroke, __ -> pinActionListener.run()).setMinSize((Dimension)new JBDimension(500, 300));
        final JBPopup popup = builder.createPopup();
        ref.set((Object)popup);
        TreeModel model = tree.getModel();
        if (model instanceof Disposable) {
            Disposer.register((Disposable)popup, (Disposable)((Disposable)model));
        }
        model.addTreeModelListener((TreeModelListener)new TreeModelAdapter(){

            protected void process(TreeModelEvent event, TreeModelAdapter.EventType type) {
                int testsCount = tree.getTestCount();
                int classesCount = tree.getTestClassesCount();
                popup.setCaption("Found " + testsCount + " " + StringUtil.pluralize((String)"Test", (int)testsCount) + " in " + classesCount + " " + StringUtil.pluralize((String)"Class", (int)classesCount) + " for " + title);
            }
        });
        popup.showInBestPositionFor(dataContext);
        Runnable whenDone = () -> {
            popup.pack(true, true);
            tree.setPaintBusy(false);
        };
        ShowDiscoveredTestsAction.processMethods(project2, methods, (clazz, method, parameter) -> {
            tree.addTest(clazz, method, parameter);
            return true;
        }, whenDone);
    }

    public static void processMethods(@NotNull Project project2, @NotNull PsiMethod[] methods, @NotNull TestDiscoveryProducer.PsiTestProcessor consumer, @Nullable Runnable doWhenDone) {
        if (project2 == null) {
            ShowDiscoveredTestsAction.$$$reportNull$$$0(12);
        }
        if (methods == null) {
            ShowDiscoveredTestsAction.$$$reportNull$$$0(13);
        }
        if (consumer == null) {
            ShowDiscoveredTestsAction.$$$reportNull$$$0(14);
        }
        ApplicationManager.getApplication().executeOnPooledThread(() -> {
            if (project2 == null) {
                ShowDiscoveredTestsAction.$$$reportNull$$$0(26);
            }
            if (methods == null) {
                ShowDiscoveredTestsAction.$$$reportNull$$$0(27);
            }
            if (consumer == null) {
                ShowDiscoveredTestsAction.$$$reportNull$$$0(28);
            }
            ShowDiscoveredTestsAction.processMethodsInner(project2, methods, consumer);
            if (doWhenDone != null) {
                EdtInvocationManager.getInstance().invokeLater(doWhenDone);
            }
        });
    }

    private static void processMethodsInner(@NotNull Project project2, @NotNull PsiMethod[] methods, @NotNull TestDiscoveryProducer.PsiTestProcessor processor) {
        if (project2 == null) {
            ShowDiscoveredTestsAction.$$$reportNull$$$0(15);
        }
        if (methods == null) {
            ShowDiscoveredTestsAction.$$$reportNull$$$0(16);
        }
        if (processor == null) {
            ShowDiscoveredTestsAction.$$$reportNull$$$0(17);
        }
        if (DumbService.isDumb((Project)project2)) {
            return;
        }
        GlobalSearchScope scope = GlobalSearchScope.projectScope((Project)project2);
        for (PsiMethod method : methods) {
            Couple methodFqnName = (Couple)ReadAction.compute(() -> ShowDiscoveredTestsAction.getMethodKey(method));
            if (methodFqnName == null) continue;
            String fqn = (String)methodFqnName.first;
            String methodName = (String)methodFqnName.second;
            for (TestDiscoveryConfigurationProducer producer : ShowDiscoveredTestsAction.getRunConfigurationProducers(project2)) {
                byte frameworkId = ((JavaTestConfigurationBase)producer.getConfigurationFactory().createTemplateConfiguration(project2)).getTestFrameworkId();
                TestDiscoveryProducer.consumeDiscoveredTests(project2, fqn, methodName, frameworkId, (testClass, testMethod, parameter) -> {
                    if (project2 == null) {
                        ShowDiscoveredTestsAction.$$$reportNull$$$0(23);
                    }
                    if (processor == null) {
                        ShowDiscoveredTestsAction.$$$reportNull$$$0(24);
                    }
                    PsiClass[] testClassPsi = new PsiClass[]{null};
                    PsiMethod[] testMethodPsi = new PsiMethod[]{null};
                    ReadAction.run(() -> {
                        boolean checkBases;
                        if (project2 == null) {
                            ShowDiscoveredTestsAction.$$$reportNull$$$0(25);
                        }
                        testClassPsi[0] = ClassUtil.findPsiClass((PsiManager)PsiManager.getInstance((Project)project2), (String)testClass, null, (boolean)true, (GlobalSearchScope)scope);
                        boolean bl = checkBases = parameter != null;
                        if (testClassPsi[0] != null) {
                            testMethodPsi[0] = (PsiMethod)ArrayUtil.getFirstElement((Object[])testClassPsi[0].findMethodsByName(testMethod, checkBases));
                        }
                    });
                    return testMethodPsi[0] == null || processor.process(testClassPsi[0], testMethodPsi[0], parameter);
                });
            }
        }
    }

    private static ActiveComponent createButton(final String text, final Icon icon, final Runnable listener) {
        return new ActiveComponent.Adapter(){

            public JComponent getComponent() {
                Presentation presentation = new Presentation();
                presentation.setText(text);
                presentation.setDescription(text);
                presentation.setIcon(icon);
                return new ActionButton(new AnAction(){

                    public void actionPerformed(AnActionEvent e) {
                        listener.run();
                    }
                }, presentation, "ShowDiscoveredTestsToolbar", ActionToolbar.DEFAULT_MINIMUM_BUTTON_SIZE);
            }
        };
    }

    private static void runAllDiscoveredTests(@NotNull Project project2, DiscoveredTestsTree tree, Ref<JBPopup> ref, ConfigurationContext context, String title) {
        if (project2 == null) {
            ShowDiscoveredTestsAction.$$$reportNull$$$0(18);
        }
        Executor executor = DefaultRunExecutor.getRunExecutorInstance();
        Module targetModule = TestDiscoveryConfigurationProducer.detectTargetModule(tree.getContainingModules(), project2);
        Location[] testMethods = (Location[])Arrays.stream(tree.getTestMethods()).map(TestMethodUsage::calculateLocation).filter(Objects::nonNull).toArray(Location[]::new);
        ShowDiscoveredTestsAction.getRunConfigurationProducers(project2).stream().map(producer -> new Object((TestDiscoveryConfigurationProducer)((Object)producer), testMethods){
            TestDiscoveryConfigurationProducer myProducer;
            Location[] mySupportedTests;
            final /* synthetic */ TestDiscoveryConfigurationProducer val$producer;
            final /* synthetic */ Location[] val$testMethods;
            {
                this.val$producer = testDiscoveryConfigurationProducer;
                this.val$testMethods = locationArray;
                this.myProducer = this.val$producer;
                this.mySupportedTests = (Location[])Arrays.stream(this.val$testMethods).filter(this.val$producer::isApplicable).toArray(Location[]::new);
            }
        }).max(Comparator.comparingInt(p -> p.mySupportedTests.length)).map(p -> p.myProducer.createProfile(p.mySupportedTests, targetModule, context, title)).ifPresent(profile2 -> {
            if (project2 == null) {
                ShowDiscoveredTestsAction.$$$reportNull$$$0(22);
            }
            try {
                ExecutionEnvironmentBuilder.create((Project)project2, (Executor)executor, (RunProfile)profile2).buildAndExecute();
            }
            catch (ExecutionException e) {
                ExecutionUtil.handleExecutionError((Project)project2, (String)executor.getToolWindowId(), (String)title, (Throwable)e);
            }
            JBPopup popup = (JBPopup)ref.get();
            if (popup != null) {
                popup.cancel();
            }
        });
    }

    @Nullable
    private static Couple<String> getMethodKey(@NotNull PsiMethod method) {
        PsiClass c;
        if (method == null) {
            ShowDiscoveredTestsAction.$$$reportNull$$$0(19);
        }
        String fqn = (c = method.getContainingClass()) != null ? ShowDiscoveredTestsAction.getName(c) : null;
        return fqn == null ? null : Couple.of((Object)fqn, (Object)ShowDiscoveredTestsAction.methodSignature(method));
    }

    @NotNull
    private static String methodSignature(@NotNull PsiMethod method) {
        if (method == null) {
            ShowDiscoveredTestsAction.$$$reportNull$$$0(20);
        }
        String string = method.getName() + "/" + ClassUtil.getAsmMethodSignature((PsiMethod)method);
        if (string == null) {
            ShowDiscoveredTestsAction.$$$reportNull$$$0(21);
        }
        return string;
    }

    private static String getName(PsiClass c) {
        PsiClass containingClass;
        if (c instanceof PsiAnonymousClass && (containingClass = (PsiClass)PsiTreeUtil.getParentOfType((PsiElement)c, PsiClass.class)) != null) {
            return ClassUtil.getJVMClassName((PsiClass)containingClass) + JavaAnonymousClassesHelper.getName((PsiAnonymousClass)((PsiAnonymousClass)c));
        }
        return ClassUtil.getJVMClassName((PsiClass)c);
    }

    @Nullable
    protected static KeyStroke findUsagesKeyStroke() {
        AnAction action = ActionManager.getInstance().getAction("FindUsages");
        ShortcutSet shortcutSet = action == null ? null : action.getShortcutSet();
        return shortcutSet == null ? null : KeymapUtil.getKeyStroke((ShortcutSet)shortcutSet);
    }

    private static List<TestDiscoveryConfigurationProducer> getRunConfigurationProducers(Project project2) {
        return RunConfigurationProducer.getProducers((Project)project2).stream().filter(producer -> producer instanceof TestDiscoveryConfigurationProducer).map(producer -> (TestDiscoveryConfigurationProducer)((Object)producer)).collect(Collectors.toList());
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 6: 
            case 21: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 6: 
            case 21: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "changes";
                break;
            }
            case 2: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "title";
                break;
            }
            case 3: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dataContext";
                break;
            }
            case 6: 
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/execution/testDiscovery/actions/ShowDiscoveredTestsAction";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "e";
                break;
            }
            case 11: 
            case 13: 
            case 16: 
            case 27: {
                objectArray2 = objectArray3;
                objectArray3[0] = "methods";
                break;
            }
            case 14: 
            case 28: {
                objectArray2 = objectArray3;
                objectArray3[0] = "consumer";
                break;
            }
            case 17: 
            case 24: {
                objectArray2 = objectArray3;
                objectArray3[0] = "processor";
                break;
            }
            case 19: 
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "method";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/execution/testDiscovery/actions/ShowDiscoveredTestsAction";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "findMethods";
                break;
            }
            case 21: {
                objectArray = objectArray2;
                objectArray2[1] = "methodSignature";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "showDiscoveredTestsByChanges";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "findMethods";
                break;
            }
            case 6: 
            case 21: {
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "findMethodAtCaret";
                break;
            }
            case 8: 
            case 9: 
            case 10: 
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "showDiscoveredTests";
                break;
            }
            case 12: 
            case 13: 
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "processMethods";
                break;
            }
            case 15: 
            case 16: 
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "processMethodsInner";
                break;
            }
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "runAllDiscoveredTests";
                break;
            }
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "getMethodKey";
                break;
            }
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "methodSignature";
                break;
            }
            case 22: {
                objectArray = objectArray;
                objectArray[2] = "lambda$runAllDiscoveredTests$18";
                break;
            }
            case 23: 
            case 24: {
                objectArray = objectArray;
                objectArray[2] = "lambda$processMethodsInner$13";
                break;
            }
            case 25: {
                objectArray = objectArray;
                objectArray[2] = "lambda$null$12";
                break;
            }
            case 26: 
            case 27: 
            case 28: {
                objectArray = objectArray;
                objectArray[2] = "lambda$processMethods$10";
                break;
            }
            case 29: {
                objectArray = objectArray;
                objectArray[2] = "lambda$showDiscoveredTests$5";
                break;
            }
            case 30: {
                objectArray = objectArray;
                objectArray[2] = "lambda$showDiscoveredTests$2";
                break;
            }
            case 31: {
                objectArray = objectArray;
                objectArray[2] = "lambda$findMethods$0";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 6: 
            case 21: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

