/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.execution.testDiscovery.actions;

import com.intellij.execution.testDiscovery.actions.TestMethodUsage;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.util.Comparing;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiMember;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.SmartPointerManager;
import com.intellij.psi.SmartPsiElementPointer;
import com.intellij.psi.util.PsiUtil;
import com.intellij.ui.tree.BaseTreeModel;
import com.intellij.util.ObjectUtils;
import com.intellij.util.SmartList;
import com.intellij.util.containers.ContainerUtil;
import gnu.trove.THashSet;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class DiscoveredTestsTreeModel
extends BaseTreeModel<Object> {
    private final Object myRoot = ObjectUtils.NULL;
    private final List<Node.Clazz> myTestClasses = new SmartList();
    private final Map<Node.Clazz, List<Node.Method>> myTests = new HashMap<Node.Clazz, List<Node.Method>>();

    DiscoveredTestsTreeModel() {
    }

    public synchronized List<?> getChildren(Object parent) {
        if (parent == this.myRoot) {
            return this.getTestClasses();
        }
        if (parent instanceof Node.Clazz) {
            return ContainerUtil.newArrayList((Iterable)this.myTests.get((Node.Clazz)parent));
        }
        return Collections.emptyList();
    }

    synchronized List<Node<PsiClass>> getTestClasses() {
        return ContainerUtil.newArrayList(this.myTestClasses);
    }

    public Object getRoot() {
        return this.myRoot;
    }

    public boolean isLeaf(Object object) {
        return this.myRoot != object && super.isLeaf(object);
    }

    synchronized void addTest(@NotNull PsiClass testClass, @NotNull PsiMethod testMethod, @Nullable String parameter) {
        Node.Method actualMethodNode;
        if (testClass == null) {
            DiscoveredTestsTreeModel.$$$reportNull$$$0(0);
        }
        if (testMethod == null) {
            DiscoveredTestsTreeModel.$$$reportNull$$$0(1);
        }
        Node.Clazz classNode = (Node.Clazz)ReadAction.compute(() -> {
            if (testClass == null) {
                DiscoveredTestsTreeModel.$$$reportNull$$$0(4);
            }
            return new Node.Clazz(testClass);
        });
        Node.Method methodNode = (Node.Method)ReadAction.compute(() -> {
            if (testMethod == null) {
                DiscoveredTestsTreeModel.$$$reportNull$$$0(3);
            }
            return new Node.Method(testMethod);
        });
        int idx = (Integer)ReadAction.compute(() -> Collections.binarySearch(this.myTestClasses, classNode, Comparator.comparing(c -> c.getName()).thenComparing(c -> c.getPackageName())));
        if (idx < 0) {
            int insertIdx = -idx - 1;
            this.myTestClasses.add(insertIdx, classNode);
            SmartList methods = new SmartList();
            methods.add(methodNode);
            this.myTests.put(classNode, (List<Node.Method>)methods);
            return;
        }
        List<Node.Method> testMethods = this.myTests.get(this.myTestClasses.get(idx));
        int methodIdx = (Integer)ReadAction.compute(() -> Collections.binarySearch(testMethods, methodNode, (o1, o2) -> Comparing.compare((Comparable)((Object)o1.getName()), (Comparable)((Object)o2.getName()))));
        if (methodIdx < 0) {
            methodIdx = -methodIdx - 1;
            testMethods.add(methodIdx, methodNode);
            actualMethodNode = methodNode;
        } else {
            actualMethodNode = testMethods.get(methodIdx);
        }
        if (parameter != null) {
            actualMethodNode.addParameter(parameter);
        }
        this.treeStructureChanged(null, null, null);
    }

    @NotNull
    synchronized TestMethodUsage[] getTestMethods() {
        TestMethodUsage[] testMethodUsageArray = (TestMethodUsage[])this.myTests.entrySet().stream().flatMap(e -> ((List)e.getValue()).stream().map(m -> new TestMethodUsage(m.getPointer(), ((Node.Clazz)e.getKey()).getPointer(), m.getParameters()))).toArray(TestMethodUsage[]::new);
        if (testMethodUsageArray == null) {
            DiscoveredTestsTreeModel.$$$reportNull$$$0(2);
        }
        return testMethodUsageArray;
    }

    synchronized int getTestCount() {
        return this.myTests.values().stream().mapToInt(ms -> ms.size()).sum();
    }

    synchronized int getTestClassesCount() {
        return this.myTests.size();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "testClass";
                break;
            }
            case 1: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "testMethod";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/execution/testDiscovery/actions/DiscoveredTestsTreeModel";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/execution/testDiscovery/actions/DiscoveredTestsTreeModel";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getTestMethods";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "addTest";
                break;
            }
            case 2: {
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "lambda$addTest$1";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "lambda$addTest$0";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    public static abstract class Node<Psi extends PsiMember> {
        @NotNull
        private final SmartPsiElementPointer<Psi> myPointer;
        private final String myName;
        private final Icon myIcon;

        private Node(@NotNull Psi psi) {
            if (psi == null) {
                Node.$$$reportNull$$$0(0);
            }
            this.myPointer = SmartPointerManager.createPointer(psi);
            this.myName = psi.getName();
            this.myIcon = psi.getIcon(2);
        }

        @NotNull
        public SmartPsiElementPointer<Psi> getPointer() {
            SmartPsiElementPointer<Psi> smartPsiElementPointer = this.myPointer;
            if (smartPsiElementPointer == null) {
                Node.$$$reportNull$$$0(1);
            }
            return smartPsiElementPointer;
        }

        String getName() {
            return this.myName;
        }

        Icon getIcon() {
            return this.myIcon;
        }

        /* synthetic */ Node(PsiMember x0, 1 x1) {
            this(x0);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 1: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 1: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "psi";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/execution/testDiscovery/actions/DiscoveredTestsTreeModel$Node";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/execution/testDiscovery/actions/DiscoveredTestsTreeModel$Node";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getPointer";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 1: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 1: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }

        static class Method
        extends Node<PsiMethod> {
            private final Collection<String> myParameters;

            private Method(@NotNull PsiMethod method) {
                if (method == null) {
                    Method.$$$reportNull$$$0(0);
                }
                super((PsiMember)method, null);
                this.myParameters = new THashSet();
            }

            public void addParameter(@NotNull String parameter) {
                if (parameter == null) {
                    Method.$$$reportNull$$$0(1);
                }
                this.myParameters.add(parameter);
            }

            @NotNull
            Collection<String> getParameters() {
                Collection<String> collection = this.myParameters;
                if (collection == null) {
                    Method.$$$reportNull$$$0(2);
                }
                return collection;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                RuntimeException runtimeException;
                Object[] objectArray;
                Object[] objectArray2;
                int n2;
                String string;
                switch (n) {
                    default: {
                        string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                        break;
                    }
                    case 2: {
                        string = "@NotNull method %s.%s must not return null";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        n2 = 3;
                        break;
                    }
                    case 2: {
                        n2 = 2;
                        break;
                    }
                }
                Object[] objectArray3 = new Object[n2];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "method";
                        break;
                    }
                    case 1: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "parameter";
                        break;
                    }
                    case 2: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "com/intellij/execution/testDiscovery/actions/DiscoveredTestsTreeModel$Node$Method";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[1] = "com/intellij/execution/testDiscovery/actions/DiscoveredTestsTreeModel$Node$Method";
                        break;
                    }
                    case 2: {
                        objectArray = objectArray2;
                        objectArray2[1] = "getParameters";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray;
                        objectArray[2] = "<init>";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray;
                        objectArray[2] = "addParameter";
                        break;
                    }
                    case 2: {
                        break;
                    }
                }
                String string2 = String.format(string, objectArray);
                switch (n) {
                    default: {
                        runtimeException = new IllegalArgumentException(string2);
                        break;
                    }
                    case 2: {
                        runtimeException = new IllegalStateException(string2);
                        break;
                    }
                }
                throw runtimeException;
            }
        }

        static class Clazz
        extends Node<PsiClass> {
            private final String myPackageName;

            Clazz(@NotNull PsiClass aClass) {
                if (aClass == null) {
                    Clazz.$$$reportNull$$$0(0);
                }
                super((PsiMember)aClass, null);
                this.myPackageName = PsiUtil.getPackageName((PsiClass)aClass);
            }

            String getPackageName() {
                return this.myPackageName;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "aClass", "com/intellij/execution/testDiscovery/actions/DiscoveredTestsTreeModel$Node$Clazz", "<init>"));
            }
        }
    }
}

