/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.execution.testDiscovery;

import com.intellij.execution.testDiscovery.LocalTestDiscoveryProducer;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.extensions.ExtensionPointName;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Couple;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiMethod;
import com.intellij.util.containers.MultiMap;
import gnu.trove.THashSet;
import java.util.Collection;
import java.util.Map;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@ApiStatus.Experimental
public interface TestDiscoveryProducer {
    public static final Logger LOG = Logger.getInstance(LocalTestDiscoveryProducer.class);
    public static final ExtensionPointName<TestDiscoveryProducer> EP = ExtensionPointName.create((String)"com.intellij.testDiscoveryProducer");

    @NotNull
    public MultiMap<String, String> getDiscoveredTests(@NotNull Project var1, @NotNull String var2, @NotNull String var3, byte var4);

    public boolean isRemote();

    public static void consumeDiscoveredTests(@NotNull Project project2, @NotNull String classFQName, @NotNull String methodName, byte frameworkId, @NotNull TestProcessor processor) {
        if (project2 == null) {
            TestDiscoveryProducer.$$$reportNull$$$0(0);
        }
        if (classFQName == null) {
            TestDiscoveryProducer.$$$reportNull$$$0(1);
        }
        if (methodName == null) {
            TestDiscoveryProducer.$$$reportNull$$$0(2);
        }
        if (processor == null) {
            TestDiscoveryProducer.$$$reportNull$$$0(3);
        }
        MultiMap<String, String> visitedTests = new MultiMap<String, String>(){

            @NotNull
            protected Collection<String> createCollection() {
                THashSet tHashSet = new THashSet();
                if (tHashSet == null) {
                    1.$$$reportNull$$$0(0);
                }
                return tHashSet;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/execution/testDiscovery/TestDiscoveryProducer$1", "createCollection"));
            }
        };
        for (TestDiscoveryProducer producer : (TestDiscoveryProducer[])EP.getExtensions()) {
            for (Map.Entry entry : producer.getDiscoveredTests(project2, classFQName, methodName, frameworkId).entrySet()) {
                String className = (String)entry.getKey();
                for (String methodRawName : (Collection)entry.getValue()) {
                    if (visitedTests.get((Object)classFQName).contains(methodRawName)) continue;
                    visitedTests.putValue((Object)className, (Object)methodRawName);
                    Couple<String> couple = TestDiscoveryProducer.extractParameter(methodRawName);
                    if (processor.process(className, (String)couple.first, (String)couple.second)) continue;
                    return;
                }
            }
        }
    }

    @NotNull
    public static Couple<String> extractParameter(@NotNull String rawName) {
        int idx;
        if (rawName == null) {
            TestDiscoveryProducer.$$$reportNull$$$0(4);
        }
        Couple couple = (idx = rawName.indexOf(91)) == -1 ? Couple.of((Object)rawName, null) : Couple.of((Object)rawName.substring(0, idx), (Object)rawName.substring(idx));
        if (couple == null) {
            TestDiscoveryProducer.$$$reportNull$$$0(5);
        }
        return couple;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 5: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 5: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "classFQName";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "methodName";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "processor";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "rawName";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/execution/testDiscovery/TestDiscoveryProducer";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/execution/testDiscovery/TestDiscoveryProducer";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "extractParameter";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "consumeDiscoveredTests";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "extractParameter";
                break;
            }
            case 5: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 5: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    @FunctionalInterface
    public static interface PsiTestProcessor {
        public boolean process(@NotNull PsiClass var1, @NotNull PsiMethod var2, @Nullable String var3);
    }

    @FunctionalInterface
    public static interface TestProcessor {
        public boolean process(@NotNull String var1, @NotNull String var2, @Nullable String var3);
    }
}

