/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.execution.testDiscovery;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.gson.annotations.SerializedName;
import com.intellij.execution.testDiscovery.TestDiscoveryProducer;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.project.Project;
import com.intellij.util.containers.MultiMap;
import com.intellij.util.io.HttpRequests;
import com.intellij.util.io.RequestBuilder;
import java.io.IOException;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class IntellijTestDiscoveryProducer
implements TestDiscoveryProducer {
    private static final String INTELLIJ_TEST_DISCOVERY_HOST = "http://intellij-test-discovery";

    @Override
    @NotNull
    public MultiMap<String, String> getDiscoveredTests(@NotNull Project project2, @NotNull String classFQName, @NotNull String methodName, byte frameworkId) {
        MultiMap multiMap;
        if (project2 == null) {
            IntellijTestDiscoveryProducer.$$$reportNull$$$0(0);
        }
        if (classFQName == null) {
            IntellijTestDiscoveryProducer.$$$reportNull$$$0(1);
        }
        if (methodName == null) {
            IntellijTestDiscoveryProducer.$$$reportNull$$$0(2);
        }
        if (!ApplicationManager.getApplication().isInternal()) {
            MultiMap multiMap2 = MultiMap.emptyInstance();
            if (multiMap2 == null) {
                IntellijTestDiscoveryProducer.$$$reportNull$$$0(3);
            }
            return multiMap2;
        }
        String methodFqn = classFQName + "." + methodName;
        String url = "http://intellij-test-discovery/search/tests/by-method?fqn=" + methodFqn;
        LOG.debug(url);
        RequestBuilder r = HttpRequests.request((String)url).productNameAsUserAgent().gzip(true);
        try {
            multiMap = (MultiMap)r.connect(request -> {
                MultiMap map = new MultiMap();
                TestsSearchResult result = (TestsSearchResult)new ObjectMapper().readValue(request.getInputStream(), TestsSearchResult.class);
                result.getTests().forEach((classFqn, testMethodName) -> map.putValues(classFqn, (Collection)testMethodName));
                return map;
            });
        }
        catch (HttpRequests.HttpStatusException http) {
            LOG.debug("No tests found for " + methodFqn);
        }
        catch (IOException e) {
            LOG.debug((Throwable)e);
        }
        if (multiMap == null) {
            IntellijTestDiscoveryProducer.$$$reportNull$$$0(4);
        }
        return multiMap;
        MultiMap multiMap3 = MultiMap.empty();
        if (multiMap3 == null) {
            IntellijTestDiscoveryProducer.$$$reportNull$$$0(5);
        }
        return multiMap3;
    }

    @Override
    public boolean isRemote() {
        return true;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 3: 
            case 4: 
            case 5: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 3: 
            case 4: 
            case 5: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "classFQName";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "methodName";
                break;
            }
            case 3: 
            case 4: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/execution/testDiscovery/IntellijTestDiscoveryProducer";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/execution/testDiscovery/IntellijTestDiscoveryProducer";
                break;
            }
            case 3: 
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getDiscoveredTests";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getDiscoveredTests";
                break;
            }
            case 3: 
            case 4: 
            case 5: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 3: 
            case 4: 
            case 5: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    @JsonInclude(value=JsonInclude.Include.NON_EMPTY)
    @JsonIgnoreProperties(ignoreUnknown=true)
    public static class TestsSearchResult {
        @Nullable
        private String method;
        @SerializedName(value="class")
        @JsonProperty(value="class")
        @Nullable
        private String className;
        private int found;
        @NotNull
        private Map<String, List<String>> tests = new HashMap<String, List<String>>();
        @Nullable
        private String message;

        @Nullable
        public String getMethod() {
            return this.method;
        }

        public TestsSearchResult setMethod(String method) {
            this.method = method;
            return this;
        }

        @Nullable
        public String getClassName() {
            return this.className;
        }

        public TestsSearchResult setClassName(String name2) {
            this.className = name2;
            return this;
        }

        public int getFound() {
            return this.found;
        }

        public TestsSearchResult setFound(int found) {
            this.found = found;
            return this;
        }

        @NotNull
        public Map<String, List<String>> getTests() {
            Map<String, List<String>> map = this.tests;
            if (map == null) {
                TestsSearchResult.$$$reportNull$$$0(0);
            }
            return map;
        }

        public TestsSearchResult setTests(@NotNull Map<String, List<String>> tests) {
            if (tests == null) {
                TestsSearchResult.$$$reportNull$$$0(1);
            }
            this.tests = tests;
            return this;
        }

        @Nullable
        public String getMessage() {
            return this.message;
        }

        public TestsSearchResult setMessage(String message) {
            this.message = message;
            return this;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
                case 1: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 2;
                    break;
                }
                case 1: {
                    n2 = 3;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/execution/testDiscovery/IntellijTestDiscoveryProducer$TestsSearchResult";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "tests";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getTests";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/execution/testDiscovery/IntellijTestDiscoveryProducer$TestsSearchResult";
                    break;
                }
            }
            switch (n) {
                default: {
                    break;
                }
                case 1: {
                    objectArray = objectArray;
                    objectArray[2] = "setTests";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
                case 1: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }
}

