/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.execution.testDiscovery;

import com.intellij.execution.testDiscovery.actions.ShowDiscoveredTestsAction;
import com.intellij.ide.DataManager;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.components.ProjectComponent;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.vcs.changes.Change;
import com.intellij.openapi.vcs.changes.ChangeList;
import com.intellij.openapi.vcs.changes.ChangeListAdapter;
import com.intellij.openapi.vcs.changes.ChangeListDecorator;
import com.intellij.openapi.vcs.changes.ChangeListListener;
import com.intellij.openapi.vcs.changes.ChangeListManager;
import com.intellij.openapi.vcs.changes.ChangesViewManager;
import com.intellij.openapi.vcs.changes.LocalChangeList;
import com.intellij.psi.PsiMethod;
import com.intellij.ui.ColoredTreeCellRenderer;
import com.intellij.ui.SimpleTextAttributes;
import com.intellij.util.Alarm;
import com.intellij.util.ArrayUtil;
import com.intellij.util.io.PowerStatus;
import com.intellij.util.ui.UIUtil;
import java.awt.Component;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.NotNull;

public class AffectedTestsInChangeListPainter
implements ChangeListDecorator,
ProjectComponent {
    private final Project myProject;
    private final ChangeListManager myChangeListManager;
    private final ChangeListAdapter myChangeListListener;
    private final Alarm myAlarm;
    private final Set<String> myCache;

    public AffectedTestsInChangeListPainter(@NotNull Project project2, ChangeListManager changeListManager) {
        if (project2 == null) {
            AffectedTestsInChangeListPainter.$$$reportNull$$$0(0);
        }
        this.myCache = new HashSet<String>();
        this.myProject = project2;
        this.myChangeListManager = changeListManager;
        this.myChangeListListener = new ChangeListAdapter(){

            public void changeListsChanged() {
                AffectedTestsInChangeListPainter.this.scheduleUpdate();
            }

            public void changeListUpdateDone() {
                AffectedTestsInChangeListPainter.this.scheduleUpdate();
            }

            public void defaultListChanged(ChangeList oldDefaultList, ChangeList newDefaultList, boolean automatic) {
                AffectedTestsInChangeListPainter.this.scheduleUpdate();
            }

            public void unchangedFileStatusChanged() {
                AffectedTestsInChangeListPainter.this.scheduleUpdate();
            }
        };
        this.myAlarm = new Alarm(Alarm.ThreadToUse.SWING_THREAD, (Disposable)project2);
        this.myChangeListManager.addChangeListListener((ChangeListListener)this.myChangeListListener);
    }

    public void projectOpened() {
        DumbService.getInstance((Project)this.myProject).runWhenSmart(() -> this.scheduleUpdate());
    }

    public void projectClosed() {
        this.myAlarm.cancelAllRequests();
    }

    public void disposeComponent() {
        this.myAlarm.cancelAllRequests();
        this.myCache.clear();
        this.myChangeListManager.removeChangeListListener((ChangeListListener)this.myChangeListListener);
    }

    private static int updateDelay() {
        return PowerStatus.getPowerStatus() == PowerStatus.AC ? 50 : 300;
    }

    public void decorateChangeList(LocalChangeList changeList, ColoredTreeCellRenderer renderer, boolean selected, boolean expanded, boolean hasFocus) {
        if (!Registry.is((String)"show.affected.tests.in.changelists")) {
            return;
        }
        if (!ShowDiscoveredTestsAction.isEnabled(this.myProject)) {
            return;
        }
        if (changeList.getChanges().isEmpty()) {
            return;
        }
        if (!this.myCache.contains(changeList.getId())) {
            return;
        }
        renderer.append(", ", SimpleTextAttributes.GRAYED_ATTRIBUTES);
        renderer.append("show affected tests", new SimpleTextAttributes(16, UIUtil.getInactiveTextColor()), () -> {
            DataContext dataContext = DataManager.getInstance().getDataContext((Component)renderer.getTree());
            Change[] changes = (Change[])ArrayUtil.toObjectArray((Collection)changeList.getChanges(), Change.class);
            ShowDiscoveredTestsAction.showDiscoveredTestsByChanges(this.myProject, changes, changeList.getName(), dataContext);
        });
    }

    private void scheduleUpdate() {
        if (!Registry.is((String)"show.affected.tests.in.changelists")) {
            return;
        }
        if (!ShowDiscoveredTestsAction.isEnabled(this.myProject)) {
            return;
        }
        this.myAlarm.cancelAllRequests();
        this.myAlarm.addRequest(() -> this.update(), AffectedTestsInChangeListPainter.updateDelay());
    }

    private void update() {
        this.myCache.clear();
        List lists = this.myChangeListManager.getChangeLists();
        for (LocalChangeList list : lists) {
            PsiMethod[] methods;
            if (list.getChanges().isEmpty() || (methods = ShowDiscoveredTestsAction.findMethods(this.myProject, (Change[])ArrayUtil.toObjectArray((Collection)list.getChanges(), Change.class))).length == 0) continue;
            ReadAction.run(() -> ShowDiscoveredTestsAction.processMethods(this.myProject, methods, (clazz, method, parameter) -> {
                this.myCache.add(list.getId());
                return false;
            }, () -> ChangesViewManager.getInstance((Project)this.myProject).scheduleRefresh()));
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/execution/testDiscovery/AffectedTestsInChangeListPainter", "<init>"));
    }
}

