/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.execution.scratch;

import com.intellij.application.options.ModulesComboBox;
import com.intellij.execution.scratch.JavaScratchConfiguration;
import com.intellij.execution.ui.CommonJavaParametersPanel;
import com.intellij.execution.ui.ConfigurationModuleSelector;
import com.intellij.execution.ui.DefaultJreSelector;
import com.intellij.execution.ui.JrePathEditor;
import com.intellij.ide.scratch.RootType;
import com.intellij.ide.scratch.ScratchFileService;
import com.intellij.ide.scratch.ScratchRootType;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.fileChooser.FileChooser;
import com.intellij.openapi.fileChooser.FileChooserDescriptor;
import com.intellij.openapi.fileChooser.FileChooserDescriptorFactory;
import com.intellij.openapi.options.ConfigurationException;
import com.intellij.openapi.options.SettingsEditor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.LabeledComponent;
import com.intellij.openapi.ui.TextFieldWithBrowseButton;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.ui.PanelWithAnchor;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.UIUtil;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JTextField;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JavaScratchConfigurable
extends SettingsEditor<JavaScratchConfiguration>
implements PanelWithAnchor {
    private final CommonJavaParametersPanel myCommonProgramParameters;
    private final LabeledComponent<JTextField> myMainClass = new LabeledComponent();
    private final LabeledComponent<TextFieldWithBrowseButton> myScratchPathField;
    private final LabeledComponent<ModulesComboBox> myModule;
    private final JPanel myWholePanel;
    private final ConfigurationModuleSelector myModuleSelector;
    private final JrePathEditor myJrePathEditor;
    private JComponent myAnchor;

    public JavaScratchConfigurable(final Project project2) {
        this.myMainClass.setLabelLocation("West");
        this.myMainClass.setText("Main &class:");
        this.myMainClass.setComponent((JComponent)new JTextField());
        this.myScratchPathField = new LabeledComponent();
        this.myScratchPathField.setLabelLocation("West");
        this.myScratchPathField.setText("&Path to scratch file:");
        this.myScratchPathField.setComponent((JComponent)new TextFieldWithBrowseButton(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                VirtualFile file;
                VirtualFile toSelect = JavaScratchConfigurable.this.getVFileFromEditor();
                if (toSelect == null) {
                    String scratchesRoot = ScratchFileService.getInstance().getRootPath((RootType)ScratchRootType.getInstance());
                    toSelect = LocalFileSystem.getInstance().findFileByPath(scratchesRoot);
                }
                if ((file = FileChooser.chooseFile((FileChooserDescriptor)FileChooserDescriptorFactory.createSingleFileNoJarsDescriptor(), (Component)JavaScratchConfigurable.this.myScratchPathField.getComponent(), (Project)project2, (VirtualFile)toSelect)) != null) {
                    JavaScratchConfigurable.this.setVFileToEditor(file);
                }
            }
        }, (Disposable)this));
        this.myModule = new LabeledComponent();
        this.myModule.setLabelLocation("West");
        this.myModule.setComponent((JComponent)new ModulesComboBox());
        this.myModule.setText("Use classpath of &module:");
        this.myModuleSelector = new ConfigurationModuleSelector(project2, (ModulesComboBox)this.myModule.getComponent());
        this.myCommonProgramParameters = new CommonJavaParametersPanel();
        this.myCommonProgramParameters.setModuleContext(this.myModuleSelector.getModule());
        ((ModulesComboBox)this.myModule.getComponent()).addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                JavaScratchConfigurable.this.myCommonProgramParameters.setModuleContext(JavaScratchConfigurable.this.myModuleSelector.getModule());
            }
        });
        this.myJrePathEditor = new JrePathEditor(DefaultJreSelector.projectSdk(project2));
        this.myWholePanel = new JPanel(new GridBagLayout());
        this.myWholePanel.add((Component)this.myMainClass, new GridBagConstraints(0, 0, 1, 1, 1.0, 0.0, 18, 2, (Insets)JBUI.insetsTop((int)6), 0, 0));
        this.myWholePanel.add((Component)this.myScratchPathField, new GridBagConstraints(-1, 1, 1, 1, 1.0, 0.0, 18, 2, (Insets)JBUI.insetsTop((int)6), 0, 0));
        this.myWholePanel.add((Component)((Object)this.myCommonProgramParameters), new GridBagConstraints(-1, 2, 1, 1, 1.0, 1.0, 18, 1, (Insets)JBUI.insets((int)12, (int)0), 0, 0));
        this.myWholePanel.add((Component)this.myModule, new GridBagConstraints(-1, 3, 1, 1, 1.0, 0.0, 18, 2, (Insets)JBUI.emptyInsets(), 0, 0));
        this.myWholePanel.add((Component)((Object)this.myJrePathEditor), new GridBagConstraints(-1, 4, 1, 1, 1.0, 0.0, 18, 2, (Insets)JBUI.insetsTop((int)6), 0, 0));
        this.myAnchor = UIUtil.mergeComponentsWithAnchor((PanelWithAnchor[])new PanelWithAnchor[]{this.myMainClass, this.myScratchPathField, this.myCommonProgramParameters, this.myJrePathEditor, this.myModule});
    }

    public void applyEditorTo(@NotNull JavaScratchConfiguration configuration) throws ConfigurationException {
        if (configuration == null) {
            JavaScratchConfigurable.$$$reportNull$$$0(0);
        }
        this.myCommonProgramParameters.applyTo(configuration);
        this.myModuleSelector.applyTo(configuration);
        configuration.setMainClassName(((JTextField)this.myMainClass.getComponent()).getText().trim());
        configuration.setAlternativeJrePath(this.myJrePathEditor.getJrePathOrName());
        configuration.setAlternativeJrePathEnabled(this.myJrePathEditor.isAlternativeJreSelected());
        VirtualFile vFile = this.getVFileFromEditor();
        configuration.setScratchFileUrl(vFile != null ? vFile.getUrl() : null);
    }

    @Nullable
    private VirtualFile getVFileFromEditor() {
        String path = FileUtil.toSystemIndependentName((String)((TextFieldWithBrowseButton)this.myScratchPathField.getComponent()).getText().trim());
        return !StringUtil.isEmpty((String)path) ? LocalFileSystem.getInstance().findFileByPath(path) : null;
    }

    public void resetEditorFrom(@NotNull JavaScratchConfiguration configuration) {
        if (configuration == null) {
            JavaScratchConfigurable.$$$reportNull$$$0(1);
        }
        this.myCommonProgramParameters.reset(configuration);
        this.myModuleSelector.reset(configuration);
        ((JTextField)this.myMainClass.getComponent()).setText(configuration.getMainClassName() != null ? configuration.getMainClassName().replaceAll("\\$", "\\.") : "");
        this.myJrePathEditor.setPathOrName(configuration.getAlternativeJrePath(), configuration.isAlternativeJrePathEnabled());
        this.setVFileToEditor(configuration.getScratchVirtualFile());
    }

    private void setVFileToEditor(VirtualFile file) {
        ((TextFieldWithBrowseButton)this.myScratchPathField.getComponent()).setText(file != null ? FileUtil.toSystemDependentName((String)file.getPath()) : "");
    }

    @NotNull
    public JComponent createEditor() {
        JPanel jPanel = this.myWholePanel;
        if (jPanel == null) {
            JavaScratchConfigurable.$$$reportNull$$$0(2);
        }
        return jPanel;
    }

    public JComponent getAnchor() {
        return this.myAnchor;
    }

    public void setAnchor(@Nullable JComponent anchor) {
        this.myAnchor = anchor;
        this.myMainClass.setAnchor(anchor);
        this.myScratchPathField.setAnchor(anchor);
        this.myCommonProgramParameters.setAnchor(anchor);
        this.myJrePathEditor.setAnchor(anchor);
        this.myModule.setAnchor(anchor);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "configuration";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/execution/scratch/JavaScratchConfigurable";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/execution/scratch/JavaScratchConfigurable";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "createEditor";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "applyEditorTo";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "resetEditorFrom";
                break;
            }
            case 2: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

