/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.execution.jar;

import com.intellij.diagnostic.logging.LogConfigurationPanel;
import com.intellij.execution.CommonJavaRunConfigurationParameters;
import com.intellij.execution.CommonProgramRunConfigurationParameters;
import com.intellij.execution.ExecutionBundle;
import com.intellij.execution.ExecutionException;
import com.intellij.execution.Executor;
import com.intellij.execution.JavaRunConfigurationExtensionManager;
import com.intellij.execution.configuration.EnvironmentVariablesComponent;
import com.intellij.execution.configurations.ConfigurationFactory;
import com.intellij.execution.configurations.JavaRunConfigurationModule;
import com.intellij.execution.configurations.LocatableConfigurationBase;
import com.intellij.execution.configurations.RunConfiguration;
import com.intellij.execution.configurations.RunConfigurationBase;
import com.intellij.execution.configurations.RunProfileState;
import com.intellij.execution.configurations.RuntimeConfigurationException;
import com.intellij.execution.configurations.RuntimeConfigurationWarning;
import com.intellij.execution.configurations.SearchScopeProvider;
import com.intellij.execution.configurations.SearchScopeProvidingRunProfile;
import com.intellij.execution.jar.JarApplicationCommandLineState;
import com.intellij.execution.jar.JarApplicationConfigurable;
import com.intellij.execution.runners.ExecutionEnvironment;
import com.intellij.execution.util.JavaParametersUtil;
import com.intellij.execution.util.ProgramParametersUtil;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.options.SettingsEditor;
import com.intellij.openapi.options.SettingsEditorGroup;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.InvalidDataException;
import com.intellij.openapi.util.WriteExternalException;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.util.xmlb.SerializationFilter;
import com.intellij.util.xmlb.SkipDefaultValuesSerializationFilters;
import com.intellij.util.xmlb.XmlSerializer;
import com.intellij.util.xmlb.XmlSerializerUtil;
import java.io.File;
import java.util.LinkedHashMap;
import java.util.Map;
import org.jdom.Element;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JarApplicationConfiguration
extends LocatableConfigurationBase
implements CommonJavaRunConfigurationParameters,
SearchScopeProvidingRunProfile {
    private static final SkipDefaultValuesSerializationFilters SERIALIZATION_FILTERS = new SkipDefaultValuesSerializationFilters();
    private JarApplicationConfigurationBean myBean = new JarApplicationConfigurationBean();
    private Map<String, String> myEnvs = new LinkedHashMap<String, String>();
    private JavaRunConfigurationModule myConfigurationModule;

    public JarApplicationConfiguration(Project project2, ConfigurationFactory factory, String name2) {
        super(project2, factory, name2);
        this.myConfigurationModule = new JavaRunConfigurationModule(project2, true);
    }

    @NotNull
    public SettingsEditor<? extends RunConfiguration> getConfigurationEditor() {
        SettingsEditorGroup group = new SettingsEditorGroup();
        group.addEditor(ExecutionBundle.message((String)"run.configuration.configuration.tab.title", (Object[])new Object[0]), (SettingsEditor)new JarApplicationConfigurable(this.getProject()));
        JavaRunConfigurationExtensionManager.getInstance().appendEditors((RunConfigurationBase)this, group);
        group.addEditor(ExecutionBundle.message((String)"logs.tab.title", (Object[])new Object[0]), (SettingsEditor)new LogConfigurationPanel());
        SettingsEditorGroup settingsEditorGroup = group;
        if (settingsEditorGroup == null) {
            JarApplicationConfiguration.$$$reportNull$$$0(0);
        }
        return settingsEditorGroup;
    }

    public void readExternal(@NotNull Element element) throws InvalidDataException {
        if (element == null) {
            JarApplicationConfiguration.$$$reportNull$$$0(1);
        }
        super.readExternal(element);
        JavaRunConfigurationExtensionManager.getInstance().readExternal((RunConfigurationBase)this, element);
        XmlSerializer.deserializeInto((Object)this.myBean, (Element)element);
        EnvironmentVariablesComponent.readExternal((Element)element, this.getEnvs());
        this.myConfigurationModule.readExternal(element);
    }

    public RunConfiguration clone() {
        JarApplicationConfiguration clone = (JarApplicationConfiguration)super.clone();
        clone.myEnvs = new LinkedHashMap<String, String>(this.myEnvs);
        clone.myConfigurationModule = new JavaRunConfigurationModule(this.getProject(), true);
        clone.myConfigurationModule.setModule(this.myConfigurationModule.getModule());
        clone.myBean = (JarApplicationConfigurationBean)XmlSerializerUtil.createCopy((Object)this.myBean);
        return clone;
    }

    public void setModule(Module module2) {
        this.myConfigurationModule.setModule(module2);
    }

    public Module getModule() {
        return this.myConfigurationModule.getModule();
    }

    public void writeExternal(@NotNull Element element) throws WriteExternalException {
        if (element == null) {
            JarApplicationConfiguration.$$$reportNull$$$0(2);
        }
        super.writeExternal(element);
        JavaRunConfigurationExtensionManager.getInstance().writeExternal((RunConfigurationBase)this, element);
        XmlSerializer.serializeInto((Object)this.myBean, (Element)element, (SerializationFilter)SERIALIZATION_FILTERS);
        EnvironmentVariablesComponent.writeExternal((Element)element, this.getEnvs());
        if (this.myConfigurationModule.getModule() != null) {
            this.myConfigurationModule.writeExternal(element);
        }
    }

    public void checkConfiguration() throws RuntimeConfigurationException {
        JavaParametersUtil.checkAlternativeJRE(this);
        ProgramParametersUtil.checkWorkingDirectoryExist((CommonProgramRunConfigurationParameters)this, (Project)this.getProject(), null);
        File jarFile = new File(this.getJarPath());
        if (!jarFile.exists()) {
            throw new RuntimeConfigurationWarning("JAR file '" + jarFile.getAbsolutePath() + "' doesn't exist");
        }
        JavaRunConfigurationExtensionManager.checkConfigurationIsValid((RunConfigurationBase)this);
    }

    @NotNull
    public Module[] getModules() {
        Module[] moduleArray;
        Module module2 = this.myConfigurationModule.getModule();
        if (module2 != null) {
            Module[] moduleArray2 = new Module[1];
            moduleArray = moduleArray2;
            moduleArray2[0] = module2;
        } else {
            moduleArray = Module.EMPTY_ARRAY;
        }
        if (moduleArray == null) {
            JarApplicationConfiguration.$$$reportNull$$$0(3);
        }
        return moduleArray;
    }

    @Nullable
    public GlobalSearchScope getSearchScope() {
        return SearchScopeProvider.createSearchScope((Module[])this.getModules());
    }

    @Nullable
    public RunProfileState getState(@NotNull Executor executor, @NotNull ExecutionEnvironment environment) throws ExecutionException {
        if (executor == null) {
            JarApplicationConfiguration.$$$reportNull$$$0(4);
        }
        if (environment == null) {
            JarApplicationConfiguration.$$$reportNull$$$0(5);
        }
        return new JarApplicationCommandLineState(this, environment);
    }

    public String getJarPath() {
        return this.myBean.JAR_PATH;
    }

    public void setJarPath(String jarPath) {
        this.myBean.JAR_PATH = jarPath;
    }

    @Override
    public void setVMParameters(@Nullable String value) {
        this.myBean.VM_PARAMETERS = value;
    }

    @Override
    public String getVMParameters() {
        return this.myBean.VM_PARAMETERS;
    }

    @Override
    public boolean isAlternativeJrePathEnabled() {
        return this.myBean.ALTERNATIVE_JRE_PATH_ENABLED;
    }

    @Override
    public void setAlternativeJrePathEnabled(boolean enabled) {
        this.myBean.ALTERNATIVE_JRE_PATH_ENABLED = enabled;
    }

    @Override
    @Nullable
    public String getAlternativeJrePath() {
        return this.myBean.ALTERNATIVE_JRE_PATH;
    }

    @Override
    public void setAlternativeJrePath(String path) {
        this.myBean.ALTERNATIVE_JRE_PATH = path;
    }

    @Override
    @Nullable
    public String getRunClass() {
        return null;
    }

    @Override
    @Nullable
    public String getPackage() {
        return null;
    }

    public void setProgramParameters(@Nullable String value) {
        this.myBean.PROGRAM_PARAMETERS = value;
    }

    @Nullable
    public String getProgramParameters() {
        return this.myBean.PROGRAM_PARAMETERS;
    }

    public void setWorkingDirectory(@Nullable String value) {
        this.myBean.WORKING_DIRECTORY = value;
    }

    @Nullable
    public String getWorkingDirectory() {
        return this.myBean.WORKING_DIRECTORY;
    }

    public void setEnvs(@NotNull Map<String, String> envs) {
        if (envs == null) {
            JarApplicationConfiguration.$$$reportNull$$$0(6);
        }
        this.myEnvs.clear();
        this.myEnvs.putAll(envs);
    }

    @NotNull
    public Map<String, String> getEnvs() {
        Map<String, String> map = this.myEnvs;
        if (map == null) {
            JarApplicationConfiguration.$$$reportNull$$$0(7);
        }
        return map;
    }

    public void setPassParentEnvs(boolean passParentEnvs) {
        this.myBean.PASS_PARENT_ENVS = passParentEnvs;
    }

    public boolean isPassParentEnvs() {
        return this.myBean.PASS_PARENT_ENVS;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 1: 
            case 2: 
            case 4: 
            case 5: 
            case 6: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 1: 
            case 2: 
            case 4: 
            case 5: 
            case 6: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/execution/jar/JarApplicationConfiguration";
                break;
            }
            case 1: 
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "executor";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "environment";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "envs";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getConfigurationEditor";
                break;
            }
            case 1: 
            case 2: 
            case 4: 
            case 5: 
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/execution/jar/JarApplicationConfiguration";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getModules";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getEnvs";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "readExternal";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "writeExternal";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "getState";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "setEnvs";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 1: 
            case 2: 
            case 4: 
            case 5: 
            case 6: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static class JarApplicationConfigurationBean {
        public String JAR_PATH = "";
        public String VM_PARAMETERS = "";
        public String PROGRAM_PARAMETERS = "";
        public String WORKING_DIRECTORY = "";
        public boolean ALTERNATIVE_JRE_PATH_ENABLED;
        public String ALTERNATIVE_JRE_PATH = "";
        public boolean PASS_PARENT_ENVS = true;

        private JarApplicationConfigurationBean() {
        }
    }
}

