/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.execution.application;

import com.intellij.diagnostic.logging.LogConfigurationPanel;
import com.intellij.execution.AlternativeSdkRootsProvider;
import com.intellij.execution.CommonJavaRunConfigurationParameters;
import com.intellij.execution.CommonProgramRunConfigurationParameters;
import com.intellij.execution.ConfigurationWithCommandLineShortener;
import com.intellij.execution.ExecutionBundle;
import com.intellij.execution.ExecutionException;
import com.intellij.execution.Executor;
import com.intellij.execution.JavaExecutionUtil;
import com.intellij.execution.JavaRunConfigurationExtensionManager;
import com.intellij.execution.ProgramRunnerUtil;
import com.intellij.execution.RunConfigurationExtension;
import com.intellij.execution.ShortenCommandLine;
import com.intellij.execution.SingleClassConfiguration;
import com.intellij.execution.application.ApplicationCommandLineState;
import com.intellij.execution.application.ApplicationConfigurable;
import com.intellij.execution.application.ApplicationConfigurationOptions;
import com.intellij.execution.application.ApplicationConfigurationType;
import com.intellij.execution.configurations.ConfigurationFactory;
import com.intellij.execution.configurations.JavaRunConfigurationModule;
import com.intellij.execution.configurations.ModuleBasedConfiguration;
import com.intellij.execution.configurations.ModuleBasedConfigurationOptions;
import com.intellij.execution.configurations.RefactoringListenerProvider;
import com.intellij.execution.configurations.RunConfiguration;
import com.intellij.execution.configurations.RunConfigurationBase;
import com.intellij.execution.configurations.RunConfigurationModule;
import com.intellij.execution.configurations.RunProfileState;
import com.intellij.execution.configurations.RuntimeConfigurationException;
import com.intellij.execution.configurations.RuntimeConfigurationWarning;
import com.intellij.execution.filters.TextConsoleBuilderFactory;
import com.intellij.execution.junit.RefactoringListeners;
import com.intellij.execution.runners.ExecutionEnvironment;
import com.intellij.execution.util.JavaParametersUtil;
import com.intellij.execution.util.ProgramParametersUtil;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.options.SettingsEditor;
import com.intellij.openapi.options.SettingsEditorGroup;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.io.FileUtilRt;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFileManager;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.util.PsiMethodUtil;
import com.intellij.refactoring.listeners.RefactoringElementListener;
import com.intellij.util.PathUtil;
import java.util.Collection;
import java.util.Map;
import java.util.Objects;
import org.jdom.Element;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ApplicationConfiguration
extends ModuleBasedConfiguration<JavaRunConfigurationModule>
implements CommonJavaRunConfigurationParameters,
ConfigurationWithCommandLineShortener,
SingleClassConfiguration,
RefactoringListenerProvider {
    @Deprecated
    public String MAIN_CLASS_NAME;
    @Deprecated
    public String PROGRAM_PARAMETERS;
    @Deprecated
    public String WORKING_DIRECTORY;
    @Deprecated
    public boolean ALTERNATIVE_JRE_PATH_ENABLED;
    @Deprecated
    public String ALTERNATIVE_JRE_PATH;
    @Deprecated
    public boolean ENABLE_SWING_INSPECTOR;
    private ShortenCommandLine myShortenCommandLine = null;

    public ApplicationConfiguration(String name2, Project project2, ApplicationConfigurationType applicationConfigurationType) {
        this(name2, project2, applicationConfigurationType.getConfigurationFactories()[0]);
    }

    public ApplicationConfiguration(String name2, Project project2) {
        this(name2, project2, ApplicationConfigurationType.getInstance().getConfigurationFactories()[0]);
    }

    protected ApplicationConfiguration(String name2, Project project2, ConfigurationFactory factory) {
        super(name2, (RunConfigurationModule)new JavaRunConfigurationModule(project2, true), factory);
    }

    protected ApplicationConfigurationOptions getOptions() {
        return (ApplicationConfigurationOptions)super.getOptions();
    }

    protected Class<? extends ModuleBasedConfigurationOptions> getOptionsClass() {
        return ApplicationConfigurationOptions.class;
    }

    @Override
    public void setMainClass(@NotNull PsiClass psiClass) {
        if (psiClass == null) {
            ApplicationConfiguration.$$$reportNull$$$0(0);
        }
        Module originalModule = ((JavaRunConfigurationModule)this.getConfigurationModule()).getModule();
        this.setMainClassName(JavaExecutionUtil.getRuntimeQualifiedName((PsiClass)psiClass));
        this.setModule(JavaExecutionUtil.findModule((PsiClass)psiClass));
        this.restoreOriginalModule(originalModule);
    }

    public RunProfileState getState(@NotNull Executor executor, @NotNull ExecutionEnvironment env) throws ExecutionException {
        if (executor == null) {
            ApplicationConfiguration.$$$reportNull$$$0(1);
        }
        if (env == null) {
            ApplicationConfiguration.$$$reportNull$$$0(2);
        }
        JavaApplicationCommandLineState<ApplicationConfiguration> state = new JavaApplicationCommandLineState<ApplicationConfiguration>(this, env);
        JavaRunConfigurationModule module2 = (JavaRunConfigurationModule)this.getConfigurationModule();
        state.setConsoleBuilder(TextConsoleBuilderFactory.getInstance().createBuilder(this.getProject(), module2.getSearchScope()));
        return state;
    }

    @NotNull
    public SettingsEditor<? extends RunConfiguration> getConfigurationEditor() {
        SettingsEditorGroup group = new SettingsEditorGroup();
        group.addEditor(ExecutionBundle.message((String)"run.configuration.configuration.tab.title", (Object[])new Object[0]), (SettingsEditor)new ApplicationConfigurable(this.getProject()));
        JavaRunConfigurationExtensionManager.getInstance().appendEditors((RunConfigurationBase)this, group);
        group.addEditor(ExecutionBundle.message((String)"logs.tab.title", (Object[])new Object[0]), (SettingsEditor)new LogConfigurationPanel());
        SettingsEditorGroup settingsEditorGroup = group;
        if (settingsEditorGroup == null) {
            ApplicationConfiguration.$$$reportNull$$$0(3);
        }
        return settingsEditorGroup;
    }

    public RefactoringElementListener getRefactoringElementListener(PsiElement element) {
        RefactoringElementListener listener = RefactoringListeners.getClassOrPackageListener(element, new RefactoringListeners.SingleClassConfigurationAccessor(this));
        return RunConfigurationExtension.wrapRefactoringElementListener(element, (RunConfigurationBase)this, listener);
    }

    @Override
    @Nullable
    public PsiClass getMainClass() {
        return ((JavaRunConfigurationModule)this.getConfigurationModule()).findClass(this.getMainClassName());
    }

    @Nullable
    public String getMainClassName() {
        return this.MAIN_CLASS_NAME;
    }

    @Nullable
    public String suggestedName() {
        if (this.getMainClassName() == null) {
            return null;
        }
        return JavaExecutionUtil.getPresentableClassName((String)this.getMainClassName());
    }

    public String getActionName() {
        if (this.getMainClassName() == null) {
            return null;
        }
        return ProgramRunnerUtil.shortenName((String)JavaExecutionUtil.getShortClassName((String)this.getMainClassName()), (int)6) + ".main()";
    }

    @Override
    public void setMainClassName(@Nullable String qualifiedName) {
        this.MAIN_CLASS_NAME = qualifiedName;
        this.getOptions().setMainClassName(qualifiedName);
    }

    public void checkConfiguration() throws RuntimeConfigurationException {
        JavaParametersUtil.checkAlternativeJRE(this);
        JavaRunConfigurationModule configurationModule = (JavaRunConfigurationModule)this.getConfigurationModule();
        PsiClass psiClass = configurationModule.checkModuleAndClassName(this.getMainClassName(), ExecutionBundle.message((String)"no.main.class.specified.error.text", (Object[])new Object[0]));
        if (!PsiMethodUtil.hasMainMethod((PsiClass)psiClass)) {
            throw new RuntimeConfigurationWarning(ExecutionBundle.message((String)"main.method.not.found.in.class.error.message", (Object[])new Object[]{this.getMainClassName()}));
        }
        ProgramParametersUtil.checkWorkingDirectoryExist((CommonProgramRunConfigurationParameters)this, (Project)this.getProject(), (Module)configurationModule.getModule());
        JavaRunConfigurationExtensionManager.checkConfigurationIsValid((RunConfigurationBase)this);
    }

    @Override
    public void setVMParameters(@Nullable String value) {
        this.getOptions().setVmParameters(value);
    }

    @Override
    public String getVMParameters() {
        return this.getOptions().getVmParameters();
    }

    public void setProgramParameters(@Nullable String value) {
        this.PROGRAM_PARAMETERS = value;
        this.getOptions().setProgramParameters(value);
    }

    public String getProgramParameters() {
        return this.PROGRAM_PARAMETERS;
    }

    public void setWorkingDirectory(@Nullable String value) {
        String normalizedValue = StringUtil.isEmptyOrSpaces((String)value) ? null : value.trim();
        this.WORKING_DIRECTORY = PathUtil.toSystemDependentName((String)normalizedValue);
        String independentValue = PathUtil.toSystemIndependentName((String)normalizedValue);
        this.getOptions().setWorkingDirectory(Comparing.equal((String)independentValue, (String)this.getProject().getBasePath()) ? null : independentValue);
    }

    public String getWorkingDirectory() {
        return this.WORKING_DIRECTORY;
    }

    public void setPassParentEnvs(boolean value) {
        this.getOptions().setPassParentEnv(value);
    }

    @NotNull
    public Map<String, String> getEnvs() {
        Map<String, String> map = this.getOptions().getEnv();
        if (map == null) {
            ApplicationConfiguration.$$$reportNull$$$0(4);
        }
        return map;
    }

    public void setEnvs(@NotNull Map<String, String> envs) {
        if (envs == null) {
            ApplicationConfiguration.$$$reportNull$$$0(5);
        }
        this.getOptions().setEnv(envs);
    }

    public boolean isPassParentEnvs() {
        return this.getOptions().isPassParentEnv();
    }

    @Override
    @Nullable
    public String getRunClass() {
        return this.getMainClassName();
    }

    @Override
    @Nullable
    public String getPackage() {
        return null;
    }

    @Override
    public boolean isAlternativeJrePathEnabled() {
        return this.ALTERNATIVE_JRE_PATH_ENABLED;
    }

    @Override
    public void setAlternativeJrePathEnabled(boolean enabled) {
        boolean changed = this.ALTERNATIVE_JRE_PATH_ENABLED != enabled;
        this.ALTERNATIVE_JRE_PATH_ENABLED = enabled;
        this.getOptions().setAlternativeJrePathEnabled(enabled);
        ApplicationConfiguration.onAlternativeJreChanged(changed, this.getProject());
    }

    @Override
    @Nullable
    public String getAlternativeJrePath() {
        return this.ALTERNATIVE_JRE_PATH;
    }

    @Override
    public void setAlternativeJrePath(@Nullable String path) {
        boolean changed = !Objects.equals(this.ALTERNATIVE_JRE_PATH, path);
        this.ALTERNATIVE_JRE_PATH = path;
        this.getOptions().setAlternativeJrePath(path);
        ApplicationConfiguration.onAlternativeJreChanged(changed, this.getProject());
    }

    public static void onAlternativeJreChanged(boolean changed, Project project2) {
        if (changed) {
            AlternativeSdkRootsProvider.reindexIfNeeded(project2);
        }
    }

    public boolean isProvidedScopeIncluded() {
        return this.getOptions().getIncludeProvidedScope();
    }

    public void setIncludeProvidedScope(boolean value) {
        this.getOptions().setIncludeProvidedScope(value);
    }

    public Collection<Module> getValidModules() {
        return JavaRunConfigurationModule.getModulesForClass((Project)this.getProject(), (String)this.getMainClassName());
    }

    public void readExternal(@NotNull Element element) {
        if (element == null) {
            ApplicationConfiguration.$$$reportNull$$$0(6);
        }
        super.readExternal(element);
        ApplicationConfigurationOptions options = this.getOptions();
        String workingDirectory = options.getWorkingDirectory();
        workingDirectory = workingDirectory == null ? PathUtil.toSystemDependentName((String)this.getProject().getBasePath()) : FileUtilRt.toSystemDependentName((String)VirtualFileManager.extractPath((String)workingDirectory));
        this.MAIN_CLASS_NAME = options.getMainClassName();
        this.PROGRAM_PARAMETERS = options.getProgramParameters();
        this.WORKING_DIRECTORY = workingDirectory;
        this.ALTERNATIVE_JRE_PATH = options.getAlternativeJrePath();
        this.ALTERNATIVE_JRE_PATH_ENABLED = options.isAlternativeJrePathEnabled();
        this.ENABLE_SWING_INSPECTOR = options.isSwingInspectorEnabled();
        JavaRunConfigurationExtensionManager.getInstance().readExternal((RunConfigurationBase)this, element);
        this.setShortenCommandLine(ShortenCommandLine.readShortenClasspathMethod((Element)element));
    }

    public void writeExternal(@NotNull Element element) {
        if (element == null) {
            ApplicationConfiguration.$$$reportNull$$$0(7);
        }
        super.writeExternal(element);
        JavaRunConfigurationExtensionManager.getInstance().writeExternal((RunConfigurationBase)this, element);
        ShortenCommandLine.writeShortenClasspathMethod((Element)element, (ShortenCommandLine)this.myShortenCommandLine);
    }

    @Nullable
    public ShortenCommandLine getShortenCommandLine() {
        return this.myShortenCommandLine;
    }

    public void setShortenCommandLine(ShortenCommandLine mode) {
        this.myShortenCommandLine = mode;
    }

    public boolean isSwingInspectorEnabled() {
        return this.ENABLE_SWING_INSPECTOR;
    }

    public void setSwingInspectorEnabled(boolean value) {
        this.ENABLE_SWING_INSPECTOR = value;
        this.getOptions().setSwingInspectorEnabled(value);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 3: 
            case 4: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 3: 
            case 4: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "psiClass";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "executor";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "env";
                break;
            }
            case 3: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/execution/application/ApplicationConfiguration";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "envs";
                break;
            }
            case 6: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/execution/application/ApplicationConfiguration";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getConfigurationEditor";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getEnvs";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "setMainClass";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "getState";
                break;
            }
            case 3: 
            case 4: {
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "setEnvs";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "readExternal";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "writeExternal";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 3: 
            case 4: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    public static class JavaApplicationCommandLineState<T extends ApplicationConfiguration>
    extends ApplicationCommandLineState<T> {
        public JavaApplicationCommandLineState(@NotNull T configuration, ExecutionEnvironment environment) {
            if (configuration == null) {
                JavaApplicationCommandLineState.$$$reportNull$$$0(0);
            }
            super(configuration, environment);
        }

        @Override
        protected boolean isProvidedScopeIncluded() {
            return ((ApplicationConfiguration)this.myConfiguration).isProvidedScopeIncluded();
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "configuration", "com/intellij/execution/application/ApplicationConfiguration$JavaApplicationCommandLineState", "<init>"));
        }
    }
}

