/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.debugger.ui.tree.render;

import com.intellij.debugger.DebuggerBundle;
import com.intellij.debugger.engine.DebugProcessImpl;
import com.intellij.debugger.engine.FullValueEvaluatorProvider;
import com.intellij.debugger.engine.SuspendContextImpl;
import com.intellij.debugger.engine.evaluation.EvaluateException;
import com.intellij.debugger.engine.evaluation.EvaluationContext;
import com.intellij.debugger.engine.evaluation.EvaluationContextImpl;
import com.intellij.debugger.engine.events.SuspendContextCommandImpl;
import com.intellij.debugger.impl.DebuggerUtilsImpl;
import com.intellij.debugger.settings.NodeRendererSettings;
import com.intellij.debugger.ui.impl.watch.ValueDescriptorImpl;
import com.intellij.debugger.ui.tree.ValueDescriptor;
import com.intellij.debugger.ui.tree.render.CompoundReferenceRenderer;
import com.intellij.debugger.ui.tree.render.DescriptorLabelListener;
import com.intellij.debugger.ui.tree.render.ImageObjectRenderer;
import com.intellij.icons.AllIcons;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.xdebugger.frame.XFullValueEvaluator;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class IconObjectRenderer
extends CompoundReferenceRenderer
implements FullValueEvaluatorProvider {
    public IconObjectRenderer(NodeRendererSettings rendererSettings) {
        super(rendererSettings, "Icon", null, null);
        this.setClassName("javax.swing.Icon");
        this.setEnabled(true);
    }

    @Override
    public Icon calcValueIcon(final ValueDescriptor descriptor2, final EvaluationContext evaluationContext, final DescriptorLabelListener listener) throws EvaluateException {
        EvaluationContextImpl evalContext = (EvaluationContextImpl)evaluationContext;
        DebugProcessImpl debugProcess = evalContext.getDebugProcess();
        if (!Registry.is((String)"debugger.auto.fetch.icons") || DebuggerUtilsImpl.isRemote(debugProcess)) {
            return null;
        }
        debugProcess.getManagerThread().schedule(new SuspendContextCommandImpl(evalContext.getSuspendContext()){

            @Override
            public void contextAction(@NotNull SuspendContextImpl suspendContext) {
                if (suspendContext == null) {
                    1.$$$reportNull$$$0(0);
                }
                String getterName = AllIcons.Debugger.Value.getIconHeight() <= 16 ? "iconToBytesPreviewNormal" : "iconToBytesPreviewRetina";
                descriptor2.setValueIcon(ImageObjectRenderer.getIcon(evaluationContext, descriptor2.getValue(), getterName));
                listener.labelChanged();
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "suspendContext", "com/intellij/debugger/ui/tree/render/IconObjectRenderer$1", "contextAction"));
            }
        });
        return null;
    }

    @Override
    @Nullable
    public XFullValueEvaluator getFullValueEvaluator(EvaluationContextImpl evaluationContext, final ValueDescriptorImpl valueDescriptor) {
        return new ImageObjectRenderer.IconPopupEvaluator(DebuggerBundle.message((String)"message.node.show.icon", (Object[])new Object[0]), evaluationContext){

            @Override
            protected Icon getData() {
                return ImageObjectRenderer.getIcon(this.getEvaluationContext(), valueDescriptor.getValue(), "iconToBytes");
            }
        };
    }
}

