/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.debugger.ui.tree.render;

import com.intellij.debugger.DebuggerBundle;
import com.intellij.debugger.DebuggerManagerEx;
import com.intellij.debugger.actions.ArrayAction;
import com.intellij.debugger.actions.ArrayFilterAction;
import com.intellij.debugger.engine.DebugProcessImpl;
import com.intellij.debugger.engine.DebuggerManagerThreadImpl;
import com.intellij.debugger.engine.JavaValue;
import com.intellij.debugger.engine.SuspendContextImpl;
import com.intellij.debugger.engine.evaluation.EvaluationContextImpl;
import com.intellij.debugger.engine.events.SuspendContextCommandImpl;
import com.intellij.debugger.impl.DebuggerUtilsImpl;
import com.intellij.debugger.impl.PrioritizedTask;
import com.intellij.debugger.settings.NodeRendererSettings;
import com.intellij.debugger.ui.impl.watch.ValueDescriptorImpl;
import com.intellij.debugger.ui.tree.render.ArrayFilterInplaceEditor;
import com.intellij.debugger.ui.tree.render.ArrayRenderer;
import com.intellij.debugger.ui.tree.render.ExpressionChildrenRenderer;
import com.intellij.icons.AllIcons;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.ThrowableComputable;
import com.intellij.psi.JavaCodeFragment;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiType;
import com.intellij.ui.SimpleColoredComponent;
import com.intellij.ui.SimpleTextAttributes;
import com.intellij.util.ui.tree.TreeModelAdapter;
import com.intellij.util.ui.tree.TreeUtil;
import com.intellij.xdebugger.XExpression;
import com.intellij.xdebugger.frame.XValue;
import com.intellij.xdebugger.impl.XDebuggerUtilImpl;
import com.intellij.xdebugger.impl.ui.DebuggerUIUtil;
import com.intellij.xdebugger.impl.ui.XDebuggerExpressionComboBox;
import com.intellij.xdebugger.impl.ui.tree.XDebuggerTree;
import com.intellij.xdebugger.impl.ui.tree.XDebuggerTreeInplaceEditor;
import com.intellij.xdebugger.impl.ui.tree.nodes.XDebuggerTreeNode;
import com.intellij.xdebugger.impl.ui.tree.nodes.XValueNodeImpl;
import com.sun.jdi.ArrayReference;
import com.sun.jdi.ArrayType;
import com.sun.jdi.Type;
import com.sun.jdi.Value;
import java.awt.Rectangle;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.function.Function;
import javax.swing.event.TreeModelEvent;
import javax.swing.event.TreeModelListener;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 10}, bv={1, 0, 2}, k=1, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 \u00102\u00020\u0001:\u0001\u0010B\u001f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\b\u0010\u0006\u001a\u0004\u0018\u00010\u0007\u00a2\u0006\u0002\u0010\bJ\b\u0010\u000b\u001a\u00020\fH\u0016J\b\u0010\r\u001a\u00020\fH\u0016J\n\u0010\u000e\u001a\u0004\u0018\u00010\u000fH\u0014R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\n\u00a8\u0006\u0011"}, d2={"Lcom/intellij/debugger/ui/tree/render/ArrayFilterInplaceEditor;", "Lcom/intellij/xdebugger/impl/ui/tree/XDebuggerTreeInplaceEditor;", "node", "Lcom/intellij/xdebugger/impl/ui/tree/nodes/XDebuggerTreeNode;", "myTemp", "", "thisType", "Lcom/intellij/psi/PsiType;", "(Lcom/intellij/xdebugger/impl/ui/tree/nodes/XDebuggerTreeNode;ZLcom/intellij/psi/PsiType;)V", "getMyTemp", "()Z", "cancelEditing", "", "doOKAction", "getEditorBounds", "Ljava/awt/Rectangle;", "Companion", "intellij.java.debugger.impl"})
public final class ArrayFilterInplaceEditor
extends XDebuggerTreeInplaceEditor {
    private final boolean myTemp;
    public static final Companion Companion = new Companion(null);

    public void cancelEditing() {
        super.cancelEditing();
        if (this.myTemp) {
            XDebuggerTreeNode xDebuggerTreeNode = this.myNode;
            Intrinsics.checkExpressionValueIsNotNull((Object)xDebuggerTreeNode, (String)"myNode");
            TreeNode treeNode = xDebuggerTreeNode.getParent();
            if (treeNode == null) {
                throw new TypeCastException("null cannot be cast to non-null type com.intellij.xdebugger.impl.ui.tree.nodes.XValueNodeImpl");
            }
            ((XValueNodeImpl)treeNode).removeTemporaryEditorNode(this.myNode);
        }
    }

    public void doOKAction() {
        ArrayRenderer arrayRenderer;
        XDebuggerTree xDebuggerTree = this.myTree;
        Intrinsics.checkExpressionValueIsNotNull((Object)xDebuggerTree, (String)"myTree");
        xDebuggerTree.getModel().addTreeModelListener((TreeModelListener)new TreeModelAdapter(this){
            final /* synthetic */ ArrayFilterInplaceEditor this$0;

            /*
             * WARNING - void declaration
             */
            protected void process(@Nullable TreeModelEvent event, @Nullable TreeModelAdapter.EventType type) {
                Serializable serializable = event;
                Object object = event != null && (serializable = ((TreeModelEvent)serializable).getTreePath()) != null ? ((TreePath)serializable).getLastPathComponent() : null;
                XDebuggerTreeNode xDebuggerTreeNode = ArrayFilterInplaceEditor.access$getMyNode$p(this.this$0);
                Intrinsics.checkExpressionValueIsNotNull((Object)xDebuggerTreeNode, (String)"myNode");
                if (Intrinsics.areEqual((Object)object, (Object)xDebuggerTreeNode.getParent()) ^ true) {
                    XDebuggerTree xDebuggerTree = ArrayFilterInplaceEditor.access$getMyTree$p(this.this$0);
                    Intrinsics.checkExpressionValueIsNotNull((Object)xDebuggerTree, (String)"myTree");
                    xDebuggerTree.getModel().removeTreeModelListener((TreeModelListener)((Object)this));
                }
                if (type == TreeModelAdapter.EventType.NodesInserted) {
                    Object[] objectArray = event;
                    if (event != null && (objectArray = objectArray.getChildren()) != null) {
                        void $receiver$iv$iv;
                        Object $receiver$iv;
                        Object object2 = $receiver$iv = objectArray;
                        Collection destination$iv$iv = new ArrayList<E>();
                        int n = ((void)$receiver$iv$iv).length;
                        for (int i = 0; i < n; ++i) {
                            void element$iv$iv;
                            void it;
                            void v5 = it = (element$iv$iv = $receiver$iv$iv[i]);
                            if (v5 == null) {
                                throw new TypeCastException("null cannot be cast to non-null type javax.swing.tree.TreeNode");
                            }
                            if (!ArrayFilterAction.isArrayFilter((TreeNode)v5)) continue;
                            destination$iv$iv.add(element$iv$iv);
                        }
                        $receiver$iv = (List)destination$iv$iv;
                        object2 = $receiver$iv.iterator();
                        while (object2.hasNext()) {
                            E element$iv;
                            E it = element$iv = object2.next();
                            XDebuggerTree xDebuggerTree = ArrayFilterInplaceEditor.access$getMyTree$p(this.this$0);
                            Intrinsics.checkExpressionValueIsNotNull((Object)xDebuggerTree, (String)"myTree");
                            E e = it;
                            if (e == null) {
                                throw new TypeCastException("null cannot be cast to non-null type javax.swing.tree.TreeNode");
                            }
                            xDebuggerTree.setSelectionPath(TreeUtil.getPathFromRoot((TreeNode)((TreeNode)e)));
                            XDebuggerTree xDebuggerTree2 = ArrayFilterInplaceEditor.access$getMyTree$p(this.this$0);
                            Intrinsics.checkExpressionValueIsNotNull((Object)xDebuggerTree2, (String)"myTree");
                            xDebuggerTree2.getModel().removeTreeModelListener((TreeModelListener)((Object)this));
                        }
                    }
                }
            }
            {
                this.this$0 = $outer;
            }
        });
        if (XDebuggerUtilImpl.isEmptyExpression((XExpression)this.getExpression())) {
            NodeRendererSettings nodeRendererSettings = NodeRendererSettings.getInstance();
            Intrinsics.checkExpressionValueIsNotNull((Object)nodeRendererSettings, (String)"NodeRendererSettings.getInstance()");
            arrayRenderer = nodeRendererSettings.getArrayRenderer();
        } else {
            arrayRenderer = new ArrayRenderer.Filtered(this.getExpression());
        }
        XDebuggerTreeNode xDebuggerTreeNode = this.myNode;
        Intrinsics.checkExpressionValueIsNotNull((Object)xDebuggerTreeNode, (String)"myNode");
        TreeNode treeNode = xDebuggerTreeNode.getParent();
        if (treeNode == null) {
            throw new TypeCastException("null cannot be cast to non-null type com.intellij.xdebugger.impl.ui.tree.nodes.XValueNodeImpl");
        }
        XValueNodeImpl xValueNodeImpl = (XValueNodeImpl)treeNode;
        DebuggerManagerEx debuggerManagerEx = DebuggerManagerEx.getInstanceEx(this.getProject());
        Intrinsics.checkExpressionValueIsNotNull((Object)((Object)debuggerManagerEx), (String)"DebuggerManagerEx.getInstanceEx(project)");
        ArrayAction.setArrayRenderer(arrayRenderer, xValueNodeImpl, debuggerManagerEx.getContext());
        super.doOKAction();
    }

    @Nullable
    protected Rectangle getEditorBounds() {
        Rectangle rectangle = super.getEditorBounds();
        if (rectangle == null) {
            return null;
        }
        Intrinsics.checkExpressionValueIsNotNull((Object)rectangle, (String)"super.getEditorBounds() ?: return null");
        Rectangle bounds = rectangle;
        SimpleColoredComponent nameLabel = new SimpleColoredComponent();
        nameLabel.getIpad().right = 0;
        nameLabel.getIpad().left = 0;
        XDebuggerTreeNode xDebuggerTreeNode = this.myNode;
        Intrinsics.checkExpressionValueIsNotNull((Object)xDebuggerTreeNode, (String)"myNode");
        nameLabel.setIcon(xDebuggerTreeNode.getIcon());
        nameLabel.append(DebuggerBundle.message((String)"message.node.filtered", (Object[])new Object[0]), SimpleTextAttributes.REGULAR_ATTRIBUTES);
        int offset = nameLabel.getPreferredSize().width;
        bounds.x += offset;
        bounds.width -= offset;
        return bounds;
    }

    public final boolean getMyTemp() {
        return this.myTemp;
    }

    public ArrayFilterInplaceEditor(@NotNull XDebuggerTreeNode node, boolean myTemp, final @Nullable PsiType thisType) {
        Intrinsics.checkParameterIsNotNull((Object)node, (String)"node");
        super(node, "arrayFilter");
        this.myTemp = myTemp;
        if (thisType != null) {
            this.myExpressionEditor.setDocumentProcessor((Function)new Function<Document, Document>(){

                @Override
                public final Document apply(Document d) {
                    PsiFile psiFile = PsiDocumentManager.getInstance((Project)this.getProject()).getPsiFile(d);
                    if (psiFile instanceof JavaCodeFragment) {
                        ((JavaCodeFragment)psiFile).setThisType(thisType);
                    }
                    return d;
                }
            });
        }
        XDebuggerTreeNode xDebuggerTreeNode = this.myNode;
        Intrinsics.checkExpressionValueIsNotNull((Object)xDebuggerTreeNode, (String)"myNode");
        TreeNode treeNode = xDebuggerTreeNode.getParent();
        if (treeNode == null) {
            throw new TypeCastException("null cannot be cast to non-null type com.intellij.xdebugger.impl.ui.tree.nodes.XValueNodeImpl");
        }
        ArrayRenderer arrayRenderer = ArrayAction.getArrayRenderer((XValue)((XValueNodeImpl)treeNode).getValueContainer());
        XDebuggerExpressionComboBox xDebuggerExpressionComboBox = this.myExpressionEditor;
        Intrinsics.checkExpressionValueIsNotNull((Object)xDebuggerExpressionComboBox, (String)"myExpressionEditor");
        xDebuggerExpressionComboBox.setExpression(arrayRenderer instanceof ArrayRenderer.Filtered ? ((ArrayRenderer.Filtered)arrayRenderer).getExpression() : null);
    }

    public static final /* synthetic */ XDebuggerTreeNode access$getMyNode$p(ArrayFilterInplaceEditor $this) {
        return $this.myNode;
    }

    public static final /* synthetic */ XDebuggerTree access$getMyTree$p(ArrayFilterInplaceEditor $this) {
        return $this.myTree;
    }

    @JvmStatic
    public static final void edit(@NotNull XDebuggerTreeNode node, boolean temp) {
        Companion.edit(node, temp);
    }

    @JvmStatic
    public static final void editParent(@NotNull XValueNodeImpl parentNode) {
        Companion.editParent(parentNode);
    }

    @Metadata(mv={1, 1, 10}, bv={1, 0, 2}, k=1, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0018\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0007J\u0010\u0010\t\u001a\u00020\u00042\u0006\u0010\n\u001a\u00020\u000bH\u0007\u00a8\u0006\f"}, d2={"Lcom/intellij/debugger/ui/tree/render/ArrayFilterInplaceEditor$Companion;", "", "()V", "edit", "", "node", "Lcom/intellij/xdebugger/impl/ui/tree/nodes/XDebuggerTreeNode;", "temp", "", "editParent", "parentNode", "Lcom/intellij/xdebugger/impl/ui/tree/nodes/XValueNodeImpl;", "intellij.java.debugger.impl"})
    public static final class Companion {
        @JvmStatic
        public final void edit(@NotNull XDebuggerTreeNode node, boolean temp) {
            Intrinsics.checkParameterIsNotNull((Object)node, (String)"node");
            TreeNode treeNode = node.getParent();
            if (treeNode == null) {
                throw new TypeCastException("null cannot be cast to non-null type com.intellij.xdebugger.impl.ui.tree.nodes.XValueNodeImpl");
            }
            XValue xValue = (XValue)((XValueNodeImpl)treeNode).getValueContainer();
            Intrinsics.checkExpressionValueIsNotNull((Object)xValue, (String)"(node.parent as XValueNodeImpl).valueContainer");
            XValue javaValue = xValue;
            if (javaValue instanceof JavaValue) {
                EvaluationContextImpl evaluationContextImpl = ((JavaValue)javaValue).getEvaluationContext();
                Intrinsics.checkExpressionValueIsNotNull((Object)evaluationContextImpl, (String)"javaValue.evaluationContext");
                DebugProcessImpl debugProcessImpl = evaluationContextImpl.getDebugProcess();
                Intrinsics.checkExpressionValueIsNotNull((Object)((Object)debugProcessImpl), (String)"javaValue.evaluationContext.debugProcess");
                DebugProcessImpl debugProcess = debugProcessImpl;
                DebuggerManagerThreadImpl debuggerManagerThreadImpl = debugProcess.getManagerThread();
                EvaluationContextImpl evaluationContextImpl2 = ((JavaValue)javaValue).getEvaluationContext();
                Intrinsics.checkExpressionValueIsNotNull((Object)evaluationContextImpl2, (String)"javaValue.evaluationContext");
                debuggerManagerThreadImpl.schedule(new SuspendContextCommandImpl(javaValue, node, temp, evaluationContextImpl2.getSuspendContext()){
                    final /* synthetic */ XValue $javaValue;
                    final /* synthetic */ XDebuggerTreeNode $node;
                    final /* synthetic */ boolean $temp;

                    @NotNull
                    public PrioritizedTask.Priority getPriority() {
                        return PrioritizedTask.Priority.NORMAL;
                    }

                    /*
                     * WARNING - void declaration
                     */
                    public void contextAction(@NotNull SuspendContextImpl suspendContext) {
                        void type;
                        Intrinsics.checkParameterIsNotNull((Object)((Object)suspendContext), (String)"suspendContext");
                        Ref.ObjectRef objectRef = new Ref.ObjectRef();
                        objectRef.element = null;
                        ValueDescriptorImpl valueDescriptorImpl = ((JavaValue)this.$javaValue).getDescriptor();
                        Intrinsics.checkExpressionValueIsNotNull((Object)valueDescriptorImpl, (String)"javaValue.descriptor");
                        Value value = valueDescriptorImpl.getValue();
                        if (value instanceof ArrayReference) {
                            Type type2 = value.type();
                            if (type2 == null) {
                                throw new TypeCastException("null cannot be cast to non-null type com.sun.jdi.ArrayType");
                            }
                            type.element = ((ArrayType)type2).componentTypeName();
                        } else {
                            Value lastChildrenValue = ExpressionChildrenRenderer.getLastChildrenValue(((JavaValue)this.$javaValue).getDescriptor());
                            if (lastChildrenValue instanceof ArrayReference) {
                                for (Value v : ((ArrayReference)lastChildrenValue).getValues(0, Math.min(((ArrayReference)lastChildrenValue).length(), 100))) {
                                    if (v == null) continue;
                                    type.element = v.type().name();
                                    break;
                                }
                            }
                        }
                        Pair pair2 = (Pair)ReadAction.compute((ThrowableComputable)((ThrowableComputable)new ThrowableComputable<T, E>(this, (Ref.ObjectRef)type){
                            final /* synthetic */ edit.1 this$0;
                            final /* synthetic */ Ref.ObjectRef $type;

                            @NotNull
                            public final Pair<PsiElement, PsiType> compute() {
                                return DebuggerUtilsImpl.getPsiClassAndType((String)this.$type.element, ((JavaValue)this.this$0.$javaValue).getProject());
                            }
                            {
                                this.this$0 = var1_1;
                                this.$type = objectRef;
                            }
                        }));
                        DebuggerUIUtil.invokeLater((Runnable)new Runnable(this, pair2){
                            final /* synthetic */ edit.1 this$0;
                            final /* synthetic */ Pair $pair;

                            public final void run() {
                                new ArrayFilterInplaceEditor(this.this$0.$node, this.this$0.$temp, (PsiType)this.$pair.second).show();
                            }
                            {
                                this.this$0 = var1_1;
                                this.$pair = pair2;
                            }
                        });
                    }

                    protected void commandCancelled() {
                        DebuggerUIUtil.invokeLater((Runnable)new Runnable(this){
                            final /* synthetic */ edit.1 this$0;

                            public final void run() {
                                new ArrayFilterInplaceEditor(this.this$0.$node, this.this$0.$temp, null).show();
                            }
                            {
                                this.this$0 = var1_1;
                            }
                        });
                    }
                    {
                        this.$javaValue = $captured_local_variable$0;
                        this.$node = $captured_local_variable$1;
                        this.$temp = $captured_local_variable$2;
                        super($super_call_param$3);
                    }
                });
            } else {
                new ArrayFilterInplaceEditor(node, temp, null).show();
            }
        }

        @JvmStatic
        public final void editParent(@NotNull XValueNodeImpl parentNode) {
            Object v1;
            boolean temp;
            block3: {
                Iterable iterable;
                Intrinsics.checkParameterIsNotNull((Object)parentNode, (String)"parentNode");
                temp = false;
                List list = parentNode.getChildren();
                Intrinsics.checkExpressionValueIsNotNull((Object)list, (String)"parentNode.children");
                Iterable iterable2 = iterable = (Iterable)list;
                for (Object t : iterable2) {
                    TreeNode it = (TreeNode)t;
                    if (!ArrayFilterAction.isArrayFilter(it)) continue;
                    v1 = t;
                    break block3;
                }
                v1 = null;
            }
            TreeNode node = v1;
            if (node == null) {
                node = (TreeNode)parentNode.addTemporaryEditorNode(AllIcons.General.Filter, DebuggerBundle.message((String)"message.node.filtered", (Object[])new Object[0]));
                temp = true;
            }
            TreeNode treeNode = node;
            if (treeNode == null) {
                throw new TypeCastException("null cannot be cast to non-null type com.intellij.xdebugger.impl.ui.tree.nodes.XDebuggerTreeNode");
            }
            this.edit((XDebuggerTreeNode)treeNode, temp);
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

