/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.debugger.ui.impl.watch;

import com.intellij.codeInsight.ChangeContextUtil;
import com.intellij.debugger.DebuggerBundle;
import com.intellij.debugger.codeinsight.RuntimeTypeEvaluator;
import com.intellij.debugger.engine.evaluation.EvaluateException;
import com.intellij.debugger.engine.evaluation.TextWithImports;
import com.intellij.debugger.engine.evaluation.TextWithImportsImpl;
import com.intellij.debugger.impl.DebuggerContextImpl;
import com.intellij.debugger.ui.impl.watch.DebuggerTreeNodeImpl;
import com.intellij.debugger.ui.impl.watch.ValueDescriptorImpl;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Key;
import com.intellij.pom.java.LanguageLevel;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiArrayType;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementFactory;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiParenthesizedExpression;
import com.intellij.psi.PsiResolveHelper;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiTypeCastExpression;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiUtil;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.containers.SmartHashSet;
import com.sun.jdi.ObjectReference;
import com.sun.jdi.ReferenceType;
import com.sun.jdi.Value;
import java.util.Set;
import org.jetbrains.annotations.Nullable;

public class DebuggerTreeNodeExpression {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.debugger.ui.impl.watch.DebuggerTreeNodeExpression");
    public static final Key<Set<String>> ADDITIONAL_IMPORTS_KEY = Key.create((String)"ADDITIONAL_IMPORTS");

    private static boolean isSuperMethod(PsiMethod superMethod, PsiMethod overridingMethod) {
        PsiMethod[] superMethods;
        for (PsiMethod method : superMethods = overridingMethod.findSuperMethods()) {
            if (method != superMethod && !DebuggerTreeNodeExpression.isSuperMethod(superMethod, method)) continue;
            return true;
        }
        return false;
    }

    @Nullable
    public static PsiExpression substituteThis(@Nullable PsiElement expressionWithThis, PsiExpression howToEvaluateThis, Value howToEvaluateThisValue) throws EvaluateException {
        PsiExpression psiExpression;
        PsiType type;
        if (!(expressionWithThis instanceof PsiExpression)) {
            return null;
        }
        PsiExpression result = (PsiExpression)expressionWithThis.copy();
        PsiClass thisClass = (PsiClass)PsiTreeUtil.getContextOfType((PsiElement)result, PsiClass.class, (boolean)true);
        boolean castNeeded = true;
        if (thisClass != null && (type = howToEvaluateThis.getType()) != null) {
            if (type instanceof PsiClassType) {
                PsiClass psiClass = ((PsiClassType)type).resolve();
                if (psiClass != null && (psiClass == thisClass || psiClass.isInheritor(thisClass, true))) {
                    castNeeded = false;
                }
            } else if (type instanceof PsiArrayType) {
                LanguageLevel languageLevel = PsiUtil.getLanguageLevel((PsiElement)expressionWithThis);
                if (thisClass == JavaPsiFacade.getInstance((Project)expressionWithThis.getProject()).getElementFactory().getArrayClass(languageLevel)) {
                    castNeeded = false;
                }
            }
        }
        if (castNeeded) {
            howToEvaluateThis = DebuggerTreeNodeExpression.castToRuntimeType(howToEvaluateThis, howToEvaluateThisValue);
        }
        ChangeContextUtil.encodeContextInfo((PsiElement)result, (boolean)false);
        try {
            psiExpression = (PsiExpression)ChangeContextUtil.decodeContextInfo((PsiElement)result, (PsiClass)thisClass, (PsiExpression)howToEvaluateThis);
        }
        catch (IncorrectOperationException e) {
            throw new EvaluateException(DebuggerBundle.message((String)"evaluation.error.invalid.this.expression", (Object[])new Object[]{result.getText(), howToEvaluateThis.getText()}), null);
        }
        try {
            PsiExpression res = JavaPsiFacade.getInstance((Project)howToEvaluateThis.getProject()).getElementFactory().createExpressionFromText(psiExpression.getText(), howToEvaluateThis.getContext());
            res.putUserData(ADDITIONAL_IMPORTS_KEY, howToEvaluateThis.getUserData(ADDITIONAL_IMPORTS_KEY));
            return res;
        }
        catch (IncorrectOperationException e) {
            throw new EvaluateException(e.getMessage(), (Throwable)e);
        }
    }

    public static PsiExpression castToRuntimeType(PsiExpression expression, Value value) throws EvaluateException {
        if (!(value instanceof ObjectReference)) {
            return expression;
        }
        ReferenceType valueType = ((ObjectReference)value).referenceType();
        if (valueType == null) {
            return expression;
        }
        Project project2 = expression.getProject();
        PsiType type = RuntimeTypeEvaluator.getCastableRuntimeType(project2, value);
        if (type == null) {
            return expression;
        }
        PsiElementFactory elementFactory = JavaPsiFacade.getElementFactory((Project)project2);
        String typeName = type.getCanonicalText();
        try {
            PsiParenthesizedExpression parenthExpression = (PsiParenthesizedExpression)elementFactory.createExpressionFromText("((" + typeName + ")expression)", null);
            ((PsiTypeCastExpression)parenthExpression.getExpression()).getOperand().replace((PsiElement)expression);
            Set imports = (Set)expression.getUserData(ADDITIONAL_IMPORTS_KEY);
            if (imports == null) {
                imports = new SmartHashSet();
            }
            imports.add(typeName);
            parenthExpression.putUserData(ADDITIONAL_IMPORTS_KEY, (Object)imports);
            return parenthExpression;
        }
        catch (IncorrectOperationException e) {
            throw new EvaluateException(DebuggerBundle.message((String)"error.invalid.type.name", (Object[])new Object[]{typeName}), (Throwable)e);
        }
    }

    public static String normalize(String qualifiedName, PsiElement contextElement, Project project2) {
        if (contextElement == null) {
            return qualifiedName;
        }
        JavaPsiFacade facade = JavaPsiFacade.getInstance((Project)project2);
        PsiClass aClass = facade.findClass(qualifiedName, GlobalSearchScope.allScope((Project)project2));
        if (aClass != null) {
            return DebuggerTreeNodeExpression.normalizePsiClass(aClass, contextElement, facade.getResolveHelper());
        }
        return qualifiedName;
    }

    private static String normalizePsiClass(PsiClass psiClass, PsiElement contextElement, PsiResolveHelper helper) {
        String name2 = psiClass.getName();
        PsiClass aClass = helper.resolveReferencedClass(name2, contextElement);
        if (psiClass.equals(aClass)) {
            return name2;
        }
        PsiClass parentClass = psiClass.getContainingClass();
        if (parentClass != null) {
            return DebuggerTreeNodeExpression.normalizePsiClass(parentClass, contextElement, helper) + "." + name2;
        }
        return psiClass.getQualifiedName();
    }

    public static PsiExpression getEvaluationExpression(DebuggerTreeNodeImpl node, DebuggerContextImpl context) throws EvaluateException {
        if (node.getDescriptor() instanceof ValueDescriptorImpl) {
            throw new IllegalStateException("Not supported any more");
        }
        LOG.error(node.getDescriptor() != null ? node.getDescriptor().getClass().getName() : "null");
        return null;
    }

    public static TextWithImports createEvaluationText(DebuggerTreeNodeImpl node, DebuggerContextImpl context) throws EvaluateException {
        EvaluateException[] ex = new EvaluateException[]{null};
        TextWithImports textWithImports = (TextWithImports)PsiDocumentManager.getInstance((Project)context.getProject()).commitAndRunReadAction(() -> {
            try {
                PsiExpression expressionText = DebuggerTreeNodeExpression.getEvaluationExpression(node, context);
                if (expressionText != null) {
                    return new TextWithImportsImpl((PsiElement)expressionText);
                }
            }
            catch (EvaluateException e) {
                ex[0] = e;
            }
            return null;
        });
        if (ex[0] != null) {
            throw ex[0];
        }
        return textWithImports;
    }

    private static class IncorrectOperationRuntimeException
    extends RuntimeException {
        private final IncorrectOperationException myException;

        public IncorrectOperationRuntimeException(IncorrectOperationException exception) {
            this.myException = exception;
        }

        public IncorrectOperationException getException() {
            return this.myException;
        }
    }
}

