/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.debugger.ui.impl;

import com.intellij.debugger.impl.DebuggerContextImpl;
import com.intellij.debugger.impl.DebuggerSession;
import com.intellij.debugger.impl.DebuggerStateManager;
import com.intellij.debugger.ui.impl.UpdatableDebuggerView;
import com.intellij.debugger.ui.impl.watch.DebuggerTree;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.ActionPopupMenu;
import com.intellij.openapi.actionSystem.DataKey;
import com.intellij.openapi.actionSystem.DataProvider;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.wm.IdeFocusManager;
import com.intellij.openapi.wm.ex.IdeFocusTraversalPolicy;
import com.intellij.ui.PopupHandler;
import com.intellij.util.SingleAlarm;
import com.intellij.xdebugger.impl.ui.DebuggerUIUtil;
import com.sun.jdi.VMDisconnectedException;
import java.awt.Component;
import java.awt.Container;
import java.awt.FocusTraversalPolicy;
import java.awt.event.MouseListener;
import javax.swing.JComponent;

public abstract class DebuggerTreePanel
extends UpdatableDebuggerView
implements DataProvider,
Disposable {
    public static final DataKey<DebuggerTreePanel> DATA_KEY = DataKey.create((String)"DebuggerPanel");
    private final SingleAlarm myRebuildAlarm = new SingleAlarm(() -> {
        try {
            DebuggerContextImpl context = this.getContext();
            if (context.getDebuggerSession() != null) {
                this.getTree().rebuild(context);
            }
        }
        catch (VMDisconnectedException vMDisconnectedException) {
            // empty catch block
        }
    }, 100);
    protected DebuggerTree myTree = this.createTreeView();

    public DebuggerTreePanel(Project project2, DebuggerStateManager stateManager) {
        super(project2, stateManager);
        final PopupHandler popupHandler = new PopupHandler(){

            public void invokePopup(Component comp, int x, int y) {
                ActionPopupMenu popupMenu = DebuggerTreePanel.this.createPopupMenu();
                if (popupMenu != null) {
                    DebuggerTreePanel.this.myTree.myTipManager.registerPopup(popupMenu.getComponent()).show(comp, x, y);
                }
            }
        };
        this.myTree.addMouseListener((MouseListener)popupHandler);
        this.setFocusTraversalPolicy((FocusTraversalPolicy)new IdeFocusTraversalPolicy(){

            public Component getDefaultComponentImpl(Container focusCycleRoot) {
                return DebuggerTreePanel.this.myTree;
            }
        });
        this.registerDisposable(new Disposable(){

            public void dispose() {
                DebuggerTreePanel.this.myTree.removeMouseListener((MouseListener)popupHandler);
            }
        });
        DebuggerUIUtil.registerActionOnComponent((String)"Debugger.MarkObject", (JComponent)((Object)this.myTree), (Disposable)this);
    }

    protected abstract DebuggerTree createTreeView();

    @Override
    protected void changeEvent(DebuggerContextImpl newContext, DebuggerSession.Event event) {
        super.changeEvent(newContext, event);
        if (event == DebuggerSession.Event.DISPOSE) {
            this.getTree().getNodeFactory().dispose();
        }
    }

    @Override
    protected void rebuild(DebuggerSession.Event event) {
        this.myRebuildAlarm.cancelAndRequest();
    }

    @Override
    public void dispose() {
        Disposer.dispose((Disposable)this.myRebuildAlarm);
        try {
            super.dispose();
        }
        finally {
            DebuggerTree tree = this.myTree;
            if (tree != null) {
                Disposer.dispose((Disposable)tree);
            }
            this.myTree = null;
        }
    }

    protected abstract ActionPopupMenu createPopupMenu();

    public final DebuggerTree getTree() {
        return this.myTree;
    }

    public void clear() {
        this.myTree.removeAllChildren();
    }

    public Object getData(String dataId) {
        if (DATA_KEY.is(dataId)) {
            return this;
        }
        return null;
    }

    @Override
    public void requestFocus() {
        IdeFocusManager.getGlobalInstance().doWhenFocusSettlesDown(() -> IdeFocusManager.getGlobalInstance().requestFocus((Component)((Object)this.getTree()), true));
    }
}

