/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.debugger.ui;

import com.intellij.debugger.DebuggerBundle;
import com.intellij.debugger.ui.XBreakpointClassGroup;
import com.intellij.debugger.ui.breakpoints.Breakpoint;
import com.intellij.debugger.ui.breakpoints.BreakpointManager;
import com.intellij.icons.AllIcons;
import com.intellij.xdebugger.breakpoints.XBreakpoint;
import com.intellij.xdebugger.breakpoints.ui.XBreakpointGroupingRule;
import java.util.Collection;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class XBreakpointGroupingByClassRule<B>
extends XBreakpointGroupingRule<B, XBreakpointClassGroup> {
    XBreakpointGroupingByClassRule() {
        super("XBreakpointGroupingByClassRule", DebuggerBundle.message((String)"rule.name.group.by.class", (Object[])new Object[0]));
    }

    public int getPriority() {
        return 400;
    }

    public XBreakpointClassGroup getGroup(@NotNull B b, @NotNull Collection<XBreakpointClassGroup> groups) {
        if (b == null) {
            XBreakpointGroupingByClassRule.$$$reportNull$$$0(0);
        }
        if (groups == null) {
            XBreakpointGroupingByClassRule.$$$reportNull$$$0(1);
        }
        if (b instanceof XBreakpoint) {
            Breakpoint javaBreakpoint = BreakpointManager.getJavaBreakpoint((XBreakpoint)b);
            if (javaBreakpoint == null) {
                return null;
            }
            String className = javaBreakpoint.getShortClassName();
            String packageName = javaBreakpoint.getPackageName();
            if (className == null) {
                return null;
            }
            for (XBreakpointClassGroup group : groups) {
                if (!group.getClassName().equals(className) || !group.getPackageName().equals(packageName)) continue;
                return group;
            }
            return new XBreakpointClassGroup(packageName, className);
        }
        return null;
    }

    @Nullable
    public Icon getIcon() {
        return AllIcons.Actions.GroupByClass;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[0] = "b";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[0] = "groups";
                break;
            }
        }
        objectArray[1] = "com/intellij/debugger/ui/XBreakpointGroupingByClassRule";
        objectArray[2] = "getGroup";
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

