/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.debugger.settings;

import com.intellij.debugger.impl.DebuggerUtilsEx;
import com.intellij.debugger.settings.CapturePoint;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.components.PersistentStateComponent;
import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.components.State;
import com.intellij.openapi.components.Storage;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.InvalidDataException;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.ui.classFilter.ClassFilter;
import com.intellij.util.EventDispatcher;
import com.intellij.util.containers.hash.LinkedHashMap;
import com.intellij.util.xmlb.SerializationFilter;
import com.intellij.util.xmlb.SkipDefaultsSerializationFilter;
import com.intellij.util.xmlb.XmlSerializer;
import com.intellij.util.xmlb.annotations.Transient;
import com.intellij.util.xmlb.annotations.XCollection;
import java.util.ArrayList;
import java.util.Collections;
import java.util.EventListener;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.jdom.Element;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@State(name="DebuggerSettings", defaultStateAsResource=true, storages={@Storage(value="debugger.xml"), @Storage(value="other.xml", deprecated=true)})
public class DebuggerSettings
implements Cloneable,
PersistentStateComponent<Element> {
    private static final Logger LOG = Logger.getInstance(DebuggerSettings.class);
    public static final int SOCKET_TRANSPORT = 0;
    public static final int SHMEM_TRANSPORT = 1;
    @NonNls
    public static final String SUSPEND_ALL = "SuspendAll";
    @NonNls
    public static final String SUSPEND_THREAD = "SuspendThread";
    @NonNls
    public static final String SUSPEND_NONE = "SuspendNone";
    @NonNls
    public static final String RUN_HOTSWAP_ALWAYS = "RunHotswapAlways";
    @NonNls
    public static final String RUN_HOTSWAP_NEVER = "RunHotswapNever";
    @NonNls
    public static final String RUN_HOTSWAP_ASK = "RunHotswapAsk";
    @NonNls
    public static final String EVALUATE_FINALLY_ALWAYS = "EvaluateFinallyAlways";
    @NonNls
    public static final String EVALUATE_FINALLY_NEVER = "EvaluateFinallyNever";
    @NonNls
    public static final String EVALUATE_FINALLY_ASK = "EvaluateFinallyAsk";
    public boolean TRACING_FILTERS_ENABLED = true;
    public int DEBUGGER_TRANSPORT;
    public boolean FORCE_CLASSIC_VM = true;
    public boolean DISABLE_JIT;
    public boolean SHOW_ALTERNATIVE_SOURCE = true;
    public boolean HOTSWAP_IN_BACKGROUND = true;
    public boolean SKIP_SYNTHETIC_METHODS = true;
    public boolean SKIP_CONSTRUCTORS;
    public boolean SKIP_GETTERS;
    public boolean SKIP_CLASSLOADERS = true;
    public String RUN_HOTSWAP_AFTER_COMPILE = "RunHotswapAsk";
    public boolean COMPILE_BEFORE_HOTSWAP = true;
    public boolean HOTSWAP_HANG_WARNING_ENABLED = false;
    public volatile boolean WATCH_RETURN_VALUES = false;
    public volatile boolean AUTO_VARIABLES_MODE = false;
    public volatile boolean KILL_PROCESS_IMMEDIATELY = false;
    public String EVALUATE_FINALLY_ON_POP_FRAME = "EvaluateFinallyAsk";
    public boolean RESUME_ONLY_CURRENT_THREAD = false;
    private ClassFilter[] mySteppingFilters = ClassFilter.EMPTY_ARRAY;
    public boolean INSTRUMENTING_AGENT = true;
    private List<CapturePoint> myCapturePoints = new ArrayList<CapturePoint>();
    public boolean CAPTURE_VARIABLES;
    private final EventDispatcher<CapturePointsSettingsListener> myDispatcher = EventDispatcher.create(CapturePointsSettingsListener.class);
    private Map<String, ContentState> myContentStates = new LinkedHashMap();

    @Transient
    public ClassFilter[] getSteppingFilters() {
        ClassFilter[] rv = new ClassFilter[this.mySteppingFilters.length];
        for (int idx = 0; idx < rv.length; ++idx) {
            rv[idx] = this.mySteppingFilters[idx].clone();
        }
        return rv;
    }

    public static DebuggerSettings getInstance() {
        return (DebuggerSettings)ServiceManager.getService(DebuggerSettings.class);
    }

    public void setSteppingFilters(ClassFilter[] steppingFilters) {
        this.mySteppingFilters = steppingFilters != null ? steppingFilters : ClassFilter.EMPTY_ARRAY;
    }

    @Nullable
    public Element getState() {
        Element state = XmlSerializer.serialize((Object)this, (SerializationFilter)new SkipDefaultsSerializationFilter());
        DebuggerUtilsEx.writeFilters(state, "filter", this.mySteppingFilters);
        for (ContentState eachState : this.myContentStates.values()) {
            Element content;
            if (!eachState.write(content = new Element("content"))) continue;
            state.addContent(content);
        }
        return state;
    }

    public void loadState(@NotNull Element state) {
        if (state == null) {
            DebuggerSettings.$$$reportNull$$$0(0);
        }
        XmlSerializer.deserializeInto((Object)this, (Element)state);
        try {
            this.setSteppingFilters(DebuggerUtilsEx.readFilters(state.getChildren("filter")));
        }
        catch (InvalidDataException e) {
            LOG.error((Throwable)e);
        }
        this.myContentStates.clear();
        for (Element content : state.getChildren("content")) {
            ContentState contentState = new ContentState(content);
            this.myContentStates.put(contentState.getType(), contentState);
        }
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof DebuggerSettings)) {
            return false;
        }
        DebuggerSettings secondSettings = (DebuggerSettings)obj;
        return this.TRACING_FILTERS_ENABLED == secondSettings.TRACING_FILTERS_ENABLED && this.DEBUGGER_TRANSPORT == secondSettings.DEBUGGER_TRANSPORT && StringUtil.equals((CharSequence)this.EVALUATE_FINALLY_ON_POP_FRAME, (CharSequence)secondSettings.EVALUATE_FINALLY_ON_POP_FRAME) && this.FORCE_CLASSIC_VM == secondSettings.FORCE_CLASSIC_VM && this.DISABLE_JIT == secondSettings.DISABLE_JIT && this.SHOW_ALTERNATIVE_SOURCE == secondSettings.SHOW_ALTERNATIVE_SOURCE && this.KILL_PROCESS_IMMEDIATELY == secondSettings.KILL_PROCESS_IMMEDIATELY && this.HOTSWAP_IN_BACKGROUND == secondSettings.HOTSWAP_IN_BACKGROUND && this.SKIP_SYNTHETIC_METHODS == secondSettings.SKIP_SYNTHETIC_METHODS && this.SKIP_CLASSLOADERS == secondSettings.SKIP_CLASSLOADERS && this.SKIP_CONSTRUCTORS == secondSettings.SKIP_CONSTRUCTORS && this.SKIP_GETTERS == secondSettings.SKIP_GETTERS && this.RESUME_ONLY_CURRENT_THREAD == secondSettings.RESUME_ONLY_CURRENT_THREAD && this.COMPILE_BEFORE_HOTSWAP == secondSettings.COMPILE_BEFORE_HOTSWAP && this.HOTSWAP_HANG_WARNING_ENABLED == secondSettings.HOTSWAP_HANG_WARNING_ENABLED && (this.RUN_HOTSWAP_AFTER_COMPILE != null ? this.RUN_HOTSWAP_AFTER_COMPILE.equals(secondSettings.RUN_HOTSWAP_AFTER_COMPILE) : secondSettings.RUN_HOTSWAP_AFTER_COMPILE == null) && DebuggerUtilsEx.filterEquals(this.mySteppingFilters, secondSettings.mySteppingFilters) && this.myCapturePoints.equals(((DebuggerSettings)obj).myCapturePoints);
    }

    public DebuggerSettings clone() {
        try {
            DebuggerSettings cloned = (DebuggerSettings)super.clone();
            cloned.myContentStates = new HashMap<String, ContentState>();
            for (Map.Entry<String, ContentState> entry : this.myContentStates.entrySet()) {
                cloned.myContentStates.put(entry.getKey(), entry.getValue().clone());
            }
            cloned.mySteppingFilters = new ClassFilter[this.mySteppingFilters.length];
            for (int idx = 0; idx < this.mySteppingFilters.length; ++idx) {
                cloned.mySteppingFilters[idx] = this.mySteppingFilters[idx].clone();
            }
            cloned.myCapturePoints = this.cloneCapturePoints();
            return cloned;
        }
        catch (CloneNotSupportedException e) {
            LOG.error((Throwable)e);
            return null;
        }
    }

    List<CapturePoint> cloneCapturePoints() {
        try {
            ArrayList<CapturePoint> res = new ArrayList<CapturePoint>(this.myCapturePoints.size());
            for (CapturePoint point : this.myCapturePoints) {
                res.add(point.clone());
            }
            return res;
        }
        catch (CloneNotSupportedException e) {
            LOG.error((Throwable)e);
            return Collections.emptyList();
        }
    }

    @XCollection(propertyElementName="capture-points")
    public List<CapturePoint> getCapturePoints() {
        return this.myCapturePoints;
    }

    public void setCapturePoints(List<CapturePoint> capturePoints) {
        this.myCapturePoints = capturePoints;
        ((CapturePointsSettingsListener)this.myDispatcher.getMulticaster()).capturePointsChanged();
    }

    public void addCapturePointsSettingsListener(CapturePointsSettingsListener listener, Disposable disposable) {
        this.myDispatcher.addListener((EventListener)listener, disposable);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "state", "com/intellij/debugger/settings/DebuggerSettings", "loadState"));
    }

    public static interface CapturePointsSettingsListener
    extends EventListener {
        public void capturePointsChanged();
    }

    public static class ContentState
    implements Cloneable {
        private final String myType;
        private boolean myMinimized;
        private String mySelectedTab;
        private double mySplitProportion;
        private boolean myDetached;
        private boolean myHorizontalToolbar;
        private boolean myMaximized;

        public ContentState(String type) {
            this.myType = type;
        }

        public ContentState(Element element) {
            this.myType = element.getAttributeValue("type");
            this.myMinimized = Boolean.parseBoolean(element.getAttributeValue("minimized"));
            this.myMaximized = Boolean.parseBoolean(element.getAttributeValue("maximized"));
            this.mySelectedTab = element.getAttributeValue("selected");
            String split = element.getAttributeValue("split");
            if (split != null) {
                this.mySplitProportion = Double.valueOf(split);
            }
            this.myDetached = Boolean.parseBoolean(element.getAttributeValue("detached"));
            this.myHorizontalToolbar = !"false".equalsIgnoreCase(element.getAttributeValue("horizontal"));
        }

        public boolean write(Element element) {
            element.setAttribute("type", this.myType);
            element.setAttribute("minimized", Boolean.valueOf(this.myMinimized).toString());
            element.setAttribute("maximized", Boolean.valueOf(this.myMaximized).toString());
            if (this.mySelectedTab != null) {
                element.setAttribute("selected", this.mySelectedTab);
            }
            element.setAttribute("split", Double.toString(this.mySplitProportion));
            element.setAttribute("detached", Boolean.valueOf(this.myDetached).toString());
            element.setAttribute("horizontal", Boolean.valueOf(this.myHorizontalToolbar).toString());
            return true;
        }

        public String getType() {
            return this.myType;
        }

        public String getSelectedTab() {
            return this.mySelectedTab;
        }

        public boolean isMinimized() {
            return this.myMinimized;
        }

        public void setMinimized(boolean minimized) {
            this.myMinimized = minimized;
        }

        public void setMaximized(boolean maximized) {
            this.myMaximized = maximized;
        }

        public boolean isMaximized() {
            return this.myMaximized;
        }

        public void setSelectedTab(String selectedTab) {
            this.mySelectedTab = selectedTab;
        }

        public void setSplitProportion(double splitProportion) {
            this.mySplitProportion = splitProportion;
        }

        public double getSplitProportion(double defaultValue) {
            return this.mySplitProportion <= 0.0 || this.mySplitProportion >= 1.0 ? defaultValue : this.mySplitProportion;
        }

        public void setDetached(boolean detached) {
            this.myDetached = detached;
        }

        public boolean isDetached() {
            return this.myDetached;
        }

        public boolean isHorizontalToolbar() {
            return this.myHorizontalToolbar;
        }

        public void setHorizontalToolbar(boolean horizontalToolbar) {
            this.myHorizontalToolbar = horizontalToolbar;
        }

        public ContentState clone() throws CloneNotSupportedException {
            return (ContentState)super.clone();
        }
    }
}

