/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.debugger.memory.action.tracking;

import com.intellij.debugger.memory.action.ActionUtil;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.ToggleAction;
import com.intellij.openapi.project.Project;
import com.intellij.xdebugger.memory.component.InstancesTracker;
import com.intellij.xdebugger.memory.tracking.TrackingType;
import com.sun.jdi.ArrayType;
import com.sun.jdi.ReferenceType;
import org.jetbrains.annotations.NotNull;

public class TrackInstancesToggleAction
extends ToggleAction {
    public void update(@NotNull AnActionEvent e) {
        ReferenceType selectedClass;
        if (e == null) {
            TrackInstancesToggleAction.$$$reportNull$$$0(0);
        }
        if ((selectedClass = ActionUtil.getSelectedClass(e)) instanceof ArrayType) {
            e.getPresentation().setEnabled(false);
        } else {
            super.update(e);
        }
    }

    public boolean isSelected(AnActionEvent e) {
        ReferenceType selectedClass = ActionUtil.getSelectedClass(e);
        Project project2 = e.getProject();
        if (project2 != null && selectedClass != null && !project2.isDisposed()) {
            InstancesTracker tracker = InstancesTracker.getInstance((Project)project2);
            return tracker.isTracked(selectedClass.name());
        }
        return false;
    }

    public void setSelected(AnActionEvent e, boolean state) {
        ReferenceType selectedClass = ActionUtil.getSelectedClass(e);
        Project project2 = e.getProject();
        if (selectedClass != null && project2 != null && !project2.isDisposed()) {
            InstancesTracker tracker = InstancesTracker.getInstance((Project)project2);
            boolean isAlreadyTracked = tracker.isTracked(selectedClass.name());
            if (isAlreadyTracked && !state) {
                tracker.remove(selectedClass.name());
            }
            if (!isAlreadyTracked && state) {
                tracker.add(selectedClass.name(), TrackingType.CREATION);
            }
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/debugger/memory/action/tracking/TrackInstancesToggleAction", "update"));
    }
}

