/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.debugger.jdi;

import com.intellij.Patches;
import com.intellij.debugger.engine.DebuggerUtils;
import com.intellij.debugger.impl.DebuggerUtilsEx;
import com.intellij.debugger.jdi.ClassesByNameProvider;
import com.intellij.openapi.util.Ref;
import com.intellij.util.ReflectionUtil;
import com.intellij.util.ThrowableConsumer;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.MultiMap;
import com.sun.jdi.ClassType;
import com.sun.jdi.InterfaceType;
import com.sun.jdi.Location;
import com.sun.jdi.Method;
import com.sun.jdi.ReferenceType;
import java.io.ByteArrayOutputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.org.objectweb.asm.Attribute;
import org.jetbrains.org.objectweb.asm.ClassReader;
import org.jetbrains.org.objectweb.asm.ClassVisitor;
import org.jetbrains.org.objectweb.asm.ClassWriter;
import org.jetbrains.org.objectweb.asm.Label;
import org.jetbrains.org.objectweb.asm.MethodVisitor;
import org.jetbrains.org.objectweb.asm.Type;

public class MethodBytecodeUtil {
    private static final Type OBJECT_TYPE = Type.getObjectType((String)"java/lang/Object");

    private MethodBytecodeUtil() {
    }

    public static void visit(Method method, MethodVisitor methodVisitor, boolean withLineNumbers) {
        MethodBytecodeUtil.visit(method, method.bytecodes(), methodVisitor, withLineNumbers);
    }

    public static void visit(Method method, long maxOffset, MethodVisitor methodVisitor, boolean withLineNumbers) {
        if (maxOffset > 0L) {
            byte[] originalBytecodes;
            byte[] bytecodes = originalBytecodes = method.bytecodes();
            if (maxOffset < (long)originalBytecodes.length) {
                bytecodes = new byte[originalBytecodes.length];
                System.arraycopy(originalBytecodes, 0, bytecodes, 0, (int)maxOffset);
            }
            MethodBytecodeUtil.visit(method, bytecodes, methodVisitor, withLineNumbers);
        }
    }

    public static byte[] getConstantPool(ReferenceType type) {
        if (Patches.JDK_BUG_ID_6822627) {
            try {
                return type.constantPool();
            }
            catch (NullPointerException e) {
                ReflectionUtil.resetField((Object)type, (String)"constantPoolInfoGotten");
                return type.constantPool();
            }
        }
        return type.constantPool();
    }

    private static void visit(final Method method, byte[] bytecodes, final MethodVisitor methodVisitor, boolean withLineNumbers) {
        ReferenceType type = method.declaringType();
        try {
            byte[] constantPool = MethodBytecodeUtil.getConstantPool(type);
            try (ByteArrayBuilderOutputStream bos = new ByteArrayBuilderOutputStream(constantPool.length + 24);
                 DataOutputStream dos = new DataOutputStream(bos);){
                dos.writeInt(-889275714);
                dos.writeInt(52);
                dos.writeShort(type.constantPoolCount());
                dos.write(constantPool);
                dos.writeShort(0);
                dos.writeShort(0);
                dos.writeShort(0);
                dos.writeShort(0);
                dos.writeShort(0);
                dos.writeShort(0);
                dos.writeShort(0);
                ClassReader reader = new ClassReader(bos.getBuffer());
                ClassWriter writer = new ClassWriter(reader, 0);
                String superName = null;
                String[] interfaces = null;
                if (type instanceof ClassType) {
                    ClassType classType = (ClassType)type;
                    ClassType superClass = classType.superclass();
                    superName = superClass != null ? superClass.name() : null;
                    interfaces = (String[])classType.interfaces().stream().map(ReferenceType::name).toArray(String[]::new);
                } else if (type instanceof InterfaceType) {
                    interfaces = (String[])((InterfaceType)type).superinterfaces().stream().map(ReferenceType::name).toArray(String[]::new);
                }
                writer.visit(52, 1, type.name(), type.signature(), superName, interfaces);
                Attribute bootstrapMethods = MethodBytecodeUtil.createBootstrapMethods(reader, writer);
                if (bootstrapMethods != null) {
                    writer.visitAttribute(bootstrapMethods);
                }
                MethodVisitor mv = writer.visitMethod(1, method.name(), method.signature(), method.signature(), null);
                mv.visitAttribute(MethodBytecodeUtil.createCode(writer, method, bytecodes, withLineNumbers));
                new ClassReader(writer.toByteArray()).accept(new ClassVisitor(393216){

                    public MethodVisitor visitMethod(int access, String name2, String desc, String signature, String[] exceptions) {
                        assert (name2.equals(method.name()));
                        return methodVisitor;
                    }
                }, 0);
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    /*
     * Exception decompiling
     */
    @NotNull
    private static Attribute createAttribute(String name, ThrowableConsumer<DataOutputStream, IOException> generator) throws IOException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    @Nullable
    private static Attribute createBootstrapMethods(ClassReader classReader, ClassWriter classWriter) throws IOException {
        HashSet<Short> indys = new HashSet<Short>();
        block4: for (int i = 1; i < classReader.getItemCount(); ++i) {
            int index = classReader.getItem(i);
            int tag = classReader.readByte(index - 1);
            switch (tag) {
                case 5: 
                case 6: {
                    ++i;
                    continue block4;
                }
                case 18: {
                    indys.add(classReader.readShort(index));
                    short s = classReader.readShort(index + 2);
                }
            }
        }
        if (!indys.isEmpty()) {
            int dummyRef = classWriter.newHandle(6, "DummyOwner", "DummyMethod", "", false);
            return MethodBytecodeUtil.createAttribute("BootstrapMethods", (ThrowableConsumer<DataOutputStream, IOException>)((ThrowableConsumer)dos -> {
                dos.writeShort(indys.size());
                for (Short indy : indys) {
                    dos.writeShort(dummyRef);
                    dos.writeShort(0);
                }
            }));
        }
        return null;
    }

    @NotNull
    private static Attribute createCode(ClassWriter cw, Method method, byte[] bytecodes, boolean withLineNumbers) throws IOException {
        Attribute attribute = MethodBytecodeUtil.createAttribute("Code", (ThrowableConsumer<DataOutputStream, IOException>)((ThrowableConsumer)dos -> {
            List<Object> locations;
            dos.writeShort(0);
            dos.writeShort(0);
            dos.writeInt(bytecodes.length);
            dos.write(bytecodes);
            dos.writeShort(0);
            List<Object> list = locations = withLineNumbers ? DebuggerUtilsEx.allLineLocations(method) : Collections.emptyList();
            if (!ContainerUtil.isEmpty(locations)) {
                dos.writeShort(1);
                dos.writeShort(cw.newUTF8("LineNumberTable"));
                dos.writeInt(2 * locations.size() + 2);
                dos.writeShort(locations.size());
                for (Location location : locations) {
                    dos.writeShort((short)location.codeIndex());
                    dos.writeShort(location.lineNumber());
                }
            } else {
                dos.writeShort(0);
            }
        }));
        if (attribute == null) {
            MethodBytecodeUtil.$$$reportNull$$$0(1);
        }
        return attribute;
    }

    public static Type getVarInstructionType(int opcode) {
        switch (opcode) {
            case 22: 
            case 55: {
                return Type.LONG_TYPE;
            }
            case 24: 
            case 57: {
                return Type.DOUBLE_TYPE;
            }
            case 23: 
            case 56: {
                return Type.FLOAT_TYPE;
            }
            case 21: 
            case 54: {
                return Type.INT_TYPE;
            }
        }
        return OBJECT_TYPE;
    }

    @Nullable
    public static Method getLambdaMethod(ReferenceType clsType, final @NotNull ClassesByNameProvider classesByName) {
        List applicableMethods;
        if (classesByName == null) {
            MethodBytecodeUtil.$$$reportNull$$$0(2);
        }
        final Ref methodRef = Ref.create();
        if (DebuggerUtilsEx.isLambdaClassName(clsType.name()) && (applicableMethods = ContainerUtil.filter(clsType.methods(), m -> m.isPublic() && !m.isBridge())).size() == 1) {
            MethodBytecodeUtil.visit((Method)applicableMethods.get(0), new MethodVisitor(393216){

                public void visitMethodInsn(int opcode, String owner2, String name2, String desc, boolean itf) {
                    Method method;
                    ReferenceType cls = (ReferenceType)ContainerUtil.getFirstItem(classesByName.get(owner2));
                    if (cls != null && (method = DebuggerUtils.findMethod((ReferenceType)cls, (String)name2, (String)desc)) != null) {
                        methodRef.setIfNull((Object)method);
                    }
                }
            }, false);
        }
        return (Method)methodRef.get();
    }

    @Nullable
    public static Method getBridgeTargetMethod(final Method method, final @NotNull ClassesByNameProvider classesByName) {
        if (classesByName == null) {
            MethodBytecodeUtil.$$$reportNull$$$0(3);
        }
        final Ref methodRef = Ref.create();
        if (method.isBridge()) {
            MethodBytecodeUtil.visit(method, new MethodVisitor(393216){

                public void visitMethodInsn(int opcode, String owner2, String name2, String desc, boolean itf) {
                    Method method2;
                    if ("java/lang/AbstractMethodError".equals(owner2)) {
                        return;
                    }
                    ReferenceType declaringType = method.declaringType();
                    owner2 = owner2.replace("/", ".");
                    ReferenceType cls = declaringType.name().equals(owner2) ? declaringType : (ReferenceType)ContainerUtil.getFirstItem(classesByName.get(owner2));
                    if (cls != null && (method2 = DebuggerUtils.findMethod((ReferenceType)cls, (String)name2, (String)desc)) != null) {
                        methodRef.setIfNull((Object)method2);
                    }
                }
            }, false);
        }
        return (Method)methodRef.get();
    }

    public static List<Location> removeSameLineLocations(@NotNull List<Location> locations) {
        if (locations == null) {
            MethodBytecodeUtil.$$$reportNull$$$0(4);
        }
        if (locations.size() < 2) {
            return locations;
        }
        MultiMap byMethod = new MultiMap();
        for (Location location : locations) {
            byMethod.putValue((Object)location.method(), (Object)location);
        }
        ArrayList<Location> res = new ArrayList<Location>();
        for (Map.Entry entry : byMethod.entrySet()) {
            res.addAll(MethodBytecodeUtil.removeMethodSameLineLocations((Method)entry.getKey(), (List)entry.getValue()));
        }
        return res;
    }

    private static Collection<Location> removeMethodSameLineLocations(@NotNull Method method, @NotNull List<Location> locations) {
        int locationsSize;
        if (method == null) {
            MethodBytecodeUtil.$$$reportNull$$$0(5);
        }
        if (locations == null) {
            MethodBytecodeUtil.$$$reportNull$$$0(6);
        }
        if ((locationsSize = locations.size()) < 2) {
            return locations;
        }
        final int lineNumber = ((Location)ContainerUtil.getFirstItem(locations)).lineNumber();
        final ArrayList mask = new ArrayList(locationsSize);
        MethodBytecodeUtil.visit(method, new MethodVisitor(393216){
            boolean myNewBlock;
            {
                super(x0);
                this.myNewBlock = true;
            }

            public void visitLineNumber(int line, Label start) {
                if (lineNumber == line) {
                    mask.add(this.myNewBlock);
                    this.myNewBlock = false;
                }
            }

            public void visitInsn(int opcode) {
                if (opcode >= 172 && opcode <= 177 || opcode == 191) {
                    this.myNewBlock = true;
                }
            }

            public void visitJumpInsn(int opcode, Label label) {
                this.myNewBlock = true;
            }
        }, true);
        if (mask.size() == locationsSize) {
            locations.sort(Comparator.comparing(Location::codeIndex));
            ArrayList<Location> res = new ArrayList<Location>(locationsSize);
            int pos = 0;
            for (Location location : locations) {
                if (!((Boolean)mask.get(pos++)).booleanValue()) continue;
                res.add(location);
            }
            return res;
        }
        return locations;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/debugger/jdi/MethodBytecodeUtil";
                break;
            }
            case 2: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "classesByName";
                break;
            }
            case 4: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "locations";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "method";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "createAttribute";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "createCode";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/debugger/jdi/MethodBytecodeUtil";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "getLambdaMethod";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "getBridgeTargetMethod";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "removeSameLineLocations";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "removeMethodSameLineLocations";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static class ByteArrayBuilderOutputStream
    extends ByteArrayOutputStream {
        public ByteArrayBuilderOutputStream(int size) {
            super(size);
        }

        byte[] getBuffer() {
            assert (this.buf.length == this.count) : "Buffer is not fully filled";
            return this.buf;
        }
    }
}

