/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.debugger.impl;

import com.intellij.application.options.CodeStyle;
import com.intellij.debugger.DebuggerBundle;
import com.intellij.debugger.SourcePosition;
import com.intellij.debugger.engine.DebugProcessImpl;
import com.intellij.debugger.engine.DebuggerManagerThreadImpl;
import com.intellij.debugger.engine.DebuggerUtils;
import com.intellij.debugger.engine.JVMNameUtil;
import com.intellij.debugger.engine.JavaDebugProcess;
import com.intellij.debugger.engine.SourcePositionHighlighter;
import com.intellij.debugger.engine.SuspendContextImpl;
import com.intellij.debugger.engine.evaluation.CodeFragmentFactory;
import com.intellij.debugger.engine.evaluation.CodeFragmentFactoryContextWrapper;
import com.intellij.debugger.engine.evaluation.CodeFragmentKind;
import com.intellij.debugger.engine.evaluation.DefaultCodeFragmentFactory;
import com.intellij.debugger.engine.evaluation.EvaluateException;
import com.intellij.debugger.engine.evaluation.EvaluateExceptionUtil;
import com.intellij.debugger.engine.evaluation.EvaluationContext;
import com.intellij.debugger.engine.evaluation.EvaluationContextImpl;
import com.intellij.debugger.engine.evaluation.TextWithImports;
import com.intellij.debugger.engine.evaluation.TextWithImportsImpl;
import com.intellij.debugger.engine.evaluation.expression.EvaluatorBuilder;
import com.intellij.debugger.engine.evaluation.expression.ExpressionEvaluator;
import com.intellij.debugger.engine.evaluation.expression.UnBoxingEvaluator;
import com.intellij.debugger.engine.requests.RequestManagerImpl;
import com.intellij.debugger.impl.DebuggerSession;
import com.intellij.debugger.impl.EditorTextProvider;
import com.intellij.debugger.jdi.VirtualMachineProxyImpl;
import com.intellij.debugger.requests.Requestor;
import com.intellij.debugger.ui.breakpoints.Breakpoint;
import com.intellij.debugger.ui.tree.DebuggerTreeNode;
import com.intellij.execution.filters.ExceptionFilters;
import com.intellij.execution.filters.LineNumbersMapping;
import com.intellij.execution.filters.TextConsoleBuilder;
import com.intellij.execution.filters.TextConsoleBuilderFactory;
import com.intellij.execution.ui.ConsoleView;
import com.intellij.execution.ui.RunnerLayoutUi;
import com.intellij.execution.ui.layout.impl.RunnerContentUi;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.fileEditor.OpenFileDescriptor;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.fileTypes.StdFileTypes;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ProjectFileIndex;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.DefaultJDOMExternalizer;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.InvalidDataException;
import com.intellij.openapi.util.JDOMExternalizable;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.WriteExternalException;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.pom.Navigatable;
import com.intellij.psi.JavaRecursiveElementVisitor;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassInitializer;
import com.intellij.psi.PsiCodeBlock;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiLambdaExpression;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiParameterListOwner;
import com.intellij.psi.PsiStatement;
import com.intellij.psi.PsiType;
import com.intellij.psi.SyntaxTraverser;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.ui.classFilter.ClassFilter;
import com.intellij.ui.content.Content;
import com.intellij.unscramble.ThreadDumpPanel;
import com.intellij.unscramble.ThreadState;
import com.intellij.util.DocumentUtil;
import com.intellij.util.SmartList;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.xdebugger.XDebugSession;
import com.intellij.xdebugger.XDebuggerManager;
import com.intellij.xdebugger.XSourcePosition;
import com.intellij.xdebugger.impl.XSourcePositionImpl;
import com.intellij.xdebugger.impl.ui.ExecutionPointHighlighter;
import com.sun.jdi.AbsentInformationException;
import com.sun.jdi.ArrayReference;
import com.sun.jdi.ArrayType;
import com.sun.jdi.BooleanValue;
import com.sun.jdi.CharValue;
import com.sun.jdi.ClassType;
import com.sun.jdi.InterfaceType;
import com.sun.jdi.Location;
import com.sun.jdi.Method;
import com.sun.jdi.ObjectCollectedException;
import com.sun.jdi.ObjectReference;
import com.sun.jdi.ReferenceType;
import com.sun.jdi.StringReference;
import com.sun.jdi.Value;
import com.sun.jdi.event.Event;
import com.sun.jdi.event.EventSet;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Function;
import java.util.regex.PatternSyntaxException;
import javax.swing.JComponent;
import org.jdom.Attribute;
import org.jdom.Element;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class DebuggerUtilsEx
extends DebuggerUtils {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.debugger.impl.DebuggerUtilsEx");
    private static Set<String> myCharOrIntegers;
    private static int myThreadDumpsCount;
    private static int myCurrentThreadDumpId;
    private static final String THREAD_DUMP_CONTENT_PREFIX = "Dump";
    private static final Key<Map<String, String>> DEBUGGER_ALTERNATIVE_SOURCE_MAPPING;
    public static final Comparator<Method> LAMBDA_ORDINAL_COMPARATOR;

    public static List<CodeFragmentFactory> getCodeFragmentFactories(@Nullable PsiElement context) {
        DefaultCodeFragmentFactory defaultFactory = DefaultCodeFragmentFactory.getInstance();
        CodeFragmentFactory[] providers = (CodeFragmentFactory[])ApplicationManager.getApplication().getExtensions(CodeFragmentFactory.EXTENSION_POINT_NAME);
        ArrayList<CodeFragmentFactory> suitableFactories = new ArrayList<CodeFragmentFactory>(providers.length);
        if (providers.length > 0) {
            for (CodeFragmentFactory factory : providers) {
                if (factory == defaultFactory || !factory.isContextAccepted(context)) continue;
                suitableFactories.add(factory);
            }
        }
        suitableFactories.add(defaultFactory);
        return suitableFactories;
    }

    public static PsiMethod findPsiMethod(PsiFile file, int offset) {
        PsiElement element = null;
        while (offset >= 0 && (element = file.findElementAt(offset)) == null) {
            --offset;
        }
        while (element != null) {
            if (element instanceof PsiClass || element instanceof PsiLambdaExpression) {
                return null;
            }
            if (element instanceof PsiMethod) {
                return (PsiMethod)element;
            }
            element = element.getParent();
        }
        return null;
    }

    public static boolean isAssignableFrom(@NotNull String baseQualifiedName, @NotNull ReferenceType checkedType) {
        if (baseQualifiedName == null) {
            DebuggerUtilsEx.$$$reportNull$$$0(0);
        }
        if (checkedType == null) {
            DebuggerUtilsEx.$$$reportNull$$$0(1);
        }
        if ("java.lang.Object".equals(baseQualifiedName)) {
            return true;
        }
        return DebuggerUtilsEx.getSuperClass(baseQualifiedName, checkedType) != null;
    }

    public static ReferenceType getSuperClass(@NotNull String baseQualifiedName, @NotNull ReferenceType checkedType) {
        if (baseQualifiedName == null) {
            DebuggerUtilsEx.$$$reportNull$$$0(2);
        }
        if (checkedType == null) {
            DebuggerUtilsEx.$$$reportNull$$$0(3);
        }
        if (baseQualifiedName.equals(checkedType.name())) {
            return checkedType;
        }
        if (checkedType instanceof ClassType) {
            ReferenceType superClass;
            ClassType classType = (ClassType)checkedType;
            ClassType superClassType = classType.superclass();
            if (superClassType != null && (superClass = DebuggerUtilsEx.getSuperClass(baseQualifiedName, superClassType)) != null) {
                return superClass;
            }
            List<InterfaceType> interfaces = classType.allInterfaces();
            for (InterfaceType iface : interfaces) {
                ReferenceType superClass2 = DebuggerUtilsEx.getSuperClass(baseQualifiedName, iface);
                if (superClass2 == null) continue;
                return superClass2;
            }
        }
        if (checkedType instanceof InterfaceType) {
            List<InterfaceType> list = ((InterfaceType)checkedType).superinterfaces();
            for (InterfaceType superInterface : list) {
                ReferenceType superClass = DebuggerUtilsEx.getSuperClass(baseQualifiedName, superInterface);
                if (superClass == null) continue;
                return superClass;
            }
        }
        return null;
    }

    public static boolean valuesEqual(Value val1, Value val2) {
        if (val1 == null) {
            return val2 == null;
        }
        if (val2 == null) {
            return false;
        }
        if (val1 instanceof StringReference && val2 instanceof StringReference) {
            return ((StringReference)val1).value().equals(((StringReference)val2).value());
        }
        return val1.equals(val2);
    }

    public static String getValueOrErrorAsString(EvaluationContext evaluationContext, Value value) {
        try {
            return DebuggerUtilsEx.getValueAsString((EvaluationContext)evaluationContext, (Value)value);
        }
        catch (EvaluateException e) {
            return e.getMessage();
        }
    }

    public static boolean isCharOrInteger(Value value) {
        return value instanceof CharValue || DebuggerUtilsEx.isInteger((Value)value);
    }

    public static boolean isCharOrIntegerArray(Value value) {
        if (value == null) {
            return false;
        }
        if (myCharOrIntegers == null) {
            myCharOrIntegers = new HashSet<String>();
            myCharOrIntegers.add("C");
            myCharOrIntegers.add("B");
            myCharOrIntegers.add("S");
            myCharOrIntegers.add("I");
            myCharOrIntegers.add("J");
        }
        String signature = value.type().signature();
        int i = 0;
        while (signature.charAt(i) == '[') {
            ++i;
        }
        if (i == 0) {
            return false;
        }
        signature = signature.substring(i);
        return myCharOrIntegers.contains(signature);
    }

    public static ClassFilter create(Element element) throws InvalidDataException {
        ClassFilter filter = new ClassFilter();
        DefaultJDOMExternalizer.readExternal((Object)filter, (Element)element);
        return filter;
    }

    private static boolean isFiltered(ClassFilter classFilter, String qName) {
        if (!classFilter.isEnabled()) {
            return false;
        }
        try {
            if (classFilter.matches(qName)) {
                return true;
            }
        }
        catch (PatternSyntaxException e) {
            LOG.debug((Throwable)e);
        }
        return false;
    }

    public static boolean isFiltered(@NotNull String qName, ClassFilter[] classFilters) {
        if (qName == null) {
            DebuggerUtilsEx.$$$reportNull$$$0(4);
        }
        return DebuggerUtilsEx.isFiltered(qName, Arrays.asList(classFilters));
    }

    public static boolean isFiltered(@NotNull String qName, List<ClassFilter> classFilters) {
        if (qName == null) {
            DebuggerUtilsEx.$$$reportNull$$$0(5);
        }
        if (qName.indexOf(91) != -1) {
            return false;
        }
        return classFilters.stream().anyMatch(filter -> {
            if (qName == null) {
                DebuggerUtilsEx.$$$reportNull$$$0(31);
            }
            return DebuggerUtilsEx.isFiltered(filter, qName);
        });
    }

    public static int getEnabledNumber(ClassFilter[] classFilters) {
        return (int)Arrays.stream(classFilters).filter(ClassFilter::isEnabled).count();
    }

    public static ClassFilter[] readFilters(List<Element> children) throws InvalidDataException {
        if (ContainerUtil.isEmpty(children)) {
            return ClassFilter.EMPTY_ARRAY;
        }
        ClassFilter[] filters = new ClassFilter[children.size()];
        int size = children.size();
        for (int i = 0; i < size; ++i) {
            filters[i] = DebuggerUtilsEx.create(children.get(i));
        }
        return filters;
    }

    public static void writeFilters(Element parentNode, @NonNls String tagName, ClassFilter[] filters) throws WriteExternalException {
        for (ClassFilter filter : filters) {
            Element element = new Element(tagName);
            parentNode.addContent(element);
            DefaultJDOMExternalizer.writeExternal((Object)filter, (Element)element);
        }
    }

    public static boolean filterEquals(ClassFilter[] filters1, ClassFilter[] filters2) {
        if (filters1.length != filters2.length) {
            return false;
        }
        HashSet f1 = new HashSet(Math.max((int)((float)filters1.length / 0.75f) + 1, 16));
        HashSet f2 = new HashSet(Math.max((int)((float)filters2.length / 0.75f) + 1, 16));
        Collections.addAll(f1, filters1);
        Collections.addAll(f2, filters2);
        return f2.equals(f1);
    }

    private static boolean elementListsEqual(List<Element> l1, List<Element> l2) {
        if (l1 == null) {
            return l2 == null;
        }
        if (l2 == null) {
            return false;
        }
        if (l1.size() != l2.size()) {
            return false;
        }
        Iterator<Element> i1 = l1.iterator();
        for (Element aL2 : l2) {
            Element elem1 = i1.next();
            if (DebuggerUtilsEx.elementsEqual(elem1, aL2)) continue;
            return false;
        }
        return true;
    }

    private static boolean attributeListsEqual(List<Attribute> l1, List<Attribute> l2) {
        if (l1 == null) {
            return l2 == null;
        }
        if (l2 == null) {
            return false;
        }
        if (l1.size() != l2.size()) {
            return false;
        }
        Iterator<Attribute> i1 = l1.iterator();
        for (Attribute aL2 : l2) {
            Attribute attr1 = i1.next();
            if (Comparing.equal((String)attr1.getName(), (String)aL2.getName()) && Comparing.equal((String)attr1.getValue(), (String)aL2.getValue())) continue;
            return false;
        }
        return true;
    }

    public static boolean elementsEqual(Element e1, Element e2) {
        if (e1 == null) {
            return e2 == null;
        }
        if (!Comparing.equal((String)e1.getName(), (String)e2.getName())) {
            return false;
        }
        if (!DebuggerUtilsEx.elementListsEqual(e1.getChildren(), e2.getChildren())) {
            return false;
        }
        return DebuggerUtilsEx.attributeListsEqual(e1.getAttributes(), e2.getAttributes());
    }

    public static boolean externalizableEqual(JDOMExternalizable e1, JDOMExternalizable e2) {
        Element root1 = new Element("root");
        Element root2 = new Element("root");
        try {
            e1.writeExternal(root1);
        }
        catch (WriteExternalException e) {
            LOG.debug((Throwable)e);
        }
        try {
            e2.writeExternal(root2);
        }
        catch (WriteExternalException e) {
            LOG.debug((Throwable)e);
        }
        return DebuggerUtilsEx.elementsEqual(root1, root2);
    }

    @NotNull
    public static List<Pair<Breakpoint, Event>> getEventDescriptors(@Nullable SuspendContextImpl suspendContext) {
        EventSet events;
        DebuggerManagerThreadImpl.assertIsManagerThread();
        if (suspendContext != null && !ContainerUtil.isEmpty((Collection)(events = suspendContext.getEventSet()))) {
            List eventDescriptors = ContainerUtil.newSmartList();
            RequestManagerImpl requestManager = suspendContext.getDebugProcess().getRequestsManager();
            for (Event event : events) {
                Requestor requestor = requestManager.findRequestor(event.request());
                if (!(requestor instanceof Breakpoint)) continue;
                eventDescriptors.add(Pair.create((Object)((Breakpoint)requestor), (Object)event));
            }
            List list = eventDescriptors;
            if (list == null) {
                DebuggerUtilsEx.$$$reportNull$$$0(6);
            }
            return list;
        }
        List<Pair<Breakpoint, Event>> list = Collections.emptyList();
        if (list == null) {
            DebuggerUtilsEx.$$$reportNull$$$0(7);
        }
        return list;
    }

    public static TextWithImports getEditorText(Editor editor) {
        if (editor == null) {
            return null;
        }
        Project project2 = editor.getProject();
        if (project2 == null) {
            return null;
        }
        String defaultExpression = editor.getSelectionModel().getSelectedText();
        if (defaultExpression == null) {
            TextWithImports editorText;
            EditorTextProvider textProvider;
            PsiElement elementAtCursor;
            int offset = editor.getCaretModel().getOffset();
            PsiFile psiFile = PsiDocumentManager.getInstance((Project)project2).getPsiFile(editor.getDocument());
            if (psiFile != null && (elementAtCursor = psiFile.findElementAt(offset)) != null && (textProvider = (EditorTextProvider)EditorTextProvider.EP.forLanguage(elementAtCursor.getLanguage())) != null && (editorText = textProvider.getEditorText(elementAtCursor)) != null) {
                return editorText;
            }
        } else {
            return new TextWithImportsImpl(CodeFragmentKind.EXPRESSION, defaultExpression);
        }
        return null;
    }

    public static void addThreadDump(Project project2, List<ThreadState> threads, RunnerLayoutUi ui, DebuggerSession session) {
        TextConsoleBuilder consoleBuilder = TextConsoleBuilderFactory.getInstance().createBuilder(project2);
        consoleBuilder.filters(ExceptionFilters.getFilters((GlobalSearchScope)session.getSearchScope()));
        ConsoleView consoleView = consoleBuilder.getConsole();
        DefaultActionGroup toolbarActions = new DefaultActionGroup();
        consoleView.allowHeavyFilters();
        ThreadDumpPanel panel = new ThreadDumpPanel(project2, consoleView, toolbarActions, threads);
        String id = "Dump #" + myCurrentThreadDumpId;
        Content content = ui.createContent(id, (JComponent)panel, id, null, null);
        content.putUserData(RunnerContentUi.LIGHTWEIGHT_CONTENT_MARKER, (Object)Boolean.TRUE);
        content.setCloseable(true);
        content.setDescription("Thread Dump");
        ui.addContent(content);
        ui.selectAndFocus(content, true, true);
        ++myThreadDumpsCount;
        ++myCurrentThreadDumpId;
        Disposer.register((Disposable)content, (Disposable)new Disposable(){

            public void dispose() {
                myThreadDumpsCount--;
                if (myThreadDumpsCount == 0) {
                    myCurrentThreadDumpId = 1;
                }
            }
        });
        Disposer.register((Disposable)content, (Disposable)consoleView);
        ui.selectAndFocus(content, true, false);
        if (threads.size() > 0) {
            panel.selectStackFrame(0);
        }
    }

    @Deprecated
    public static void keep(Value value, EvaluationContext context) {
        context.keep(value);
    }

    public static StringReference mirrorOfString(@NotNull String s, VirtualMachineProxyImpl virtualMachineProxy, EvaluationContext context) throws EvaluateException {
        if (s == null) {
            DebuggerUtilsEx.$$$reportNull$$$0(8);
        }
        return (StringReference)context.computeAndKeep(() -> {
            if (s == null) {
                DebuggerUtilsEx.$$$reportNull$$$0(30);
            }
            return virtualMachineProxy.mirrorOf(s);
        });
    }

    public static ArrayReference mirrorOfArray(@NotNull ArrayType arrayType, int dimension, EvaluationContext context) throws EvaluateException {
        if (arrayType == null) {
            DebuggerUtilsEx.$$$reportNull$$$0(9);
        }
        return (ArrayReference)context.computeAndKeep(() -> {
            if (arrayType == null) {
                DebuggerUtilsEx.$$$reportNull$$$0(29);
            }
            return context.getDebugProcess().newInstance(arrayType, dimension);
        });
    }

    public abstract DebuggerTreeNode getSelectedNode(DataContext var1);

    public abstract EvaluatorBuilder getEvaluatorBuilder();

    @NotNull
    public static CodeFragmentFactory getCodeFragmentFactory(@Nullable PsiElement context, @Nullable FileType fileType) {
        DefaultCodeFragmentFactory defaultFactory = DefaultCodeFragmentFactory.getInstance();
        if (fileType == null) {
            if (context == null) {
                DefaultCodeFragmentFactory defaultCodeFragmentFactory = defaultFactory;
                if (defaultCodeFragmentFactory == null) {
                    DebuggerUtilsEx.$$$reportNull$$$0(10);
                }
                return defaultCodeFragmentFactory;
            }
            PsiFile file = context.getContainingFile();
            fileType = file != null ? file.getFileType() : null;
        }
        for (CodeFragmentFactory factory : (CodeFragmentFactory[])ApplicationManager.getApplication().getExtensions(CodeFragmentFactory.EXTENSION_POINT_NAME)) {
            if (factory == defaultFactory || fileType != null && !factory.getFileType().equals(fileType) || !factory.isContextAccepted(context)) continue;
            CodeFragmentFactory codeFragmentFactory = factory;
            if (codeFragmentFactory == null) {
                DebuggerUtilsEx.$$$reportNull$$$0(11);
            }
            return codeFragmentFactory;
        }
        DefaultCodeFragmentFactory defaultCodeFragmentFactory = defaultFactory;
        if (defaultCodeFragmentFactory == null) {
            DebuggerUtilsEx.$$$reportNull$$$0(12);
        }
        return defaultCodeFragmentFactory;
    }

    @NotNull
    public static CodeFragmentFactory findAppropriateCodeFragmentFactory(TextWithImports text, PsiElement context) {
        CodeFragmentFactory factory = (CodeFragmentFactory)ReadAction.compute(() -> DebuggerUtilsEx.getCodeFragmentFactory(context, text.getFileType()));
        CodeFragmentFactoryContextWrapper codeFragmentFactoryContextWrapper = new CodeFragmentFactoryContextWrapper(factory);
        if (codeFragmentFactoryContextWrapper == null) {
            DebuggerUtilsEx.$$$reportNull$$$0(13);
        }
        return codeFragmentFactoryContextWrapper;
    }

    public static String methodKey(Method m) {
        return m.declaringType().name() + '.' + m.name() + m.signature();
    }

    public static String methodNameWithArguments(Method m) {
        return m.name() + "(" + StringUtil.join(m.argumentTypeNames(), StringUtil::getShortName, (String)", ") + ")";
    }

    public static String methodName(Method m) {
        return DebuggerUtilsEx.methodName(DebuggerUtilsEx.signatureToName(m.declaringType().signature()), m.name(), m.signature());
    }

    public static String methodName(final String className, final String methodName, String signature) {
        try {
            return new SigReader(signature){

                @Override
                String getMethodName() {
                    return methodName;
                }

                @Override
                String getClassName() {
                    return className;
                }
            }.getSignature();
        }
        catch (Exception ignored) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("Internal error : unknown signature" + signature);
            }
            return className + "." + methodName;
        }
    }

    public static String signatureToName(String s) {
        return new SigReader(s).getSignature();
    }

    @Nullable
    public static List<Location> allLineLocations(Method method) {
        try {
            return method.allLineLocations();
        }
        catch (AbsentInformationException ignored) {
            return null;
        }
    }

    @Nullable
    public static List<Location> allLineLocations(ReferenceType cls) {
        try {
            return cls.allLineLocations();
        }
        catch (AbsentInformationException ignored) {
            return null;
        }
        catch (ObjectCollectedException ignored) {
            return Collections.emptyList();
        }
    }

    public static int getLineNumber(Location location, boolean zeroBased) {
        try {
            return location.lineNumber() - (zeroBased ? 1 : 0);
        }
        catch (IllegalArgumentException | InternalError e) {
            return -1;
        }
    }

    public static String getSourceName(Location location, Function<Throwable, String> defaultName) {
        try {
            return location.sourceName();
        }
        catch (AbsentInformationException | InternalError e) {
            return defaultName.apply(e);
        }
    }

    public static boolean isVoid(@NotNull Method method) {
        if (method == null) {
            DebuggerUtilsEx.$$$reportNull$$$0(14);
        }
        return "void".equals(method.returnTypeName());
    }

    @Nullable
    public static Method getMethod(Location location) {
        try {
            return location.method();
        }
        catch (IllegalArgumentException e) {
            LOG.info((Throwable)e);
            return null;
        }
    }

    public static Value createValue(VirtualMachineProxyImpl vm, String expectedType, double value) {
        if (PsiType.DOUBLE.getName().equals(expectedType)) {
            return vm.mirrorOf(value);
        }
        if (PsiType.FLOAT.getName().equals(expectedType)) {
            return vm.mirrorOf((float)value);
        }
        if (PsiType.LONG.getName().equals(expectedType)) {
            return vm.mirrorOf((long)value);
        }
        if (PsiType.INT.getName().equals(expectedType)) {
            return vm.mirrorOf((int)value);
        }
        if (PsiType.SHORT.getName().equals(expectedType)) {
            return vm.mirrorOf((short)value);
        }
        if (PsiType.BYTE.getName().equals(expectedType)) {
            return vm.mirrorOf((byte)value);
        }
        if (PsiType.CHAR.getName().equals(expectedType)) {
            return vm.mirrorOf((char)value);
        }
        return null;
    }

    public static Value createValue(VirtualMachineProxyImpl vm, String expectedType, long value) {
        if (PsiType.LONG.getName().equals(expectedType)) {
            return vm.mirrorOf(value);
        }
        if (PsiType.INT.getName().equals(expectedType)) {
            return vm.mirrorOf((int)value);
        }
        if (PsiType.SHORT.getName().equals(expectedType)) {
            return vm.mirrorOf((short)value);
        }
        if (PsiType.BYTE.getName().equals(expectedType)) {
            return vm.mirrorOf((byte)value);
        }
        if (PsiType.CHAR.getName().equals(expectedType)) {
            return vm.mirrorOf((char)value);
        }
        if (PsiType.DOUBLE.getName().equals(expectedType)) {
            return vm.mirrorOf((double)value);
        }
        if (PsiType.FLOAT.getName().equals(expectedType)) {
            return vm.mirrorOf((float)value);
        }
        return null;
    }

    public static Value createValue(VirtualMachineProxyImpl vm, String expectedType, boolean value) {
        if (PsiType.BOOLEAN.getName().equals(expectedType)) {
            return vm.mirrorOf(value);
        }
        return null;
    }

    public static Value createValue(VirtualMachineProxyImpl vm, String expectedType, char value) {
        if (PsiType.CHAR.getName().equals(expectedType)) {
            return vm.mirrorOf(value);
        }
        if (PsiType.LONG.getName().equals(expectedType)) {
            return vm.mirrorOf((long)value);
        }
        if (PsiType.INT.getName().equals(expectedType)) {
            return vm.mirrorOf((int)value);
        }
        if (PsiType.SHORT.getName().equals(expectedType)) {
            return vm.mirrorOf((short)value);
        }
        if (PsiType.BYTE.getName().equals(expectedType)) {
            return vm.mirrorOf((byte)value);
        }
        if (PsiType.DOUBLE.getName().equals(expectedType)) {
            return vm.mirrorOf((double)value);
        }
        if (PsiType.FLOAT.getName().equals(expectedType)) {
            return vm.mirrorOf((float)value);
        }
        return null;
    }

    public static String truncateString(String str) {
        if (str.length() > 1005) {
            return str.substring(0, 1005);
        }
        return str;
    }

    public static String getThreadStatusText(int statusId) {
        switch (statusId) {
            case 3: {
                return DebuggerBundle.message((String)"status.thread.monitor", (Object[])new Object[0]);
            }
            case 5: {
                return DebuggerBundle.message((String)"status.thread.not.started", (Object[])new Object[0]);
            }
            case 1: {
                return DebuggerBundle.message((String)"status.thread.running", (Object[])new Object[0]);
            }
            case 2: {
                return DebuggerBundle.message((String)"status.thread.sleeping", (Object[])new Object[0]);
            }
            case -1: {
                return DebuggerBundle.message((String)"status.thread.unknown", (Object[])new Object[0]);
            }
            case 4: {
                return DebuggerBundle.message((String)"status.thread.wait", (Object[])new Object[0]);
            }
            case 0: {
                return DebuggerBundle.message((String)"status.thread.zombie", (Object[])new Object[0]);
            }
        }
        return DebuggerBundle.message((String)"status.thread.undefined", (Object[])new Object[0]);
    }

    public static String prepareValueText(String text, Project project2) {
        text = StringUtil.unquoteString((String)text);
        text = StringUtil.unescapeStringCharacters((String)text);
        int tabSize = CodeStyle.getSettings((Project)project2).getTabSize((FileType)StdFileTypes.JAVA);
        if (tabSize < 0) {
            tabSize = 0;
        }
        return text.replace("\t", StringUtil.repeat((String)" ", (int)tabSize));
    }

    public static void setAlternativeSourceUrl(String className, String source, Project project2) {
        ConcurrentHashMap<String, String> map = (ConcurrentHashMap<String, String>)project2.getUserData(DEBUGGER_ALTERNATIVE_SOURCE_MAPPING);
        if (map == null) {
            map = new ConcurrentHashMap<String, String>();
            project2.putUserData(DEBUGGER_ALTERNATIVE_SOURCE_MAPPING, map);
        }
        map.put(className, source);
    }

    @Nullable
    public static String getAlternativeSourceUrl(@Nullable String className, Project project2) {
        Map map = (Map)project2.getUserData(DEBUGGER_ALTERNATIVE_SOURCE_MAPPING);
        return map != null ? (String)map.get(className) : null;
    }

    @Nullable
    public static XSourcePosition toXSourcePosition(@Nullable SourcePosition position) {
        if (position != null) {
            VirtualFile file = position.getFile().getVirtualFile();
            if (file == null) {
                file = position.getFile().getOriginalFile().getVirtualFile();
            }
            if (file != null) {
                return new JavaXSourcePosition(position, file);
            }
        }
        return null;
    }

    @Nullable
    public static SourcePosition toSourcePosition(@Nullable XSourcePosition position, Project project2) {
        if (position != null) {
            if (position instanceof JavaXSourcePosition) {
                return ((JavaXSourcePosition)position).mySourcePosition;
            }
            PsiFile psiFile = DebuggerUtilsEx.getPsiFile(position, project2);
            if (psiFile != null) {
                return SourcePosition.createFromLine((PsiFile)psiFile, (int)position.getLine());
            }
        }
        return null;
    }

    @Nullable
    public static TextRange intersectWithLine(@Nullable TextRange range, @Nullable PsiFile file, int line) {
        Document document;
        if (range != null && file != null && (document = PsiDocumentManager.getInstance((Project)file.getProject()).getDocument(file)) != null) {
            range = range.intersection(DocumentUtil.getLineTextRange((Document)document, (int)line));
        }
        return range;
    }

    @Nullable
    public static PsiFile getPsiFile(@Nullable XSourcePosition position, Project project2) {
        VirtualFile file;
        ApplicationManager.getApplication().assertReadAccessAllowed();
        if (position != null && (file = position.getFile()).isValid()) {
            return PsiManager.getInstance((Project)project2).findFile(file);
        }
        return null;
    }

    @Nullable
    public static PsiElement findElementAt(@Nullable PsiFile file, int offset) {
        return file != null ? file.findElementAt(offset) : null;
    }

    public static String getLocationMethodQName(@NotNull Location location) {
        if (location == null) {
            DebuggerUtilsEx.$$$reportNull$$$0(15);
        }
        StringBuilder res = new StringBuilder();
        ReferenceType type = location.declaringType();
        if (type != null) {
            res.append(type.name()).append('.');
        }
        res.append(location.method().name());
        return res.toString();
    }

    private static PsiElement getNextElement(PsiElement element) {
        PsiElement sibling = element.getNextSibling();
        if (sibling != null) {
            return sibling;
        }
        if ((element = element.getParent()) != null) {
            return DebuggerUtilsEx.getNextElement(element);
        }
        return null;
    }

    public static boolean isLambdaClassName(String typeName) {
        return DebuggerUtilsEx.getLambdaBaseClassName(typeName) != null;
    }

    @Nullable
    public static String getLambdaBaseClassName(String typeName) {
        return StringUtil.substringBefore((String)typeName, (String)"$$Lambda$");
    }

    public static boolean isLambdaName(@Nullable String name2) {
        return !StringUtil.isEmpty((String)name2) && name2.startsWith("lambda$");
    }

    public static boolean isLambda(@Nullable Method method) {
        return method != null && DebuggerUtilsEx.isLambdaName(method.name());
    }

    public static int getLambdaOrdinal(@NotNull String name2) {
        int pos;
        if (name2 == null) {
            DebuggerUtilsEx.$$$reportNull$$$0(16);
        }
        if ((pos = name2.lastIndexOf(36)) > -1) {
            try {
                return Integer.parseInt(name2.substring(pos + 1));
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return -1;
    }

    public static List<PsiLambdaExpression> collectLambdas(@NotNull SourcePosition position, final boolean onlyOnTheLine) {
        PsiElement parent;
        if (position == null) {
            DebuggerUtilsEx.$$$reportNull$$$0(17);
        }
        ApplicationManager.getApplication().assertReadAccessAllowed();
        PsiFile file = position.getFile();
        final int line = position.getLine();
        final Document document = PsiDocumentManager.getInstance((Project)file.getProject()).getDocument(file);
        if (document == null || line >= document.getLineCount()) {
            return Collections.emptyList();
        }
        PsiElement element = position.getElementAt();
        if (element == null) {
            return Collections.emptyList();
        }
        TextRange lineRange = DocumentUtil.getLineTextRange((Document)document, (int)line);
        while ((parent = element.getParent()) != null && parent.getTextOffset() >= lineRange.getStartOffset()) {
            element = parent;
        }
        SmartList lambdas = new SmartList();
        JavaRecursiveElementVisitor lambdaCollector = new JavaRecursiveElementVisitor((List)lambdas){
            final /* synthetic */ List val$lambdas;
            {
                this.val$lambdas = list;
            }

            public void visitLambdaExpression(PsiLambdaExpression expression) {
                super.visitLambdaExpression(expression);
                if (!onlyOnTheLine || DebuggerUtilsEx.getFirstElementOnTheLine(expression, document, line) != null) {
                    this.val$lambdas.add(expression);
                }
            }
        };
        element.accept((PsiElementVisitor)lambdaCollector);
        PsiElement sibling = DebuggerUtilsEx.getNextElement(element);
        while (sibling != null && DebuggerUtilsEx.intersects(lineRange, sibling)) {
            sibling.accept((PsiElementVisitor)lambdaCollector);
            sibling = DebuggerUtilsEx.getNextElement(sibling);
        }
        PsiElement method = DebuggerUtilsEx.getContainingMethod(element);
        if (method instanceof PsiLambdaExpression && !lambdas.contains(method)) {
            lambdas.add((PsiLambdaExpression)method);
        }
        return lambdas;
    }

    @Nullable
    public static PsiElement getBody(PsiElement method) {
        if (method instanceof PsiParameterListOwner) {
            return ((PsiParameterListOwner)method).getBody();
        }
        if (method instanceof PsiClassInitializer) {
            return ((PsiClassInitializer)method).getBody();
        }
        return null;
    }

    @NotNull
    public static PsiParameter[] getParameters(PsiElement method) {
        if (method instanceof PsiParameterListOwner) {
            PsiParameter[] psiParameterArray = ((PsiParameterListOwner)method).getParameterList().getParameters();
            if (psiParameterArray == null) {
                DebuggerUtilsEx.$$$reportNull$$$0(18);
            }
            return psiParameterArray;
        }
        if (PsiParameter.EMPTY_ARRAY == null) {
            DebuggerUtilsEx.$$$reportNull$$$0(19);
        }
        return PsiParameter.EMPTY_ARRAY;
    }

    public static boolean evaluateBoolean(ExpressionEvaluator evaluator, EvaluationContextImpl context) throws EvaluateException {
        Object value = UnBoxingEvaluator.unbox(evaluator.evaluate((EvaluationContext)context), context);
        if (!(value instanceof BooleanValue)) {
            throw EvaluateExceptionUtil.createEvaluateException((String)DebuggerBundle.message((String)"evaluation.error.boolean.expected", (Object[])new Object[0]));
        }
        return ((BooleanValue)value).booleanValue();
    }

    public static boolean intersects(@NotNull TextRange range, @NotNull PsiElement elem) {
        TextRange elemRange;
        if (range == null) {
            DebuggerUtilsEx.$$$reportNull$$$0(20);
        }
        if (elem == null) {
            DebuggerUtilsEx.$$$reportNull$$$0(21);
        }
        return (elemRange = elem.getTextRange()) != null && elemRange.intersects(range);
    }

    @Nullable
    public static PsiElement getFirstElementOnTheLine(PsiLambdaExpression lambda2, Document document, int line) {
        PsiStatement[] statements;
        ApplicationManager.getApplication().assertReadAccessAllowed();
        TextRange lineRange = DocumentUtil.getLineTextRange((Document)document, (int)line);
        if (!DebuggerUtilsEx.intersects(lineRange, (PsiElement)lambda2)) {
            return null;
        }
        PsiElement body = lambda2.getBody();
        if (body == null || !DebuggerUtilsEx.intersects(lineRange, body)) {
            return null;
        }
        if (body instanceof PsiCodeBlock && (statements = ((PsiCodeBlock)body).getStatements()).length > 0) {
            for (PsiStatement statement2 : statements) {
                if (lineRange.contains(statement2.getTextOffset())) {
                    return statement2;
                }
                if (!DebuggerUtilsEx.intersects(lineRange, (PsiElement)statement2)) continue;
                for (PsiElement element : SyntaxTraverser.psiTraverser((PsiElement)statement2)) {
                    if (!lineRange.contains(element.getTextOffset())) continue;
                    return element;
                }
            }
            return null;
        }
        return body;
    }

    public static boolean inTheMethod(@NotNull SourcePosition pos, @NotNull PsiElement method) {
        PsiElement elem;
        if (pos == null) {
            DebuggerUtilsEx.$$$reportNull$$$0(22);
        }
        if (method == null) {
            DebuggerUtilsEx.$$$reportNull$$$0(23);
        }
        if ((elem = pos.getElementAt()) == null) {
            return false;
        }
        return Comparing.equal((Object)DebuggerUtilsEx.getContainingMethod(elem), (Object)method);
    }

    public static boolean inTheSameMethod(@NotNull SourcePosition pos1, @NotNull SourcePosition pos2) {
        if (pos1 == null) {
            DebuggerUtilsEx.$$$reportNull$$$0(24);
        }
        if (pos2 == null) {
            DebuggerUtilsEx.$$$reportNull$$$0(25);
        }
        ApplicationManager.getApplication().assertReadAccessAllowed();
        PsiElement elem1 = pos1.getElementAt();
        PsiElement elem2 = pos2.getElementAt();
        if (elem1 == null) {
            return elem2 == null;
        }
        if (elem2 != null) {
            PsiElement expectedMethod = DebuggerUtilsEx.getContainingMethod(elem1);
            PsiElement currentMethod = DebuggerUtilsEx.getContainingMethod(elem2);
            return Comparing.equal((Object)expectedMethod, (Object)currentMethod);
        }
        return false;
    }

    public static boolean methodMatches(@NotNull PsiMethod psiMethod, String className, String name2, String signature, DebugProcessImpl process2) {
        if (psiMethod == null) {
            DebuggerUtilsEx.$$$reportNull$$$0(26);
        }
        PsiClass containingClass = psiMethod.getContainingClass();
        try {
            return containingClass != null && Objects.equals(JVMNameUtil.getClassVMName(containingClass), className) && JVMNameUtil.getJVMMethodName(psiMethod).equals(name2) && JVMNameUtil.getJVMSignature(psiMethod).getName(process2).equals(signature);
        }
        catch (EvaluateException e) {
            LOG.debug((Throwable)e);
            return false;
        }
    }

    @Nullable
    public static PsiElement getContainingMethod(@Nullable PsiElement elem) {
        return PsiTreeUtil.getContextOfType((PsiElement)elem, (Class[])new Class[]{PsiMethod.class, PsiLambdaExpression.class, PsiClassInitializer.class});
    }

    @Nullable
    public static PsiElement getContainingMethod(@Nullable SourcePosition position) {
        if (position == null) {
            return null;
        }
        return DebuggerUtilsEx.getContainingMethod(position.getElementAt());
    }

    public static void disableCollection(ObjectReference reference) {
        try {
            reference.disableCollection();
        }
        catch (UnsupportedOperationException unsupportedOperationException) {
            // empty catch block
        }
    }

    public static void enableCollection(ObjectReference reference) {
        try {
            reference.enableCollection();
        }
        catch (UnsupportedOperationException unsupportedOperationException) {
            // empty catch block
        }
    }

    public static int bytecodeToSourceLine(PsiFile psiFile, int originalLine) {
        int line;
        LineNumbersMapping mapping;
        VirtualFile file = psiFile.getVirtualFile();
        if (file != null && (mapping = (LineNumbersMapping)file.getUserData(LineNumbersMapping.LINE_NUMBERS_MAPPING_KEY)) != null && (line = mapping.bytecodeToSource(originalLine + 1)) > -1) {
            return line - 1;
        }
        return -1;
    }

    public static boolean isInLibraryContent(@Nullable VirtualFile file, @NotNull Project project2) {
        if (project2 == null) {
            DebuggerUtilsEx.$$$reportNull$$$0(27);
        }
        return (Boolean)ReadAction.compute(() -> {
            if (project2 == null) {
                DebuggerUtilsEx.$$$reportNull$$$0(28);
            }
            if (file == null) {
                return true;
            }
            ProjectFileIndex projectFileIndex = ProjectRootManager.getInstance((Project)project2).getFileIndex();
            return projectFileIndex.isInLibraryClasses(file) || projectFileIndex.isInLibrarySource(file);
        });
    }

    public static boolean isInJavaSession(AnActionEvent e) {
        Project project2;
        XDebugSession session = (XDebugSession)e.getData(XDebugSession.DATA_KEY);
        if (session == null && (project2 = e.getProject()) != null) {
            session = XDebuggerManager.getInstance((Project)project2).getCurrentSession();
        }
        return session != null && session.getDebugProcess() instanceof JavaDebugProcess;
    }

    static {
        myThreadDumpsCount = 0;
        myCurrentThreadDumpId = 1;
        DEBUGGER_ALTERNATIVE_SOURCE_MAPPING = Key.create((String)"DEBUGGER_ALTERNATIVE_SOURCE_MAPPING");
        LAMBDA_ORDINAL_COMPARATOR = Comparator.comparingInt(m -> DebuggerUtilsEx.getLambdaOrdinal(m.name()));
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 6: 
            case 7: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 18: 
            case 19: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 6: 
            case 7: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 18: 
            case 19: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "baseQualifiedName";
                break;
            }
            case 1: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "checkedType";
                break;
            }
            case 4: 
            case 5: 
            case 31: {
                objectArray2 = objectArray3;
                objectArray3[0] = "qName";
                break;
            }
            case 6: 
            case 7: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 18: 
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/debugger/impl/DebuggerUtilsEx";
                break;
            }
            case 8: 
            case 30: {
                objectArray2 = objectArray3;
                objectArray3[0] = "s";
                break;
            }
            case 9: 
            case 29: {
                objectArray2 = objectArray3;
                objectArray3[0] = "arrayType";
                break;
            }
            case 14: 
            case 23: {
                objectArray2 = objectArray3;
                objectArray3[0] = "method";
                break;
            }
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "location";
                break;
            }
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "position";
                break;
            }
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "range";
                break;
            }
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "elem";
                break;
            }
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "pos";
                break;
            }
            case 24: {
                objectArray2 = objectArray3;
                objectArray3[0] = "pos1";
                break;
            }
            case 25: {
                objectArray2 = objectArray3;
                objectArray3[0] = "pos2";
                break;
            }
            case 26: {
                objectArray2 = objectArray3;
                objectArray3[0] = "psiMethod";
                break;
            }
            case 27: 
            case 28: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/debugger/impl/DebuggerUtilsEx";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getEventDescriptors";
                break;
            }
            case 10: 
            case 11: 
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "getCodeFragmentFactory";
                break;
            }
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "findAppropriateCodeFragmentFactory";
                break;
            }
            case 18: 
            case 19: {
                objectArray = objectArray2;
                objectArray2[1] = "getParameters";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "isAssignableFrom";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "getSuperClass";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "isFiltered";
                break;
            }
            case 6: 
            case 7: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 18: 
            case 19: {
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "mirrorOfString";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "mirrorOfArray";
                break;
            }
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "isVoid";
                break;
            }
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "getLocationMethodQName";
                break;
            }
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "getLambdaOrdinal";
                break;
            }
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "collectLambdas";
                break;
            }
            case 20: 
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "intersects";
                break;
            }
            case 22: 
            case 23: {
                objectArray = objectArray;
                objectArray[2] = "inTheMethod";
                break;
            }
            case 24: 
            case 25: {
                objectArray = objectArray;
                objectArray[2] = "inTheSameMethod";
                break;
            }
            case 26: {
                objectArray = objectArray;
                objectArray[2] = "methodMatches";
                break;
            }
            case 27: {
                objectArray = objectArray;
                objectArray[2] = "isInLibraryContent";
                break;
            }
            case 28: {
                objectArray = objectArray;
                objectArray[2] = "lambda$isInLibraryContent$5";
                break;
            }
            case 29: {
                objectArray = objectArray;
                objectArray[2] = "lambda$mirrorOfArray$2";
                break;
            }
            case 30: {
                objectArray = objectArray;
                objectArray[2] = "lambda$mirrorOfString$1";
                break;
            }
            case 31: {
                objectArray = objectArray;
                objectArray[2] = "lambda$isFiltered$0";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 6: 
            case 7: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 18: 
            case 19: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static class JavaXSourcePosition
    implements XSourcePosition,
    ExecutionPointHighlighter.HighlighterProvider {
        private final SourcePosition mySourcePosition;
        @NotNull
        private final VirtualFile myFile;

        public JavaXSourcePosition(@NotNull SourcePosition sourcePosition, @NotNull VirtualFile file) {
            if (sourcePosition == null) {
                JavaXSourcePosition.$$$reportNull$$$0(0);
            }
            if (file == null) {
                JavaXSourcePosition.$$$reportNull$$$0(1);
            }
            this.mySourcePosition = sourcePosition;
            this.myFile = file;
        }

        public int getLine() {
            return this.mySourcePosition.getLine();
        }

        public int getOffset() {
            return this.mySourcePosition.getOffset();
        }

        @NotNull
        public VirtualFile getFile() {
            VirtualFile virtualFile = this.myFile;
            if (virtualFile == null) {
                JavaXSourcePosition.$$$reportNull$$$0(2);
            }
            return virtualFile;
        }

        @NotNull
        public Navigatable createNavigatable(@NotNull Project project2) {
            if (project2 == null) {
                JavaXSourcePosition.$$$reportNull$$$0(3);
            }
            OpenFileDescriptor openFileDescriptor = XSourcePositionImpl.doCreateOpenFileDescriptor((Project)project2, (XSourcePosition)this);
            if (openFileDescriptor == null) {
                JavaXSourcePosition.$$$reportNull$$$0(4);
            }
            return openFileDescriptor;
        }

        @Nullable
        public TextRange getHighlightRange() {
            return DebuggerUtilsEx.intersectWithLine(SourcePositionHighlighter.getHighlightRangeFor((SourcePosition)this.mySourcePosition), this.mySourcePosition.getFile(), this.getLine());
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 2: 
                case 4: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 2: 
                case 4: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "sourcePosition";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "file";
                    break;
                }
                case 2: 
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/debugger/impl/DebuggerUtilsEx$JavaXSourcePosition";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/debugger/impl/DebuggerUtilsEx$JavaXSourcePosition";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getFile";
                    break;
                }
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[1] = "createNavigatable";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 2: 
                case 4: {
                    break;
                }
                case 3: {
                    objectArray = objectArray;
                    objectArray[2] = "createNavigatable";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 2: 
                case 4: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    private static class SigReader {
        final String buffer;
        int pos = 0;

        SigReader(String s) {
            this.buffer = s;
        }

        int get() {
            return this.buffer.charAt(this.pos++);
        }

        int peek() {
            return this.buffer.charAt(this.pos);
        }

        boolean eof() {
            return this.buffer.length() <= this.pos;
        }

        @NonNls
        String getSignature() {
            if (this.eof()) {
                return "";
            }
            switch (this.get()) {
                case 90: {
                    return "boolean";
                }
                case 66: {
                    return "byte";
                }
                case 67: {
                    return "char";
                }
                case 83: {
                    return "short";
                }
                case 73: {
                    return "int";
                }
                case 74: {
                    return "long";
                }
                case 70: {
                    return "float";
                }
                case 68: {
                    return "double";
                }
                case 86: {
                    return "void";
                }
                case 76: {
                    int start = this.pos;
                    this.pos = this.buffer.indexOf(59, start) + 1;
                    LOG.assertTrue(this.pos > 0);
                    return this.buffer.substring(start, this.pos - 1).replace('/', '.');
                }
                case 91: {
                    return this.getSignature() + "[]";
                }
                case 40: {
                    StringBuilder result = new StringBuilder("(");
                    String separator = "";
                    while (this.peek() != 41) {
                        result.append(separator);
                        result.append(this.getSignature());
                        separator = ", ";
                    }
                    this.get();
                    result.append(")");
                    return this.getSignature() + " " + this.getClassName() + "." + this.getMethodName() + " " + result;
                }
            }
            return null;
        }

        String getMethodName() {
            return "";
        }

        String getClassName() {
            return "";
        }
    }
}

