/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.debugger.engine.evaluation.expression;

import com.intellij.debugger.DebuggerBundle;
import com.intellij.debugger.engine.evaluation.EvaluateException;
import com.intellij.debugger.engine.evaluation.EvaluateExceptionUtil;
import com.intellij.debugger.engine.evaluation.EvaluationContext;
import com.intellij.debugger.engine.evaluation.EvaluationContextImpl;
import com.intellij.debugger.engine.evaluation.expression.Evaluator;
import com.intellij.debugger.impl.DebuggerUtilsEx;
import com.intellij.debugger.jdi.VirtualMachineProxyImpl;
import com.intellij.openapi.util.ThrowableComputable;
import com.intellij.openapi.util.registry.Registry;
import com.sun.jdi.ClassType;
import com.sun.jdi.Method;
import com.sun.jdi.StringReference;
import java.util.Collections;

class LiteralEvaluator
implements Evaluator {
    private final Object myValue;
    private final String myExpectedType;

    public LiteralEvaluator(Object value, String expectedType) {
        this.myValue = value;
        this.myExpectedType = expectedType;
    }

    @Override
    public Object evaluate(EvaluationContextImpl context) throws EvaluateException {
        if (this.myValue == null) {
            return null;
        }
        VirtualMachineProxyImpl vm = context.getDebugProcess().getVirtualMachineProxy();
        if (this.myValue instanceof Boolean) {
            return DebuggerUtilsEx.createValue(vm, this.myExpectedType, (Boolean)this.myValue);
        }
        if (this.myValue instanceof Character) {
            return DebuggerUtilsEx.createValue(vm, this.myExpectedType, ((Character)this.myValue).charValue());
        }
        if (this.myValue instanceof Double) {
            return DebuggerUtilsEx.createValue(vm, this.myExpectedType, ((Number)this.myValue).doubleValue());
        }
        if (this.myValue instanceof Float) {
            return DebuggerUtilsEx.createValue(vm, this.myExpectedType, ((Number)this.myValue).floatValue());
        }
        if (this.myValue instanceof Number) {
            return DebuggerUtilsEx.createValue(vm, this.myExpectedType, ((Number)this.myValue).longValue());
        }
        if (this.myValue instanceof String) {
            return vm.mirrorOfStringLiteral((String)this.myValue, (ThrowableComputable<StringReference, EvaluateException>)((ThrowableComputable)() -> {
                Method internMethod;
                StringReference str = DebuggerUtilsEx.mirrorOfString((String)this.myValue, vm, context);
                if (Registry.is((String)"debugger.intern.string.literals") && vm.versionHigher("1.7") && (internMethod = ((ClassType)str.referenceType()).concreteMethodByName("intern", "()Ljava/lang/String;")) != null) {
                    return (StringReference)context.getDebugProcess().invokeMethod((EvaluationContext)context, str, internMethod, Collections.emptyList());
                }
                return str;
            }));
        }
        throw EvaluateExceptionUtil.createEvaluateException((String)DebuggerBundle.message((String)"evaluation.error.unknown.expression.type", (Object[])new Object[]{this.myExpectedType}));
    }

    public String toString() {
        return this.myValue != null ? this.myValue.toString() : "null";
    }
}

