/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.debugger.engine;

import com.intellij.debugger.DebuggerBundle;
import com.intellij.debugger.engine.DebugProcessImpl;
import com.intellij.debugger.engine.DebuggerManagerThreadImpl;
import com.intellij.debugger.engine.JavaBreakpointHandler;
import com.intellij.debugger.engine.JavaBreakpointHandlerFactory;
import com.intellij.debugger.engine.JavaExecutionStack;
import com.intellij.debugger.engine.JavaStackFrame;
import com.intellij.debugger.engine.JavaValueMarker;
import com.intellij.debugger.engine.SuspendContextImpl;
import com.intellij.debugger.engine.evaluation.EvaluationContext;
import com.intellij.debugger.engine.events.DebuggerCommandImpl;
import com.intellij.debugger.engine.events.SuspendContextCommandImpl;
import com.intellij.debugger.impl.DebuggerContextImpl;
import com.intellij.debugger.impl.DebuggerContextListener;
import com.intellij.debugger.impl.DebuggerContextUtil;
import com.intellij.debugger.impl.DebuggerSession;
import com.intellij.debugger.impl.DebuggerStateManager;
import com.intellij.debugger.impl.DebuggerUtilsEx;
import com.intellij.debugger.impl.PrioritizedTask;
import com.intellij.debugger.impl.SourceCodeChecker;
import com.intellij.debugger.jdi.StackFrameProxyImpl;
import com.intellij.debugger.jdi.ThreadReferenceProxyImpl;
import com.intellij.debugger.memory.component.MemoryViewDebugProcessData;
import com.intellij.debugger.memory.ui.ClassesFilteredView;
import com.intellij.debugger.settings.DebuggerSettings;
import com.intellij.debugger.ui.AlternativeSourceNotificationProvider;
import com.intellij.debugger.ui.breakpoints.Breakpoint;
import com.intellij.debugger.ui.impl.ThreadsPanel;
import com.intellij.debugger.ui.impl.watch.DebuggerTreeNodeImpl;
import com.intellij.debugger.ui.impl.watch.MessageDescriptor;
import com.intellij.debugger.ui.impl.watch.NodeManagerImpl;
import com.intellij.debugger.ui.overhead.OverheadView;
import com.intellij.debugger.ui.tree.NodeDescriptor;
import com.intellij.execution.process.ProcessHandler;
import com.intellij.execution.ui.ExecutionConsole;
import com.intellij.execution.ui.ExecutionConsoleEx;
import com.intellij.execution.ui.RunnerLayoutUi;
import com.intellij.execution.ui.layout.PlaceInGrid;
import com.intellij.icons.AllIcons;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.Anchor;
import com.intellij.openapi.actionSystem.Constraints;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.actionSystem.Separator;
import com.intellij.openapi.actionSystem.ToggleAction;
import com.intellij.openapi.extensions.Extensions;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.ui.EditorNotifications;
import com.intellij.ui.content.Content;
import com.intellij.ui.content.ContentManagerAdapter;
import com.intellij.ui.content.ContentManagerEvent;
import com.intellij.ui.content.ContentManagerListener;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.xdebugger.XDebugProcess;
import com.intellij.xdebugger.XDebugSession;
import com.intellij.xdebugger.XDebugSessionListener;
import com.intellij.xdebugger.XDebuggerBundle;
import com.intellij.xdebugger.XDebuggerManager;
import com.intellij.xdebugger.XSourcePosition;
import com.intellij.xdebugger.breakpoints.XBreakpoint;
import com.intellij.xdebugger.breakpoints.XBreakpointHandler;
import com.intellij.xdebugger.evaluation.XDebuggerEditorsProvider;
import com.intellij.xdebugger.frame.XStackFrame;
import com.intellij.xdebugger.frame.XSuspendContext;
import com.intellij.xdebugger.frame.XValueMarkerProvider;
import com.intellij.xdebugger.impl.XDebugSessionImpl;
import com.intellij.xdebugger.impl.XDebuggerUtilImpl;
import com.intellij.xdebugger.memory.component.InstancesTracker;
import com.intellij.xdebugger.ui.XDebugTabLayouter;
import com.sun.jdi.event.Event;
import com.sun.jdi.event.LocatableEvent;
import javax.swing.JComponent;
import one.util.streamex.StreamEx;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.java.debugger.JavaDebuggerEditorsProvider;

public class JavaDebugProcess
extends XDebugProcess {
    private final DebuggerSession myJavaSession;
    private final JavaDebuggerEditorsProvider myEditorsProvider;
    private final XBreakpointHandler<?>[] myBreakpointHandlers;
    private final NodeManagerImpl myNodeManager;
    private static final JavaBreakpointHandlerFactory[] ourDefaultBreakpointHandlerFactories = new JavaBreakpointHandlerFactory[]{JavaBreakpointHandler.JavaLineBreakpointHandler::new, JavaBreakpointHandler.JavaExceptionBreakpointHandler::new, JavaBreakpointHandler.JavaFieldBreakpointHandler::new, JavaBreakpointHandler.JavaMethodBreakpointHandler::new, JavaBreakpointHandler.JavaWildcardBreakpointHandler::new};

    public static JavaDebugProcess create(@NotNull XDebugSession session, DebuggerSession javaSession) {
        if (session == null) {
            JavaDebugProcess.$$$reportNull$$$0(0);
        }
        JavaDebugProcess res = new JavaDebugProcess(session, javaSession);
        javaSession.getProcess().setXDebugProcess(res);
        return res;
    }

    protected JavaDebugProcess(final @NotNull XDebugSession session, final DebuggerSession javaSession) {
        if (session == null) {
            JavaDebugProcess.$$$reportNull$$$0(1);
        }
        super(session);
        this.myJavaSession = javaSession;
        this.myEditorsProvider = new JavaDebuggerEditorsProvider();
        final DebugProcessImpl process2 = javaSession.getProcess();
        this.myBreakpointHandlers = (XBreakpointHandler[])StreamEx.of((Object[])ourDefaultBreakpointHandlerFactories).append(Extensions.getExtensions(JavaBreakpointHandlerFactory.EP_NAME)).map(factory -> factory.createHandler(process2)).toArray(XBreakpointHandler[]::new);
        this.myJavaSession.getContextManager().addListener(new DebuggerContextListener(){

            @Override
            public void changeEvent(final @NotNull DebuggerContextImpl newContext, DebuggerSession.Event event) {
                if (newContext == null) {
                    1.$$$reportNull$$$0(0);
                }
                if (event == DebuggerSession.Event.PAUSE || event == DebuggerSession.Event.CONTEXT || event == DebuggerSession.Event.REFRESH || event == DebuggerSession.Event.REFRESH_WITH_STACK && JavaDebugProcess.this.myJavaSession.isPaused()) {
                    final SuspendContextImpl newSuspendContext = newContext.getSuspendContext();
                    if (newSuspendContext != null && (JavaDebugProcess.this.shouldApplyContext(newContext) || event == DebuggerSession.Event.REFRESH_WITH_STACK)) {
                        process2.getManagerThread().schedule(new SuspendContextCommandImpl(newSuspendContext){

                            @Override
                            public void contextAction(@NotNull SuspendContextImpl suspendContext) {
                                if (suspendContext == null) {
                                    1.$$$reportNull$$$0(0);
                                }
                                ThreadReferenceProxyImpl threadProxy = newContext.getThreadProxy();
                                newSuspendContext.initExecutionStacks(threadProxy);
                                Pair item = (Pair)ContainerUtil.getFirstItem(DebuggerUtilsEx.getEventDescriptors(newSuspendContext));
                                if (item != null) {
                                    XBreakpoint xBreakpoint = ((Breakpoint)item.getFirst()).getXBreakpoint();
                                    Event second = (Event)item.getSecond();
                                    if (xBreakpoint != null && second instanceof LocatableEvent && threadProxy != null && ((LocatableEvent)second).thread() == threadProxy.getThreadReference()) {
                                        ((XDebugSessionImpl)JavaDebugProcess.this.getSession()).breakpointReachedNoProcessing(xBreakpoint, (XSuspendContext)newSuspendContext);
                                        JavaDebugProcess.this.unsetPausedIfNeeded(newContext);
                                        SourceCodeChecker.checkSource(newContext);
                                        return;
                                    }
                                }
                                JavaDebugProcess.this.getSession().positionReached((XSuspendContext)newSuspendContext);
                                JavaDebugProcess.this.unsetPausedIfNeeded(newContext);
                                SourceCodeChecker.checkSource(newContext);
                            }

                            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "suspendContext", "com/intellij/debugger/engine/JavaDebugProcess$1$1", "contextAction"));
                            }
                        });
                    }
                } else if (event == DebuggerSession.Event.ATTACHED) {
                    JavaDebugProcess.this.getSession().rebuildViews();
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "newContext", "com/intellij/debugger/engine/JavaDebugProcess$1", "changeEvent"));
            }
        });
        this.myNodeManager = new NodeManagerImpl(session.getProject(), null){

            @Override
            @NotNull
            public DebuggerTreeNodeImpl createNode(NodeDescriptor descriptor2, EvaluationContext evaluationContext) {
                DebuggerTreeNodeImpl debuggerTreeNodeImpl = new DebuggerTreeNodeImpl(null, descriptor2);
                if (debuggerTreeNodeImpl == null) {
                    2.$$$reportNull$$$0(0);
                }
                return debuggerTreeNodeImpl;
            }

            @Override
            public DebuggerTreeNodeImpl createMessageNode(MessageDescriptor descriptor2) {
                return new DebuggerTreeNodeImpl(null, descriptor2);
            }

            @Override
            @NotNull
            public DebuggerTreeNodeImpl createMessageNode(String message) {
                DebuggerTreeNodeImpl debuggerTreeNodeImpl = new DebuggerTreeNodeImpl(null, new MessageDescriptor(message));
                if (debuggerTreeNodeImpl == null) {
                    2.$$$reportNull$$$0(1);
                }
                return debuggerTreeNodeImpl;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[2];
                objectArray2[0] = "com/intellij/debugger/engine/JavaDebugProcess$2";
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[1] = "createNode";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[1] = "createMessageNode";
                        break;
                    }
                }
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", objectArray));
            }
        };
        session.addSessionListener(new XDebugSessionListener(){

            public void sessionPaused() {
                JavaDebugProcess.this.saveNodeHistory();
                this.showAlternativeNotification(session.getCurrentStackFrame());
            }

            public void stackFrameChanged() {
                XStackFrame frame = session.getCurrentStackFrame();
                if (frame instanceof JavaStackFrame) {
                    this.showAlternativeNotification(frame);
                    StackFrameProxyImpl frameProxy = ((JavaStackFrame)frame).getStackFrameProxy();
                    DebuggerContextUtil.setStackFrame(javaSession.getContextManager(), frameProxy);
                    JavaDebugProcess.this.saveNodeHistory(frameProxy);
                }
            }

            private void showAlternativeNotification(@Nullable XStackFrame frame) {
                VirtualFile file;
                XSourcePosition position;
                if (frame != null && (position = frame.getSourcePosition()) != null && !AlternativeSourceNotificationProvider.isFileProcessed(file = position.getFile())) {
                    EditorNotifications.getInstance((Project)session.getProject()).updateNotifications(file);
                }
            }
        });
    }

    private void unsetPausedIfNeeded(DebuggerContextImpl context) {
        SuspendContextImpl suspendContext = context.getSuspendContext();
        if (suspendContext != null && !suspendContext.suspends(context.getThreadProxy())) {
            ((XDebugSessionImpl)this.getSession()).unsetPaused();
        }
    }

    private boolean shouldApplyContext(DebuggerContextImpl context) {
        SuspendContextImpl suspendContext = context.getSuspendContext();
        SuspendContextImpl currentContext = (SuspendContextImpl)this.getSession().getSuspendContext();
        if (suspendContext != null && !((Object)((Object)suspendContext)).equals((Object)currentContext)) {
            return true;
        }
        JavaExecutionStack currentExecutionStack = currentContext != null ? currentContext.getActiveExecutionStack() : null;
        return currentExecutionStack == null || !Comparing.equal((Object)context.getThreadProxy(), (Object)currentExecutionStack.getThreadProxy());
    }

    public void saveNodeHistory() {
        this.saveNodeHistory(this.getDebuggerStateManager().getContext().getFrameProxy());
    }

    private void saveNodeHistory(final StackFrameProxyImpl frameProxy) {
        this.myJavaSession.getProcess().getManagerThread().invoke(new DebuggerCommandImpl(){

            @Override
            protected void action() {
                JavaDebugProcess.this.myNodeManager.setHistoryByContext(frameProxy);
            }

            @Override
            public PrioritizedTask.Priority getPriority() {
                return PrioritizedTask.Priority.NORMAL;
            }
        });
    }

    private DebuggerStateManager getDebuggerStateManager() {
        return this.myJavaSession.getContextManager();
    }

    public DebuggerSession getDebuggerSession() {
        return this.myJavaSession;
    }

    @NotNull
    public XDebuggerEditorsProvider getEditorsProvider() {
        JavaDebuggerEditorsProvider javaDebuggerEditorsProvider = this.myEditorsProvider;
        if (javaDebuggerEditorsProvider == null) {
            JavaDebugProcess.$$$reportNull$$$0(2);
        }
        return javaDebuggerEditorsProvider;
    }

    public void startStepOver(@Nullable XSuspendContext context) {
        this.myJavaSession.stepOver(false);
    }

    public void startStepInto(@Nullable XSuspendContext context) {
        this.myJavaSession.stepInto(false, null);
    }

    public void startForceStepInto(@Nullable XSuspendContext context) {
        this.myJavaSession.stepInto(true, null);
    }

    public void startStepOut(@Nullable XSuspendContext context) {
        this.myJavaSession.stepOut();
    }

    public void stop() {
        this.myJavaSession.dispose();
        this.myNodeManager.dispose();
    }

    public void startPausing() {
        this.myJavaSession.pause();
    }

    public void resume(@Nullable XSuspendContext context) {
        this.myJavaSession.resume();
    }

    public void runToPosition(@NotNull XSourcePosition position, @Nullable XSuspendContext context) {
        if (position == null) {
            JavaDebugProcess.$$$reportNull$$$0(3);
        }
        this.myJavaSession.runToCursor(position, false);
    }

    @NotNull
    public XBreakpointHandler<?>[] getBreakpointHandlers() {
        if (this.myBreakpointHandlers == null) {
            JavaDebugProcess.$$$reportNull$$$0(4);
        }
        return this.myBreakpointHandlers;
    }

    public boolean checkCanInitBreakpoints() {
        return false;
    }

    @Nullable
    protected ProcessHandler doGetProcessHandler() {
        return this.myJavaSession.getProcess().getProcessHandler();
    }

    @NotNull
    public ExecutionConsole createConsole() {
        ExecutionConsole console = this.myJavaSession.getProcess().getExecutionResult().getExecutionConsole();
        if (console != null) {
            ExecutionConsole executionConsole = console;
            if (executionConsole == null) {
                JavaDebugProcess.$$$reportNull$$$0(5);
            }
            return executionConsole;
        }
        ExecutionConsole executionConsole = super.createConsole();
        if (executionConsole == null) {
            JavaDebugProcess.$$$reportNull$$$0(6);
        }
        return executionConsole;
    }

    @NotNull
    public XDebugTabLayouter createTabLayouter() {
        XDebugTabLayouter xDebugTabLayouter = new XDebugTabLayouter(){

            public void registerAdditionalContent(@NotNull RunnerLayoutUi ui) {
                if (ui == null) {
                    5.$$$reportNull$$$0(0);
                }
                this.registerThreadsPanel(ui);
                this.registerMemoryViewPanel(ui);
                this.registerOverheadMonitor(ui);
            }

            @NotNull
            public Content registerConsoleContent(@NotNull RunnerLayoutUi ui, @NotNull ExecutionConsole console) {
                if (ui == null) {
                    5.$$$reportNull$$$0(1);
                }
                if (console == null) {
                    5.$$$reportNull$$$0(2);
                }
                Content content = null;
                if (console instanceof ExecutionConsoleEx) {
                    ((ExecutionConsoleEx)console).buildUi(ui);
                    content = ui.findContent("ConsoleContent");
                }
                if (content == null) {
                    content = super.registerConsoleContent(ui, console);
                }
                Content content2 = content;
                if (content2 == null) {
                    5.$$$reportNull$$$0(3);
                }
                return content2;
            }

            private void registerThreadsPanel(@NotNull RunnerLayoutUi ui) {
                if (ui == null) {
                    5.$$$reportNull$$$0(4);
                }
                final ThreadsPanel panel = new ThreadsPanel(JavaDebugProcess.this.myJavaSession.getProject(), JavaDebugProcess.this.getDebuggerStateManager());
                final Content threadsContent = ui.createContent("ThreadsContent", (JComponent)panel, XDebuggerBundle.message((String)"debugger.session.tab.threads.title", (Object[])new Object[0]), AllIcons.Debugger.Threads, null);
                threadsContent.setCloseable(false);
                ui.addContent(threadsContent, 0, PlaceInGrid.left, true);
                ui.addListener((ContentManagerListener)new ContentManagerAdapter(){

                    public void selectionChanged(ContentManagerEvent event) {
                        if (event.getContent() == threadsContent) {
                            if (threadsContent.isSelected()) {
                                panel.setUpdateEnabled(true);
                                if (panel.isRefreshNeeded()) {
                                    panel.rebuildIfVisible(DebuggerSession.Event.CONTEXT);
                                }
                            } else {
                                panel.setUpdateEnabled(false);
                            }
                        }
                    }
                }, (Disposable)threadsContent);
            }

            private void registerMemoryViewPanel(@NotNull RunnerLayoutUi ui) {
                if (ui == null) {
                    5.$$$reportNull$$$0(5);
                }
                if (!Registry.is((String)"debugger.enable.memory.view")) {
                    return;
                }
                final XDebugSession session = JavaDebugProcess.this.getSession();
                DebugProcessImpl process2 = JavaDebugProcess.this.myJavaSession.getProcess();
                InstancesTracker tracker = InstancesTracker.getInstance((Project)JavaDebugProcess.this.myJavaSession.getProject());
                final ClassesFilteredView classesFilteredView = new ClassesFilteredView(session, process2, tracker);
                final Content memoryViewContent = ui.createContent("MemoryView", (JComponent)((Object)classesFilteredView), "Memory", AllIcons.Debugger.MemoryView.Active, null);
                memoryViewContent.setCloseable(false);
                memoryViewContent.setShouldDisposeContent(true);
                final MemoryViewDebugProcessData data = new MemoryViewDebugProcessData();
                process2.putUserData(MemoryViewDebugProcessData.KEY, data);
                session.addSessionListener(new XDebugSessionListener(){

                    public void sessionStopped() {
                        session.removeSessionListener((XDebugSessionListener)this);
                        data.getTrackedStacks().clear();
                    }
                });
                ui.addContent(memoryViewContent, 0, PlaceInGrid.right, true);
                final DebuggerManagerThreadImpl managerThread = process2.getManagerThread();
                ui.addListener((ContentManagerListener)new ContentManagerAdapter(){

                    public void selectionChanged(ContentManagerEvent event) {
                        if (event != null && event.getContent() == memoryViewContent) {
                            classesFilteredView.setActive(memoryViewContent.isSelected(), managerThread);
                        }
                    }
                }, (Disposable)memoryViewContent);
            }

            private void registerOverheadMonitor(@NotNull RunnerLayoutUi ui) {
                if (ui == null) {
                    5.$$$reportNull$$$0(6);
                }
                if (!Registry.is((String)"debugger.enable.overhead.monitor")) {
                    return;
                }
                DebugProcessImpl process2 = JavaDebugProcess.this.myJavaSession.getProcess();
                OverheadView monitor = new OverheadView(process2);
                Content overheadContent = ui.createContent("OverheadMonitor", (JComponent)((Object)monitor), "Overhead", AllIcons.Debugger.Overhead, null);
                monitor.setBouncer(() -> {
                    if (ui == null) {
                        5.$$$reportNull$$$0(7);
                    }
                    ui.setBouncing(overheadContent, true);
                });
                overheadContent.setCloseable(false);
                overheadContent.setShouldDisposeContent(true);
                ui.addContent(overheadContent, 0, PlaceInGrid.right, true);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                RuntimeException runtimeException;
                Object[] objectArray;
                Object[] objectArray2;
                int n2;
                String string;
                switch (n) {
                    default: {
                        string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                        break;
                    }
                    case 3: {
                        string = "@NotNull method %s.%s must not return null";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        n2 = 3;
                        break;
                    }
                    case 3: {
                        n2 = 2;
                        break;
                    }
                }
                Object[] objectArray3 = new Object[n2];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "ui";
                        break;
                    }
                    case 2: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "console";
                        break;
                    }
                    case 3: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "com/intellij/debugger/engine/JavaDebugProcess$5";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[1] = "com/intellij/debugger/engine/JavaDebugProcess$5";
                        break;
                    }
                    case 3: {
                        objectArray = objectArray2;
                        objectArray2[1] = "registerConsoleContent";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray;
                        objectArray[2] = "registerAdditionalContent";
                        break;
                    }
                    case 1: 
                    case 2: {
                        objectArray = objectArray;
                        objectArray[2] = "registerConsoleContent";
                        break;
                    }
                    case 3: {
                        break;
                    }
                    case 4: {
                        objectArray = objectArray;
                        objectArray[2] = "registerThreadsPanel";
                        break;
                    }
                    case 5: {
                        objectArray = objectArray;
                        objectArray[2] = "registerMemoryViewPanel";
                        break;
                    }
                    case 6: {
                        objectArray = objectArray;
                        objectArray[2] = "registerOverheadMonitor";
                        break;
                    }
                    case 7: {
                        objectArray = objectArray;
                        objectArray[2] = "lambda$registerOverheadMonitor$0";
                        break;
                    }
                }
                String string2 = String.format(string, objectArray);
                switch (n) {
                    default: {
                        runtimeException = new IllegalArgumentException(string2);
                        break;
                    }
                    case 3: {
                        runtimeException = new IllegalStateException(string2);
                        break;
                    }
                }
                throw runtimeException;
            }
        };
        if (xDebugTabLayouter == null) {
            JavaDebugProcess.$$$reportNull$$$0(7);
        }
        return xDebugTabLayouter;
    }

    public void registerAdditionalActions(@NotNull DefaultActionGroup leftToolbar, @NotNull DefaultActionGroup topToolbar, @NotNull DefaultActionGroup settings) {
        if (leftToolbar == null) {
            JavaDebugProcess.$$$reportNull$$$0(8);
        }
        if (topToolbar == null) {
            JavaDebugProcess.$$$reportNull$$$0(9);
        }
        if (settings == null) {
            JavaDebugProcess.$$$reportNull$$$0(10);
        }
        Constraints beforeRunner = new Constraints(Anchor.BEFORE, "Runner.Layout");
        leftToolbar.add((AnAction)Separator.getInstance(), beforeRunner);
        leftToolbar.add(ActionManager.getInstance().getAction("DumpThreads"), beforeRunner);
        leftToolbar.add((AnAction)Separator.getInstance(), beforeRunner);
        Constraints beforeSort = new Constraints(Anchor.BEFORE, "XDebugger.ToggleSortValues");
        settings.addAction((AnAction)new WatchLastMethodReturnValueAction(), beforeSort);
        settings.addAction((AnAction)new AutoVarsSwitchAction(), beforeSort);
    }

    @Nullable
    private static DebugProcessImpl getCurrentDebugProcess(@Nullable Project project2) {
        XDebugProcess process2;
        XDebugSession session;
        if (project2 != null && (session = XDebuggerManager.getInstance((Project)project2).getCurrentSession()) != null && (process2 = session.getDebugProcess()) instanceof JavaDebugProcess) {
            return ((JavaDebugProcess)process2).getDebuggerSession().getProcess();
        }
        return null;
    }

    public NodeManagerImpl getNodeManager() {
        return this.myNodeManager;
    }

    public String getCurrentStateMessage() {
        String description = this.myJavaSession.getStateDescription();
        return description != null ? description : super.getCurrentStateMessage();
    }

    @Nullable
    public XValueMarkerProvider<?, ?> createValueMarkerProvider() {
        return new JavaValueMarker();
    }

    public boolean isLibraryFrameFilterSupported() {
        return true;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "session";
                break;
            }
            case 2: 
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/debugger/engine/JavaDebugProcess";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "position";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "leftToolbar";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "topToolbar";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "settings";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/debugger/engine/JavaDebugProcess";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getEditorsProvider";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getBreakpointHandlers";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "createConsole";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "createTabLayouter";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "create";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: 
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "runToPosition";
                break;
            }
            case 8: 
            case 9: 
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "registerAdditionalActions";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static class WatchLastMethodReturnValueAction
    extends ToggleAction {
        private final String myText = DebuggerBundle.message((String)"action.watches.method.return.value.enable", (Object[])new Object[0]);
        private final String myTextUnavailable = DebuggerBundle.message((String)"action.watches.method.return.value.unavailable.reason", (Object[])new Object[0]);

        public WatchLastMethodReturnValueAction() {
            super("", DebuggerBundle.message((String)"action.watch.method.return.value.description", (Object[])new Object[0]), null);
        }

        public void update(@NotNull AnActionEvent e) {
            if (e == null) {
                WatchLastMethodReturnValueAction.$$$reportNull$$$0(0);
            }
            super.update(e);
            Presentation presentation = e.getPresentation();
            DebugProcessImpl process2 = JavaDebugProcess.getCurrentDebugProcess(e.getProject());
            if (process2 == null || process2.canGetMethodReturnValue()) {
                presentation.setEnabled(true);
                presentation.setText(this.myText);
            } else {
                presentation.setEnabled(false);
                presentation.setText(this.myTextUnavailable);
            }
        }

        public boolean isSelected(AnActionEvent e) {
            return DebuggerSettings.getInstance().WATCH_RETURN_VALUES;
        }

        public void setSelected(AnActionEvent e, boolean watch) {
            DebuggerSettings.getInstance().WATCH_RETURN_VALUES = watch;
            DebugProcessImpl process2 = JavaDebugProcess.getCurrentDebugProcess(e.getProject());
            if (process2 != null) {
                process2.setWatchMethodReturnValuesEnabled(watch);
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/debugger/engine/JavaDebugProcess$WatchLastMethodReturnValueAction", "update"));
        }
    }

    private static class AutoVarsSwitchAction
    extends ToggleAction {
        private volatile boolean myAutoModeEnabled;

        public AutoVarsSwitchAction() {
            super(DebuggerBundle.message((String)"action.auto.variables.mode", (Object[])new Object[0]), DebuggerBundle.message((String)"action.auto.variables.mode.description", (Object[])new Object[0]), null);
            this.myAutoModeEnabled = DebuggerSettings.getInstance().AUTO_VARIABLES_MODE;
        }

        public boolean isSelected(AnActionEvent e) {
            return this.myAutoModeEnabled;
        }

        public void setSelected(AnActionEvent e, boolean enabled) {
            this.myAutoModeEnabled = enabled;
            DebuggerSettings.getInstance().AUTO_VARIABLES_MODE = enabled;
            XDebuggerUtilImpl.rebuildAllSessionsViews((Project)e.getProject());
        }
    }
}

