/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.debugger.engine;

import com.intellij.execution.Executor;
import com.intellij.execution.ProgramRunnerUtil;
import com.intellij.execution.RunManager;
import com.intellij.execution.RunnerAndConfigurationSettings;
import com.intellij.execution.configurations.ConfigurationTypeUtil;
import com.intellij.execution.configurations.RunConfiguration;
import com.intellij.execution.executors.DefaultDebugExecutor;
import com.intellij.execution.process.ProcessInfo;
import com.intellij.internal.DebugAttachDetector;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.rt.execution.application.AppMainV2;
import com.intellij.util.ArrayUtil;
import com.intellij.util.ReflectionUtil;
import com.intellij.util.execution.ParametersListUtil;
import com.intellij.xdebugger.attach.XDefaultLocalAttachGroup;
import com.intellij.xdebugger.attach.XLocalAttachDebugger;
import com.intellij.xdebugger.attach.XLocalAttachDebuggerProvider;
import com.intellij.xdebugger.attach.XLocalAttachGroup;
import com.sun.tools.attach.AttachNotSupportedException;
import com.sun.tools.attach.VirtualMachine;
import java.io.IOException;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Properties;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JavaAttachDebuggerProvider
implements XLocalAttachDebuggerProvider {
    private static final List<XLocalAttachDebugger> ourAttachDebuggers = Collections.singletonList(new XLocalAttachDebugger(){

        @NotNull
        public String getDebuggerDisplayName() {
            if ("Java Debugger" == null) {
                1.$$$reportNull$$$0(0);
            }
            return "Java Debugger";
        }

        public void attachDebugSession(@NotNull Project project2, @NotNull ProcessInfo processInfo) {
            if (project2 == null) {
                1.$$$reportNull$$$0(1);
            }
            if (processInfo == null) {
                1.$$$reportNull$$$0(2);
            }
            LocalAttachInfo info = JavaAttachDebuggerProvider.getAttachInfo(processInfo, null);
            assert (info != null);
            RunnerAndConfigurationSettings runSettings = RunManager.getInstance((Project)project2).createRunConfiguration("localhost:" + info.myAddress, Objects.requireNonNull(ConfigurationTypeUtil.findConfigurationType((String)"Remote")).getConfigurationFactories()[0]);
            RunConfiguration remoteConfiguration = runSettings.getConfiguration();
            ReflectionUtil.setField(remoteConfiguration.getClass(), (Object)remoteConfiguration, String.class, (String)"HOST", (Object)"127.0.0.1");
            ReflectionUtil.setField(remoteConfiguration.getClass(), (Object)remoteConfiguration, String.class, (String)(info.myUseSocket ? "PORT" : "SHMEM_ADDRESS"), (Object)info.myAddress);
            ReflectionUtil.setField(remoteConfiguration.getClass(), (Object)remoteConfiguration, Boolean.TYPE, (String)"USE_SOCKET_TRANSPORT", (Object)info.myUseSocket);
            ReflectionUtil.setField(remoteConfiguration.getClass(), (Object)remoteConfiguration, Boolean.TYPE, (String)"SERVER_MODE", (Object)false);
            ProgramRunnerUtil.executeConfiguration((RunnerAndConfigurationSettings)runSettings, (Executor)DefaultDebugExecutor.getDebugExecutorInstance());
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
                case 1: 
                case 2: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 2;
                    break;
                }
                case 1: 
                case 2: {
                    n2 = 3;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/debugger/engine/JavaAttachDebuggerProvider$1";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "processInfo";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getDebuggerDisplayName";
                    break;
                }
                case 1: 
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/debugger/engine/JavaAttachDebuggerProvider$1";
                    break;
                }
            }
            switch (n) {
                default: {
                    break;
                }
                case 1: 
                case 2: {
                    objectArray = objectArray;
                    objectArray[2] = "attachDebugSession";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
                case 1: 
                case 2: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    });
    private static final Key<Map<String, LocalAttachInfo>> ADDRESS_MAP_KEY = Key.create((String)"ADDRESS_MAP");
    private static final XLocalAttachGroup ourAttachGroup = new XDefaultLocalAttachGroup(){

        public int getOrder() {
            return 1;
        }

        @NotNull
        public String getGroupName() {
            if ("Java" == null) {
                2.$$$reportNull$$$0(0);
            }
            return "Java";
        }

        @NotNull
        public String getProcessDisplayText(@NotNull Project project2, @NotNull ProcessInfo info, @NotNull UserDataHolder dataHolder) {
            if (project2 == null) {
                2.$$$reportNull$$$0(1);
            }
            if (info == null) {
                2.$$$reportNull$$$0(2);
            }
            if (dataHolder == null) {
                2.$$$reportNull$$$0(3);
            }
            LocalAttachInfo attachInfo = JavaAttachDebuggerProvider.getAttachInfo(info, (Map)dataHolder.getUserData(ADDRESS_MAP_KEY));
            assert (attachInfo != null);
            StringBuilder res = new StringBuilder();
            String executable = info.getExecutableDisplayName();
            if ("java".equals(executable)) {
                if (!StringUtil.isEmpty((String)attachInfo.myClass)) {
                    res.append(attachInfo.myClass);
                } else {
                    res.append(StringUtil.notNullize((String)((String)ArrayUtil.getLastElement((Object[])info.getCommandLine().split(" ")))));
                }
            } else {
                res.append(executable);
            }
            String string = res.append(" (").append(attachInfo.myAddress).append(')').toString();
            if (string == null) {
                2.$$$reportNull$$$0(4);
            }
            return string;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
                case 1: 
                case 2: 
                case 3: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 2;
                    break;
                }
                case 1: 
                case 2: 
                case 3: {
                    n2 = 3;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/debugger/engine/JavaAttachDebuggerProvider$2";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "info";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "dataHolder";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getGroupName";
                    break;
                }
                case 1: 
                case 2: 
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/debugger/engine/JavaAttachDebuggerProvider$2";
                    break;
                }
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getProcessDisplayText";
                    break;
                }
            }
            switch (n) {
                default: {
                    break;
                }
                case 1: 
                case 2: 
                case 3: {
                    objectArray = objectArray;
                    objectArray[2] = "getProcessDisplayText";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
                case 1: 
                case 2: 
                case 3: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    };

    @NotNull
    public XLocalAttachGroup getAttachGroup() {
        XLocalAttachGroup xLocalAttachGroup = ourAttachGroup;
        if (xLocalAttachGroup == null) {
            JavaAttachDebuggerProvider.$$$reportNull$$$0(0);
        }
        return xLocalAttachGroup;
    }

    @NotNull
    public List<XLocalAttachDebugger> getAvailableDebuggers(@NotNull Project project2, @NotNull ProcessInfo processInfo, @NotNull UserDataHolder contextHolder) {
        HashMap addressMap;
        if (project2 == null) {
            JavaAttachDebuggerProvider.$$$reportNull$$$0(1);
        }
        if (processInfo == null) {
            JavaAttachDebuggerProvider.$$$reportNull$$$0(2);
        }
        if (contextHolder == null) {
            JavaAttachDebuggerProvider.$$$reportNull$$$0(3);
        }
        if ((addressMap = (HashMap)contextHolder.getUserData(ADDRESS_MAP_KEY)) == null) {
            addressMap = new HashMap();
            contextHolder.putUserData(ADDRESS_MAP_KEY, addressMap);
            HashMap map = addressMap;
            VirtualMachine.list().forEach(desc -> {
                LocalAttachInfo address = JavaAttachDebuggerProvider.getProcessAttachInfo(desc.id());
                if (address != null) {
                    map.put(desc.id(), address);
                }
            });
        }
        List<Object> list = JavaAttachDebuggerProvider.getAttachInfo(processInfo, addressMap) != null ? ourAttachDebuggers : Collections.emptyList();
        if (list == null) {
            JavaAttachDebuggerProvider.$$$reportNull$$$0(4);
        }
        return list;
    }

    @Nullable
    private static LocalAttachInfo getAttachInfo(ProcessInfo processInfo, @Nullable Map<String, LocalAttachInfo> addressMap) {
        Pair address;
        LocalAttachInfo res = addressMap != null ? addressMap.get(String.valueOf(processInfo.getPid())) : JavaAttachDebuggerProvider.getProcessAttachInfo(String.valueOf(processInfo.getPid()));
        if (res == null && (address = DebugAttachDetector.getAttachAddress((List)ParametersListUtil.parse((String)processInfo.getCommandLine()))) != null) {
            res = new LocalAttachInfo(true, String.valueOf(address.getSecond()), null);
        }
        return res;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    private static LocalAttachInfo getProcessAttachInfo(String pid) {
        VirtualMachine vm = null;
        try {
            vm = VirtualMachine.attach(pid);
            Properties agentProperties = vm.getAgentProperties();
            String property = agentProperties.getProperty("sun.jdwp.listenerAddress");
            if (property != null && property.indexOf(58) != -1) {
                String command = agentProperties.getProperty("sun.java.command");
                if (!StringUtil.isEmpty((String)command)) {
                    command = StringUtil.replace((String)command, (String)AppMainV2.class.getName(), (String)"").trim();
                    command = StringUtil.substringBefore((String)command, (String)" ");
                }
                LocalAttachInfo localAttachInfo = new LocalAttachInfo(!"dt_shmem".equals(StringUtil.substringBefore((String)property, (String)":")), StringUtil.substringAfter((String)property, (String)":"), command);
                return localAttachInfo;
            }
        }
        catch (AttachNotSupportedException | IOException exception) {
        }
        finally {
            if (vm != null) {
                try {
                    vm.detach();
                }
                catch (IOException iOException) {}
            }
        }
        return null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/debugger/engine/JavaAttachDebuggerProvider";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "processInfo";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "contextHolder";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getAttachGroup";
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/debugger/engine/JavaAttachDebuggerProvider";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getAvailableDebuggers";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "getAvailableDebuggers";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static class LocalAttachInfo {
        final boolean myUseSocket;
        final String myAddress;
        final String myClass;

        private LocalAttachInfo(boolean socket, @NotNull String address, String aClass) {
            if (address == null) {
                LocalAttachInfo.$$$reportNull$$$0(0);
            }
            this.myUseSocket = socket;
            this.myAddress = address;
            this.myClass = aClass;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "address", "com/intellij/debugger/engine/JavaAttachDebuggerProvider$LocalAttachInfo", "<init>"));
        }
    }
}

