/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.debugger.actions;

import com.intellij.debugger.actions.SmartStepTarget;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiLambdaExpression;
import com.intellij.psi.PsiSubstitutor;
import com.intellij.psi.PsiType;
import com.intellij.psi.util.PsiFormatUtil;
import com.intellij.util.Range;
import java.util.Objects;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class LambdaSmartStepTarget
extends SmartStepTarget {
    private final PsiLambdaExpression myLambda;
    private final int myOrdinal;
    private final boolean myAsync;

    public LambdaSmartStepTarget(@NotNull PsiLambdaExpression lambda2, @Nullable String label, @Nullable PsiElement highlightElement, int ordinal, Range<Integer> lines, boolean async) {
        if (lambda2 == null) {
            LambdaSmartStepTarget.$$$reportNull$$$0(0);
        }
        super(label, highlightElement, true, lines);
        this.myLambda = lambda2;
        this.myOrdinal = ordinal;
        this.myAsync = async;
    }

    public PsiLambdaExpression getLambda() {
        return this.myLambda;
    }

    public int getOrdinal() {
        return this.myOrdinal;
    }

    public boolean isAsync() {
        return this.myAsync;
    }

    @Override
    @Nullable
    public Icon getIcon() {
        return this.myLambda.getIcon(0);
    }

    @Override
    @NotNull
    public String getPresentation() {
        String typeText = PsiFormatUtil.formatType((PsiType)this.myLambda.getType(), (int)0, (PsiSubstitutor)PsiSubstitutor.EMPTY);
        String label = this.getLabel();
        String string = label != null ? label + typeText : typeText;
        if (string == null) {
            LambdaSmartStepTarget.$$$reportNull$$$0(1);
        }
        return string;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        LambdaSmartStepTarget that = (LambdaSmartStepTarget)o;
        if (this.myOrdinal != that.myOrdinal) {
            return false;
        }
        return this.myLambda.equals(that.myLambda);
    }

    public int hashCode() {
        return Objects.hash(this.myLambda, this.myOrdinal);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "lambda";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/debugger/actions/LambdaSmartStepTarget";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/debugger/actions/LambdaSmartStepTarget";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getPresentation";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

