/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.compiler.server.impl;

import com.intellij.compiler.server.BuildProcessParametersProvider;
import com.intellij.compiler.server.CompileServerPlugin;
import com.intellij.ide.plugins.IdeaPluginDescriptor;
import com.intellij.ide.plugins.PluginManager;
import com.intellij.openapi.application.PluginPathManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.extensions.PluginId;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.PathUtil;
import com.intellij.util.containers.ContainerUtil;
import java.io.File;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.Nullable;

public class BuildProcessClasspathManager {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.compiler.server.impl.BuildProcessClasspathManager");
    private List<String> myCompileServerPluginsClasspath;
    private static final Map<String, String> OLD_TO_NEW_MODULE_NAME = new LinkedHashMap<String, String>();

    public List<String> getBuildProcessPluginsClasspath(Project project2) {
        List<String> staticClasspath = this.getStaticClasspath();
        List<String> dynamicClasspath = BuildProcessClasspathManager.getDynamicClasspath(project2);
        if (dynamicClasspath.isEmpty()) {
            return staticClasspath;
        }
        dynamicClasspath.addAll(staticClasspath);
        return dynamicClasspath;
    }

    private List<String> getStaticClasspath() {
        if (this.myCompileServerPluginsClasspath == null) {
            this.myCompileServerPluginsClasspath = BuildProcessClasspathManager.computeCompileServerPluginsClasspath();
        }
        return this.myCompileServerPluginsClasspath;
    }

    private static List<String> computeCompileServerPluginsClasspath() {
        ArrayList classpath = ContainerUtil.newArrayList();
        for (CompileServerPlugin serverPlugin : (CompileServerPlugin[])CompileServerPlugin.EP_NAME.getExtensions()) {
            PluginId pluginId = serverPlugin.getPluginDescriptor().getPluginId();
            IdeaPluginDescriptor plugin = PluginManager.getPlugin((PluginId)pluginId);
            LOG.assertTrue(plugin != null, (Object)pluginId);
            File baseFile = plugin.getPath();
            if (baseFile.isFile()) {
                classpath.add(baseFile.getPath());
                continue;
            }
            if (!baseFile.isDirectory()) continue;
            for (String relativePath : StringUtil.split((String)serverPlugin.getClasspath(), (String)";")) {
                File dir;
                File baseOutputDir;
                File jarFile = new File(new File(baseFile, "lib"), relativePath);
                File classesDir = new File(baseFile, "classes");
                if (jarFile.exists()) {
                    classpath.add(jarFile.getPath());
                    continue;
                }
                if (classesDir.isDirectory()) {
                    classpath.add(classesDir.getPath());
                    continue;
                }
                String moduleName = FileUtil.getNameWithoutExtension((String)PathUtil.getFileName((String)relativePath));
                if (OLD_TO_NEW_MODULE_NAME.containsKey(moduleName)) {
                    moduleName = OLD_TO_NEW_MODULE_NAME.get(moduleName);
                }
                if ((baseOutputDir = baseFile.getParentFile()).getName().equals("test")) {
                    baseOutputDir = new File(baseOutputDir.getParentFile(), "production");
                }
                if ((dir = new File(baseOutputDir, moduleName)).exists()) {
                    classpath.add(dir.getPath());
                    continue;
                }
                File pluginDir = BuildProcessClasspathManager.getPluginDir(plugin);
                if (pluginDir != null) {
                    File libraryFile = new File(pluginDir, "lib" + File.separator + PathUtil.getFileName((String)relativePath));
                    if (libraryFile.exists()) {
                        classpath.add(libraryFile.getPath());
                        continue;
                    }
                    LOG.error("Cannot add " + relativePath + " from '" + plugin.getName() + ' ' + plugin.getVersion() + "' to external compiler classpath: library " + libraryFile.getAbsolutePath() + " not found");
                    continue;
                }
                LOG.error("Cannot add " + relativePath + " from '" + plugin.getName() + ' ' + plugin.getVersion() + "' to external compiler classpath: home directory of plugin not found");
            }
        }
        return classpath;
    }

    @Nullable
    private static File getPluginDir(IdeaPluginDescriptor plugin) {
        File extraDirFile;
        String pluginDirName = StringUtil.getShortName((String)plugin.getPluginId().getIdString());
        String extraDir = System.getProperty("idea.external.build.development.plugins.dir");
        if (extraDir != null && (extraDirFile = new File(extraDir, pluginDirName)).isDirectory()) {
            return extraDirFile;
        }
        File pluginHome = PluginPathManager.getPluginHome((String)pluginDirName);
        if (!pluginHome.isDirectory() && StringUtil.isCapitalized((String)pluginDirName)) {
            pluginHome = PluginPathManager.getPluginHome((String)StringUtil.decapitalize((String)pluginDirName));
        }
        return pluginHome.isDirectory() ? pluginHome : null;
    }

    private static List<String> getDynamicClasspath(Project project2) {
        ArrayList classpath = ContainerUtil.newArrayList();
        for (BuildProcessParametersProvider provider : (BuildProcessParametersProvider[])project2.getExtensions(BuildProcessParametersProvider.EP_NAME)) {
            classpath.addAll(provider.getClassPath());
        }
        return classpath;
    }

    public static List<String> getLauncherClasspath(Project project2) {
        ArrayList classpath = ContainerUtil.newArrayList();
        for (BuildProcessParametersProvider provider : (BuildProcessParametersProvider[])project2.getExtensions(BuildProcessParametersProvider.EP_NAME)) {
            classpath.addAll(provider.getLauncherClassPath());
        }
        return classpath;
    }

    static {
        OLD_TO_NEW_MODULE_NAME.put("android-jps-plugin", "intellij.android.jps");
        OLD_TO_NEW_MODULE_NAME.put("ant-jps-plugin", "intellij.ant.jps");
        OLD_TO_NEW_MODULE_NAME.put("aspectj-jps-plugin", "intellij.aspectj.jps");
        OLD_TO_NEW_MODULE_NAME.put("devkit-jps-plugin", "intellij.devkit.jps");
        OLD_TO_NEW_MODULE_NAME.put("eclipse-jps-plugin", "intellij.eclipse.jps");
        OLD_TO_NEW_MODULE_NAME.put("error-prone-jps-plugin", "intellij.errorProne.jps");
        OLD_TO_NEW_MODULE_NAME.put("flex-jps-plugin", "intellij.flex.jps");
        OLD_TO_NEW_MODULE_NAME.put("gradle-jps-plugin", "intellij.gradle.jps");
        OLD_TO_NEW_MODULE_NAME.put("grails-jps-plugin", "intellij.groovy.grails.jps");
        OLD_TO_NEW_MODULE_NAME.put("groovy-jps-plugin", "intellij.groovy.jps");
        OLD_TO_NEW_MODULE_NAME.put("gwt-jps-plugin", "intellij.gwt.jps");
        OLD_TO_NEW_MODULE_NAME.put("google-app-engine-jps-plugin", "intellij.java.googleAppEngine.jps");
        OLD_TO_NEW_MODULE_NAME.put("ui-designer-jps-plugin", "intellij.java.guiForms.jps");
        OLD_TO_NEW_MODULE_NAME.put("intellilang-jps-plugin", "intellij.java.langInjection.jps");
        OLD_TO_NEW_MODULE_NAME.put("dmServer-jps-plugin", "intellij.javaee.appServers.dmServer.jps");
        OLD_TO_NEW_MODULE_NAME.put("weblogic-jps-plugin", "intellij.javaee.appServers.weblogic.jps");
        OLD_TO_NEW_MODULE_NAME.put("webSphere-jps-plugin", "intellij.javaee.appServers.websphere.jps");
        OLD_TO_NEW_MODULE_NAME.put("jpa-jps-plugin", "intellij.javaee.jpa.jps");
        OLD_TO_NEW_MODULE_NAME.put("javaee-jps-plugin", "intellij.javaee.jps");
        OLD_TO_NEW_MODULE_NAME.put("javaFX-jps-plugin", "intellij.javaFX.jps");
        OLD_TO_NEW_MODULE_NAME.put("maven-jps-plugin", "intellij.maven.jps");
        OLD_TO_NEW_MODULE_NAME.put("osmorc-jps-plugin", "intellij.osgi.jps");
        OLD_TO_NEW_MODULE_NAME.put("ruby-chef-jps-plugin", "intellij.ruby.chef.jps");
        OLD_TO_NEW_MODULE_NAME.put("android-common", "intellij.android.common");
        OLD_TO_NEW_MODULE_NAME.put("build-common", "intellij.android.buildCommon");
        OLD_TO_NEW_MODULE_NAME.put("android-rt", "intellij.android.rt");
        OLD_TO_NEW_MODULE_NAME.put("sdk-common", "android.sdktools.sdk-common");
        OLD_TO_NEW_MODULE_NAME.put("sdklib", "android.sdktools.sdklib");
        OLD_TO_NEW_MODULE_NAME.put("layoutlib-api", "android.sdktools.layoutlib-api");
        OLD_TO_NEW_MODULE_NAME.put("repository", "android.sdktools.repository");
        OLD_TO_NEW_MODULE_NAME.put("manifest-merger", "android.sdktools.manifest-merger");
        OLD_TO_NEW_MODULE_NAME.put("common-eclipse-util", "intellij.eclipse.common");
        OLD_TO_NEW_MODULE_NAME.put("flex-shared", "intellij.flex.shared");
        OLD_TO_NEW_MODULE_NAME.put("groovy-rt-constants", "intellij.groovy.constants.rt");
        OLD_TO_NEW_MODULE_NAME.put("grails-compiler-patch", "intellij.groovy.grails.compilerPatch");
        OLD_TO_NEW_MODULE_NAME.put("appEngine-runtime", "intellij.java.googleAppEngine.runtime");
        OLD_TO_NEW_MODULE_NAME.put("common-javaFX-plugin", "intellij.javaFX.common");
    }
}

