/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.compiler.options;

import com.intellij.compiler.options.ValidationConfiguration;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.compiler.CompilerBundle;
import com.intellij.openapi.compiler.options.ExcludeEntryDescription;
import com.intellij.openapi.compiler.options.ExcludesConfiguration;
import com.intellij.openapi.fileEditor.OpenFileDescriptor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.pom.Navigatable;
import org.jetbrains.annotations.Nullable;

public class ExcludeFromValidationAction
extends AnAction {
    public ExcludeFromValidationAction() {
        super(CompilerBundle.message((String)"action.name.exclude.from.validation", (Object[])new Object[0]));
    }

    public void actionPerformed(AnActionEvent e) {
        Project project2 = (Project)e.getData(CommonDataKeys.PROJECT);
        Pair<ExcludesConfiguration, VirtualFile> pair2 = ExcludeFromValidationAction.getExcludedConfigurationAndFile(e, project2);
        if (pair2 == null) {
            return;
        }
        ExcludeEntryDescription description = new ExcludeEntryDescription((VirtualFile)pair2.getSecond(), false, true, (Disposable)project2);
        ((ExcludesConfiguration)pair2.getFirst()).addExcludeEntryDescription(description);
    }

    @Nullable
    private static Pair<ExcludesConfiguration, VirtualFile> getExcludedConfigurationAndFile(AnActionEvent event, Project project2) {
        Navigatable navigatable = (Navigatable)event.getData(CommonDataKeys.NAVIGATABLE);
        if (project2 != null && navigatable instanceof OpenFileDescriptor) {
            VirtualFile file = ((OpenFileDescriptor)navigatable).getFile();
            ExcludesConfiguration configuration = ValidationConfiguration.getExcludedEntriesConfiguration(project2);
            return Pair.create((Object)configuration, (Object)file);
        }
        return null;
    }

    public void update(AnActionEvent e) {
        Project project2 = (Project)e.getData(CommonDataKeys.PROJECT);
        boolean applicable = ExcludeFromValidationAction.getExcludedConfigurationAndFile(e, project2) != null;
        e.getPresentation().setVisible(applicable);
        e.getPresentation().setEnabled(applicable);
    }
}

