/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.compiler.impl;

import com.intellij.compiler.impl.CompilerCacheManager;
import com.intellij.compiler.impl.CompilerUtil;
import com.intellij.compiler.impl.ExitException;
import com.intellij.compiler.impl.ExitStatus;
import com.intellij.compiler.impl.generic.GenericCompilerCache;
import com.intellij.compiler.impl.generic.GenericCompilerPersistentData;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.compiler.CompileContext;
import com.intellij.openapi.compiler.CompilerBundle;
import com.intellij.openapi.compiler.CompilerMessageCategory;
import com.intellij.openapi.compiler.CompilerPaths;
import com.intellij.openapi.compiler.generic.BuildTarget;
import com.intellij.openapi.compiler.generic.CompileItem;
import com.intellij.openapi.compiler.generic.GenericCompiler;
import com.intellij.openapi.compiler.generic.GenericCompilerCacheState;
import com.intellij.openapi.compiler.generic.GenericCompilerInstance;
import com.intellij.openapi.compiler.generic.GenericCompilerProcessingItem;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Ref;
import com.intellij.util.CommonProcessors;
import com.intellij.util.io.KeyDescriptor;
import gnu.trove.THashSet;
import gnu.trove.TObjectHashingStrategy;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class GenericCompilerRunner {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.compiler.impl.GenericCompilerRunner");
    private static final Logger FULL_LOG = Logger.getInstance((String)"#com.intellij.full-generic-compiler-log");
    private final CompileContext myContext;
    private final boolean myForceCompile;
    private final boolean myOnlyCheckStatus;
    private final GenericCompiler<?, ?, ?>[] myCompilers;
    private final Project myProject;

    public GenericCompilerRunner(CompileContext context, boolean forceCompile, boolean onlyCheckStatus, GenericCompiler[] compilers) {
        this.myContext = context;
        this.myForceCompile = forceCompile;
        this.myOnlyCheckStatus = onlyCheckStatus;
        this.myCompilers = compilers;
        this.myProject = this.myContext.getProject();
    }

    public boolean invokeCompilers(GenericCompiler.CompileOrderPlace place) throws ExitException {
        boolean didSomething = false;
        try {
            for (GenericCompiler<?, ?, ?> compiler : this.myCompilers) {
                if (!compiler.getOrderPlace().equals((Object)place)) continue;
                didSomething |= this.invokeCompiler(compiler);
            }
        }
        catch (IOException e) {
            LOG.info((Throwable)e);
            this.myContext.requestRebuildNextTime(e.getMessage());
            throw new ExitException(ExitStatus.ERRORS);
        }
        catch (ExitException | ProcessCanceledException e) {
            throw e;
        }
        catch (Exception e) {
            LOG.info((Throwable)e);
            this.myContext.addMessage(CompilerMessageCategory.ERROR, CompilerBundle.message((String)"compiler.error.exception", (Object[])new Object[]{e.getMessage()}), null, -1, -1);
        }
        return didSomething;
    }

    private <Key, SourceState, OutputState> boolean invokeCompiler(GenericCompiler<Key, SourceState, OutputState> compiler) throws IOException, ExitException {
        return this.invokeCompiler(compiler, compiler.createInstance(this.myContext));
    }

    private <T extends BuildTarget, Item extends CompileItem<Key, SourceState, OutputState>, Key, SourceState, OutputState> boolean invokeCompiler(GenericCompiler<Key, SourceState, OutputState> compiler, GenericCompilerInstance<T, Item, Key, SourceState, OutputState> instance2) throws IOException, ExitException {
        GenericCompilerCache cache = CompilerCacheManager.getInstance(this.myProject).getGenericCompilerCache(compiler);
        GenericCompilerPersistentData data = new GenericCompilerPersistentData(GenericCompilerRunner.getGenericCompilerCacheDir(this.myProject, compiler), compiler.getVersion());
        if (data.isVersionChanged()) {
            LOG.info("Clearing cache for " + compiler.getDescription());
            cache.wipe();
            data.save();
        }
        HashSet<String> targetsToRemove = new HashSet<String>(data.getAllTargets());
        ReadAction.run(() -> {
            for (BuildTarget target : instance2.getAllTargets()) {
                targetsToRemove.remove(target.getId());
            }
        });
        if (!this.myOnlyCheckStatus) {
            for (String target : targetsToRemove) {
                int id = data.removeId(target);
                if (LOG.isDebugEnabled()) {
                    LOG.debug("Removing obsolete target '" + target + "' (id=" + id + ")");
                }
                ArrayList keys = new ArrayList();
                CompilerUtil.runInContext(this.myContext, "Processing obsolete targets...", () -> {
                    cache.processSources(id, new CommonProcessors.CollectProcessor((Collection)keys));
                    ArrayList obsoleteSources = new ArrayList();
                    for (Object key : keys) {
                        GenericCompilerCache.PersistentStateData state = cache.getState(id, key);
                        obsoleteSources.add(new GenericCompilerCacheState(key, state.mySourceState, state.myOutputState));
                    }
                    instance2.processObsoleteTarget(target, obsoleteSources);
                });
                this.checkForErrorsOrCanceled();
                for (Object key : keys) {
                    cache.remove(id, key);
                }
            }
        }
        List selectedTargets = (List)ReadAction.compute(() -> instance2.getSelectedTargets());
        boolean didSomething = false;
        for (BuildTarget target : selectedTargets) {
            int id = data.getId(target.getId());
            didSomething |= this.processTarget(target, id, compiler, instance2, cache);
        }
        data.save();
        return didSomething;
    }

    private void checkForErrorsOrCanceled() throws ExitException {
        if (this.myContext.getMessageCount(CompilerMessageCategory.ERROR) > 0) {
            throw new ExitException(ExitStatus.ERRORS);
        }
        if (this.myContext.getProgressIndicator().isCanceled()) {
            throw new ExitException(ExitStatus.CANCELLED);
        }
    }

    public static File getGenericCompilerCacheDir(Project project2, GenericCompiler<?, ?, ?> compiler) {
        return new File(CompilerPaths.getCacheStoreDirectory((Project)project2), compiler.getId());
    }

    private <T extends BuildTarget, Item extends CompileItem<Key, SourceState, OutputState>, Key, SourceState, OutputState> boolean processTarget(T target, int targetId, GenericCompiler<Key, SourceState, OutputState> compiler, GenericCompilerInstance<T, Item, Key, SourceState, OutputState> instance2, GenericCompilerCache<Key, SourceState, OutputState> cache) throws IOException, ExitException {
        if (LOG.isDebugEnabled()) {
            LOG.debug("Processing target '" + target + "' (id=" + targetId + ") by " + compiler);
        }
        List items = instance2.getItems(target);
        this.checkForErrorsOrCanceled();
        ArrayList toProcess = new ArrayList();
        THashSet keySet = new THashSet(new SourceItemHashingStrategy<Key>(compiler));
        Ref exception = Ref.create(null);
        HashMap sourceStates = new HashMap();
        DumbService.getInstance((Project)this.myProject).runReadActionInSmartMode(() -> {
            try {
                for (CompileItem item : items) {
                    Object outputState;
                    Object key = item.getKey();
                    keySet.add(key);
                    if (item.isExcluded()) continue;
                    GenericCompilerCache.PersistentStateData data = cache.getState(targetId, key);
                    Object sourceState = data != null ? (Object)data.mySourceState : null;
                    Object OutputState = outputState = data != null ? (Object)data.myOutputState : null;
                    if (!this.myForceCompile && sourceState != null && item.isSourceUpToDate(sourceState) && outputState != null && item.isOutputUpToDate(outputState)) continue;
                    sourceStates.put(item, item.computeSourceState());
                    toProcess.add(new GenericCompilerProcessingItem<CompileItem, Object, Object>(item, sourceState, outputState));
                }
            }
            catch (IOException e) {
                exception.set((Object)e);
            }
        });
        if (!exception.isNull()) {
            throw (IOException)exception.get();
        }
        ArrayList toRemove = new ArrayList();
        cache.processSources(targetId, key -> {
            if (!keySet.contains(key)) {
                toRemove.add(key);
            }
            return true;
        });
        if (LOG.isDebugEnabled()) {
            int i;
            LOG.debug(toProcess.size() + " items will be processed, " + toRemove.size() + " items will be removed");
            for (i = 0; i < GenericCompilerRunner.getItemsCountToShowInLog(toProcess.size()); ++i) {
                LOG.debug("to process:" + ((CompileItem)((GenericCompilerProcessingItem)toProcess.get(i)).getItem()).getKey());
            }
            for (i = 0; i < GenericCompilerRunner.getItemsCountToShowInLog(toRemove.size()); ++i) {
                LOG.debug("to delete:" + toRemove.get(i));
            }
        }
        if (toProcess.isEmpty() && toRemove.isEmpty()) {
            return false;
        }
        if (this.myOnlyCheckStatus) {
            throw new ExitException(ExitStatus.CANCELLED);
        }
        ArrayList obsoleteItems = new ArrayList();
        for (Object key2 : toRemove) {
            GenericCompilerCache.PersistentStateData<SourceState, OutputState> data = cache.getState(targetId, key2);
            obsoleteItems.add(new GenericCompilerCacheState(key2, data.mySourceState, data.myOutputState));
        }
        final ArrayList processedItems = new ArrayList();
        final ArrayList filesToRefresh = new ArrayList();
        final ArrayList dirsToRefresh = new ArrayList();
        instance2.processItems(target, toProcess, obsoleteItems, new GenericCompilerInstance.OutputConsumer<Item>(){

            @Override
            public void addFileToRefresh(@NotNull File file) {
                if (file == null) {
                    1.$$$reportNull$$$0(0);
                }
                filesToRefresh.add(file);
            }

            @Override
            public void addDirectoryToRefresh(@NotNull File dir) {
                if (dir == null) {
                    1.$$$reportNull$$$0(1);
                }
                dirsToRefresh.add(dir);
            }

            @Override
            public void addProcessedItem(@NotNull Item sourceItem) {
                if (sourceItem == null) {
                    1.$$$reportNull$$$0(2);
                }
                processedItems.add(sourceItem);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2;
                Object[] objectArray3 = new Object[3];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "file";
                        break;
                    }
                    case 1: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "dir";
                        break;
                    }
                    case 2: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "sourceItem";
                        break;
                    }
                }
                objectArray2[1] = "com/intellij/compiler/impl/GenericCompilerRunner$1";
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[2] = "addFileToRefresh";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[2] = "addDirectoryToRefresh";
                        break;
                    }
                    case 2: {
                        objectArray = objectArray2;
                        objectArray2[2] = "addProcessedItem";
                        break;
                    }
                }
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        });
        this.checkForErrorsOrCanceled();
        CompilerUtil.runInContext(this.myContext, CompilerBundle.message((String)"progress.updating.caches", (Object[])new Object[0]), () -> {
            for (Object key : toRemove) {
                cache.remove(targetId, key);
            }
            CompilerUtil.refreshIOFiles(filesToRefresh);
            CompilerUtil.refreshIODirectories(dirsToRefresh);
            if (LOG.isDebugEnabled()) {
                int i;
                LOG.debug("refreshed " + filesToRefresh.size() + " files and " + dirsToRefresh.size() + " dirs");
                for (i = 0; i < GenericCompilerRunner.getItemsCountToShowInLog(filesToRefresh.size()); ++i) {
                    LOG.debug("file: " + filesToRefresh.get(i));
                }
                for (i = 0; i < GenericCompilerRunner.getItemsCountToShowInLog(dirsToRefresh.size()); ++i) {
                    LOG.debug("dir: " + dirsToRefresh.get(i));
                }
            }
            ReadAction.run(() -> {
                for (CompileItem item : processedItems) {
                    Object sourceState = sourceStates.get(item);
                    if (sourceState == null) {
                        sourceState = item.computeSourceState();
                    }
                    cache.putState(targetId, item.getKey(), sourceState, item.computeOutputState());
                }
            });
        });
        return true;
    }

    private static int getItemsCountToShowInLog(int size) {
        if (size > 100 && !FULL_LOG.isDebugEnabled()) {
            return 100;
        }
        return size;
    }

    private class SourceItemHashingStrategy<S>
    implements TObjectHashingStrategy<S> {
        private final KeyDescriptor<S> myKeyDescriptor;

        public SourceItemHashingStrategy(GenericCompiler<S, ?, ?> compiler) {
            this.myKeyDescriptor = compiler.getItemKeyDescriptor();
        }

        public int computeHashCode(S object) {
            return this.myKeyDescriptor.getHashCode(object);
        }

        public boolean equals(S o1, S o2) {
            return this.myKeyDescriptor.isEqual(o1, o2);
        }
    }
}

